/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Snowflake parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeParameters implements SdkPojo, Serializable,
        ToCopyableBuilder<SnowflakeParameters.Builder, SnowflakeParameters> {
    private static final SdkField<String> HOST_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Host")
            .getter(getter(SnowflakeParameters::host)).setter(setter(Builder::host))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Host").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(SnowflakeParameters::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final SdkField<String> WAREHOUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Warehouse").getter(getter(SnowflakeParameters::warehouse)).setter(setter(Builder::warehouse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Warehouse").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HOST_FIELD, DATABASE_FIELD,
            WAREHOUSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String host;

    private final String database;

    private final String warehouse;

    private SnowflakeParameters(BuilderImpl builder) {
        this.host = builder.host;
        this.database = builder.database;
        this.warehouse = builder.warehouse;
    }

    /**
     * <p>
     * Host.
     * </p>
     * 
     * @return Host.
     */
    public final String host() {
        return host;
    }

    /**
     * <p>
     * Database.
     * </p>
     * 
     * @return Database.
     */
    public final String database() {
        return database;
    }

    /**
     * <p>
     * Warehouse.
     * </p>
     * 
     * @return Warehouse.
     */
    public final String warehouse() {
        return warehouse;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(host());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        hashCode = 31 * hashCode + Objects.hashCode(warehouse());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeParameters)) {
            return false;
        }
        SnowflakeParameters other = (SnowflakeParameters) obj;
        return Objects.equals(host(), other.host()) && Objects.equals(database(), other.database())
                && Objects.equals(warehouse(), other.warehouse());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeParameters").add("Host", host()).add("Database", database())
                .add("Warehouse", warehouse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Host":
            return Optional.ofNullable(clazz.cast(host()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        case "Warehouse":
            return Optional.ofNullable(clazz.cast(warehouse()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeParameters, T> g) {
        return obj -> g.apply((SnowflakeParameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeParameters> {
        /**
         * <p>
         * Host.
         * </p>
         * 
         * @param host
         *        Host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder host(String host);

        /**
         * <p>
         * Database.
         * </p>
         * 
         * @param database
         *        Database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);

        /**
         * <p>
         * Warehouse.
         * </p>
         * 
         * @param warehouse
         *        Warehouse.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder warehouse(String warehouse);
    }

    static final class BuilderImpl implements Builder {
        private String host;

        private String database;

        private String warehouse;

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeParameters model) {
            host(model.host);
            database(model.database);
            warehouse(model.warehouse);
        }

        public final String getHost() {
            return host;
        }

        public final void setHost(String host) {
            this.host = host;
        }

        @Override
        @Transient
        public final Builder host(String host) {
            this.host = host;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        @Transient
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final String getWarehouse() {
            return warehouse;
        }

        public final void setWarehouse(String warehouse) {
            this.warehouse = warehouse;
        }

        @Override
        @Transient
        public final Builder warehouse(String warehouse) {
            this.warehouse = warehouse;
            return this;
        }

        @Override
        public SnowflakeParameters build() {
            return new SnowflakeParameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
