/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of tags on a dataset to set row-level security.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RowLevelPermissionTagConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RowLevelPermissionTagConfiguration.Builder, RowLevelPermissionTagConfiguration> {
    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(RowLevelPermissionTagConfiguration::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<List<RowLevelPermissionTagRule>> TAG_RULES_FIELD = SdkField
            .<List<RowLevelPermissionTagRule>> builder(MarshallingType.LIST)
            .memberName("TagRules")
            .getter(getter(RowLevelPermissionTagConfiguration::tagRules))
            .setter(setter(Builder::tagRules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagRules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RowLevelPermissionTagRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(RowLevelPermissionTagRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(STATUS_FIELD, TAG_RULES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String status;

    private final List<RowLevelPermissionTagRule> tagRules;

    private RowLevelPermissionTagConfiguration(BuilderImpl builder) {
        this.status = builder.status;
        this.tagRules = builder.tagRules;
    }

    /**
     * <p>
     * The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the
     *         status is <code>DISABLED</code>.
     * @see Status
     */
    public final Status status() {
        return Status.fromValue(status);
    }

    /**
     * <p>
     * The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the status is
     * <code>DISABLED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link Status#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the
     *         status is <code>DISABLED</code>.
     * @see Status
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * For responses, this returns true if the service returned a value for the TagRules property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTagRules() {
        return tagRules != null && !(tagRules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A set of rules associated with row-level security, such as the tag names and columns that they are assigned to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTagRules} method.
     * </p>
     * 
     * @return A set of rules associated with row-level security, such as the tag names and columns that they are
     *         assigned to.
     */
    public final List<RowLevelPermissionTagRule> tagRules() {
        return tagRules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTagRules() ? tagRules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RowLevelPermissionTagConfiguration)) {
            return false;
        }
        RowLevelPermissionTagConfiguration other = (RowLevelPermissionTagConfiguration) obj;
        return Objects.equals(statusAsString(), other.statusAsString()) && hasTagRules() == other.hasTagRules()
                && Objects.equals(tagRules(), other.tagRules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RowLevelPermissionTagConfiguration").add("Status", statusAsString())
                .add("TagRules", hasTagRules() ? tagRules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "TagRules":
            return Optional.ofNullable(clazz.cast(tagRules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RowLevelPermissionTagConfiguration, T> g) {
        return obj -> g.apply((RowLevelPermissionTagConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RowLevelPermissionTagConfiguration> {
        /**
         * <p>
         * The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the
         * status is <code>DISABLED</code>.
         * </p>
         * 
         * @param status
         *        The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled,
         *        the status is <code>DISABLED</code>.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(String status);

        /**
         * <p>
         * The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled, the
         * status is <code>DISABLED</code>.
         * </p>
         * 
         * @param status
         *        The status of row-level security tags. If enabled, the status is <code>ENABLED</code>. If disabled,
         *        the status is <code>DISABLED</code>.
         * @see Status
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Status
         */
        Builder status(Status status);

        /**
         * <p>
         * A set of rules associated with row-level security, such as the tag names and columns that they are assigned
         * to.
         * </p>
         * 
         * @param tagRules
         *        A set of rules associated with row-level security, such as the tag names and columns that they are
         *        assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagRules(Collection<RowLevelPermissionTagRule> tagRules);

        /**
         * <p>
         * A set of rules associated with row-level security, such as the tag names and columns that they are assigned
         * to.
         * </p>
         * 
         * @param tagRules
         *        A set of rules associated with row-level security, such as the tag names and columns that they are
         *        assigned to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagRules(RowLevelPermissionTagRule... tagRules);

        /**
         * <p>
         * A set of rules associated with row-level security, such as the tag names and columns that they are assigned
         * to.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RowLevelPermissionTagRule>.Builder}
         * avoiding the need to create one manually via {@link List<RowLevelPermissionTagRule>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RowLevelPermissionTagRule>.Builder#build()} is called
         * immediately and its result is passed to {@link #tagRules(List<RowLevelPermissionTagRule>)}.
         * 
         * @param tagRules
         *        a consumer that will call methods on {@link List<RowLevelPermissionTagRule>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagRules(List<RowLevelPermissionTagRule>)
         */
        Builder tagRules(Consumer<RowLevelPermissionTagRule.Builder>... tagRules);
    }

    static final class BuilderImpl implements Builder {
        private String status;

        private List<RowLevelPermissionTagRule> tagRules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RowLevelPermissionTagConfiguration model) {
            status(model.status);
            tagRules(model.tagRules);
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<RowLevelPermissionTagRule.Builder> getTagRules() {
            List<RowLevelPermissionTagRule.Builder> result = RowLevelPermissionTagRuleListCopier.copyToBuilder(this.tagRules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagRules(Collection<RowLevelPermissionTagRule.BuilderImpl> tagRules) {
            this.tagRules = RowLevelPermissionTagRuleListCopier.copyFromBuilder(tagRules);
        }

        @Override
        public final Builder tagRules(Collection<RowLevelPermissionTagRule> tagRules) {
            this.tagRules = RowLevelPermissionTagRuleListCopier.copy(tagRules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRules(RowLevelPermissionTagRule... tagRules) {
            tagRules(Arrays.asList(tagRules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagRules(Consumer<RowLevelPermissionTagRule.Builder>... tagRules) {
            tagRules(Stream.of(tagRules).map(c -> RowLevelPermissionTagRule.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public RowLevelPermissionTagConfiguration build() {
            return new RowLevelPermissionTagConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
