/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeDataSetPermissionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeDataSetPermissionsResponse.Builder, DescribeDataSetPermissionsResponse> {
    private static final SdkField<String> DATA_SET_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetArn").getter(getter(DescribeDataSetPermissionsResponse::dataSetArn))
            .setter(setter(Builder::dataSetArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetArn").build()).build();

    private static final SdkField<String> DATA_SET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSetId").getter(getter(DescribeDataSetPermissionsResponse::dataSetId))
            .setter(setter(Builder::dataSetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSetId").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(DescribeDataSetPermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeDataSetPermissionsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeDataSetPermissionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_SET_ARN_FIELD,
            DATA_SET_ID_FIELD, PERMISSIONS_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final String dataSetArn;

    private final String dataSetId;

    private final List<ResourcePermission> permissions;

    private final String requestId;

    private final Integer status;

    private DescribeDataSetPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.dataSetArn = builder.dataSetArn;
        this.dataSetId = builder.dataSetId;
        this.permissions = builder.permissions;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the dataset.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the dataset.
     */
    public final String dataSetArn() {
        return dataSetArn;
    }

    /**
     * <p>
     * The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each Amazon
     * Web Services account.
     * </p>
     * 
     * @return The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each
     *         Amazon Web Services account.
     */
    public final String dataSetId() {
        return dataSetId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource permissions on the dataset.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A list of resource permissions on the dataset.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(dataSetArn());
        hashCode = 31 * hashCode + Objects.hashCode(dataSetId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeDataSetPermissionsResponse)) {
            return false;
        }
        DescribeDataSetPermissionsResponse other = (DescribeDataSetPermissionsResponse) obj;
        return Objects.equals(dataSetArn(), other.dataSetArn()) && Objects.equals(dataSetId(), other.dataSetId())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeDataSetPermissionsResponse").add("DataSetArn", dataSetArn())
                .add("DataSetId", dataSetId()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DataSetArn":
            return Optional.ofNullable(clazz.cast(dataSetArn()));
        case "DataSetId":
            return Optional.ofNullable(clazz.cast(dataSetId()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeDataSetPermissionsResponse, T> g) {
        return obj -> g.apply((DescribeDataSetPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeDataSetPermissionsResponse> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the dataset.
         * </p>
         * 
         * @param dataSetArn
         *        The Amazon Resource Name (ARN) of the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetArn(String dataSetArn);

        /**
         * <p>
         * The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for each
         * Amazon Web Services account.
         * </p>
         * 
         * @param dataSetId
         *        The ID for the dataset that you want to create. This ID is unique per Amazon Web Services Region for
         *        each Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSetId(String dataSetId);

        /**
         * <p>
         * A list of resource permissions on the dataset.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions on the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A list of resource permissions on the dataset.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions on the dataset.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A list of resource permissions on the dataset.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ResourcePermission>.Builder}
         * avoiding the need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String dataSetArn;

        private String dataSetId;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeDataSetPermissionsResponse model) {
            super(model);
            dataSetArn(model.dataSetArn);
            dataSetId(model.dataSetId);
            permissions(model.permissions);
            requestId(model.requestId);
            status(model.status);
        }

        public final String getDataSetArn() {
            return dataSetArn;
        }

        public final void setDataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
        }

        @Override
        public final Builder dataSetArn(String dataSetArn) {
            this.dataSetArn = dataSetArn;
            return this;
        }

        public final String getDataSetId() {
            return dataSetId;
        }

        public final void setDataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
        }

        @Override
        public final Builder dataSetId(String dataSetId) {
            this.dataSetId = dataSetId;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeDataSetPermissionsResponse build() {
            return new DescribeDataSetPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
