/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAnalysisResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeAnalysisResponse.Builder, DescribeAnalysisResponse> {
    private static final SdkField<Analysis> ANALYSIS_FIELD = SdkField.<Analysis> builder(MarshallingType.SDK_POJO)
            .memberName("Analysis").getter(getter(DescribeAnalysisResponse::analysis)).setter(setter(Builder::analysis))
            .constructor(Analysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeAnalysisResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeAnalysisResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ANALYSIS_FIELD, STATUS_FIELD,
            REQUEST_ID_FIELD));

    private final Analysis analysis;

    private final Integer status;

    private final String requestId;

    private DescribeAnalysisResponse(BuilderImpl builder) {
        super(builder);
        this.analysis = builder.analysis;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * A metadata structure that contains summary information for the analysis that you're describing.
     * </p>
     * 
     * @return A metadata structure that contains summary information for the analysis that you're describing.
     */
    public final Analysis analysis() {
        return analysis;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(analysis());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAnalysisResponse)) {
            return false;
        }
        DescribeAnalysisResponse other = (DescribeAnalysisResponse) obj;
        return Objects.equals(analysis(), other.analysis()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAnalysisResponse").add("Analysis", analysis()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Analysis":
            return Optional.ofNullable(clazz.cast(analysis()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAnalysisResponse, T> g) {
        return obj -> g.apply((DescribeAnalysisResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DescribeAnalysisResponse> {
        /**
         * <p>
         * A metadata structure that contains summary information for the analysis that you're describing.
         * </p>
         * 
         * @param analysis
         *        A metadata structure that contains summary information for the analysis that you're describing.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysis(Analysis analysis);

        /**
         * <p>
         * A metadata structure that contains summary information for the analysis that you're describing.
         * </p>
         * This is a convenience method that creates an instance of the {@link Analysis.Builder} avoiding the need to
         * create one manually via {@link Analysis#builder()}.
         *
         * When the {@link Consumer} completes, {@link Analysis.Builder#build()} is called immediately and its result is
         * passed to {@link #analysis(Analysis)}.
         * 
         * @param analysis
         *        a consumer that will call methods on {@link Analysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysis(Analysis)
         */
        default Builder analysis(Consumer<Analysis.Builder> analysis) {
            return analysis(Analysis.builder().applyMutation(analysis).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Analysis analysis;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAnalysisResponse model) {
            super(model);
            analysis(model.analysis);
            status(model.status);
            requestId(model.requestId);
        }

        public final Analysis.Builder getAnalysis() {
            return analysis != null ? analysis.toBuilder() : null;
        }

        public final void setAnalysis(Analysis.BuilderImpl analysis) {
            this.analysis = analysis != null ? analysis.build() : null;
        }

        @Override
        public final Builder analysis(Analysis analysis) {
            this.analysis = analysis;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public DescribeAnalysisResponse build() {
            return new DescribeAnalysisResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
