/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListNamespacesResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListNamespacesResponse.Builder, ListNamespacesResponse> {
    private static final SdkField<List<NamespaceInfoV2>> NAMESPACES_FIELD = SdkField
            .<List<NamespaceInfoV2>> builder(MarshallingType.LIST)
            .memberName("Namespaces")
            .getter(getter(ListNamespacesResponse::namespaces))
            .setter(setter(Builder::namespaces))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Namespaces").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<NamespaceInfoV2> builder(MarshallingType.SDK_POJO)
                                            .constructor(NamespaceInfoV2::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListNamespacesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListNamespacesResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListNamespacesResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAMESPACES_FIELD,
            NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final List<NamespaceInfoV2> namespaces;

    private final String nextToken;

    private final String requestId;

    private final Integer status;

    private ListNamespacesResponse(BuilderImpl builder) {
        super(builder);
        this.namespaces = builder.namespaces;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the Namespaces property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasNamespaces() {
        return namespaces != null && !(namespaces instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The information about the namespaces in this Amazon Web Services account. The response includes the namespace
     * ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNamespaces} method.
     * </p>
     * 
     * @return The information about the namespaces in this Amazon Web Services account. The response includes the
     *         namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and
     *         identity store.
     */
    public final List<NamespaceInfoV2> namespaces() {
        return namespaces;
    }

    /**
     * <p>
     * A unique pagination token that can be used in a subsequent request. Receiving <code>NextToken</code> in your
     * response inticates that there is more data that can be returned. To receive the data, make another
     * <code>ListNamespaces</code> API call with the returned token to retrieve the next page of data. Each token is
     * valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an expired token, you will
     * receive a <code>HTTP 400 InvalidNextTokenException</code> error.
     * </p>
     * 
     * @return A unique pagination token that can be used in a subsequent request. Receiving <code>NextToken</code> in
     *         your response inticates that there is more data that can be returned. To receive the data, make another
     *         <code>ListNamespaces</code> API call with the returned token to retrieve the next page of data. Each
     *         token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an expired
     *         token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasNamespaces() ? namespaces() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListNamespacesResponse)) {
            return false;
        }
        ListNamespacesResponse other = (ListNamespacesResponse) obj;
        return hasNamespaces() == other.hasNamespaces() && Objects.equals(namespaces(), other.namespaces())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListNamespacesResponse").add("Namespaces", hasNamespaces() ? namespaces() : null)
                .add("NextToken", nextToken()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Namespaces":
            return Optional.ofNullable(clazz.cast(namespaces()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListNamespacesResponse, T> g) {
        return obj -> g.apply((ListNamespacesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListNamespacesResponse> {
        /**
         * <p>
         * The information about the namespaces in this Amazon Web Services account. The response includes the namespace
         * ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.
         * </p>
         * 
         * @param namespaces
         *        The information about the namespaces in this Amazon Web Services account. The response includes the
         *        namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and
         *        identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(Collection<NamespaceInfoV2> namespaces);

        /**
         * <p>
         * The information about the namespaces in this Amazon Web Services account. The response includes the namespace
         * ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.
         * </p>
         * 
         * @param namespaces
         *        The information about the namespaces in this Amazon Web Services account. The response includes the
         *        namespace ARN, name, Amazon Web Services Region, notification email address, creation status, and
         *        identity store.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespaces(NamespaceInfoV2... namespaces);

        /**
         * <p>
         * The information about the namespaces in this Amazon Web Services account. The response includes the namespace
         * ARN, name, Amazon Web Services Region, notification email address, creation status, and identity store.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<NamespaceInfoV2>.Builder} avoiding
         * the need to create one manually via {@link List<NamespaceInfoV2>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<NamespaceInfoV2>.Builder#build()} is called immediately and
         * its result is passed to {@link #namespaces(List<NamespaceInfoV2>)}.
         * 
         * @param namespaces
         *        a consumer that will call methods on {@link List<NamespaceInfoV2>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #namespaces(List<NamespaceInfoV2>)
         */
        Builder namespaces(Consumer<NamespaceInfoV2.Builder>... namespaces);

        /**
         * <p>
         * A unique pagination token that can be used in a subsequent request. Receiving <code>NextToken</code> in your
         * response inticates that there is more data that can be returned. To receive the data, make another
         * <code>ListNamespaces</code> API call with the returned token to retrieve the next page of data. Each token is
         * valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with an expired token, you will
         * receive a <code>HTTP 400 InvalidNextTokenException</code> error.
         * </p>
         * 
         * @param nextToken
         *        A unique pagination token that can be used in a subsequent request. Receiving <code>NextToken</code>
         *        in your response inticates that there is more data that can be returned. To receive the data, make
         *        another <code>ListNamespaces</code> API call with the returned token to retrieve the next page of
         *        data. Each token is valid for 24 hours. If you try to make a <code>ListNamespaces</code> API call with
         *        an expired token, you will receive a <code>HTTP 400 InvalidNextTokenException</code> error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<NamespaceInfoV2> namespaces = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListNamespacesResponse model) {
            super(model);
            namespaces(model.namespaces);
            nextToken(model.nextToken);
            requestId(model.requestId);
            status(model.status);
        }

        public final List<NamespaceInfoV2.Builder> getNamespaces() {
            List<NamespaceInfoV2.Builder> result = NamespacesCopier.copyToBuilder(this.namespaces);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNamespaces(Collection<NamespaceInfoV2.BuilderImpl> namespaces) {
            this.namespaces = NamespacesCopier.copyFromBuilder(namespaces);
        }

        @Override
        public final Builder namespaces(Collection<NamespaceInfoV2> namespaces) {
            this.namespaces = NamespacesCopier.copy(namespaces);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(NamespaceInfoV2... namespaces) {
            namespaces(Arrays.asList(namespaces));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder namespaces(Consumer<NamespaceInfoV2.Builder>... namespaces) {
            namespaces(Stream.of(namespaces).map(c -> NamespaceInfoV2.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public ListNamespacesResponse build() {
            return new ListNamespacesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
