/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListUsersResponse extends QuickSightResponse implements
        ToCopyableBuilder<ListUsersResponse.Builder, ListUsersResponse> {
    private static final SdkField<List<User>> USER_LIST_FIELD = SdkField
            .<List<User>> builder(MarshallingType.LIST)
            .memberName("UserList")
            .getter(getter(ListUsersResponse::userList))
            .setter(setter(Builder::userList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<User> builder(MarshallingType.SDK_POJO)
                                            .constructor(User::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListUsersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(ListUsersResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(ListUsersResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_LIST_FIELD,
            NEXT_TOKEN_FIELD, REQUEST_ID_FIELD, STATUS_FIELD));

    private final List<User> userList;

    private final String nextToken;

    private final String requestId;

    private final Integer status;

    private ListUsersResponse(BuilderImpl builder) {
        super(builder);
        this.userList = builder.userList;
        this.nextToken = builder.nextToken;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserList property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasUserList() {
        return userList != null && !(userList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of users.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserList} method.
     * </p>
     * 
     * @return The list of users.
     */
    public final List<User> userList() {
        return userList;
    }

    /**
     * <p>
     * A pagination token that can be used in a subsequent request.
     * </p>
     * 
     * @return A pagination token that can be used in a subsequent request.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserList() ? userList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListUsersResponse)) {
            return false;
        }
        ListUsersResponse other = (ListUsersResponse) obj;
        return hasUserList() == other.hasUserList() && Objects.equals(userList(), other.userList())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListUsersResponse").add("UserList", hasUserList() ? userList() : null)
                .add("NextToken", nextToken()).add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserList":
            return Optional.ofNullable(clazz.cast(userList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListUsersResponse, T> g) {
        return obj -> g.apply((ListUsersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListUsersResponse> {
        /**
         * <p>
         * The list of users.
         * </p>
         * 
         * @param userList
         *        The list of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userList(Collection<User> userList);

        /**
         * <p>
         * The list of users.
         * </p>
         * 
         * @param userList
         *        The list of users.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userList(User... userList);

        /**
         * <p>
         * The list of users.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<User>.Builder} avoiding the need to
         * create one manually via {@link List<User>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<User>.Builder#build()} is called immediately and its result
         * is passed to {@link #userList(List<User>)}.
         * 
         * @param userList
         *        a consumer that will call methods on {@link List<User>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userList(List<User>)
         */
        Builder userList(Consumer<User.Builder>... userList);

        /**
         * <p>
         * A pagination token that can be used in a subsequent request.
         * </p>
         * 
         * @param nextToken
         *        A pagination token that can be used in a subsequent request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private List<User> userList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListUsersResponse model) {
            super(model);
            userList(model.userList);
            nextToken(model.nextToken);
            requestId(model.requestId);
            status(model.status);
        }

        public final List<User.Builder> getUserList() {
            List<User.Builder> result = UserListCopier.copyToBuilder(this.userList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserList(Collection<User.BuilderImpl> userList) {
            this.userList = UserListCopier.copyFromBuilder(userList);
        }

        @Override
        public final Builder userList(Collection<User> userList) {
            this.userList = UserListCopier.copy(userList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userList(User... userList) {
            userList(Arrays.asList(userList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userList(Consumer<User.Builder>... userList) {
            userList(Stream.of(userList).map(c -> User.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public ListUsersResponse build() {
            return new ListUsersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
