/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFolderPermissionsResponse extends QuickSightResponse implements
        ToCopyableBuilder<UpdateFolderPermissionsResponse.Builder, UpdateFolderPermissionsResponse> {
    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(UpdateFolderPermissionsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(UpdateFolderPermissionsResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> FOLDER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FolderId").getter(getter(UpdateFolderPermissionsResponse::folderId)).setter(setter(Builder::folderId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FolderId").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(UpdateFolderPermissionsResponse::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(UpdateFolderPermissionsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STATUS_FIELD, ARN_FIELD,
            FOLDER_ID_FIELD, PERMISSIONS_FIELD, REQUEST_ID_FIELD));

    private final Integer status;

    private final String arn;

    private final String folderId;

    private final List<ResourcePermission> permissions;

    private final String requestId;

    private UpdateFolderPermissionsResponse(BuilderImpl builder) {
        super(builder);
        this.status = builder.status;
        this.arn = builder.arn;
        this.folderId = builder.folderId;
        this.permissions = builder.permissions;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * The status. If succeeded, the status is <code>SC_OK</code>.
     * </p>
     * 
     * @return The status. If succeeded, the status is <code>SC_OK</code>.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN).
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The folder ID.
     * </p>
     * 
     * @return The folder ID.
     */
    public final String folderId() {
        return folderId;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Information about the permissions on the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return Information about the permissions on the dashboard.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The request ID.
     * </p>
     * 
     * @return The request ID.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(folderId());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFolderPermissionsResponse)) {
            return false;
        }
        UpdateFolderPermissionsResponse other = (UpdateFolderPermissionsResponse) obj;
        return Objects.equals(status(), other.status()) && Objects.equals(arn(), other.arn())
                && Objects.equals(folderId(), other.folderId()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions()) && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFolderPermissionsResponse").add("Status", status()).add("Arn", arn())
                .add("FolderId", folderId()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "FolderId":
            return Optional.ofNullable(clazz.cast(folderId()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFolderPermissionsResponse, T> g) {
        return obj -> g.apply((UpdateFolderPermissionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateFolderPermissionsResponse> {
        /**
         * <p>
         * The status. If succeeded, the status is <code>SC_OK</code>.
         * </p>
         * 
         * @param status
         *        The status. If succeeded, the status is <code>SC_OK</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Resource Name (ARN).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The folder ID.
         * </p>
         * 
         * @param folderId
         *        The folder ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder folderId(String folderId);

        /**
         * <p>
         * Information about the permissions on the dashboard.
         * </p>
         * 
         * @param permissions
         *        Information about the permissions on the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * Information about the permissions on the dashboard.
         * </p>
         * 
         * @param permissions
         *        Information about the permissions on the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * Information about the permissions on the dashboard.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The request ID.
         * </p>
         * 
         * @param requestId
         *        The request ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private Integer status;

        private String arn;

        private String folderId;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFolderPermissionsResponse model) {
            super(model);
            status(model.status);
            arn(model.arn);
            folderId(model.folderId);
            permissions(model.permissions);
            requestId(model.requestId);
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getFolderId() {
            return folderId;
        }

        public final void setFolderId(String folderId) {
            this.folderId = folderId;
        }

        @Override
        @Transient
        public final Builder folderId(String folderId) {
            this.folderId = folderId;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        @Transient
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public UpdateFolderPermissionsResponse build() {
            return new UpdateFolderPermissionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
