/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GenerateEmbedUrlForRegisteredUserRequest extends QuickSightRequest implements
        ToCopyableBuilder<GenerateEmbedUrlForRegisteredUserRequest.Builder, GenerateEmbedUrlForRegisteredUserRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(GenerateEmbedUrlForRegisteredUserRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<Long> SESSION_LIFETIME_IN_MINUTES_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("SessionLifetimeInMinutes")
            .getter(getter(GenerateEmbedUrlForRegisteredUserRequest::sessionLifetimeInMinutes))
            .setter(setter(Builder::sessionLifetimeInMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionLifetimeInMinutes").build())
            .build();

    private static final SdkField<String> USER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UserArn").getter(getter(GenerateEmbedUrlForRegisteredUserRequest::userArn))
            .setter(setter(Builder::userArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserArn").build()).build();

    private static final SdkField<RegisteredUserEmbeddingExperienceConfiguration> EXPERIENCE_CONFIGURATION_FIELD = SdkField
            .<RegisteredUserEmbeddingExperienceConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ExperienceConfiguration")
            .getter(getter(GenerateEmbedUrlForRegisteredUserRequest::experienceConfiguration))
            .setter(setter(Builder::experienceConfiguration))
            .constructor(RegisteredUserEmbeddingExperienceConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExperienceConfiguration").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_DOMAINS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AllowedDomains")
            .getter(getter(GenerateEmbedUrlForRegisteredUserRequest::allowedDomains))
            .setter(setter(Builder::allowedDomains))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AllowedDomains").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            SESSION_LIFETIME_IN_MINUTES_FIELD, USER_ARN_FIELD, EXPERIENCE_CONFIGURATION_FIELD, ALLOWED_DOMAINS_FIELD));

    private final String awsAccountId;

    private final Long sessionLifetimeInMinutes;

    private final String userArn;

    private final RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration;

    private final List<String> allowedDomains;

    private GenerateEmbedUrlForRegisteredUserRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.sessionLifetimeInMinutes = builder.sessionLifetimeInMinutes;
        this.userArn = builder.userArn;
        this.experienceConfiguration = builder.experienceConfiguration;
        this.allowedDomains = builder.allowedDomains;
    }

    /**
     * <p>
     * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     * </p>
     * 
     * @return The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
     * </p>
     * 
     * @return How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
     */
    public final Long sessionLifetimeInMinutes() {
        return sessionLifetimeInMinutes;
    }

    /**
     * <p>
     * The Amazon Resource Name for the registered user.
     * </p>
     * 
     * @return The Amazon Resource Name for the registered user.
     */
    public final String userArn() {
        return userArn;
    }

    /**
     * <p>
     * The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards, Amazon
     * QuickSight visuals, the Amazon QuickSight Q search bar, or the entire Amazon QuickSight console.
     * </p>
     * 
     * @return The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards,
     *         Amazon QuickSight visuals, the Amazon QuickSight Q search bar, or the entire Amazon QuickSight console.
     */
    public final RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration() {
        return experienceConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedDomains property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedDomains() {
        return allowedDomains != null && !(allowedDomains instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The domains that you want to add to the allow list for access to the generated URL that is then embedded. This
     * optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the Amazon
     * QuickSight console. Instead, it allows only the domains that you include in this parameter. You can list up to
     * three domains or subdomains in each API call.
     * </p>
     * <p>
     * To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
     * <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedDomains} method.
     * </p>
     * 
     * @return The domains that you want to add to the allow list for access to the generated URL that is then embedded.
     *         This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in
     *         the Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter.
     *         You can list up to three domains or subdomains in each API call.</p>
     *         <p>
     *         To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
     *         <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
     */
    public final List<String> allowedDomains() {
        return allowedDomains;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionLifetimeInMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(userArn());
        hashCode = 31 * hashCode + Objects.hashCode(experienceConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedDomains() ? allowedDomains() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GenerateEmbedUrlForRegisteredUserRequest)) {
            return false;
        }
        GenerateEmbedUrlForRegisteredUserRequest other = (GenerateEmbedUrlForRegisteredUserRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId())
                && Objects.equals(sessionLifetimeInMinutes(), other.sessionLifetimeInMinutes())
                && Objects.equals(userArn(), other.userArn())
                && Objects.equals(experienceConfiguration(), other.experienceConfiguration())
                && hasAllowedDomains() == other.hasAllowedDomains() && Objects.equals(allowedDomains(), other.allowedDomains());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GenerateEmbedUrlForRegisteredUserRequest").add("AwsAccountId", awsAccountId())
                .add("SessionLifetimeInMinutes", sessionLifetimeInMinutes()).add("UserArn", userArn())
                .add("ExperienceConfiguration", experienceConfiguration())
                .add("AllowedDomains", hasAllowedDomains() ? allowedDomains() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "SessionLifetimeInMinutes":
            return Optional.ofNullable(clazz.cast(sessionLifetimeInMinutes()));
        case "UserArn":
            return Optional.ofNullable(clazz.cast(userArn()));
        case "ExperienceConfiguration":
            return Optional.ofNullable(clazz.cast(experienceConfiguration()));
        case "AllowedDomains":
            return Optional.ofNullable(clazz.cast(allowedDomains()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GenerateEmbedUrlForRegisteredUserRequest, T> g) {
        return obj -> g.apply((GenerateEmbedUrlForRegisteredUserRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GenerateEmbedUrlForRegisteredUserRequest> {
        /**
         * <p>
         * The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         * </p>
         * 
         * @param awsAccountId
         *        The ID for the Amazon Web Services account that contains the dashboard that you're embedding.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
         * </p>
         * 
         * @param sessionLifetimeInMinutes
         *        How many minutes the session is valid. The session lifetime must be in [15-600] minutes range.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes);

        /**
         * <p>
         * The Amazon Resource Name for the registered user.
         * </p>
         * 
         * @param userArn
         *        The Amazon Resource Name for the registered user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userArn(String userArn);

        /**
         * <p>
         * The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards, Amazon
         * QuickSight visuals, the Amazon QuickSight Q search bar, or the entire Amazon QuickSight console.
         * </p>
         * 
         * @param experienceConfiguration
         *        The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards,
         *        Amazon QuickSight visuals, the Amazon QuickSight Q search bar, or the entire Amazon QuickSight
         *        console.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder experienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration);

        /**
         * <p>
         * The experience you are embedding. For registered users, you can embed Amazon QuickSight dashboards, Amazon
         * QuickSight visuals, the Amazon QuickSight Q search bar, or the entire Amazon QuickSight console.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link RegisteredUserEmbeddingExperienceConfiguration.Builder} avoiding the need to create one manually via
         * {@link RegisteredUserEmbeddingExperienceConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegisteredUserEmbeddingExperienceConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #experienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration)}.
         * 
         * @param experienceConfiguration
         *        a consumer that will call methods on {@link RegisteredUserEmbeddingExperienceConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #experienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration)
         */
        default Builder experienceConfiguration(
                Consumer<RegisteredUserEmbeddingExperienceConfiguration.Builder> experienceConfiguration) {
            return experienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration.builder()
                    .applyMutation(experienceConfiguration).build());
        }

        /**
         * <p>
         * The domains that you want to add to the allow list for access to the generated URL that is then embedded.
         * This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the
         * Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can
         * list up to three domains or subdomains in each API call.
         * </p>
         * <p>
         * To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         * <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
         * </p>
         * 
         * @param allowedDomains
         *        The domains that you want to add to the allow list for access to the generated URL that is then
         *        embedded. This optional parameter overrides the static domains that are configured in the Manage
         *        QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include
         *        in this parameter. You can list up to three domains or subdomains in each API call.</p>
         *        <p>
         *        To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         *        <code>https://*.sapp.amazon.com</code> includes all subdomains under
         *        <code>https://sapp.amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedDomains(Collection<String> allowedDomains);

        /**
         * <p>
         * The domains that you want to add to the allow list for access to the generated URL that is then embedded.
         * This optional parameter overrides the static domains that are configured in the Manage QuickSight menu in the
         * Amazon QuickSight console. Instead, it allows only the domains that you include in this parameter. You can
         * list up to three domains or subdomains in each API call.
         * </p>
         * <p>
         * To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         * <code>https://*.sapp.amazon.com</code> includes all subdomains under <code>https://sapp.amazon.com</code>.
         * </p>
         * 
         * @param allowedDomains
         *        The domains that you want to add to the allow list for access to the generated URL that is then
         *        embedded. This optional parameter overrides the static domains that are configured in the Manage
         *        QuickSight menu in the Amazon QuickSight console. Instead, it allows only the domains that you include
         *        in this parameter. You can list up to three domains or subdomains in each API call.</p>
         *        <p>
         *        To include all subdomains under a specific domain to the allow list, use <code>*</code>. For example,
         *        <code>https://*.sapp.amazon.com</code> includes all subdomains under
         *        <code>https://sapp.amazon.com</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedDomains(String... allowedDomains);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private Long sessionLifetimeInMinutes;

        private String userArn;

        private RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration;

        private List<String> allowedDomains = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GenerateEmbedUrlForRegisteredUserRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            sessionLifetimeInMinutes(model.sessionLifetimeInMinutes);
            userArn(model.userArn);
            experienceConfiguration(model.experienceConfiguration);
            allowedDomains(model.allowedDomains);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final Long getSessionLifetimeInMinutes() {
            return sessionLifetimeInMinutes;
        }

        public final void setSessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
        }

        @Override
        public final Builder sessionLifetimeInMinutes(Long sessionLifetimeInMinutes) {
            this.sessionLifetimeInMinutes = sessionLifetimeInMinutes;
            return this;
        }

        public final String getUserArn() {
            return userArn;
        }

        public final void setUserArn(String userArn) {
            this.userArn = userArn;
        }

        @Override
        public final Builder userArn(String userArn) {
            this.userArn = userArn;
            return this;
        }

        public final RegisteredUserEmbeddingExperienceConfiguration.Builder getExperienceConfiguration() {
            return experienceConfiguration != null ? experienceConfiguration.toBuilder() : null;
        }

        public final void setExperienceConfiguration(
                RegisteredUserEmbeddingExperienceConfiguration.BuilderImpl experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration != null ? experienceConfiguration.build() : null;
        }

        @Override
        public final Builder experienceConfiguration(RegisteredUserEmbeddingExperienceConfiguration experienceConfiguration) {
            this.experienceConfiguration = experienceConfiguration;
            return this;
        }

        public final Collection<String> getAllowedDomains() {
            if (allowedDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedDomains;
        }

        public final void setAllowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
        }

        @Override
        public final Builder allowedDomains(Collection<String> allowedDomains) {
            this.allowedDomains = StringListCopier.copy(allowedDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedDomains(String... allowedDomains) {
            allowedDomains(Arrays.asList(allowedDomains));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GenerateEmbedUrlForRegisteredUserRequest build() {
            return new GenerateEmbedUrlForRegisteredUserRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
