/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateIamPolicyAssignmentRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateIamPolicyAssignmentRequest.Builder, CreateIamPolicyAssignmentRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateIamPolicyAssignmentRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ASSIGNMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentName").getter(getter(CreateIamPolicyAssignmentRequest::assignmentName))
            .setter(setter(Builder::assignmentName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentName").build()).build();

    private static final SdkField<String> ASSIGNMENT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AssignmentStatus").getter(getter(CreateIamPolicyAssignmentRequest::assignmentStatusAsString))
            .setter(setter(Builder::assignmentStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AssignmentStatus").build()).build();

    private static final SdkField<String> POLICY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PolicyArn").getter(getter(CreateIamPolicyAssignmentRequest::policyArn))
            .setter(setter(Builder::policyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PolicyArn").build()).build();

    private static final SdkField<Map<String, List<String>>> IDENTITIES_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("Identities")
            .getter(getter(CreateIamPolicyAssignmentRequest::identities))
            .setter(setter(Builder::identities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Identities").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Namespace").getter(getter(CreateIamPolicyAssignmentRequest::namespace))
            .setter(setter(Builder::namespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("Namespace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            ASSIGNMENT_NAME_FIELD, ASSIGNMENT_STATUS_FIELD, POLICY_ARN_FIELD, IDENTITIES_FIELD, NAMESPACE_FIELD));

    private final String awsAccountId;

    private final String assignmentName;

    private final String assignmentStatus;

    private final String policyArn;

    private final Map<String, List<String>> identities;

    private final String namespace;

    private CreateIamPolicyAssignmentRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.assignmentName = builder.assignmentName;
        this.assignmentStatus = builder.assignmentStatus;
        this.policyArn = builder.policyArn;
        this.identities = builder.identities;
        this.namespace = builder.namespace;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account; where you want to assign an IAM policy to QuickSight users or groups.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account; where you want to assign an IAM policy to QuickSight users or
     *         groups.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account;.
     * </p>
     * 
     * @return The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account;.
     */
    public final String assignmentName() {
        return assignmentName;
    }

    /**
     * <p>
     * The status of the assignment. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - This assignment isn't used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - This assignment isn't used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     *         </p>
     *         </li>
     * @see AssignmentStatus
     */
    public final AssignmentStatus assignmentStatus() {
        return AssignmentStatus.fromValue(assignmentStatus);
    }

    /**
     * <p>
     * The status of the assignment. Possible values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DISABLED</code> - This assignment isn't used when creating the data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #assignmentStatus}
     * will return {@link AssignmentStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #assignmentStatusAsString}.
     * </p>
     * 
     * @return The status of the assignment. Possible values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DISABLED</code> - This assignment isn't used when creating the data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
     *         </p>
     *         </li>
     * @see AssignmentStatus
     */
    public final String assignmentStatusAsString() {
        return assignmentStatus;
    }

    /**
     * <p>
     * The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
     * </p>
     * 
     * @return The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
     */
    public final String policyArn() {
        return policyArn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Identities property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasIdentities() {
        return identities != null && !(identities instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The QuickSight users, groups, or both that you want to assign the policy to.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasIdentities} method.
     * </p>
     * 
     * @return The QuickSight users, groups, or both that you want to assign the policy to.
     */
    public final Map<String, List<String>> identities() {
        return identities;
    }

    /**
     * <p>
     * The namespace that contains the assignment.
     * </p>
     * 
     * @return The namespace that contains the assignment.
     */
    public final String namespace() {
        return namespace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentName());
        hashCode = 31 * hashCode + Objects.hashCode(assignmentStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(policyArn());
        hashCode = 31 * hashCode + Objects.hashCode(hasIdentities() ? identities() : null);
        hashCode = 31 * hashCode + Objects.hashCode(namespace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateIamPolicyAssignmentRequest)) {
            return false;
        }
        CreateIamPolicyAssignmentRequest other = (CreateIamPolicyAssignmentRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(assignmentName(), other.assignmentName())
                && Objects.equals(assignmentStatusAsString(), other.assignmentStatusAsString())
                && Objects.equals(policyArn(), other.policyArn()) && hasIdentities() == other.hasIdentities()
                && Objects.equals(identities(), other.identities()) && Objects.equals(namespace(), other.namespace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateIamPolicyAssignmentRequest").add("AwsAccountId", awsAccountId())
                .add("AssignmentName", assignmentName()).add("AssignmentStatus", assignmentStatusAsString())
                .add("PolicyArn", policyArn()).add("Identities", hasIdentities() ? identities() : null)
                .add("Namespace", namespace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AssignmentName":
            return Optional.ofNullable(clazz.cast(assignmentName()));
        case "AssignmentStatus":
            return Optional.ofNullable(clazz.cast(assignmentStatusAsString()));
        case "PolicyArn":
            return Optional.ofNullable(clazz.cast(policyArn()));
        case "Identities":
            return Optional.ofNullable(clazz.cast(identities()));
        case "Namespace":
            return Optional.ofNullable(clazz.cast(namespace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateIamPolicyAssignmentRequest, T> g) {
        return obj -> g.apply((CreateIamPolicyAssignmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateIamPolicyAssignmentRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account; where you want to assign an IAM policy to QuickSight users or
         * groups.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account; where you want to assign an IAM policy to QuickSight users
         *        or groups.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The name of the assignment, also called a rule. It must be unique within an Amazon Web Services account;.
         * </p>
         * 
         * @param assignmentName
         *        The name of the assignment, also called a rule. It must be unique within an Amazon Web Services
         *        account;.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignmentName(String assignmentName);

        /**
         * <p>
         * The status of the assignment. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - This assignment isn't used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assignmentStatus
         *        The status of the assignment. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - This assignment isn't used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data
         *        source.
         *        </p>
         *        </li>
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(String assignmentStatus);

        /**
         * <p>
         * The status of the assignment. Possible values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DISABLED</code> - This assignment isn't used when creating the data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data source.
         * </p>
         * </li>
         * </ul>
         * 
         * @param assignmentStatus
         *        The status of the assignment. Possible values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ENABLED</code> - Anything specified in this assignment is used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DISABLED</code> - This assignment isn't used when creating the data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DRAFT</code> - This assignment is an unfinished draft and isn't used when creating the data
         *        source.
         *        </p>
         *        </li>
         * @see AssignmentStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssignmentStatus
         */
        Builder assignmentStatus(AssignmentStatus assignmentStatus);

        /**
         * <p>
         * The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
         * </p>
         * 
         * @param policyArn
         *        The ARN for the IAM policy to apply to the QuickSight users and groups specified in this assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder policyArn(String policyArn);

        /**
         * <p>
         * The QuickSight users, groups, or both that you want to assign the policy to.
         * </p>
         * 
         * @param identities
         *        The QuickSight users, groups, or both that you want to assign the policy to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identities(Map<String, ? extends Collection<String>> identities);

        /**
         * <p>
         * The namespace that contains the assignment.
         * </p>
         * 
         * @param namespace
         *        The namespace that contains the assignment.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder namespace(String namespace);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String assignmentName;

        private String assignmentStatus;

        private String policyArn;

        private Map<String, List<String>> identities = DefaultSdkAutoConstructMap.getInstance();

        private String namespace;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateIamPolicyAssignmentRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            assignmentName(model.assignmentName);
            assignmentStatus(model.assignmentStatus);
            policyArn(model.policyArn);
            identities(model.identities);
            namespace(model.namespace);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAssignmentName() {
            return assignmentName;
        }

        public final void setAssignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
        }

        @Override
        @Transient
        public final Builder assignmentName(String assignmentName) {
            this.assignmentName = assignmentName;
            return this;
        }

        public final String getAssignmentStatus() {
            return assignmentStatus;
        }

        public final void setAssignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
        }

        @Override
        @Transient
        public final Builder assignmentStatus(String assignmentStatus) {
            this.assignmentStatus = assignmentStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder assignmentStatus(AssignmentStatus assignmentStatus) {
            this.assignmentStatus(assignmentStatus == null ? null : assignmentStatus.toString());
            return this;
        }

        public final String getPolicyArn() {
            return policyArn;
        }

        public final void setPolicyArn(String policyArn) {
            this.policyArn = policyArn;
        }

        @Override
        @Transient
        public final Builder policyArn(String policyArn) {
            this.policyArn = policyArn;
            return this;
        }

        public final Map<String, ? extends Collection<String>> getIdentities() {
            if (identities instanceof SdkAutoConstructMap) {
                return null;
            }
            return identities;
        }

        public final void setIdentities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
        }

        @Override
        @Transient
        public final Builder identities(Map<String, ? extends Collection<String>> identities) {
            this.identities = IdentityMapCopier.copy(identities);
            return this;
        }

        public final String getNamespace() {
            return namespace;
        }

        public final void setNamespace(String namespace) {
            this.namespace = namespace;
        }

        @Override
        @Transient
        public final Builder namespace(String namespace) {
            this.namespace = namespace;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateIamPolicyAssignmentRequest build() {
            return new CreateIamPolicyAssignmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
