/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The instructions associated with a join.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JoinInstruction implements SdkPojo, Serializable, ToCopyableBuilder<JoinInstruction.Builder, JoinInstruction> {
    private static final SdkField<String> LEFT_OPERAND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LeftOperand").getter(getter(JoinInstruction::leftOperand)).setter(setter(Builder::leftOperand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftOperand").build()).build();

    private static final SdkField<String> RIGHT_OPERAND_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RightOperand").getter(getter(JoinInstruction::rightOperand)).setter(setter(Builder::rightOperand))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightOperand").build()).build();

    private static final SdkField<JoinKeyProperties> LEFT_JOIN_KEY_PROPERTIES_FIELD = SdkField
            .<JoinKeyProperties> builder(MarshallingType.SDK_POJO).memberName("LeftJoinKeyProperties")
            .getter(getter(JoinInstruction::leftJoinKeyProperties)).setter(setter(Builder::leftJoinKeyProperties))
            .constructor(JoinKeyProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LeftJoinKeyProperties").build())
            .build();

    private static final SdkField<JoinKeyProperties> RIGHT_JOIN_KEY_PROPERTIES_FIELD = SdkField
            .<JoinKeyProperties> builder(MarshallingType.SDK_POJO).memberName("RightJoinKeyProperties")
            .getter(getter(JoinInstruction::rightJoinKeyProperties)).setter(setter(Builder::rightJoinKeyProperties))
            .constructor(JoinKeyProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RightJoinKeyProperties").build())
            .build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(JoinInstruction::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> ON_CLAUSE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("OnClause").getter(getter(JoinInstruction::onClause)).setter(setter(Builder::onClause))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OnClause").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LEFT_OPERAND_FIELD,
            RIGHT_OPERAND_FIELD, LEFT_JOIN_KEY_PROPERTIES_FIELD, RIGHT_JOIN_KEY_PROPERTIES_FIELD, TYPE_FIELD, ON_CLAUSE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String leftOperand;

    private final String rightOperand;

    private final JoinKeyProperties leftJoinKeyProperties;

    private final JoinKeyProperties rightJoinKeyProperties;

    private final String type;

    private final String onClause;

    private JoinInstruction(BuilderImpl builder) {
        this.leftOperand = builder.leftOperand;
        this.rightOperand = builder.rightOperand;
        this.leftJoinKeyProperties = builder.leftJoinKeyProperties;
        this.rightJoinKeyProperties = builder.rightJoinKeyProperties;
        this.type = builder.type;
        this.onClause = builder.onClause;
    }

    /**
     * <p>
     * The operand on the left side of a join.
     * </p>
     * 
     * @return The operand on the left side of a join.
     */
    public final String leftOperand() {
        return leftOperand;
    }

    /**
     * <p>
     * The operand on the right side of a join.
     * </p>
     * 
     * @return The operand on the right side of a join.
     */
    public final String rightOperand() {
        return rightOperand;
    }

    /**
     * <p>
     * Join key properties of the left operand.
     * </p>
     * 
     * @return Join key properties of the left operand.
     */
    public final JoinKeyProperties leftJoinKeyProperties() {
        return leftJoinKeyProperties;
    }

    /**
     * <p>
     * Join key properties of the right operand.
     * </p>
     * 
     * @return Join key properties of the right operand.
     */
    public final JoinKeyProperties rightJoinKeyProperties() {
        return rightJoinKeyProperties;
    }

    /**
     * <p>
     * The type of join that it is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JoinType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of join that it is.
     * @see JoinType
     */
    public final JoinType type() {
        return JoinType.fromValue(type);
    }

    /**
     * <p>
     * The type of join that it is.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link JoinType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of join that it is.
     * @see JoinType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The join instructions provided in the <code>ON</code> clause of a join.
     * </p>
     * 
     * @return The join instructions provided in the <code>ON</code> clause of a join.
     */
    public final String onClause() {
        return onClause;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(leftOperand());
        hashCode = 31 * hashCode + Objects.hashCode(rightOperand());
        hashCode = 31 * hashCode + Objects.hashCode(leftJoinKeyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(rightJoinKeyProperties());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(onClause());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JoinInstruction)) {
            return false;
        }
        JoinInstruction other = (JoinInstruction) obj;
        return Objects.equals(leftOperand(), other.leftOperand()) && Objects.equals(rightOperand(), other.rightOperand())
                && Objects.equals(leftJoinKeyProperties(), other.leftJoinKeyProperties())
                && Objects.equals(rightJoinKeyProperties(), other.rightJoinKeyProperties())
                && Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(onClause(), other.onClause());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JoinInstruction").add("LeftOperand", leftOperand()).add("RightOperand", rightOperand())
                .add("LeftJoinKeyProperties", leftJoinKeyProperties()).add("RightJoinKeyProperties", rightJoinKeyProperties())
                .add("Type", typeAsString()).add("OnClause", onClause()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "LeftOperand":
            return Optional.ofNullable(clazz.cast(leftOperand()));
        case "RightOperand":
            return Optional.ofNullable(clazz.cast(rightOperand()));
        case "LeftJoinKeyProperties":
            return Optional.ofNullable(clazz.cast(leftJoinKeyProperties()));
        case "RightJoinKeyProperties":
            return Optional.ofNullable(clazz.cast(rightJoinKeyProperties()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "OnClause":
            return Optional.ofNullable(clazz.cast(onClause()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<JoinInstruction, T> g) {
        return obj -> g.apply((JoinInstruction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JoinInstruction> {
        /**
         * <p>
         * The operand on the left side of a join.
         * </p>
         * 
         * @param leftOperand
         *        The operand on the left side of a join.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leftOperand(String leftOperand);

        /**
         * <p>
         * The operand on the right side of a join.
         * </p>
         * 
         * @param rightOperand
         *        The operand on the right side of a join.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightOperand(String rightOperand);

        /**
         * <p>
         * Join key properties of the left operand.
         * </p>
         * 
         * @param leftJoinKeyProperties
         *        Join key properties of the left operand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder leftJoinKeyProperties(JoinKeyProperties leftJoinKeyProperties);

        /**
         * <p>
         * Join key properties of the left operand.
         * </p>
         * This is a convenience that creates an instance of the {@link JoinKeyProperties.Builder} avoiding the need to
         * create one manually via {@link JoinKeyProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link JoinKeyProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #leftJoinKeyProperties(JoinKeyProperties)}.
         * 
         * @param leftJoinKeyProperties
         *        a consumer that will call methods on {@link JoinKeyProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #leftJoinKeyProperties(JoinKeyProperties)
         */
        default Builder leftJoinKeyProperties(Consumer<JoinKeyProperties.Builder> leftJoinKeyProperties) {
            return leftJoinKeyProperties(JoinKeyProperties.builder().applyMutation(leftJoinKeyProperties).build());
        }

        /**
         * <p>
         * Join key properties of the right operand.
         * </p>
         * 
         * @param rightJoinKeyProperties
         *        Join key properties of the right operand.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rightJoinKeyProperties(JoinKeyProperties rightJoinKeyProperties);

        /**
         * <p>
         * Join key properties of the right operand.
         * </p>
         * This is a convenience that creates an instance of the {@link JoinKeyProperties.Builder} avoiding the need to
         * create one manually via {@link JoinKeyProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link JoinKeyProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #rightJoinKeyProperties(JoinKeyProperties)}.
         * 
         * @param rightJoinKeyProperties
         *        a consumer that will call methods on {@link JoinKeyProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rightJoinKeyProperties(JoinKeyProperties)
         */
        default Builder rightJoinKeyProperties(Consumer<JoinKeyProperties.Builder> rightJoinKeyProperties) {
            return rightJoinKeyProperties(JoinKeyProperties.builder().applyMutation(rightJoinKeyProperties).build());
        }

        /**
         * <p>
         * The type of join that it is.
         * </p>
         * 
         * @param type
         *        The type of join that it is.
         * @see JoinType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of join that it is.
         * </p>
         * 
         * @param type
         *        The type of join that it is.
         * @see JoinType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JoinType
         */
        Builder type(JoinType type);

        /**
         * <p>
         * The join instructions provided in the <code>ON</code> clause of a join.
         * </p>
         * 
         * @param onClause
         *        The join instructions provided in the <code>ON</code> clause of a join.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder onClause(String onClause);
    }

    static final class BuilderImpl implements Builder {
        private String leftOperand;

        private String rightOperand;

        private JoinKeyProperties leftJoinKeyProperties;

        private JoinKeyProperties rightJoinKeyProperties;

        private String type;

        private String onClause;

        private BuilderImpl() {
        }

        private BuilderImpl(JoinInstruction model) {
            leftOperand(model.leftOperand);
            rightOperand(model.rightOperand);
            leftJoinKeyProperties(model.leftJoinKeyProperties);
            rightJoinKeyProperties(model.rightJoinKeyProperties);
            type(model.type);
            onClause(model.onClause);
        }

        public final String getLeftOperand() {
            return leftOperand;
        }

        public final void setLeftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
        }

        @Override
        @Transient
        public final Builder leftOperand(String leftOperand) {
            this.leftOperand = leftOperand;
            return this;
        }

        public final String getRightOperand() {
            return rightOperand;
        }

        public final void setRightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
        }

        @Override
        @Transient
        public final Builder rightOperand(String rightOperand) {
            this.rightOperand = rightOperand;
            return this;
        }

        public final JoinKeyProperties.Builder getLeftJoinKeyProperties() {
            return leftJoinKeyProperties != null ? leftJoinKeyProperties.toBuilder() : null;
        }

        public final void setLeftJoinKeyProperties(JoinKeyProperties.BuilderImpl leftJoinKeyProperties) {
            this.leftJoinKeyProperties = leftJoinKeyProperties != null ? leftJoinKeyProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder leftJoinKeyProperties(JoinKeyProperties leftJoinKeyProperties) {
            this.leftJoinKeyProperties = leftJoinKeyProperties;
            return this;
        }

        public final JoinKeyProperties.Builder getRightJoinKeyProperties() {
            return rightJoinKeyProperties != null ? rightJoinKeyProperties.toBuilder() : null;
        }

        public final void setRightJoinKeyProperties(JoinKeyProperties.BuilderImpl rightJoinKeyProperties) {
            this.rightJoinKeyProperties = rightJoinKeyProperties != null ? rightJoinKeyProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder rightJoinKeyProperties(JoinKeyProperties rightJoinKeyProperties) {
            this.rightJoinKeyProperties = rightJoinKeyProperties;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        @Transient
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        @Transient
        public final Builder type(JoinType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getOnClause() {
            return onClause;
        }

        public final void setOnClause(String onClause) {
            this.onClause = onClause;
        }

        @Override
        @Transient
        public final Builder onClause(String onClause) {
            this.onClause = onClause;
            return this;
        }

        @Override
        public JoinInstruction build() {
            return new JoinInstruction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
