/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A template object. A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to
 * create an analysis and that you can use to create a dashboard. A template adds a layer of abstraction by using
 * placeholders to replace the dataset associated with an analysis. You can use templates to create dashboards by
 * replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis
 * and template.
 * </p>
 * <p>
 * You can share templates across Amazon Web Services accounts by allowing users in other Amazon Web Services accounts
 * to create a template or a dashboard from an existing template.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Template implements SdkPojo, Serializable, ToCopyableBuilder<Template.Builder, Template> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Template::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Template::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<TemplateVersion> VERSION_FIELD = SdkField.<TemplateVersion> builder(MarshallingType.SDK_POJO)
            .memberName("Version").getter(getter(Template::version)).setter(setter(Builder::version))
            .constructor(TemplateVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<String> TEMPLATE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TemplateId").getter(getter(Template::templateId)).setter(setter(Builder::templateId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateId").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Template::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Template::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            VERSION_FIELD, TEMPLATE_ID_FIELD, LAST_UPDATED_TIME_FIELD, CREATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final TemplateVersion version;

    private final String templateId;

    private final Instant lastUpdatedTime;

    private final Instant createdTime;

    private Template(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.templateId = builder.templateId;
        this.lastUpdatedTime = builder.lastUpdatedTime;
        this.createdTime = builder.createdTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the template.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the template.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The display name of the template.
     * </p>
     * 
     * @return The display name of the template.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A structure describing the versions of the template.
     * </p>
     * 
     * @return A structure describing the versions of the template.
     */
    public final TemplateVersion version() {
        return version;
    }

    /**
     * <p>
     * The ID for the template. This is unique per Amazon Web Services Region; for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID for the template. This is unique per Amazon Web Services Region; for each Amazon Web Services
     *         account.
     */
    public final String templateId() {
        return templateId;
    }

    /**
     * <p>
     * Time when this was last updated.
     * </p>
     * 
     * @return Time when this was last updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    /**
     * <p>
     * Time when this was created.
     * </p>
     * 
     * @return Time when this was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(templateId());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Template)) {
            return false;
        }
        Template other = (Template) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(version(), other.version()) && Objects.equals(templateId(), other.templateId())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime())
                && Objects.equals(createdTime(), other.createdTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Template").add("Arn", arn()).add("Name", name()).add("Version", version())
                .add("TemplateId", templateId()).add("LastUpdatedTime", lastUpdatedTime()).add("CreatedTime", createdTime())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "TemplateId":
            return Optional.ofNullable(clazz.cast(templateId()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Template, T> g) {
        return obj -> g.apply((Template) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Template> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the template.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The display name of the template.
         * </p>
         * 
         * @param name
         *        The display name of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A structure describing the versions of the template.
         * </p>
         * 
         * @param version
         *        A structure describing the versions of the template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(TemplateVersion version);

        /**
         * <p>
         * A structure describing the versions of the template.
         * </p>
         * This is a convenience that creates an instance of the {@link TemplateVersion.Builder} avoiding the need to
         * create one manually via {@link TemplateVersion#builder()}.
         *
         * When the {@link Consumer} completes, {@link TemplateVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #version(TemplateVersion)}.
         * 
         * @param version
         *        a consumer that will call methods on {@link TemplateVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #version(TemplateVersion)
         */
        default Builder version(Consumer<TemplateVersion.Builder> version) {
            return version(TemplateVersion.builder().applyMutation(version).build());
        }

        /**
         * <p>
         * The ID for the template. This is unique per Amazon Web Services Region; for each Amazon Web Services account.
         * </p>
         * 
         * @param templateId
         *        The ID for the template. This is unique per Amazon Web Services Region; for each Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateId(String templateId);

        /**
         * <p>
         * Time when this was last updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        Time when this was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);

        /**
         * <p>
         * Time when this was created.
         * </p>
         * 
         * @param createdTime
         *        Time when this was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private TemplateVersion version;

        private String templateId;

        private Instant lastUpdatedTime;

        private Instant createdTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Template model) {
            arn(model.arn);
            name(model.name);
            version(model.version);
            templateId(model.templateId);
            lastUpdatedTime(model.lastUpdatedTime);
            createdTime(model.createdTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final TemplateVersion.Builder getVersion() {
            return version != null ? version.toBuilder() : null;
        }

        public final void setVersion(TemplateVersion.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        @Transient
        public final Builder version(TemplateVersion version) {
            this.version = version;
            return this;
        }

        public final String getTemplateId() {
            return templateId;
        }

        public final void setTemplateId(String templateId) {
            this.templateId = templateId;
        }

        @Override
        @Transient
        public final Builder templateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        @Override
        public Template build() {
            return new Template(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
