/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDataSourceRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateDataSourceRequest.Builder, CreateDataSourceRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateDataSourceRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DataSourceId").getter(getter(CreateDataSourceRequest::dataSourceId))
            .setter(setter(Builder::dataSourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDataSourceRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(CreateDataSourceRequest::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<DataSourceParameters> DATA_SOURCE_PARAMETERS_FIELD = SdkField
            .<DataSourceParameters> builder(MarshallingType.SDK_POJO).memberName("DataSourceParameters")
            .getter(getter(CreateDataSourceRequest::dataSourceParameters)).setter(setter(Builder::dataSourceParameters))
            .constructor(DataSourceParameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataSourceParameters").build())
            .build();

    private static final SdkField<DataSourceCredentials> CREDENTIALS_FIELD = SdkField
            .<DataSourceCredentials> builder(MarshallingType.SDK_POJO).memberName("Credentials")
            .getter(getter(CreateDataSourceRequest::credentials)).setter(setter(Builder::credentials))
            .constructor(DataSourceCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Credentials").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateDataSourceRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<VpcConnectionProperties> VPC_CONNECTION_PROPERTIES_FIELD = SdkField
            .<VpcConnectionProperties> builder(MarshallingType.SDK_POJO).memberName("VpcConnectionProperties")
            .getter(getter(CreateDataSourceRequest::vpcConnectionProperties)).setter(setter(Builder::vpcConnectionProperties))
            .constructor(VpcConnectionProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConnectionProperties").build())
            .build();

    private static final SdkField<SslProperties> SSL_PROPERTIES_FIELD = SdkField
            .<SslProperties> builder(MarshallingType.SDK_POJO).memberName("SslProperties")
            .getter(getter(CreateDataSourceRequest::sslProperties)).setter(setter(Builder::sslProperties))
            .constructor(SslProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SslProperties").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDataSourceRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DATA_SOURCE_ID_FIELD, NAME_FIELD, TYPE_FIELD, DATA_SOURCE_PARAMETERS_FIELD, CREDENTIALS_FIELD, PERMISSIONS_FIELD,
            VPC_CONNECTION_PROPERTIES_FIELD, SSL_PROPERTIES_FIELD, TAGS_FIELD));

    private final String awsAccountId;

    private final String dataSourceId;

    private final String name;

    private final String type;

    private final DataSourceParameters dataSourceParameters;

    private final DataSourceCredentials credentials;

    private final List<ResourcePermission> permissions;

    private final VpcConnectionProperties vpcConnectionProperties;

    private final SslProperties sslProperties;

    private final List<Tag> tags;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dataSourceId = builder.dataSourceId;
        this.name = builder.name;
        this.type = builder.type;
        this.dataSourceParameters = builder.dataSourceParameters;
        this.credentials = builder.credentials;
        this.permissions = builder.permissions;
        this.vpcConnectionProperties = builder.vpcConnectionProperties;
        this.sslProperties = builder.sslProperties;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The AWS account ID.
     * </p>
     * 
     * @return The AWS account ID.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * An ID for the data source. This ID is unique per AWS Region for each AWS account.
     * </p>
     * 
     * @return An ID for the data source. This ID is unique per AWS Region for each AWS account.
     */
    public final String dataSourceId() {
        return dataSourceId;
    }

    /**
     * <p>
     * A display name for the data source.
     * </p>
     * 
     * @return A display name for the data source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The type of the data source. Currently, the supported types for this operation are:
     * <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
     * . Use <code>ListDataSources</code> to return a list of all data sources.
     * </p>
     * <p>
     * <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source. Currently, the supported types for this operation are:
     *         <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
     *         . Use <code>ListDataSources</code> to return a list of all data sources.</p>
     *         <p>
     *         <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
     * @see DataSourceType
     */
    public final DataSourceType type() {
        return DataSourceType.fromValue(type);
    }

    /**
     * <p>
     * The type of the data source. Currently, the supported types for this operation are:
     * <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
     * . Use <code>ListDataSources</code> to return a list of all data sources.
     * </p>
     * <p>
     * <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DataSourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of the data source. Currently, the supported types for this operation are:
     *         <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
     *         . Use <code>ListDataSources</code> to return a list of all data sources.</p>
     *         <p>
     *         <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
     * @see DataSourceType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * The parameters that QuickSight uses to connect to your underlying source.
     * </p>
     * 
     * @return The parameters that QuickSight uses to connect to your underlying source.
     */
    public final DataSourceParameters dataSourceParameters() {
        return dataSourceParameters;
    }

    /**
     * <p>
     * The credentials QuickSight that uses to connect to your underlying source. Currently, only credentials based on
     * user name and password are supported.
     * </p>
     * 
     * @return The credentials QuickSight that uses to connect to your underlying source. Currently, only credentials
     *         based on user name and password are supported.
     */
    public final DataSourceCredentials credentials() {
        return credentials;
    }

    /**
     * Returns true if the Permissions property was specified by the sender (it may be empty), or false if the sender
     * did not specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of resource permissions on the data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasPermissions()} to see if a value was sent in this field.
     * </p>
     * 
     * @return A list of resource permissions on the data source.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying
     * source.
     * </p>
     * 
     * @return Use this parameter only when you want QuickSight to use a VPC connection when connecting to your
     *         underlying source.
     */
    public final VpcConnectionProperties vpcConnectionProperties() {
        return vpcConnectionProperties;
    }

    /**
     * <p>
     * Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
     * </p>
     * 
     * @return Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
     */
    public final SslProperties sslProperties() {
        return sslProperties;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
     */
    public final List<Tag> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceParameters());
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(vpcConnectionProperties());
        hashCode = 31 * hashCode + Objects.hashCode(sslProperties());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dataSourceId(), other.dataSourceId())
                && Objects.equals(name(), other.name()) && Objects.equals(typeAsString(), other.typeAsString())
                && Objects.equals(dataSourceParameters(), other.dataSourceParameters())
                && Objects.equals(credentials(), other.credentials()) && hasPermissions() == other.hasPermissions()
                && Objects.equals(permissions(), other.permissions())
                && Objects.equals(vpcConnectionProperties(), other.vpcConnectionProperties())
                && Objects.equals(sslProperties(), other.sslProperties()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDataSourceRequest").add("AwsAccountId", awsAccountId())
                .add("DataSourceId", dataSourceId()).add("Name", name()).add("Type", typeAsString())
                .add("DataSourceParameters", dataSourceParameters())
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Permissions", hasPermissions() ? permissions() : null)
                .add("VpcConnectionProperties", vpcConnectionProperties()).add("SslProperties", sslProperties())
                .add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DataSourceId":
            return Optional.ofNullable(clazz.cast(dataSourceId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "DataSourceParameters":
            return Optional.ofNullable(clazz.cast(dataSourceParameters()));
        case "Credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "VpcConnectionProperties":
            return Optional.ofNullable(clazz.cast(vpcConnectionProperties()));
        case "SslProperties":
            return Optional.ofNullable(clazz.cast(sslProperties()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDataSourceRequest> {
        /**
         * <p>
         * The AWS account ID.
         * </p>
         * 
         * @param awsAccountId
         *        The AWS account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * An ID for the data source. This ID is unique per AWS Region for each AWS account.
         * </p>
         * 
         * @param dataSourceId
         *        An ID for the data source. This ID is unique per AWS Region for each AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceId(String dataSourceId);

        /**
         * <p>
         * A display name for the data source.
         * </p>
         * 
         * @param name
         *        A display name for the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The type of the data source. Currently, the supported types for this operation are:
         * <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
         * . Use <code>ListDataSources</code> to return a list of all data sources.
         * </p>
         * <p>
         * <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
         * </p>
         * 
         * @param type
         *        The type of the data source. Currently, the supported types for this operation are:
         *        <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
         *        . Use <code>ListDataSources</code> to return a list of all data sources.</p>
         *        <p>
         *        <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of the data source. Currently, the supported types for this operation are:
         * <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
         * . Use <code>ListDataSources</code> to return a list of all data sources.
         * </p>
         * <p>
         * <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
         * </p>
         * 
         * @param type
         *        The type of the data source. Currently, the supported types for this operation are:
         *        <code>ATHENA, AURORA, AURORA_POSTGRESQL, AMAZON_ELASTICSEARCH, MARIADB, MYSQL, POSTGRESQL, PRESTO, REDSHIFT, S3, SNOWFLAKE, SPARK, SQLSERVER, TERADATA</code>
         *        . Use <code>ListDataSources</code> to return a list of all data sources.</p>
         *        <p>
         *        <code>AMAZON_ELASTICSEARCH</code> is for Amazon managed Elasticsearch Service.
         * @see DataSourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DataSourceType
         */
        Builder type(DataSourceType type);

        /**
         * <p>
         * The parameters that QuickSight uses to connect to your underlying source.
         * </p>
         * 
         * @param dataSourceParameters
         *        The parameters that QuickSight uses to connect to your underlying source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceParameters(DataSourceParameters dataSourceParameters);

        /**
         * <p>
         * The parameters that QuickSight uses to connect to your underlying source.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceParameters.Builder} avoiding the need
         * to create one manually via {@link DataSourceParameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceParameters.Builder#build()} is called immediately and
         * its result is passed to {@link #dataSourceParameters(DataSourceParameters)}.
         * 
         * @param dataSourceParameters
         *        a consumer that will call methods on {@link DataSourceParameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataSourceParameters(DataSourceParameters)
         */
        default Builder dataSourceParameters(Consumer<DataSourceParameters.Builder> dataSourceParameters) {
            return dataSourceParameters(DataSourceParameters.builder().applyMutation(dataSourceParameters).build());
        }

        /**
         * <p>
         * The credentials QuickSight that uses to connect to your underlying source. Currently, only credentials based
         * on user name and password are supported.
         * </p>
         * 
         * @param credentials
         *        The credentials QuickSight that uses to connect to your underlying source. Currently, only credentials
         *        based on user name and password are supported.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(DataSourceCredentials credentials);

        /**
         * <p>
         * The credentials QuickSight that uses to connect to your underlying source. Currently, only credentials based
         * on user name and password are supported.
         * </p>
         * This is a convenience that creates an instance of the {@link DataSourceCredentials.Builder} avoiding the need
         * to create one manually via {@link DataSourceCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link DataSourceCredentials.Builder#build()} is called immediately and
         * its result is passed to {@link #credentials(DataSourceCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link DataSourceCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(DataSourceCredentials)
         */
        default Builder credentials(Consumer<DataSourceCredentials.Builder> credentials) {
            return credentials(DataSourceCredentials.builder().applyMutation(credentials).build());
        }

        /**
         * <p>
         * A list of resource permissions on the data source.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions on the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A list of resource permissions on the data source.
         * </p>
         * 
         * @param permissions
         *        A list of resource permissions on the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A list of resource permissions on the data source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying
         * source.
         * </p>
         * 
         * @param vpcConnectionProperties
         *        Use this parameter only when you want QuickSight to use a VPC connection when connecting to your
         *        underlying source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties);

        /**
         * <p>
         * Use this parameter only when you want QuickSight to use a VPC connection when connecting to your underlying
         * source.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConnectionProperties.Builder} avoiding the
         * need to create one manually via {@link VpcConnectionProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConnectionProperties.Builder#build()} is called immediately
         * and its result is passed to {@link #vpcConnectionProperties(VpcConnectionProperties)}.
         * 
         * @param vpcConnectionProperties
         *        a consumer that will call methods on {@link VpcConnectionProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConnectionProperties(VpcConnectionProperties)
         */
        default Builder vpcConnectionProperties(Consumer<VpcConnectionProperties.Builder> vpcConnectionProperties) {
            return vpcConnectionProperties(VpcConnectionProperties.builder().applyMutation(vpcConnectionProperties).build());
        }

        /**
         * <p>
         * Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
         * </p>
         * 
         * @param sslProperties
         *        Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sslProperties(SslProperties sslProperties);

        /**
         * <p>
         * Secure Socket Layer (SSL) properties that apply when QuickSight connects to your underlying source.
         * </p>
         * This is a convenience that creates an instance of the {@link SslProperties.Builder} avoiding the need to
         * create one manually via {@link SslProperties#builder()}.
         *
         * When the {@link Consumer} completes, {@link SslProperties.Builder#build()} is called immediately and its
         * result is passed to {@link #sslProperties(SslProperties)}.
         * 
         * @param sslProperties
         *        a consumer that will call methods on {@link SslProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sslProperties(SslProperties)
         */
        default Builder sslProperties(Consumer<SslProperties.Builder> sslProperties) {
            return sslProperties(SslProperties.builder().applyMutation(sslProperties).build());
        }

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the data source.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dataSourceId;

        private String name;

        private String type;

        private DataSourceParameters dataSourceParameters;

        private DataSourceCredentials credentials;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private VpcConnectionProperties vpcConnectionProperties;

        private SslProperties sslProperties;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dataSourceId(model.dataSourceId);
            name(model.name);
            type(model.type);
            dataSourceParameters(model.dataSourceParameters);
            credentials(model.credentials);
            permissions(model.permissions);
            vpcConnectionProperties(model.vpcConnectionProperties);
            sslProperties(model.sslProperties);
            tags(model.tags);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        public final String getDataSourceId() {
            return dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getType() {
            return type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DataSourceType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final DataSourceParameters.Builder getDataSourceParameters() {
            return dataSourceParameters != null ? dataSourceParameters.toBuilder() : null;
        }

        @Override
        public final Builder dataSourceParameters(DataSourceParameters dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters;
            return this;
        }

        public final void setDataSourceParameters(DataSourceParameters.BuilderImpl dataSourceParameters) {
            this.dataSourceParameters = dataSourceParameters != null ? dataSourceParameters.build() : null;
        }

        public final DataSourceCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        @Override
        public final Builder credentials(DataSourceCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final void setCredentials(DataSourceCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        public final VpcConnectionProperties.Builder getVpcConnectionProperties() {
            return vpcConnectionProperties != null ? vpcConnectionProperties.toBuilder() : null;
        }

        @Override
        public final Builder vpcConnectionProperties(VpcConnectionProperties vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties;
            return this;
        }

        public final void setVpcConnectionProperties(VpcConnectionProperties.BuilderImpl vpcConnectionProperties) {
            this.vpcConnectionProperties = vpcConnectionProperties != null ? vpcConnectionProperties.build() : null;
        }

        public final SslProperties.Builder getSslProperties() {
            return sslProperties != null ? sslProperties.toBuilder() : null;
        }

        @Override
        public final Builder sslProperties(SslProperties sslProperties) {
            this.sslProperties = sslProperties;
            return this;
        }

        public final void setSslProperties(SslProperties.BuilderImpl sslProperties) {
            this.sslProperties = sslProperties != null ? sslProperties.build() : null;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
