/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeAccountSettingsResponse extends QuickSightResponse implements
        ToCopyableBuilder<DescribeAccountSettingsResponse.Builder, DescribeAccountSettingsResponse> {
    private static final SdkField<AccountSettings> ACCOUNT_SETTINGS_FIELD = SdkField
            .<AccountSettings> builder(MarshallingType.SDK_POJO).memberName("AccountSettings")
            .getter(getter(DescribeAccountSettingsResponse::accountSettings)).setter(setter(Builder::accountSettings))
            .constructor(AccountSettings::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountSettings").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DescribeAccountSettingsResponse::requestId))
            .setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DescribeAccountSettingsResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_SETTINGS_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD));

    private final AccountSettings accountSettings;

    private final String requestId;

    private final Integer status;

    private DescribeAccountSettingsResponse(BuilderImpl builder) {
        super(builder);
        this.accountSettings = builder.accountSettings;
        this.requestId = builder.requestId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of
     * Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the
     * Amazon QuickSight subscription. In the Amazon QuickSight console, the Amazon QuickSight subscription is sometimes
     * referred to as a Amazon QuickSight "account" even though it's technically not an account by itself. Instead, it's
     * a subscription to the Amazon QuickSight service for your Amazon Web Services account. The edition that you
     * subscribe to applies to Amazon QuickSight in every Amazon Web Services Region; where you use it.
     * </p>
     * 
     * @return The Amazon QuickSight settings for this Amazon Web Services account. This information includes the
     *         edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification
     *         email for the Amazon QuickSight subscription. In the Amazon QuickSight console, the Amazon QuickSight
     *         subscription is sometimes referred to as a Amazon QuickSight "account" even though it's technically not
     *         an account by itself. Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web
     *         Services account. The edition that you subscribe to applies to Amazon QuickSight in every Amazon Web
     *         Services Region; where you use it.
     */
    public final AccountSettings accountSettings() {
        return accountSettings;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountSettings());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAccountSettingsResponse)) {
            return false;
        }
        DescribeAccountSettingsResponse other = (DescribeAccountSettingsResponse) obj;
        return Objects.equals(accountSettings(), other.accountSettings()) && Objects.equals(requestId(), other.requestId())
                && Objects.equals(status(), other.status());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeAccountSettingsResponse").add("AccountSettings", accountSettings())
                .add("RequestId", requestId()).add("Status", status()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountSettings":
            return Optional.ofNullable(clazz.cast(accountSettings()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAccountSettingsResponse, T> g) {
        return obj -> g.apply((DescribeAccountSettingsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeAccountSettingsResponse> {
        /**
         * <p>
         * The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of
         * Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the
         * Amazon QuickSight subscription. In the Amazon QuickSight console, the Amazon QuickSight subscription is
         * sometimes referred to as a Amazon QuickSight "account" even though it's technically not an account by itself.
         * Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web Services account. The
         * edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region; where you use
         * it.
         * </p>
         * 
         * @param accountSettings
         *        The Amazon QuickSight settings for this Amazon Web Services account. This information includes the
         *        edition of Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the
         *        notification email for the Amazon QuickSight subscription. In the Amazon QuickSight console, the
         *        Amazon QuickSight subscription is sometimes referred to as a Amazon QuickSight "account" even though
         *        it's technically not an account by itself. Instead, it's a subscription to the Amazon QuickSight
         *        service for your Amazon Web Services account. The edition that you subscribe to applies to Amazon
         *        QuickSight in every Amazon Web Services Region; where you use it.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountSettings(AccountSettings accountSettings);

        /**
         * <p>
         * The Amazon QuickSight settings for this Amazon Web Services account. This information includes the edition of
         * Amazon Amazon QuickSight that you subscribed to (Standard or Enterprise) and the notification email for the
         * Amazon QuickSight subscription. In the Amazon QuickSight console, the Amazon QuickSight subscription is
         * sometimes referred to as a Amazon QuickSight "account" even though it's technically not an account by itself.
         * Instead, it's a subscription to the Amazon QuickSight service for your Amazon Web Services account. The
         * edition that you subscribe to applies to Amazon QuickSight in every Amazon Web Services Region; where you use
         * it.
         * </p>
         * This is a convenience that creates an instance of the {@link AccountSettings.Builder} avoiding the need to
         * create one manually via {@link AccountSettings#builder()}.
         *
         * When the {@link Consumer} completes, {@link AccountSettings.Builder#build()} is called immediately and its
         * result is passed to {@link #accountSettings(AccountSettings)}.
         * 
         * @param accountSettings
         *        a consumer that will call methods on {@link AccountSettings.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #accountSettings(AccountSettings)
         */
        default Builder accountSettings(Consumer<AccountSettings.Builder> accountSettings) {
            return accountSettings(AccountSettings.builder().applyMutation(accountSettings).build());
        }

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private AccountSettings accountSettings;

        private String requestId;

        private Integer status;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAccountSettingsResponse model) {
            super(model);
            accountSettings(model.accountSettings);
            requestId(model.requestId);
            status(model.status);
        }

        public final AccountSettings.Builder getAccountSettings() {
            return accountSettings != null ? accountSettings.toBuilder() : null;
        }

        public final void setAccountSettings(AccountSettings.BuilderImpl accountSettings) {
            this.accountSettings = accountSettings != null ? accountSettings.build() : null;
        }

        @Override
        @Transient
        public final Builder accountSettings(AccountSettings accountSettings) {
            this.accountSettings = accountSettings;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        @Override
        public DescribeAccountSettingsResponse build() {
            return new DescribeAccountSettingsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
