/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The template alias.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TemplateAlias implements SdkPojo, Serializable, ToCopyableBuilder<TemplateAlias.Builder, TemplateAlias> {
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(TemplateAlias::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(TemplateAlias::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<Long> TEMPLATE_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("TemplateVersionNumber").getter(getter(TemplateAlias::templateVersionNumber))
            .setter(setter(Builder::templateVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TemplateVersionNumber").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_NAME_FIELD, ARN_FIELD,
            TEMPLATE_VERSION_NUMBER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aliasName;

    private final String arn;

    private final Long templateVersionNumber;

    private TemplateAlias(BuilderImpl builder) {
        this.aliasName = builder.aliasName;
        this.arn = builder.arn;
        this.templateVersionNumber = builder.templateVersionNumber;
    }

    /**
     * <p>
     * The display name of the template alias.
     * </p>
     * 
     * @return The display name of the template alias.
     */
    public final String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the template alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the template alias.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The version number of the template alias.
     * </p>
     * 
     * @return The version number of the template alias.
     */
    public final Long templateVersionNumber() {
        return templateVersionNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(templateVersionNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateAlias)) {
            return false;
        }
        TemplateAlias other = (TemplateAlias) obj;
        return Objects.equals(aliasName(), other.aliasName()) && Objects.equals(arn(), other.arn())
                && Objects.equals(templateVersionNumber(), other.templateVersionNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TemplateAlias").add("AliasName", aliasName()).add("Arn", arn())
                .add("TemplateVersionNumber", templateVersionNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "TemplateVersionNumber":
            return Optional.ofNullable(clazz.cast(templateVersionNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TemplateAlias, T> g) {
        return obj -> g.apply((TemplateAlias) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TemplateAlias> {
        /**
         * <p>
         * The display name of the template alias.
         * </p>
         * 
         * @param aliasName
         *        The display name of the template alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the template alias.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the template alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The version number of the template alias.
         * </p>
         * 
         * @param templateVersionNumber
         *        The version number of the template alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder templateVersionNumber(Long templateVersionNumber);
    }

    static final class BuilderImpl implements Builder {
        private String aliasName;

        private String arn;

        private Long templateVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(TemplateAlias model) {
            aliasName(model.aliasName);
            arn(model.arn);
            templateVersionNumber(model.templateVersionNumber);
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        @Transient
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Long getTemplateVersionNumber() {
            return templateVersionNumber;
        }

        public final void setTemplateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
        }

        @Override
        @Transient
        public final Builder templateVersionNumber(Long templateVersionNumber) {
            this.templateVersionNumber = templateVersionNumber;
            return this;
        }

        @Override
        public TemplateAlias build() {
            return new TemplateAlias(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
