/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The theme summary.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThemeSummary implements SdkPojo, Serializable, ToCopyableBuilder<ThemeSummary.Builder, ThemeSummary> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(ThemeSummary::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(ThemeSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeId").getter(getter(ThemeSummary::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeId").build()).build();

    private static final SdkField<Long> LATEST_VERSION_NUMBER_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("LatestVersionNumber").getter(getter(ThemeSummary::latestVersionNumber))
            .setter(setter(Builder::latestVersionNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestVersionNumber").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(ThemeSummary::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(ThemeSummary::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            THEME_ID_FIELD, LATEST_VERSION_NUMBER_FIELD, CREATED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String themeId;

    private final Long latestVersionNumber;

    private final Instant createdTime;

    private final Instant lastUpdatedTime;

    private ThemeSummary(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.themeId = builder.themeId;
        this.latestVersionNumber = builder.latestVersionNumber;
        this.createdTime = builder.createdTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * the display name for the theme.
     * </p>
     * 
     * @return the display name for the theme.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The ID of the theme. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.
     * </p>
     * 
     * @return The ID of the theme. This ID is unique per Amazon Web Services Region; for each Amazon Web Services
     *         account.
     */
    public final String themeId() {
        return themeId;
    }

    /**
     * <p>
     * The latest version number for the theme.
     * </p>
     * 
     * @return The latest version number for the theme.
     */
    public final Long latestVersionNumber() {
        return latestVersionNumber;
    }

    /**
     * <p>
     * The date and time that this theme was created.
     * </p>
     * 
     * @return The date and time that this theme was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last date and time that this theme was updated.
     * </p>
     * 
     * @return The last date and time that this theme was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeSummary)) {
            return false;
        }
        ThemeSummary other = (ThemeSummary) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(themeId(), other.themeId())
                && Objects.equals(latestVersionNumber(), other.latestVersionNumber())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThemeSummary").add("Arn", arn()).add("Name", name()).add("ThemeId", themeId())
                .add("LatestVersionNumber", latestVersionNumber()).add("CreatedTime", createdTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        case "LatestVersionNumber":
            return Optional.ofNullable(clazz.cast(latestVersionNumber()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ThemeSummary, T> g) {
        return obj -> g.apply((ThemeSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThemeSummary> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * the display name for the theme.
         * </p>
         * 
         * @param name
         *        the display name for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The ID of the theme. This ID is unique per Amazon Web Services Region; for each Amazon Web Services account.
         * </p>
         * 
         * @param themeId
         *        The ID of the theme. This ID is unique per Amazon Web Services Region; for each Amazon Web Services
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);

        /**
         * <p>
         * The latest version number for the theme.
         * </p>
         * 
         * @param latestVersionNumber
         *        The latest version number for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersionNumber(Long latestVersionNumber);

        /**
         * <p>
         * The date and time that this theme was created.
         * </p>
         * 
         * @param createdTime
         *        The date and time that this theme was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last date and time that this theme was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last date and time that this theme was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String themeId;

        private Long latestVersionNumber;

        private Instant createdTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeSummary model) {
            arn(model.arn);
            name(model.name);
            themeId(model.themeId);
            latestVersionNumber(model.latestVersionNumber);
            createdTime(model.createdTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getThemeId() {
            return themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        @Transient
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        public final Long getLatestVersionNumber() {
            return latestVersionNumber;
        }

        public final void setLatestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
        }

        @Override
        @Transient
        public final Builder latestVersionNumber(Long latestVersionNumber) {
            this.latestVersionNumber = latestVersionNumber;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        @Transient
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public ThemeSummary build() {
            return new ThemeSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
