/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDashboardRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateDashboardRequest.Builder, CreateDashboardRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateDashboardRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(CreateDashboardRequest::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(CreateDashboardRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<Parameters> PARAMETERS_FIELD = SdkField.<Parameters> builder(MarshallingType.SDK_POJO)
            .memberName("Parameters").getter(getter(CreateDashboardRequest::parameters)).setter(setter(Builder::parameters))
            .constructor(Parameters::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Parameters").build()).build();

    private static final SdkField<List<ResourcePermission>> PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("Permissions")
            .getter(getter(CreateDashboardRequest::permissions))
            .setter(setter(Builder::permissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<DashboardSourceEntity> SOURCE_ENTITY_FIELD = SdkField
            .<DashboardSourceEntity> builder(MarshallingType.SDK_POJO).memberName("SourceEntity")
            .getter(getter(CreateDashboardRequest::sourceEntity)).setter(setter(Builder::sourceEntity))
            .constructor(DashboardSourceEntity::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceEntity").build()).build();

    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField
            .<List<Tag>> builder(MarshallingType.LIST)
            .memberName("Tags")
            .getter(getter(CreateDashboardRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Tag> builder(MarshallingType.SDK_POJO)
                                            .constructor(Tag::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> VERSION_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VersionDescription").getter(getter(CreateDashboardRequest::versionDescription))
            .setter(setter(Builder::versionDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VersionDescription").build())
            .build();

    private static final SdkField<DashboardPublishOptions> DASHBOARD_PUBLISH_OPTIONS_FIELD = SdkField
            .<DashboardPublishOptions> builder(MarshallingType.SDK_POJO).memberName("DashboardPublishOptions")
            .getter(getter(CreateDashboardRequest::dashboardPublishOptions)).setter(setter(Builder::dashboardPublishOptions))
            .constructor(DashboardPublishOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardPublishOptions").build())
            .build();

    private static final SdkField<String> THEME_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeArn").getter(getter(CreateDashboardRequest::themeArn)).setter(setter(Builder::themeArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, NAME_FIELD, PARAMETERS_FIELD, PERMISSIONS_FIELD, SOURCE_ENTITY_FIELD, TAGS_FIELD,
            VERSION_DESCRIPTION_FIELD, DASHBOARD_PUBLISH_OPTIONS_FIELD, THEME_ARN_FIELD));

    private final String awsAccountId;

    private final String dashboardId;

    private final String name;

    private final Parameters parameters;

    private final List<ResourcePermission> permissions;

    private final DashboardSourceEntity sourceEntity;

    private final List<Tag> tags;

    private final String versionDescription;

    private final DashboardPublishOptions dashboardPublishOptions;

    private final String themeArn;

    private CreateDashboardRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.name = builder.name;
        this.parameters = builder.parameters;
        this.permissions = builder.permissions;
        this.sourceEntity = builder.sourceEntity;
        this.tags = builder.tags;
        this.versionDescription = builder.versionDescription;
        this.dashboardPublishOptions = builder.dashboardPublishOptions;
        this.themeArn = builder.themeArn;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account where you want to create the dashboard.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account where you want to create the dashboard.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the dashboard, also added to the IAMpolicy.
     * </p>
     * 
     * @return The ID for the dashboard, also added to the IAMpolicy.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The display name of the dashboard.
     * </p>
     * 
     * @return The display name of the dashboard.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The parameters for the creation of the dashboard, which you want to use to override the default settings. A
     * dashboard can have any type of parameters, and some parameters might accept multiple values.
     * </p>
     * 
     * @return The parameters for the creation of the dashboard, which you want to use to override the default settings.
     *         A dashboard can have any type of parameters, and some parameters might accept multiple values.
     */
    public final Parameters parameters() {
        return parameters;
    }

    /**
     * For responses, this returns true if the service returned a value for the Permissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasPermissions() {
        return permissions != null && !(permissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A structure that contains the permissions of the dashboard. You can use this structure for granting permissions
     * by providing a list of IAMaction information for each principal ARN.
     * </p>
     * <p>
     * To specify no permissions, omit the permissions list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPermissions} method.
     * </p>
     * 
     * @return A structure that contains the permissions of the dashboard. You can use this structure for granting
     *         permissions by providing a list of IAMaction information for each principal ARN. </p>
     *         <p>
     *         To specify no permissions, omit the permissions list.
     */
    public final List<ResourcePermission> permissions() {
        return permissions;
    }

    /**
     * <p>
     * The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you
     * specify the type of object you're using as source. You can only create a dashboard from a template, so you use a
     * <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert the
     * analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>, specify
     * the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain any Amazon
     * Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;.
     * </p>
     * <p>
     * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement datasets
     * for the placeholders listed in the original. The schema in each dataset must match its placeholder.
     * </p>
     * 
     * @return The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>,
     *         you specify the type of object you're using as source. You can only create a dashboard from a template,
     *         so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis,
     *         first convert the analysis to a template by using the <a>CreateTemplate</a> API operation. For
     *         <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The
     *         <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon
     *         QuickSight-supported Amazon Web Services Region;. </p>
     *         <p>
     *         Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement
     *         datasets for the placeholders listed in the original. The schema in each dataset must match its
     *         placeholder.
     */
    public final DashboardSourceEntity sourceEntity() {
        return sourceEntity;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
     */
    public final List<Tag> tags() {
        return tags;
    }

    /**
     * <p>
     * A description for the first version of the dashboard being created.
     * </p>
     * 
     * @return A description for the first version of the dashboard being created.
     */
    public final String versionDescription() {
        return versionDescription;
    }

    /**
     * <p>
     * Options for publishing the dashboard when you create it:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight
     * disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering. This
     * option is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
     * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled when
     * this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
     * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Options for publishing the dashboard when you create it:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon
     *         QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc
     *         (one-time) filtering. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
     *         <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't
     *         enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
     *         <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
     *         </p>
     *         </li>
     */
    public final DashboardPublishOptions dashboardPublishOptions() {
        return dashboardPublishOptions;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for this
     * field, it overrides the value that is used in the source entity. The theme ARN must exist in the same Amazon Web
     * Services account where you create the dashboard.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for
     *         this field, it overrides the value that is used in the source entity. The theme ARN must exist in the
     *         same Amazon Web Services account where you create the dashboard.
     */
    public final String themeArn() {
        return themeArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(parameters());
        hashCode = 31 * hashCode + Objects.hashCode(hasPermissions() ? permissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sourceEntity());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(versionDescription());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardPublishOptions());
        hashCode = 31 * hashCode + Objects.hashCode(themeArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDashboardRequest)) {
            return false;
        }
        CreateDashboardRequest other = (CreateDashboardRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && Objects.equals(name(), other.name()) && Objects.equals(parameters(), other.parameters())
                && hasPermissions() == other.hasPermissions() && Objects.equals(permissions(), other.permissions())
                && Objects.equals(sourceEntity(), other.sourceEntity()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags()) && Objects.equals(versionDescription(), other.versionDescription())
                && Objects.equals(dashboardPublishOptions(), other.dashboardPublishOptions())
                && Objects.equals(themeArn(), other.themeArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateDashboardRequest").add("AwsAccountId", awsAccountId()).add("DashboardId", dashboardId())
                .add("Name", name()).add("Parameters", parameters()).add("Permissions", hasPermissions() ? permissions() : null)
                .add("SourceEntity", sourceEntity()).add("Tags", hasTags() ? tags() : null)
                .add("VersionDescription", versionDescription()).add("DashboardPublishOptions", dashboardPublishOptions())
                .add("ThemeArn", themeArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Parameters":
            return Optional.ofNullable(clazz.cast(parameters()));
        case "Permissions":
            return Optional.ofNullable(clazz.cast(permissions()));
        case "SourceEntity":
            return Optional.ofNullable(clazz.cast(sourceEntity()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "VersionDescription":
            return Optional.ofNullable(clazz.cast(versionDescription()));
        case "DashboardPublishOptions":
            return Optional.ofNullable(clazz.cast(dashboardPublishOptions()));
        case "ThemeArn":
            return Optional.ofNullable(clazz.cast(themeArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDashboardRequest, T> g) {
        return obj -> g.apply((CreateDashboardRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDashboardRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account where you want to create the dashboard.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account where you want to create the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the dashboard, also added to the IAMpolicy.
         * </p>
         * 
         * @param dashboardId
         *        The ID for the dashboard, also added to the IAMpolicy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The display name of the dashboard.
         * </p>
         * 
         * @param name
         *        The display name of the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The parameters for the creation of the dashboard, which you want to use to override the default settings. A
         * dashboard can have any type of parameters, and some parameters might accept multiple values.
         * </p>
         * 
         * @param parameters
         *        The parameters for the creation of the dashboard, which you want to use to override the default
         *        settings. A dashboard can have any type of parameters, and some parameters might accept multiple
         *        values.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameters(Parameters parameters);

        /**
         * <p>
         * The parameters for the creation of the dashboard, which you want to use to override the default settings. A
         * dashboard can have any type of parameters, and some parameters might accept multiple values.
         * </p>
         * This is a convenience that creates an instance of the {@link Parameters.Builder} avoiding the need to create
         * one manually via {@link Parameters#builder()}.
         *
         * When the {@link Consumer} completes, {@link Parameters.Builder#build()} is called immediately and its result
         * is passed to {@link #parameters(Parameters)}.
         * 
         * @param parameters
         *        a consumer that will call methods on {@link Parameters.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameters(Parameters)
         */
        default Builder parameters(Consumer<Parameters.Builder> parameters) {
            return parameters(Parameters.builder().applyMutation(parameters).build());
        }

        /**
         * <p>
         * A structure that contains the permissions of the dashboard. You can use this structure for granting
         * permissions by providing a list of IAMaction information for each principal ARN.
         * </p>
         * <p>
         * To specify no permissions, omit the permissions list.
         * </p>
         * 
         * @param permissions
         *        A structure that contains the permissions of the dashboard. You can use this structure for granting
         *        permissions by providing a list of IAMaction information for each principal ARN. </p>
         *        <p>
         *        To specify no permissions, omit the permissions list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(Collection<ResourcePermission> permissions);

        /**
         * <p>
         * A structure that contains the permissions of the dashboard. You can use this structure for granting
         * permissions by providing a list of IAMaction information for each principal ARN.
         * </p>
         * <p>
         * To specify no permissions, omit the permissions list.
         * </p>
         * 
         * @param permissions
         *        A structure that contains the permissions of the dashboard. You can use this structure for granting
         *        permissions by providing a list of IAMaction information for each principal ARN. </p>
         *        <p>
         *        To specify no permissions, omit the permissions list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder permissions(ResourcePermission... permissions);

        /**
         * <p>
         * A structure that contains the permissions of the dashboard. You can use this structure for granting
         * permissions by providing a list of IAMaction information for each principal ARN.
         * </p>
         * <p>
         * To specify no permissions, omit the permissions list.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #permissions(List<ResourcePermission>)}.
         * 
         * @param permissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #permissions(List<ResourcePermission>)
         */
        Builder permissions(Consumer<ResourcePermission.Builder>... permissions);

        /**
         * <p>
         * The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source. You can only create a dashboard from a template, so you
         * use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert
         * the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>,
         * specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain
         * any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement
         * datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * </p>
         * 
         * @param sourceEntity
         *        The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>,
         *        you specify the type of object you're using as source. You can only create a dashboard from a
         *        template, so you use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an
         *        analysis, first convert the analysis to a template by using the <a>CreateTemplate</a> API operation.
         *        For <code>SourceTemplate</code>, specify the Amazon Resource Name (ARN) of the source template. The
         *        <code>SourceTemplate</code>ARN can contain any Amazon Web Services account and any Amazon
         *        QuickSight-supported Amazon Web Services Region;. </p>
         *        <p>
         *        Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the
         *        replacement datasets for the placeholders listed in the original. The schema in each dataset must
         *        match its placeholder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceEntity(DashboardSourceEntity sourceEntity);

        /**
         * <p>
         * The entity that you are using as a source when you create the dashboard. In <code>SourceEntity</code>, you
         * specify the type of object you're using as source. You can only create a dashboard from a template, so you
         * use a <code>SourceTemplate</code> entity. If you need to create a dashboard from an analysis, first convert
         * the analysis to a template by using the <a>CreateTemplate</a> API operation. For <code>SourceTemplate</code>,
         * specify the Amazon Resource Name (ARN) of the source template. The <code>SourceTemplate</code>ARN can contain
         * any Amazon Web Services account and any Amazon QuickSight-supported Amazon Web Services Region;.
         * </p>
         * <p>
         * Use the <code>DataSetReferences</code> entity within <code>SourceTemplate</code> to list the replacement
         * datasets for the placeholders listed in the original. The schema in each dataset must match its placeholder.
         * </p>
         * This is a convenience that creates an instance of the {@link DashboardSourceEntity.Builder} avoiding the need
         * to create one manually via {@link DashboardSourceEntity#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashboardSourceEntity.Builder#build()} is called immediately and
         * its result is passed to {@link #sourceEntity(DashboardSourceEntity)}.
         * 
         * @param sourceEntity
         *        a consumer that will call methods on {@link DashboardSourceEntity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceEntity(DashboardSourceEntity)
         */
        default Builder sourceEntity(Consumer<DashboardSourceEntity.Builder> sourceEntity) {
            return sourceEntity(DashboardSourceEntity.builder().applyMutation(sourceEntity).build());
        }

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Collection<Tag> tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         * </p>
         * 
         * @param tags
         *        Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Tag... tags);

        /**
         * <p>
         * Contains a map of the key-value pairs for the resource tag or tags assigned to the dashboard.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Tag>.Builder} avoiding the need to create
         * one manually via {@link List<Tag>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Tag>.Builder#build()} is called immediately and its result
         * is passed to {@link #tags(List<Tag>)}.
         * 
         * @param tags
         *        a consumer that will call methods on {@link List<Tag>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tags(List<Tag>)
         */
        Builder tags(Consumer<Tag.Builder>... tags);

        /**
         * <p>
         * A description for the first version of the dashboard being created.
         * </p>
         * 
         * @param versionDescription
         *        A description for the first version of the dashboard being created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder versionDescription(String versionDescription);

        /**
         * <p>
         * Options for publishing the dashboard when you create it:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight
         * disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering.
         * This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled
         * when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
         * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
         * </p>
         * </li>
         * </ul>
         * 
         * @param dashboardPublishOptions
         *        Options for publishing the dashboard when you create it:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon
         *        QuickSight disables the left filter pane on the published dashboard, which can be used for ad hoc
         *        (one-time) filtering. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         *        <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't
         *        enabled when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be
         *        either <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by
         *        default.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions);

        /**
         * <p>
         * Options for publishing the dashboard when you create it:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>AdHocFilteringOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. When this is set to <code>DISABLED</code>, Amazon QuickSight
         * disables the left filter pane on the published dashboard, which can be used for ad hoc (one-time) filtering.
         * This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AvailabilityStatus</code> for <code>ExportToCSVOption</code> - This status can be either
         * <code>ENABLED</code> or <code>DISABLED</code>. The visual option to export data to .CSV format isn't enabled
         * when this is set to <code>DISABLED</code>. This option is <code>ENABLED</code> by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>VisibilityState</code> for <code>SheetControlsOption</code> - This visibility state can be either
         * <code>COLLAPSED</code> or <code>EXPANDED</code>. This option is <code>COLLAPSED</code> by default.
         * </p>
         * </li>
         * </ul>
         * This is a convenience that creates an instance of the {@link DashboardPublishOptions.Builder} avoiding the
         * need to create one manually via {@link DashboardPublishOptions#builder()}.
         *
         * When the {@link Consumer} completes, {@link DashboardPublishOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #dashboardPublishOptions(DashboardPublishOptions)}.
         * 
         * @param dashboardPublishOptions
         *        a consumer that will call methods on {@link DashboardPublishOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboardPublishOptions(DashboardPublishOptions)
         */
        default Builder dashboardPublishOptions(Consumer<DashboardPublishOptions.Builder> dashboardPublishOptions) {
            return dashboardPublishOptions(DashboardPublishOptions.builder().applyMutation(dashboardPublishOptions).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value for
         * this field, it overrides the value that is used in the source entity. The theme ARN must exist in the same
         * Amazon Web Services account where you create the dashboard.
         * </p>
         * 
         * @param themeArn
         *        The Amazon Resource Name (ARN) of the theme that is being used for this dashboard. If you add a value
         *        for this field, it overrides the value that is used in the source entity. The theme ARN must exist in
         *        the same Amazon Web Services account where you create the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeArn(String themeArn);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private String name;

        private Parameters parameters;

        private List<ResourcePermission> permissions = DefaultSdkAutoConstructList.getInstance();

        private DashboardSourceEntity sourceEntity;

        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private String versionDescription;

        private DashboardPublishOptions dashboardPublishOptions;

        private String themeArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDashboardRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            name(model.name);
            parameters(model.parameters);
            permissions(model.permissions);
            sourceEntity(model.sourceEntity);
            tags(model.tags);
            versionDescription(model.versionDescription);
            dashboardPublishOptions(model.dashboardPublishOptions);
            themeArn(model.themeArn);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        @Transient
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Parameters.Builder getParameters() {
            return parameters != null ? parameters.toBuilder() : null;
        }

        public final void setParameters(Parameters.BuilderImpl parameters) {
            this.parameters = parameters != null ? parameters.build() : null;
        }

        @Override
        @Transient
        public final Builder parameters(Parameters parameters) {
            this.parameters = parameters;
            return this;
        }

        public final List<ResourcePermission.Builder> getPermissions() {
            List<ResourcePermission.Builder> result = ResourcePermissionListCopier.copyToBuilder(this.permissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPermissions(Collection<ResourcePermission.BuilderImpl> permissions) {
            this.permissions = ResourcePermissionListCopier.copyFromBuilder(permissions);
        }

        @Override
        @Transient
        public final Builder permissions(Collection<ResourcePermission> permissions) {
            this.permissions = ResourcePermissionListCopier.copy(permissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(ResourcePermission... permissions) {
            permissions(Arrays.asList(permissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder permissions(Consumer<ResourcePermission.Builder>... permissions) {
            permissions(Stream.of(permissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final DashboardSourceEntity.Builder getSourceEntity() {
            return sourceEntity != null ? sourceEntity.toBuilder() : null;
        }

        public final void setSourceEntity(DashboardSourceEntity.BuilderImpl sourceEntity) {
            this.sourceEntity = sourceEntity != null ? sourceEntity.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceEntity(DashboardSourceEntity sourceEntity) {
            this.sourceEntity = sourceEntity;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        @Transient
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Tag... tags) {
            tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder>... tags) {
            tags(Stream.of(tags).map(c -> Tag.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getVersionDescription() {
            return versionDescription;
        }

        public final void setVersionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
        }

        @Override
        @Transient
        public final Builder versionDescription(String versionDescription) {
            this.versionDescription = versionDescription;
            return this;
        }

        public final DashboardPublishOptions.Builder getDashboardPublishOptions() {
            return dashboardPublishOptions != null ? dashboardPublishOptions.toBuilder() : null;
        }

        public final void setDashboardPublishOptions(DashboardPublishOptions.BuilderImpl dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions != null ? dashboardPublishOptions.build() : null;
        }

        @Override
        @Transient
        public final Builder dashboardPublishOptions(DashboardPublishOptions dashboardPublishOptions) {
            this.dashboardPublishOptions = dashboardPublishOptions;
            return this;
        }

        public final String getThemeArn() {
            return themeArn;
        }

        public final void setThemeArn(String themeArn) {
            this.themeArn = themeArn;
        }

        @Override
        @Transient
        public final Builder themeArn(String themeArn) {
            this.themeArn = themeArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDashboardRequest build() {
            return new CreateDashboardRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
