/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the Amazon QuickSight console that you want to embed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserQuickSightConsoleEmbeddingConfiguration
        implements
        SdkPojo,
        Serializable,
        ToCopyableBuilder<RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder, RegisteredUserQuickSightConsoleEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialPath").getter(getter(RegisteredUserQuickSightConsoleEmbeddingConfiguration::initialPath))
            .setter(setter(Builder::initialPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_PATH_FIELD));

    private static final long serialVersionUID = 1L;

    private final String initialPath;

    private RegisteredUserQuickSightConsoleEmbeddingConfiguration(BuilderImpl builder) {
        this.initialPath = builder.initialPath;
    }

    /**
     * <p>
     * The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.
     * </p>
     * <p>
     * The entry point URL is constrained to the following paths:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>/start</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/analyses</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/dashboards</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/start/favorites</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight console
     * URL of the dashboard.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console URL
     * of the analysis.
     * </p>
     * </li>
     * </ul>
     * 
     * @return The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p>
     *         <p>
     *         The entry point URL is constrained to the following paths:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>/start</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/analyses</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/dashboards</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/start/favorites</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight
     *         console URL of the dashboard.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight
     *         console URL of the analysis.
     *         </p>
     *         </li>
     */
    public final String initialPath() {
        return initialPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserQuickSightConsoleEmbeddingConfiguration)) {
            return false;
        }
        RegisteredUserQuickSightConsoleEmbeddingConfiguration other = (RegisteredUserQuickSightConsoleEmbeddingConfiguration) obj;
        return Objects.equals(initialPath(), other.initialPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserQuickSightConsoleEmbeddingConfiguration").add("InitialPath", initialPath())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialPath":
            return Optional.ofNullable(clazz.cast(initialPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserQuickSightConsoleEmbeddingConfiguration, T> g) {
        return obj -> g.apply((RegisteredUserQuickSightConsoleEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserQuickSightConsoleEmbeddingConfiguration> {
        /**
         * <p>
         * The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.
         * </p>
         * <p>
         * The entry point URL is constrained to the following paths:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>/start</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/analyses</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/dashboards</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/start/favorites</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon QuickSight
         * console URL of the dashboard.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight console
         * URL of the analysis.
         * </p>
         * </li>
         * </ul>
         * 
         * @param initialPath
         *        The initial URL path for the Amazon QuickSight console. <code>InitialPath</code> is required.</p>
         *        <p>
         *        The entry point URL is constrained to the following paths:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>/start</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/analyses</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/dashboards</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/start/favorites</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/dashboards/DashboardId</code>. <i>DashboardId</i> is the actual ID key from the Amazon
         *        QuickSight console URL of the dashboard.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>/analyses/AnalysisId</code>. <i>AnalysisId</i> is the actual ID key from the Amazon QuickSight
         *        console URL of the analysis.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialPath(String initialPath);
    }

    static final class BuilderImpl implements Builder {
        private String initialPath;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserQuickSightConsoleEmbeddingConfiguration model) {
            initialPath(model.initialPath);
        }

        public final String getInitialPath() {
            return initialPath;
        }

        @Override
        public final Builder initialPath(String initialPath) {
            this.initialPath = initialPath;
            return this;
        }

        public final void setInitialPath(String initialPath) {
            this.initialPath = initialPath;
        }

        @Override
        public RegisteredUserQuickSightConsoleEmbeddingConfiguration build() {
            return new RegisteredUserQuickSightConsoleEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
