/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteThemeAliasResponse extends QuickSightResponse implements
        ToCopyableBuilder<DeleteThemeAliasResponse.Builder, DeleteThemeAliasResponse> {
    private static final SdkField<String> ALIAS_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AliasName").getter(getter(DeleteThemeAliasResponse::aliasName)).setter(setter(Builder::aliasName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AliasName").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(DeleteThemeAliasResponse::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(DeleteThemeAliasResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(DeleteThemeAliasResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> THEME_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeId").getter(getter(DeleteThemeAliasResponse::themeId)).setter(setter(Builder::themeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALIAS_NAME_FIELD, ARN_FIELD,
            REQUEST_ID_FIELD, STATUS_FIELD, THEME_ID_FIELD));

    private final String aliasName;

    private final String arn;

    private final String requestId;

    private final Integer status;

    private final String themeId;

    private DeleteThemeAliasResponse(BuilderImpl builder) {
        super(builder);
        this.aliasName = builder.aliasName;
        this.arn = builder.arn;
        this.requestId = builder.requestId;
        this.status = builder.status;
        this.themeId = builder.themeId;
    }

    /**
     * <p>
     * The name for the theme alias.
     * </p>
     * 
     * @return The name for the theme alias.
     */
    public final String aliasName() {
        return aliasName;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the theme resource using the deleted alias.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the theme resource using the deleted alias.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * An ID for the theme associated with the deletion.
     * </p>
     * 
     * @return An ID for the theme associated with the deletion.
     */
    public final String themeId() {
        return themeId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(aliasName());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(themeId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteThemeAliasResponse)) {
            return false;
        }
        DeleteThemeAliasResponse other = (DeleteThemeAliasResponse) obj;
        return Objects.equals(aliasName(), other.aliasName()) && Objects.equals(arn(), other.arn())
                && Objects.equals(requestId(), other.requestId()) && Objects.equals(status(), other.status())
                && Objects.equals(themeId(), other.themeId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteThemeAliasResponse").add("AliasName", aliasName()).add("Arn", arn())
                .add("RequestId", requestId()).add("Status", status()).add("ThemeId", themeId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AliasName":
            return Optional.ofNullable(clazz.cast(aliasName()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "ThemeId":
            return Optional.ofNullable(clazz.cast(themeId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteThemeAliasResponse, T> g) {
        return obj -> g.apply((DeleteThemeAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, DeleteThemeAliasResponse> {
        /**
         * <p>
         * The name for the theme alias.
         * </p>
         * 
         * @param aliasName
         *        The name for the theme alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder aliasName(String aliasName);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the theme resource using the deleted alias.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the theme resource using the deleted alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * An ID for the theme associated with the deletion.
         * </p>
         * 
         * @param themeId
         *        An ID for the theme associated with the deletion.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeId(String themeId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private String aliasName;

        private String arn;

        private String requestId;

        private Integer status;

        private String themeId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteThemeAliasResponse model) {
            super(model);
            aliasName(model.aliasName);
            arn(model.arn);
            requestId(model.requestId);
            status(model.status);
            themeId(model.themeId);
        }

        public final String getAliasName() {
            return aliasName;
        }

        public final void setAliasName(String aliasName) {
            this.aliasName = aliasName;
        }

        @Override
        @Transient
        public final Builder aliasName(String aliasName) {
            this.aliasName = aliasName;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getRequestId() {
            return requestId;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        @Transient
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final Integer getStatus() {
            return status;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        @Override
        @Transient
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final String getThemeId() {
            return themeId;
        }

        public final void setThemeId(String themeId) {
            this.themeId = themeId;
        }

        @Override
        @Transient
        public final Builder themeId(String themeId) {
            this.themeId = themeId;
            return this;
        }

        @Override
        public DeleteThemeAliasResponse build() {
            return new DeleteThemeAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
