/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateDashboardPermissionsRequest extends QuickSightRequest implements
        ToCopyableBuilder<UpdateDashboardPermissionsRequest.Builder, UpdateDashboardPermissionsRequest> {
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(UpdateDashboardPermissionsRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(UpdateDashboardPermissionsRequest::dashboardId))
            .setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("DashboardId").build()).build();

    private static final SdkField<List<ResourcePermission>> GRANT_PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("GrantPermissions")
            .getter(getter(UpdateDashboardPermissionsRequest::grantPermissions))
            .setter(setter(Builder::grantPermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GrantPermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<ResourcePermission>> REVOKE_PERMISSIONS_FIELD = SdkField
            .<List<ResourcePermission>> builder(MarshallingType.LIST)
            .memberName("RevokePermissions")
            .getter(getter(UpdateDashboardPermissionsRequest::revokePermissions))
            .setter(setter(Builder::revokePermissions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RevokePermissions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ResourcePermission> builder(MarshallingType.SDK_POJO)
                                            .constructor(ResourcePermission::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_ACCOUNT_ID_FIELD,
            DASHBOARD_ID_FIELD, GRANT_PERMISSIONS_FIELD, REVOKE_PERMISSIONS_FIELD));

    private final String awsAccountId;

    private final String dashboardId;

    private final List<ResourcePermission> grantPermissions;

    private final List<ResourcePermission> revokePermissions;

    private UpdateDashboardPermissionsRequest(BuilderImpl builder) {
        super(builder);
        this.awsAccountId = builder.awsAccountId;
        this.dashboardId = builder.dashboardId;
        this.grantPermissions = builder.grantPermissions;
        this.revokePermissions = builder.revokePermissions;
    }

    /**
     * <p>
     * The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.
     * </p>
     * 
     * @return The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The ID for the dashboard.
     * </p>
     * 
     * @return The ID for the dashboard.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * For responses, this returns true if the service returned a value for the GrantPermissions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasGrantPermissions() {
        return grantPermissions != null && !(grantPermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions that you want to grant on this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGrantPermissions} method.
     * </p>
     * 
     * @return The permissions that you want to grant on this resource.
     */
    public final List<ResourcePermission> grantPermissions() {
        return grantPermissions;
    }

    /**
     * For responses, this returns true if the service returned a value for the RevokePermissions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRevokePermissions() {
        return revokePermissions != null && !(revokePermissions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The permissions that you want to revoke from this resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRevokePermissions} method.
     * </p>
     * 
     * @return The permissions that you want to revoke from this resource.
     */
    public final List<ResourcePermission> revokePermissions() {
        return revokePermissions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(hasGrantPermissions() ? grantPermissions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRevokePermissions() ? revokePermissions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateDashboardPermissionsRequest)) {
            return false;
        }
        UpdateDashboardPermissionsRequest other = (UpdateDashboardPermissionsRequest) obj;
        return Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(dashboardId(), other.dashboardId())
                && hasGrantPermissions() == other.hasGrantPermissions()
                && Objects.equals(grantPermissions(), other.grantPermissions())
                && hasRevokePermissions() == other.hasRevokePermissions()
                && Objects.equals(revokePermissions(), other.revokePermissions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateDashboardPermissionsRequest").add("AwsAccountId", awsAccountId())
                .add("DashboardId", dashboardId()).add("GrantPermissions", hasGrantPermissions() ? grantPermissions() : null)
                .add("RevokePermissions", hasRevokePermissions() ? revokePermissions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "GrantPermissions":
            return Optional.ofNullable(clazz.cast(grantPermissions()));
        case "RevokePermissions":
            return Optional.ofNullable(clazz.cast(revokePermissions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateDashboardPermissionsRequest, T> g) {
        return obj -> g.apply((UpdateDashboardPermissionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, UpdateDashboardPermissionsRequest> {
        /**
         * <p>
         * The ID of the Amazon Web Services account that contains the dashboard whose permissions you're updating.
         * </p>
         * 
         * @param awsAccountId
         *        The ID of the Amazon Web Services account that contains the dashboard whose permissions you're
         *        updating.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The ID for the dashboard.
         * </p>
         * 
         * @param dashboardId
         *        The ID for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The permissions that you want to grant on this resource.
         * </p>
         * 
         * @param grantPermissions
         *        The permissions that you want to grant on this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(Collection<ResourcePermission> grantPermissions);

        /**
         * <p>
         * The permissions that you want to grant on this resource.
         * </p>
         * 
         * @param grantPermissions
         *        The permissions that you want to grant on this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder grantPermissions(ResourcePermission... grantPermissions);

        /**
         * <p>
         * The permissions that you want to grant on this resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #grantPermissions(List<ResourcePermission>)}.
         * 
         * @param grantPermissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #grantPermissions(List<ResourcePermission>)
         */
        Builder grantPermissions(Consumer<ResourcePermission.Builder>... grantPermissions);

        /**
         * <p>
         * The permissions that you want to revoke from this resource.
         * </p>
         * 
         * @param revokePermissions
         *        The permissions that you want to revoke from this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(Collection<ResourcePermission> revokePermissions);

        /**
         * <p>
         * The permissions that you want to revoke from this resource.
         * </p>
         * 
         * @param revokePermissions
         *        The permissions that you want to revoke from this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder revokePermissions(ResourcePermission... revokePermissions);

        /**
         * <p>
         * The permissions that you want to revoke from this resource.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ResourcePermission>.Builder} avoiding the
         * need to create one manually via {@link List<ResourcePermission>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ResourcePermission>.Builder#build()} is called immediately
         * and its result is passed to {@link #revokePermissions(List<ResourcePermission>)}.
         * 
         * @param revokePermissions
         *        a consumer that will call methods on {@link List<ResourcePermission>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #revokePermissions(List<ResourcePermission>)
         */
        Builder revokePermissions(Consumer<ResourcePermission.Builder>... revokePermissions);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String awsAccountId;

        private String dashboardId;

        private List<ResourcePermission> grantPermissions = DefaultSdkAutoConstructList.getInstance();

        private List<ResourcePermission> revokePermissions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateDashboardPermissionsRequest model) {
            super(model);
            awsAccountId(model.awsAccountId);
            dashboardId(model.dashboardId);
            grantPermissions(model.grantPermissions);
            revokePermissions(model.revokePermissions);
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        @Transient
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        @Transient
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final List<ResourcePermission.Builder> getGrantPermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.grantPermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGrantPermissions(Collection<ResourcePermission.BuilderImpl> grantPermissions) {
            this.grantPermissions = UpdateResourcePermissionListCopier.copyFromBuilder(grantPermissions);
        }

        @Override
        @Transient
        public final Builder grantPermissions(Collection<ResourcePermission> grantPermissions) {
            this.grantPermissions = UpdateResourcePermissionListCopier.copy(grantPermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grantPermissions(ResourcePermission... grantPermissions) {
            grantPermissions(Arrays.asList(grantPermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder grantPermissions(Consumer<ResourcePermission.Builder>... grantPermissions) {
            grantPermissions(Stream.of(grantPermissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<ResourcePermission.Builder> getRevokePermissions() {
            List<ResourcePermission.Builder> result = UpdateResourcePermissionListCopier.copyToBuilder(this.revokePermissions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRevokePermissions(Collection<ResourcePermission.BuilderImpl> revokePermissions) {
            this.revokePermissions = UpdateResourcePermissionListCopier.copyFromBuilder(revokePermissions);
        }

        @Override
        @Transient
        public final Builder revokePermissions(Collection<ResourcePermission> revokePermissions) {
            this.revokePermissions = UpdateResourcePermissionListCopier.copy(revokePermissions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder revokePermissions(ResourcePermission... revokePermissions) {
            revokePermissions(Arrays.asList(revokePermissions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder revokePermissions(Consumer<ResourcePermission.Builder>... revokePermissions) {
            revokePermissions(Stream.of(revokePermissions).map(c -> ResourcePermission.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateDashboardPermissionsRequest build() {
            return new UpdateDashboardPermissionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
