/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the dashboard you want to embed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserDashboardEmbeddingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredUserDashboardEmbeddingConfiguration.Builder, RegisteredUserDashboardEmbeddingConfiguration> {
    private static final SdkField<String> INITIAL_DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InitialDashboardId").getter(getter(RegisteredUserDashboardEmbeddingConfiguration::initialDashboardId))
            .setter(setter(Builder::initialDashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitialDashboardId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INITIAL_DASHBOARD_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String initialDashboardId;

    private RegisteredUserDashboardEmbeddingConfiguration(BuilderImpl builder) {
        this.initialDashboardId = builder.initialDashboardId;
    }

    /**
     * <p>
     * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL.
     * When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has permissions to
     * view it.
     * </p>
     * <p>
     * If the user does not have permission to view this dashboard, they see a permissions error message.
     * </p>
     * 
     * @return The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output
     *         URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has
     *         permissions to view it.</p>
     *         <p>
     *         If the user does not have permission to view this dashboard, they see a permissions error message.
     */
    public final String initialDashboardId() {
        return initialDashboardId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(initialDashboardId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserDashboardEmbeddingConfiguration)) {
            return false;
        }
        RegisteredUserDashboardEmbeddingConfiguration other = (RegisteredUserDashboardEmbeddingConfiguration) obj;
        return Objects.equals(initialDashboardId(), other.initialDashboardId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserDashboardEmbeddingConfiguration").add("InitialDashboardId", initialDashboardId())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InitialDashboardId":
            return Optional.ofNullable(clazz.cast(initialDashboardId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserDashboardEmbeddingConfiguration, T> g) {
        return obj -> g.apply((RegisteredUserDashboardEmbeddingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserDashboardEmbeddingConfiguration> {
        /**
         * <p>
         * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output
         * URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user has
         * permissions to view it.
         * </p>
         * <p>
         * If the user does not have permission to view this dashboard, they see a permissions error message.
         * </p>
         * 
         * @param initialDashboardId
         *        The dashboard ID for the dashboard that you want the user to see first. This ID is included in the
         *        output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard if the user
         *        has permissions to view it.</p>
         *        <p>
         *        If the user does not have permission to view this dashboard, they see a permissions error message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder initialDashboardId(String initialDashboardId);
    }

    static final class BuilderImpl implements Builder {
        private String initialDashboardId;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserDashboardEmbeddingConfiguration model) {
            initialDashboardId(model.initialDashboardId);
        }

        public final String getInitialDashboardId() {
            return initialDashboardId;
        }

        public final void setInitialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
        }

        @Override
        @Transient
        public final Builder initialDashboardId(String initialDashboardId) {
            this.initialDashboardId = initialDashboardId;
            return this;
        }

        @Override
        public RegisteredUserDashboardEmbeddingConfiguration build() {
            return new RegisteredUserDashboardEmbeddingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
