/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * S3 parameters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class S3Parameters implements SdkPojo, Serializable, ToCopyableBuilder<S3Parameters.Builder, S3Parameters> {
    private static final SdkField<ManifestFileLocation> MANIFEST_FILE_LOCATION_FIELD = SdkField
            .<ManifestFileLocation> builder(MarshallingType.SDK_POJO).memberName("ManifestFileLocation")
            .getter(getter(S3Parameters::manifestFileLocation)).setter(setter(Builder::manifestFileLocation))
            .constructor(ManifestFileLocation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ManifestFileLocation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFEST_FILE_LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ManifestFileLocation manifestFileLocation;

    private S3Parameters(BuilderImpl builder) {
        this.manifestFileLocation = builder.manifestFileLocation;
    }

    /**
     * <p>
     * Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into QuickSight.
     * </p>
     * 
     * @return Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into QuickSight.
     */
    public final ManifestFileLocation manifestFileLocation() {
        return manifestFileLocation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(manifestFileLocation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Parameters)) {
            return false;
        }
        S3Parameters other = (S3Parameters) obj;
        return Objects.equals(manifestFileLocation(), other.manifestFileLocation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("S3Parameters").add("ManifestFileLocation", manifestFileLocation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ManifestFileLocation":
            return Optional.ofNullable(clazz.cast(manifestFileLocation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<S3Parameters, T> g) {
        return obj -> g.apply((S3Parameters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, S3Parameters> {
        /**
         * <p>
         * Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into QuickSight.
         * </p>
         * 
         * @param manifestFileLocation
         *        Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into
         *        QuickSight.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifestFileLocation(ManifestFileLocation manifestFileLocation);

        /**
         * <p>
         * Location of the Amazon S3 manifest file. This is NULL if the manifest file was uploaded into QuickSight.
         * </p>
         * This is a convenience that creates an instance of the {@link ManifestFileLocation.Builder} avoiding the need
         * to create one manually via {@link ManifestFileLocation#builder()}.
         *
         * When the {@link Consumer} completes, {@link ManifestFileLocation.Builder#build()} is called immediately and
         * its result is passed to {@link #manifestFileLocation(ManifestFileLocation)}.
         * 
         * @param manifestFileLocation
         *        a consumer that will call methods on {@link ManifestFileLocation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifestFileLocation(ManifestFileLocation)
         */
        default Builder manifestFileLocation(Consumer<ManifestFileLocation.Builder> manifestFileLocation) {
            return manifestFileLocation(ManifestFileLocation.builder().applyMutation(manifestFileLocation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ManifestFileLocation manifestFileLocation;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Parameters model) {
            manifestFileLocation(model.manifestFileLocation);
        }

        public final ManifestFileLocation.Builder getManifestFileLocation() {
            return manifestFileLocation != null ? manifestFileLocation.toBuilder() : null;
        }

        @Override
        public final Builder manifestFileLocation(ManifestFileLocation manifestFileLocation) {
            this.manifestFileLocation = manifestFileLocation;
            return this;
        }

        public final void setManifestFileLocation(ManifestFileLocation.BuilderImpl manifestFileLocation) {
            this.manifestFileLocation = manifestFileLocation != null ? manifestFileLocation.build() : null;
        }

        @Override
        public S3Parameters build() {
            return new S3Parameters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
