/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of experience you want to embed. For registered users, you can embed Amazon QuickSight dashboards or the
 * Amazon QuickSight console.
 * </p>
 * <note>
 * <p>
 * Exactly one of the experience configurations is required. You can choose <code>Dashboard</code> or
 * <code>QuickSightConsole</code>. You cannot choose more than one experience configuration.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RegisteredUserEmbeddingExperienceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<RegisteredUserEmbeddingExperienceConfiguration.Builder, RegisteredUserEmbeddingExperienceConfiguration> {
    private static final SdkField<RegisteredUserDashboardEmbeddingConfiguration> DASHBOARD_FIELD = SdkField
            .<RegisteredUserDashboardEmbeddingConfiguration> builder(MarshallingType.SDK_POJO).memberName("Dashboard")
            .getter(getter(RegisteredUserEmbeddingExperienceConfiguration::dashboard)).setter(setter(Builder::dashboard))
            .constructor(RegisteredUserDashboardEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboard").build()).build();

    private static final SdkField<RegisteredUserQuickSightConsoleEmbeddingConfiguration> QUICK_SIGHT_CONSOLE_FIELD = SdkField
            .<RegisteredUserQuickSightConsoleEmbeddingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("QuickSightConsole").getter(getter(RegisteredUserEmbeddingExperienceConfiguration::quickSightConsole))
            .setter(setter(Builder::quickSightConsole))
            .constructor(RegisteredUserQuickSightConsoleEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QuickSightConsole").build()).build();

    private static final SdkField<RegisteredUserQSearchBarEmbeddingConfiguration> Q_SEARCH_BAR_FIELD = SdkField
            .<RegisteredUserQSearchBarEmbeddingConfiguration> builder(MarshallingType.SDK_POJO).memberName("QSearchBar")
            .getter(getter(RegisteredUserEmbeddingExperienceConfiguration::qSearchBar)).setter(setter(Builder::qSearchBar))
            .constructor(RegisteredUserQSearchBarEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("QSearchBar").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_FIELD,
            QUICK_SIGHT_CONSOLE_FIELD, Q_SEARCH_BAR_FIELD));

    private static final long serialVersionUID = 1L;

    private final RegisteredUserDashboardEmbeddingConfiguration dashboard;

    private final RegisteredUserQuickSightConsoleEmbeddingConfiguration quickSightConsole;

    private final RegisteredUserQSearchBarEmbeddingConfiguration qSearchBar;

    private RegisteredUserEmbeddingExperienceConfiguration(BuilderImpl builder) {
        this.dashboard = builder.dashboard;
        this.quickSightConsole = builder.quickSightConsole;
        this.qSearchBar = builder.qSearchBar;
    }

    /**
     * <p>
     * The configuration details for providing a dashboard embedding experience.
     * </p>
     * 
     * @return The configuration details for providing a dashboard embedding experience.
     */
    public final RegisteredUserDashboardEmbeddingConfiguration dashboard() {
        return dashboard;
    }

    /**
     * <p>
     * The configuration details for providing each Amazon QuickSight console embedding experience. This can be used
     * along with custom permissions to restrict access to certain features. For more information, see <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     * >Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Use
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> </code>
     * where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and
     * dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to the author or admin
     * security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile
     * to the user with the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
     * API operation. Use the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code>
     * API operation to add a new user with a custom permission profile attached. For more information, see the
     * following sections in the <i>Amazon QuickSight User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html"
     * >Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     * >Customizing Access to the Amazon QuickSight Console</a>
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
     * customize embedding, visit the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer
     * Portal</a>.
     * </p>
     * 
     * @return The configuration details for providing each Amazon QuickSight console embedding experience. This can be
     *         used along with custom permissions to restrict access to certain features. For more information, see <a
     *         href=
     *         "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     *         >Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User Guide</i>.</p>
     *         <p>
     *         Use
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> </code>
     *         where you want to provide an authoring portal that allows users to create data sources, datasets,
     *         analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to
     *         the author or admin security cohort. If you want to restrict permissions to some of these features, add a
     *         custom permissions profile to the user with the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
     *         API operation. Use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code>
     *         API operation to add a new user with a custom permission profile attached. For more information, see the
     *         following sections in the <i>Amazon QuickSight User Guide</i>:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html"
     *         >Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     *         >Customizing Access to the Amazon QuickSight Console</a>
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         For more information about the high-level steps for embedding and for an interactive demo of the ways you
     *         can customize embedding, visit the <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight
     *         Developer Portal</a>.
     */
    public final RegisteredUserQuickSightConsoleEmbeddingConfiguration quickSightConsole() {
        return quickSightConsole;
    }

    /**
     * <p>
     * The configuration details for embedding the Q search bar.
     * </p>
     * <p>
     * For more information about embedding the Q search bar, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.
     * </p>
     * 
     * @return The configuration details for embedding the Q search bar.</p>
     *         <p>
     *         For more information about embedding the Q search bar, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.
     */
    public final RegisteredUserQSearchBarEmbeddingConfiguration qSearchBar() {
        return qSearchBar;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboard());
        hashCode = 31 * hashCode + Objects.hashCode(quickSightConsole());
        hashCode = 31 * hashCode + Objects.hashCode(qSearchBar());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisteredUserEmbeddingExperienceConfiguration)) {
            return false;
        }
        RegisteredUserEmbeddingExperienceConfiguration other = (RegisteredUserEmbeddingExperienceConfiguration) obj;
        return Objects.equals(dashboard(), other.dashboard()) && Objects.equals(quickSightConsole(), other.quickSightConsole())
                && Objects.equals(qSearchBar(), other.qSearchBar());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RegisteredUserEmbeddingExperienceConfiguration").add("Dashboard", dashboard())
                .add("QuickSightConsole", quickSightConsole()).add("QSearchBar", qSearchBar()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dashboard":
            return Optional.ofNullable(clazz.cast(dashboard()));
        case "QuickSightConsole":
            return Optional.ofNullable(clazz.cast(quickSightConsole()));
        case "QSearchBar":
            return Optional.ofNullable(clazz.cast(qSearchBar()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RegisteredUserEmbeddingExperienceConfiguration, T> g) {
        return obj -> g.apply((RegisteredUserEmbeddingExperienceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RegisteredUserEmbeddingExperienceConfiguration> {
        /**
         * <p>
         * The configuration details for providing a dashboard embedding experience.
         * </p>
         * 
         * @param dashboard
         *        The configuration details for providing a dashboard embedding experience.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboard(RegisteredUserDashboardEmbeddingConfiguration dashboard);

        /**
         * <p>
         * The configuration details for providing a dashboard embedding experience.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link RegisteredUserDashboardEmbeddingConfiguration.Builder} avoiding the need to create one manually via
         * {@link RegisteredUserDashboardEmbeddingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegisteredUserDashboardEmbeddingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dashboard(RegisteredUserDashboardEmbeddingConfiguration)}.
         * 
         * @param dashboard
         *        a consumer that will call methods on {@link RegisteredUserDashboardEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboard(RegisteredUserDashboardEmbeddingConfiguration)
         */
        default Builder dashboard(Consumer<RegisteredUserDashboardEmbeddingConfiguration.Builder> dashboard) {
            return dashboard(RegisteredUserDashboardEmbeddingConfiguration.builder().applyMutation(dashboard).build());
        }

        /**
         * <p>
         * The configuration details for providing each Amazon QuickSight console embedding experience. This can be used
         * along with custom permissions to restrict access to certain features. For more information, see <a href=
         * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
         * >Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * <p>
         * Use
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> </code>
         * where you want to provide an authoring portal that allows users to create data sources, datasets, analyses,
         * and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to the author or
         * admin security cohort. If you want to restrict permissions to some of these features, add a custom
         * permissions profile to the user with the
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
         * API operation. Use the
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code>
         * API operation to add a new user with a custom permission profile attached. For more information, see the
         * following sections in the <i>Amazon QuickSight User Guide</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html"
         * >Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
         * >Customizing Access to the Amazon QuickSight Console</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
         * customize embedding, visit the <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight
         * Developer Portal</a>.
         * </p>
         * 
         * @param quickSightConsole
         *        The configuration details for providing each Amazon QuickSight console embedding experience. This can
         *        be used along with custom permissions to restrict access to certain features. For more information,
         *        see <a href=
         *        "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
         *        >Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User
         *        Guide</i>.</p>
         *        <p>
         *        Use
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> </code>
         *        where you want to provide an authoring portal that allows users to create data sources, datasets,
         *        analyses, and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong
         *        to the author or admin security cohort. If you want to restrict permissions to some of these features,
         *        add a custom permissions profile to the user with the
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
         *        API operation. Use the
         *        <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code>
         *        API operation to add a new user with a custom permission profile attached. For more information, see
         *        the following sections in the <i>Amazon QuickSight User Guide</i>:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html"
         *        >Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
         *        >Customizing Access to the Amazon QuickSight Console</a>
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        For more information about the high-level steps for embedding and for an interactive demo of the ways
         *        you can customize embedding, visit the <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight
         *        Developer Portal</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quickSightConsole(RegisteredUserQuickSightConsoleEmbeddingConfiguration quickSightConsole);

        /**
         * <p>
         * The configuration details for providing each Amazon QuickSight console embedding experience. This can be used
         * along with custom permissions to restrict access to certain features. For more information, see <a href=
         * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
         * >Customizing Access to the Amazon QuickSight Console</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * <p>
         * Use
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html">GenerateEmbedUrlForRegisteredUser</a> </code>
         * where you want to provide an authoring portal that allows users to create data sources, datasets, analyses,
         * and dashboards. The users who accesses an embedded Amazon QuickSight console needs to belong to the author or
         * admin security cohort. If you want to restrict permissions to some of these features, add a custom
         * permissions profile to the user with the
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
         * API operation. Use the
         * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code>
         * API operation to add a new user with a custom permission profile attached. For more information, see the
         * following sections in the <i>Amazon QuickSight User Guide</i>:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-full-console-for-authenticated-users.html"
         * >Embedding the Full Functionality of the Amazon QuickSight Console for Authenticated Users</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href=
         * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
         * >Customizing Access to the Amazon QuickSight Console</a>
         * </p>
         * </li>
         * </ul>
         * <p>
         * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
         * customize embedding, visit the <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight
         * Developer Portal</a>.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder} avoiding the need to create one
         * manually via {@link RegisteredUserQuickSightConsoleEmbeddingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes,
         * {@link RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #quickSightConsole(RegisteredUserQuickSightConsoleEmbeddingConfiguration)}.
         * 
         * @param quickSightConsole
         *        a consumer that will call methods on
         *        {@link RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #quickSightConsole(RegisteredUserQuickSightConsoleEmbeddingConfiguration)
         */
        default Builder quickSightConsole(
                Consumer<RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder> quickSightConsole) {
            return quickSightConsole(RegisteredUserQuickSightConsoleEmbeddingConfiguration.builder()
                    .applyMutation(quickSightConsole).build());
        }

        /**
         * <p>
         * The configuration details for embedding the Q search bar.
         * </p>
         * <p>
         * For more information about embedding the Q search bar, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.
         * </p>
         * 
         * @param qSearchBar
         *        The configuration details for embedding the Q search bar.</p>
         *        <p>
         *        For more information about embedding the Q search bar, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding
         *        Overview</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder qSearchBar(RegisteredUserQSearchBarEmbeddingConfiguration qSearchBar);

        /**
         * <p>
         * The configuration details for embedding the Q search bar.
         * </p>
         * <p>
         * For more information about embedding the Q search bar, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/embedding-overview.html">Embedding Overview</a>.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link RegisteredUserQSearchBarEmbeddingConfiguration.Builder} avoiding the need to create one manually via
         * {@link RegisteredUserQSearchBarEmbeddingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link RegisteredUserQSearchBarEmbeddingConfiguration.Builder#build()}
         * is called immediately and its result is passed to
         * {@link #qSearchBar(RegisteredUserQSearchBarEmbeddingConfiguration)}.
         * 
         * @param qSearchBar
         *        a consumer that will call methods on {@link RegisteredUserQSearchBarEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #qSearchBar(RegisteredUserQSearchBarEmbeddingConfiguration)
         */
        default Builder qSearchBar(Consumer<RegisteredUserQSearchBarEmbeddingConfiguration.Builder> qSearchBar) {
            return qSearchBar(RegisteredUserQSearchBarEmbeddingConfiguration.builder().applyMutation(qSearchBar).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private RegisteredUserDashboardEmbeddingConfiguration dashboard;

        private RegisteredUserQuickSightConsoleEmbeddingConfiguration quickSightConsole;

        private RegisteredUserQSearchBarEmbeddingConfiguration qSearchBar;

        private BuilderImpl() {
        }

        private BuilderImpl(RegisteredUserEmbeddingExperienceConfiguration model) {
            dashboard(model.dashboard);
            quickSightConsole(model.quickSightConsole);
            qSearchBar(model.qSearchBar);
        }

        public final RegisteredUserDashboardEmbeddingConfiguration.Builder getDashboard() {
            return dashboard != null ? dashboard.toBuilder() : null;
        }

        public final void setDashboard(RegisteredUserDashboardEmbeddingConfiguration.BuilderImpl dashboard) {
            this.dashboard = dashboard != null ? dashboard.build() : null;
        }

        @Override
        @Transient
        public final Builder dashboard(RegisteredUserDashboardEmbeddingConfiguration dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public final RegisteredUserQuickSightConsoleEmbeddingConfiguration.Builder getQuickSightConsole() {
            return quickSightConsole != null ? quickSightConsole.toBuilder() : null;
        }

        public final void setQuickSightConsole(RegisteredUserQuickSightConsoleEmbeddingConfiguration.BuilderImpl quickSightConsole) {
            this.quickSightConsole = quickSightConsole != null ? quickSightConsole.build() : null;
        }

        @Override
        @Transient
        public final Builder quickSightConsole(RegisteredUserQuickSightConsoleEmbeddingConfiguration quickSightConsole) {
            this.quickSightConsole = quickSightConsole;
            return this;
        }

        public final RegisteredUserQSearchBarEmbeddingConfiguration.Builder getQSearchBar() {
            return qSearchBar != null ? qSearchBar.toBuilder() : null;
        }

        public final void setQSearchBar(RegisteredUserQSearchBarEmbeddingConfiguration.BuilderImpl qSearchBar) {
            this.qSearchBar = qSearchBar != null ? qSearchBar.build() : null;
        }

        @Override
        @Transient
        public final Builder qSearchBar(RegisteredUserQSearchBarEmbeddingConfiguration qSearchBar) {
            this.qSearchBar = qSearchBar;
            return this;
        }

        @Override
        public RegisteredUserEmbeddingExperienceConfiguration build() {
            return new RegisteredUserEmbeddingExperienceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
