/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The type of experience you want to embed. For anonymous users, you can embed an Amazon QuickSight dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AnonymousUserEmbeddingExperienceConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<AnonymousUserEmbeddingExperienceConfiguration.Builder, AnonymousUserEmbeddingExperienceConfiguration> {
    private static final SdkField<AnonymousUserDashboardEmbeddingConfiguration> DASHBOARD_FIELD = SdkField
            .<AnonymousUserDashboardEmbeddingConfiguration> builder(MarshallingType.SDK_POJO).memberName("Dashboard")
            .getter(getter(AnonymousUserEmbeddingExperienceConfiguration::dashboard)).setter(setter(Builder::dashboard))
            .constructor(AnonymousUserDashboardEmbeddingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dashboard").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_FIELD));

    private static final long serialVersionUID = 1L;

    private final AnonymousUserDashboardEmbeddingConfiguration dashboard;

    private AnonymousUserEmbeddingExperienceConfiguration(BuilderImpl builder) {
        this.dashboard = builder.dashboard;
    }

    /**
     * <p>
     * The type of embedding experience. In this case, an Amazon QuickSight dashboard.
     * </p>
     * 
     * @return The type of embedding experience. In this case, an Amazon QuickSight dashboard.
     */
    public final AnonymousUserDashboardEmbeddingConfiguration dashboard() {
        return dashboard;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboard());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnonymousUserEmbeddingExperienceConfiguration)) {
            return false;
        }
        AnonymousUserEmbeddingExperienceConfiguration other = (AnonymousUserEmbeddingExperienceConfiguration) obj;
        return Objects.equals(dashboard(), other.dashboard());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AnonymousUserEmbeddingExperienceConfiguration").add("Dashboard", dashboard()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Dashboard":
            return Optional.ofNullable(clazz.cast(dashboard()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AnonymousUserEmbeddingExperienceConfiguration, T> g) {
        return obj -> g.apply((AnonymousUserEmbeddingExperienceConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AnonymousUserEmbeddingExperienceConfiguration> {
        /**
         * <p>
         * The type of embedding experience. In this case, an Amazon QuickSight dashboard.
         * </p>
         * 
         * @param dashboard
         *        The type of embedding experience. In this case, an Amazon QuickSight dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboard(AnonymousUserDashboardEmbeddingConfiguration dashboard);

        /**
         * <p>
         * The type of embedding experience. In this case, an Amazon QuickSight dashboard.
         * </p>
         * This is a convenience that creates an instance of the
         * {@link AnonymousUserDashboardEmbeddingConfiguration.Builder} avoiding the need to create one manually via
         * {@link AnonymousUserDashboardEmbeddingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link AnonymousUserDashboardEmbeddingConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #dashboard(AnonymousUserDashboardEmbeddingConfiguration)}.
         * 
         * @param dashboard
         *        a consumer that will call methods on {@link AnonymousUserDashboardEmbeddingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dashboard(AnonymousUserDashboardEmbeddingConfiguration)
         */
        default Builder dashboard(Consumer<AnonymousUserDashboardEmbeddingConfiguration.Builder> dashboard) {
            return dashboard(AnonymousUserDashboardEmbeddingConfiguration.builder().applyMutation(dashboard).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private AnonymousUserDashboardEmbeddingConfiguration dashboard;

        private BuilderImpl() {
        }

        private BuilderImpl(AnonymousUserEmbeddingExperienceConfiguration model) {
            dashboard(model.dashboard);
        }

        public final AnonymousUserDashboardEmbeddingConfiguration.Builder getDashboard() {
            return dashboard != null ? dashboard.toBuilder() : null;
        }

        @Override
        public final Builder dashboard(AnonymousUserDashboardEmbeddingConfiguration dashboard) {
            this.dashboard = dashboard;
            return this;
        }

        public final void setDashboard(AnonymousUserDashboardEmbeddingConfiguration.BuilderImpl dashboard) {
            this.dashboard = dashboard != null ? dashboard.build() : null;
        }

        @Override
        public AnonymousUserEmbeddingExperienceConfiguration build() {
            return new AnonymousUserEmbeddingExperienceConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
