/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateThemeAliasResponse extends QuickSightResponse implements
        ToCopyableBuilder<CreateThemeAliasResponse.Builder, CreateThemeAliasResponse> {
    private static final SdkField<ThemeAlias> THEME_ALIAS_FIELD = SdkField.<ThemeAlias> builder(MarshallingType.SDK_POJO)
            .memberName("ThemeAlias").getter(getter(CreateThemeAliasResponse::themeAlias)).setter(setter(Builder::themeAlias))
            .constructor(ThemeAlias::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeAlias").build()).build();

    private static final SdkField<Integer> STATUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Status").getter(getter(CreateThemeAliasResponse::status)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.STATUS_CODE).locationName("Status").build()).build();

    private static final SdkField<String> REQUEST_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequestId").getter(getter(CreateThemeAliasResponse::requestId)).setter(setter(Builder::requestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(THEME_ALIAS_FIELD,
            STATUS_FIELD, REQUEST_ID_FIELD));

    private final ThemeAlias themeAlias;

    private final Integer status;

    private final String requestId;

    private CreateThemeAliasResponse(BuilderImpl builder) {
        super(builder);
        this.themeAlias = builder.themeAlias;
        this.status = builder.status;
        this.requestId = builder.requestId;
    }

    /**
     * <p>
     * Information about the theme alias.
     * </p>
     * 
     * @return Information about the theme alias.
     */
    public final ThemeAlias themeAlias() {
        return themeAlias;
    }

    /**
     * <p>
     * The HTTP status of the request.
     * </p>
     * 
     * @return The HTTP status of the request.
     */
    public final Integer status() {
        return status;
    }

    /**
     * <p>
     * The Amazon Web Services request ID for this operation.
     * </p>
     * 
     * @return The Amazon Web Services request ID for this operation.
     */
    public final String requestId() {
        return requestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(themeAlias());
        hashCode = 31 * hashCode + Objects.hashCode(status());
        hashCode = 31 * hashCode + Objects.hashCode(requestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateThemeAliasResponse)) {
            return false;
        }
        CreateThemeAliasResponse other = (CreateThemeAliasResponse) obj;
        return Objects.equals(themeAlias(), other.themeAlias()) && Objects.equals(status(), other.status())
                && Objects.equals(requestId(), other.requestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateThemeAliasResponse").add("ThemeAlias", themeAlias()).add("Status", status())
                .add("RequestId", requestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ThemeAlias":
            return Optional.ofNullable(clazz.cast(themeAlias()));
        case "Status":
            return Optional.ofNullable(clazz.cast(status()));
        case "RequestId":
            return Optional.ofNullable(clazz.cast(requestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateThemeAliasResponse, T> g) {
        return obj -> g.apply((CreateThemeAliasResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightResponse.Builder, SdkPojo, CopyableBuilder<Builder, CreateThemeAliasResponse> {
        /**
         * <p>
         * Information about the theme alias.
         * </p>
         * 
         * @param themeAlias
         *        Information about the theme alias.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder themeAlias(ThemeAlias themeAlias);

        /**
         * <p>
         * Information about the theme alias.
         * </p>
         * This is a convenience that creates an instance of the {@link ThemeAlias.Builder} avoiding the need to create
         * one manually via {@link ThemeAlias#builder()}.
         *
         * When the {@link Consumer} completes, {@link ThemeAlias.Builder#build()} is called immediately and its result
         * is passed to {@link #themeAlias(ThemeAlias)}.
         * 
         * @param themeAlias
         *        a consumer that will call methods on {@link ThemeAlias.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #themeAlias(ThemeAlias)
         */
        default Builder themeAlias(Consumer<ThemeAlias.Builder> themeAlias) {
            return themeAlias(ThemeAlias.builder().applyMutation(themeAlias).build());
        }

        /**
         * <p>
         * The HTTP status of the request.
         * </p>
         * 
         * @param status
         *        The HTTP status of the request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder status(Integer status);

        /**
         * <p>
         * The Amazon Web Services request ID for this operation.
         * </p>
         * 
         * @param requestId
         *        The Amazon Web Services request ID for this operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestId(String requestId);
    }

    static final class BuilderImpl extends QuickSightResponse.BuilderImpl implements Builder {
        private ThemeAlias themeAlias;

        private Integer status;

        private String requestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateThemeAliasResponse model) {
            super(model);
            themeAlias(model.themeAlias);
            status(model.status);
            requestId(model.requestId);
        }

        public final ThemeAlias.Builder getThemeAlias() {
            return themeAlias != null ? themeAlias.toBuilder() : null;
        }

        @Override
        public final Builder themeAlias(ThemeAlias themeAlias) {
            this.themeAlias = themeAlias;
            return this;
        }

        public final void setThemeAlias(ThemeAlias.BuilderImpl themeAlias) {
            this.themeAlias = themeAlias != null ? themeAlias.build() : null;
        }

        public final Integer getStatus() {
            return status;
        }

        @Override
        public final Builder status(Integer status) {
            this.status = status;
            return this;
        }

        public final void setStatus(Integer status) {
            this.status = status;
        }

        public final String getRequestId() {
            return requestId;
        }

        @Override
        public final Builder requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        public final void setRequestId(String requestId) {
            this.requestId = requestId;
        }

        @Override
        public CreateThemeAliasResponse build() {
            return new CreateThemeAliasResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
