/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Information about the format for a source file or files.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UploadSettings implements SdkPojo, Serializable, ToCopyableBuilder<UploadSettings.Builder, UploadSettings> {
    private static final SdkField<String> FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Format")
            .getter(getter(UploadSettings::formatAsString)).setter(setter(Builder::format))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Format").build()).build();

    private static final SdkField<Integer> START_FROM_ROW_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("StartFromRow").getter(getter(UploadSettings::startFromRow)).setter(setter(Builder::startFromRow))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartFromRow").build()).build();

    private static final SdkField<Boolean> CONTAINS_HEADER_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ContainsHeader").getter(getter(UploadSettings::containsHeader)).setter(setter(Builder::containsHeader))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContainsHeader").build()).build();

    private static final SdkField<String> TEXT_QUALIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TextQualifier").getter(getter(UploadSettings::textQualifierAsString))
            .setter(setter(Builder::textQualifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TextQualifier").build()).build();

    private static final SdkField<String> DELIMITER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Delimiter").getter(getter(UploadSettings::delimiter)).setter(setter(Builder::delimiter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Delimiter").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FORMAT_FIELD,
            START_FROM_ROW_FIELD, CONTAINS_HEADER_FIELD, TEXT_QUALIFIER_FIELD, DELIMITER_FIELD));

    private static final long serialVersionUID = 1L;

    private final String format;

    private final Integer startFromRow;

    private final Boolean containsHeader;

    private final String textQualifier;

    private final String delimiter;

    private UploadSettings(BuilderImpl builder) {
        this.format = builder.format;
        this.startFromRow = builder.startFromRow;
        this.containsHeader = builder.containsHeader;
        this.textQualifier = builder.textQualifier;
        this.delimiter = builder.delimiter;
    }

    /**
     * <p>
     * File format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return File format.
     * @see FileFormat
     */
    public final FileFormat format() {
        return FileFormat.fromValue(format);
    }

    /**
     * <p>
     * File format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #format} will
     * return {@link FileFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #formatAsString}.
     * </p>
     * 
     * @return File format.
     * @see FileFormat
     */
    public final String formatAsString() {
        return format;
    }

    /**
     * <p>
     * A row number to start reading data from.
     * </p>
     * 
     * @return A row number to start reading data from.
     */
    public final Integer startFromRow() {
        return startFromRow;
    }

    /**
     * <p>
     * Whether the file has a header row, or the files each have a header row.
     * </p>
     * 
     * @return Whether the file has a header row, or the files each have a header row.
     */
    public final Boolean containsHeader() {
        return containsHeader;
    }

    /**
     * <p>
     * Text qualifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textQualifier}
     * will return {@link TextQualifier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textQualifierAsString}.
     * </p>
     * 
     * @return Text qualifier.
     * @see TextQualifier
     */
    public final TextQualifier textQualifier() {
        return TextQualifier.fromValue(textQualifier);
    }

    /**
     * <p>
     * Text qualifier.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #textQualifier}
     * will return {@link TextQualifier#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #textQualifierAsString}.
     * </p>
     * 
     * @return Text qualifier.
     * @see TextQualifier
     */
    public final String textQualifierAsString() {
        return textQualifier;
    }

    /**
     * <p>
     * The delimiter between values in the file.
     * </p>
     * 
     * @return The delimiter between values in the file.
     */
    public final String delimiter() {
        return delimiter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(formatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startFromRow());
        hashCode = 31 * hashCode + Objects.hashCode(containsHeader());
        hashCode = 31 * hashCode + Objects.hashCode(textQualifierAsString());
        hashCode = 31 * hashCode + Objects.hashCode(delimiter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadSettings)) {
            return false;
        }
        UploadSettings other = (UploadSettings) obj;
        return Objects.equals(formatAsString(), other.formatAsString()) && Objects.equals(startFromRow(), other.startFromRow())
                && Objects.equals(containsHeader(), other.containsHeader())
                && Objects.equals(textQualifierAsString(), other.textQualifierAsString())
                && Objects.equals(delimiter(), other.delimiter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UploadSettings").add("Format", formatAsString()).add("StartFromRow", startFromRow())
                .add("ContainsHeader", containsHeader()).add("TextQualifier", textQualifierAsString())
                .add("Delimiter", delimiter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Format":
            return Optional.ofNullable(clazz.cast(formatAsString()));
        case "StartFromRow":
            return Optional.ofNullable(clazz.cast(startFromRow()));
        case "ContainsHeader":
            return Optional.ofNullable(clazz.cast(containsHeader()));
        case "TextQualifier":
            return Optional.ofNullable(clazz.cast(textQualifierAsString()));
        case "Delimiter":
            return Optional.ofNullable(clazz.cast(delimiter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadSettings, T> g) {
        return obj -> g.apply((UploadSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UploadSettings> {
        /**
         * <p>
         * File format.
         * </p>
         * 
         * @param format
         *        File format.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder format(String format);

        /**
         * <p>
         * File format.
         * </p>
         * 
         * @param format
         *        File format.
         * @see FileFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FileFormat
         */
        Builder format(FileFormat format);

        /**
         * <p>
         * A row number to start reading data from.
         * </p>
         * 
         * @param startFromRow
         *        A row number to start reading data from.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startFromRow(Integer startFromRow);

        /**
         * <p>
         * Whether the file has a header row, or the files each have a header row.
         * </p>
         * 
         * @param containsHeader
         *        Whether the file has a header row, or the files each have a header row.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder containsHeader(Boolean containsHeader);

        /**
         * <p>
         * Text qualifier.
         * </p>
         * 
         * @param textQualifier
         *        Text qualifier.
         * @see TextQualifier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextQualifier
         */
        Builder textQualifier(String textQualifier);

        /**
         * <p>
         * Text qualifier.
         * </p>
         * 
         * @param textQualifier
         *        Text qualifier.
         * @see TextQualifier
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TextQualifier
         */
        Builder textQualifier(TextQualifier textQualifier);

        /**
         * <p>
         * The delimiter between values in the file.
         * </p>
         * 
         * @param delimiter
         *        The delimiter between values in the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder delimiter(String delimiter);
    }

    static final class BuilderImpl implements Builder {
        private String format;

        private Integer startFromRow;

        private Boolean containsHeader;

        private String textQualifier;

        private String delimiter;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadSettings model) {
            format(model.format);
            startFromRow(model.startFromRow);
            containsHeader(model.containsHeader);
            textQualifier(model.textQualifier);
            delimiter(model.delimiter);
        }

        public final String getFormat() {
            return format;
        }

        @Override
        public final Builder format(String format) {
            this.format = format;
            return this;
        }

        @Override
        public final Builder format(FileFormat format) {
            this.format(format == null ? null : format.toString());
            return this;
        }

        public final void setFormat(String format) {
            this.format = format;
        }

        public final Integer getStartFromRow() {
            return startFromRow;
        }

        @Override
        public final Builder startFromRow(Integer startFromRow) {
            this.startFromRow = startFromRow;
            return this;
        }

        public final void setStartFromRow(Integer startFromRow) {
            this.startFromRow = startFromRow;
        }

        public final Boolean getContainsHeader() {
            return containsHeader;
        }

        @Override
        public final Builder containsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
            return this;
        }

        public final void setContainsHeader(Boolean containsHeader) {
            this.containsHeader = containsHeader;
        }

        public final String getTextQualifier() {
            return textQualifier;
        }

        @Override
        public final Builder textQualifier(String textQualifier) {
            this.textQualifier = textQualifier;
            return this;
        }

        @Override
        public final Builder textQualifier(TextQualifier textQualifier) {
            this.textQualifier(textQualifier == null ? null : textQualifier.toString());
            return this;
        }

        public final void setTextQualifier(String textQualifier) {
            this.textQualifier = textQualifier;
        }

        public final String getDelimiter() {
            return delimiter;
        }

        @Override
        public final Builder delimiter(String delimiter) {
            this.delimiter = delimiter;
            return this;
        }

        public final void setDelimiter(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public UploadSettings build() {
            return new UploadSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
