/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Display options related to tiles on a sheet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TileStyle implements SdkPojo, Serializable, ToCopyableBuilder<TileStyle.Builder, TileStyle> {
    private static final SdkField<BorderStyle> BORDER_FIELD = SdkField.<BorderStyle> builder(MarshallingType.SDK_POJO)
            .memberName("Border").getter(getter(TileStyle::border)).setter(setter(Builder::border))
            .constructor(BorderStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Border").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final BorderStyle border;

    private TileStyle(BuilderImpl builder) {
        this.border = builder.border;
    }

    /**
     * <p>
     * The border around a tile.
     * </p>
     * 
     * @return The border around a tile.
     */
    public final BorderStyle border() {
        return border;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(border());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TileStyle)) {
            return false;
        }
        TileStyle other = (TileStyle) obj;
        return Objects.equals(border(), other.border());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TileStyle").add("Border", border()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Border":
            return Optional.ofNullable(clazz.cast(border()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TileStyle, T> g) {
        return obj -> g.apply((TileStyle) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TileStyle> {
        /**
         * <p>
         * The border around a tile.
         * </p>
         * 
         * @param border
         *        The border around a tile.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder border(BorderStyle border);

        /**
         * <p>
         * The border around a tile.
         * </p>
         * This is a convenience that creates an instance of the {@link BorderStyle.Builder} avoiding the need to create
         * one manually via {@link BorderStyle#builder()}.
         *
         * When the {@link Consumer} completes, {@link BorderStyle.Builder#build()} is called immediately and its result
         * is passed to {@link #border(BorderStyle)}.
         * 
         * @param border
         *        a consumer that will call methods on {@link BorderStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #border(BorderStyle)
         */
        default Builder border(Consumer<BorderStyle.Builder> border) {
            return border(BorderStyle.builder().applyMutation(border).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BorderStyle border;

        private BuilderImpl() {
        }

        private BuilderImpl(TileStyle model) {
            border(model.border);
        }

        public final BorderStyle.Builder getBorder() {
            return border != null ? border.toBuilder() : null;
        }

        public final void setBorder(BorderStyle.BuilderImpl border) {
            this.border = border != null ? border.build() : null;
        }

        @Override
        @Transient
        public final Builder border(BorderStyle border) {
            this.border = border;
            return this;
        }

        @Override
        public TileStyle build() {
            return new TileStyle(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
