/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAccountSubscriptionRequest extends QuickSightRequest implements
        ToCopyableBuilder<CreateAccountSubscriptionRequest.Builder, CreateAccountSubscriptionRequest> {
    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(CreateAccountSubscriptionRequest::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<String> AUTHENTICATION_METHOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AuthenticationMethod").getter(getter(CreateAccountSubscriptionRequest::authenticationMethodAsString))
            .setter(setter(Builder::authenticationMethod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationMethod").build())
            .build();

    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AwsAccountId").getter(getter(CreateAccountSubscriptionRequest::awsAccountId))
            .setter(setter(Builder::awsAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("AwsAccountId").build()).build();

    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(CreateAccountSubscriptionRequest::accountName))
            .setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationEmail").getter(getter(CreateAccountSubscriptionRequest::notificationEmail))
            .setter(setter(Builder::notificationEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()).build();

    private static final SdkField<String> ACTIVE_DIRECTORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ActiveDirectoryName").getter(getter(CreateAccountSubscriptionRequest::activeDirectoryName))
            .setter(setter(Builder::activeDirectoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveDirectoryName").build())
            .build();

    private static final SdkField<String> REALM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Realm")
            .getter(getter(CreateAccountSubscriptionRequest::realm)).setter(setter(Builder::realm))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Realm").build()).build();

    private static final SdkField<String> DIRECTORY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryId").getter(getter(CreateAccountSubscriptionRequest::directoryId))
            .setter(setter(Builder::directoryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryId").build()).build();

    private static final SdkField<List<String>> ADMIN_GROUP_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AdminGroup")
            .getter(getter(CreateAccountSubscriptionRequest::adminGroup))
            .setter(setter(Builder::adminGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AdminGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> AUTHOR_GROUP_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AuthorGroup")
            .getter(getter(CreateAccountSubscriptionRequest::authorGroup))
            .setter(setter(Builder::authorGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthorGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> READER_GROUP_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ReaderGroup")
            .getter(getter(CreateAccountSubscriptionRequest::readerGroup))
            .setter(setter(Builder::readerGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReaderGroup").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FIRST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FirstName").getter(getter(CreateAccountSubscriptionRequest::firstName))
            .setter(setter(Builder::firstName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FirstName").build()).build();

    private static final SdkField<String> LAST_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastName").getter(getter(CreateAccountSubscriptionRequest::lastName)).setter(setter(Builder::lastName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastName").build()).build();

    private static final SdkField<String> EMAIL_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EmailAddress").getter(getter(CreateAccountSubscriptionRequest::emailAddress))
            .setter(setter(Builder::emailAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EmailAddress").build()).build();

    private static final SdkField<String> CONTACT_NUMBER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ContactNumber").getter(getter(CreateAccountSubscriptionRequest::contactNumber))
            .setter(setter(Builder::contactNumber))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContactNumber").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITION_FIELD,
            AUTHENTICATION_METHOD_FIELD, AWS_ACCOUNT_ID_FIELD, ACCOUNT_NAME_FIELD, NOTIFICATION_EMAIL_FIELD,
            ACTIVE_DIRECTORY_NAME_FIELD, REALM_FIELD, DIRECTORY_ID_FIELD, ADMIN_GROUP_FIELD, AUTHOR_GROUP_FIELD,
            READER_GROUP_FIELD, FIRST_NAME_FIELD, LAST_NAME_FIELD, EMAIL_ADDRESS_FIELD, CONTACT_NUMBER_FIELD));

    private final String edition;

    private final String authenticationMethod;

    private final String awsAccountId;

    private final String accountName;

    private final String notificationEmail;

    private final String activeDirectoryName;

    private final String realm;

    private final String directoryId;

    private final List<String> adminGroup;

    private final List<String> authorGroup;

    private final List<String> readerGroup;

    private final String firstName;

    private final String lastName;

    private final String emailAddress;

    private final String contactNumber;

    private CreateAccountSubscriptionRequest(BuilderImpl builder) {
        super(builder);
        this.edition = builder.edition;
        this.authenticationMethod = builder.authenticationMethod;
        this.awsAccountId = builder.awsAccountId;
        this.accountName = builder.accountName;
        this.notificationEmail = builder.notificationEmail;
        this.activeDirectoryName = builder.activeDirectoryName;
        this.realm = builder.realm;
        this.directoryId = builder.directoryId;
        this.adminGroup = builder.adminGroup;
        this.authorGroup = builder.authorGroup;
        this.readerGroup = builder.readerGroup;
        this.firstName = builder.firstName;
        this.lastName = builder.lastName;
        this.emailAddress = builder.emailAddress;
        this.contactNumber = builder.contactNumber;
    }

    /**
     * <p>
     * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
     * <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.
     * </p>
     * <p>
     * If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FirstName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EmailAddress</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContactNumber</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
     *         <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.</p>
     *         <p>
     *         If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FirstName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EmailAddress</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ContactNumber</code>
     *         </p>
     *         </li>
     * @see Edition
     */
    public final Edition edition() {
        return Edition.fromValue(edition);
    }

    /**
     * <p>
     * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
     * <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.
     * </p>
     * <p>
     * If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>FirstName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>LastName</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EmailAddress</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ContactNumber</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
     *         <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.</p>
     *         <p>
     *         If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>FirstName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>LastName</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EmailAddress</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ContactNumber</code>
     *         </p>
     *         </li>
     * @see Edition
     */
    public final String editionAsString() {
        return edition;
    }

    /**
     * <p>
     * The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for
     * this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and <code>ACTIVE_DIRECTORY</code>.
     * </p>
     * <p>
     * If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
     * <code>AdminGroup</code> associated with your Active Directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link AuthenticationMethodOption#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid
     *         values for this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and
     *         <code>ACTIVE_DIRECTORY</code>.</p>
     *         <p>
     *         If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
     *         <code>AdminGroup</code> associated with your Active Directory.
     * @see AuthenticationMethodOption
     */
    public final AuthenticationMethodOption authenticationMethod() {
        return AuthenticationMethodOption.fromValue(authenticationMethod);
    }

    /**
     * <p>
     * The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values for
     * this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and <code>ACTIVE_DIRECTORY</code>.
     * </p>
     * <p>
     * If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
     * <code>AdminGroup</code> associated with your Active Directory.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationMethod} will return {@link AuthenticationMethodOption#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #authenticationMethodAsString}.
     * </p>
     * 
     * @return The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid
     *         values for this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and
     *         <code>ACTIVE_DIRECTORY</code>.</p>
     *         <p>
     *         If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
     *         <code>AdminGroup</code> associated with your Active Directory.
     * @see AuthenticationMethodOption
     */
    public final String authenticationMethodAsString() {
        return authenticationMethod;
    }

    /**
     * <p>
     * The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight account.
     * </p>
     * 
     * @return The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight
     *         account.
     */
    public final String awsAccountId() {
        return awsAccountId;
    }

    /**
     * <p>
     * The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it appears
     * only when users sign in. You can't change <code>AccountName</code> value after the Amazon QuickSight account is
     * created.
     * </p>
     * 
     * @return The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it
     *         appears only when users sign in. You can't change <code>AccountName</code> value after the Amazon
     *         QuickSight account is created.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight
     * account or Amazon QuickSight subscription.
     * </p>
     * 
     * @return The email address that you want Amazon QuickSight to send notifications to regarding your Amazon
     *         QuickSight account or Amazon QuickSight subscription.
     */
    public final String notificationEmail() {
        return notificationEmail;
    }

    /**
     * <p>
     * The name of your Active Directory. This field is required if <code>ACTIVE_DIRECTORY</code> is the selected
     * authentication method of the new Amazon QuickSight account.
     * </p>
     * 
     * @return The name of your Active Directory. This field is required if <code>ACTIVE_DIRECTORY</code> is the
     *         selected authentication method of the new Amazon QuickSight account.
     */
    public final String activeDirectoryName() {
        return activeDirectoryName;
    }

    /**
     * <p>
     * The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is required
     * if <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight account.
     * </p>
     * 
     * @return The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is
     *         required if <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon
     *         QuickSight account.
     */
    public final String realm() {
        return realm;
    }

    /**
     * <p>
     * The ID of the Active Directory that is associated with your Amazon QuickSight account.
     * </p>
     * 
     * @return The ID of the Active Directory that is associated with your Amazon QuickSight account.
     */
    public final String directoryId() {
        return directoryId;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdminGroup property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAdminGroup() {
        return adminGroup != null && !(adminGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The admin group associated with your Active Directory. This field is required if <code>ACTIVE_DIRECTORY</code> is
     * the selected authentication method of the new Amazon QuickSight account. For more information about using Active
     * Directory in Amazon QuickSight, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with
     * Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdminGroup} method.
     * </p>
     * 
     * @return The admin group associated with your Active Directory. This field is required if
     *         <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight account.
     *         For more information about using Active Directory in Amazon QuickSight, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
     *         Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
     */
    public final List<String> adminGroup() {
        return adminGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the AuthorGroup property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAuthorGroup() {
        return authorGroup != null && !(authorGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The author group associated with your Active Directory. For more information about using Active Directory in
     * Amazon QuickSight, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with
     * Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAuthorGroup} method.
     * </p>
     * 
     * @return The author group associated with your Active Directory. For more information about using Active Directory
     *         in Amazon QuickSight, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
     *         Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
     */
    public final List<String> authorGroup() {
        return authorGroup;
    }

    /**
     * For responses, this returns true if the service returned a value for the ReaderGroup property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasReaderGroup() {
        return readerGroup != null && !(readerGroup instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The reader group associated with your Active Direcrtory. For more information about using Active Directory in
     * Amazon QuickSight, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory with
     * Amazon QuickSight Enterprise Edition</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasReaderGroup} method.
     * </p>
     * 
     * @return The reader group associated with your Active Direcrtory. For more information about using Active
     *         Directory in Amazon QuickSight, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
     *         Directory with Amazon QuickSight Enterprise Edition</a> in the <i>Amazon QuickSight User Guide</i>.
     */
    public final List<String> readerGroup() {
        return readerGroup;
    }

    /**
     * <p>
     * The first name of the author of the Amazon QuickSight account to use for future communications. This field is
     * required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.
     * </p>
     * 
     * @return The first name of the author of the Amazon QuickSight account to use for future communications. This
     *         field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight
     *         account.
     */
    public final String firstName() {
        return firstName;
    }

    /**
     * <p>
     * The last name of the author of the Amazon QuickSight account to use for future communications. This field is
     * required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.
     * </p>
     * 
     * @return The last name of the author of the Amazon QuickSight account to use for future communications. This field
     *         is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight
     *         account.
     */
    public final String lastName() {
        return lastName;
    }

    /**
     * <p>
     * The email address of the author of the Amazon QuickSight account to use for future communications. This field is
     * required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.
     * </p>
     * 
     * @return The email address of the author of the Amazon QuickSight account to use for future communications. This
     *         field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight
     *         account.
     */
    public final String emailAddress() {
        return emailAddress;
    }

    /**
     * <p>
     * A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications. This
     * field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.
     * </p>
     * 
     * @return A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications.
     *         This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon
     *         QuickSight account.
     */
    public final String contactNumber() {
        return contactNumber;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationMethodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEmail());
        hashCode = 31 * hashCode + Objects.hashCode(activeDirectoryName());
        hashCode = 31 * hashCode + Objects.hashCode(realm());
        hashCode = 31 * hashCode + Objects.hashCode(directoryId());
        hashCode = 31 * hashCode + Objects.hashCode(hasAdminGroup() ? adminGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAuthorGroup() ? authorGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasReaderGroup() ? readerGroup() : null);
        hashCode = 31 * hashCode + Objects.hashCode(firstName());
        hashCode = 31 * hashCode + Objects.hashCode(lastName());
        hashCode = 31 * hashCode + Objects.hashCode(emailAddress());
        hashCode = 31 * hashCode + Objects.hashCode(contactNumber());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccountSubscriptionRequest)) {
            return false;
        }
        CreateAccountSubscriptionRequest other = (CreateAccountSubscriptionRequest) obj;
        return Objects.equals(editionAsString(), other.editionAsString())
                && Objects.equals(authenticationMethodAsString(), other.authenticationMethodAsString())
                && Objects.equals(awsAccountId(), other.awsAccountId()) && Objects.equals(accountName(), other.accountName())
                && Objects.equals(notificationEmail(), other.notificationEmail())
                && Objects.equals(activeDirectoryName(), other.activeDirectoryName()) && Objects.equals(realm(), other.realm())
                && Objects.equals(directoryId(), other.directoryId()) && hasAdminGroup() == other.hasAdminGroup()
                && Objects.equals(adminGroup(), other.adminGroup()) && hasAuthorGroup() == other.hasAuthorGroup()
                && Objects.equals(authorGroup(), other.authorGroup()) && hasReaderGroup() == other.hasReaderGroup()
                && Objects.equals(readerGroup(), other.readerGroup()) && Objects.equals(firstName(), other.firstName())
                && Objects.equals(lastName(), other.lastName()) && Objects.equals(emailAddress(), other.emailAddress())
                && Objects.equals(contactNumber(), other.contactNumber());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAccountSubscriptionRequest").add("Edition", editionAsString())
                .add("AuthenticationMethod", authenticationMethodAsString()).add("AwsAccountId", awsAccountId())
                .add("AccountName", accountName()).add("NotificationEmail", notificationEmail())
                .add("ActiveDirectoryName", activeDirectoryName()).add("Realm", realm()).add("DirectoryId", directoryId())
                .add("AdminGroup", hasAdminGroup() ? adminGroup() : null)
                .add("AuthorGroup", hasAuthorGroup() ? authorGroup() : null)
                .add("ReaderGroup", hasReaderGroup() ? readerGroup() : null).add("FirstName", firstName())
                .add("LastName", lastName()).add("EmailAddress", emailAddress()).add("ContactNumber", contactNumber()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        case "AuthenticationMethod":
            return Optional.ofNullable(clazz.cast(authenticationMethodAsString()));
        case "AwsAccountId":
            return Optional.ofNullable(clazz.cast(awsAccountId()));
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "NotificationEmail":
            return Optional.ofNullable(clazz.cast(notificationEmail()));
        case "ActiveDirectoryName":
            return Optional.ofNullable(clazz.cast(activeDirectoryName()));
        case "Realm":
            return Optional.ofNullable(clazz.cast(realm()));
        case "DirectoryId":
            return Optional.ofNullable(clazz.cast(directoryId()));
        case "AdminGroup":
            return Optional.ofNullable(clazz.cast(adminGroup()));
        case "AuthorGroup":
            return Optional.ofNullable(clazz.cast(authorGroup()));
        case "ReaderGroup":
            return Optional.ofNullable(clazz.cast(readerGroup()));
        case "FirstName":
            return Optional.ofNullable(clazz.cast(firstName()));
        case "LastName":
            return Optional.ofNullable(clazz.cast(lastName()));
        case "EmailAddress":
            return Optional.ofNullable(clazz.cast(emailAddress()));
        case "ContactNumber":
            return Optional.ofNullable(clazz.cast(contactNumber()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateAccountSubscriptionRequest, T> g) {
        return obj -> g.apply((CreateAccountSubscriptionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends QuickSightRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAccountSubscriptionRequest> {
        /**
         * <p>
         * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
         * <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.
         * </p>
         * <p>
         * If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FirstName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EmailAddress</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ContactNumber</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param edition
         *        The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
         *        <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.</p>
         *        <p>
         *        If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FirstName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EmailAddress</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ContactNumber</code>
         *        </p>
         *        </li>
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
         * <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.
         * </p>
         * <p>
         * If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>FirstName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>LastName</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EmailAddress</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ContactNumber</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param edition
         *        The edition of Amazon QuickSight that you want your account to have. Currently, you can choose from
         *        <code>ENTERPRISE</code> or <code>ENTERPRISE_AND_Q</code>.</p>
         *        <p>
         *        If you choose <code>ENTERPRISE_AND_Q</code>, the following parameters are required:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>FirstName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>LastName</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EmailAddress</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ContactNumber</code>
         *        </p>
         *        </li>
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(Edition edition);

        /**
         * <p>
         * The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values
         * for this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and
         * <code>ACTIVE_DIRECTORY</code>.
         * </p>
         * <p>
         * If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
         * <code>AdminGroup</code> associated with your Active Directory.
         * </p>
         * 
         * @param authenticationMethod
         *        The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid
         *        values for this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and
         *        <code>ACTIVE_DIRECTORY</code>.</p>
         *        <p>
         *        If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
         *        <code>AdminGroup</code> associated with your Active Directory.
         * @see AuthenticationMethodOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethodOption
         */
        Builder authenticationMethod(String authenticationMethod);

        /**
         * <p>
         * The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid values
         * for this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and
         * <code>ACTIVE_DIRECTORY</code>.
         * </p>
         * <p>
         * If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
         * <code>AdminGroup</code> associated with your Active Directory.
         * </p>
         * 
         * @param authenticationMethod
         *        The method that you want to use to authenticate your Amazon QuickSight account. Currently, the valid
         *        values for this parameter are <code>IAM_AND_QUICKSIGHT</code>, <code>IAM_ONLY</code>, and
         *        <code>ACTIVE_DIRECTORY</code>.</p>
         *        <p>
         *        If you choose <code>ACTIVE_DIRECTORY</code>, provide an <code>ActiveDirectoryName</code> and an
         *        <code>AdminGroup</code> associated with your Active Directory.
         * @see AuthenticationMethodOption
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationMethodOption
         */
        Builder authenticationMethod(AuthenticationMethodOption authenticationMethod);

        /**
         * <p>
         * The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight account.
         * </p>
         * 
         * @param awsAccountId
         *        The Amazon Web Services account ID of the account that you're using to create your Amazon QuickSight
         *        account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsAccountId(String awsAccountId);

        /**
         * <p>
         * The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and it
         * appears only when users sign in. You can't change <code>AccountName</code> value after the Amazon QuickSight
         * account is created.
         * </p>
         * 
         * @param accountName
         *        The name of your Amazon QuickSight account. This name is unique over all of Amazon Web Services, and
         *        it appears only when users sign in. You can't change <code>AccountName</code> value after the Amazon
         *        QuickSight account is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The email address that you want Amazon QuickSight to send notifications to regarding your Amazon QuickSight
         * account or Amazon QuickSight subscription.
         * </p>
         * 
         * @param notificationEmail
         *        The email address that you want Amazon QuickSight to send notifications to regarding your Amazon
         *        QuickSight account or Amazon QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEmail(String notificationEmail);

        /**
         * <p>
         * The name of your Active Directory. This field is required if <code>ACTIVE_DIRECTORY</code> is the selected
         * authentication method of the new Amazon QuickSight account.
         * </p>
         * 
         * @param activeDirectoryName
         *        The name of your Active Directory. This field is required if <code>ACTIVE_DIRECTORY</code> is the
         *        selected authentication method of the new Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeDirectoryName(String activeDirectoryName);

        /**
         * <p>
         * The realm of the Active Directory that is associated with your Amazon QuickSight account. This field is
         * required if <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight
         * account.
         * </p>
         * 
         * @param realm
         *        The realm of the Active Directory that is associated with your Amazon QuickSight account. This field
         *        is required if <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon
         *        QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder realm(String realm);

        /**
         * <p>
         * The ID of the Active Directory that is associated with your Amazon QuickSight account.
         * </p>
         * 
         * @param directoryId
         *        The ID of the Active Directory that is associated with your Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryId(String directoryId);

        /**
         * <p>
         * The admin group associated with your Active Directory. This field is required if
         * <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight account. For
         * more information about using Active Directory in Amazon QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory
         * with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * </p>
         * 
         * @param adminGroup
         *        The admin group associated with your Active Directory. This field is required if
         *        <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight
         *        account. For more information about using Active Directory in Amazon QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
         *        Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminGroup(Collection<String> adminGroup);

        /**
         * <p>
         * The admin group associated with your Active Directory. This field is required if
         * <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight account. For
         * more information about using Active Directory in Amazon QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory
         * with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * </p>
         * 
         * @param adminGroup
         *        The admin group associated with your Active Directory. This field is required if
         *        <code>ACTIVE_DIRECTORY</code> is the selected authentication method of the new Amazon QuickSight
         *        account. For more information about using Active Directory in Amazon QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
         *        Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder adminGroup(String... adminGroup);

        /**
         * <p>
         * The author group associated with your Active Directory. For more information about using Active Directory in
         * Amazon QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory
         * with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * </p>
         * 
         * @param authorGroup
         *        The author group associated with your Active Directory. For more information about using Active
         *        Directory in Amazon QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
         *        Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorGroup(Collection<String> authorGroup);

        /**
         * <p>
         * The author group associated with your Active Directory. For more information about using Active Directory in
         * Amazon QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory
         * with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * </p>
         * 
         * @param authorGroup
         *        The author group associated with your Active Directory. For more information about using Active
         *        Directory in Amazon QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
         *        Directory with Amazon QuickSight Enterprise Edition</a> in the Amazon QuickSight User Guide.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authorGroup(String... authorGroup);

        /**
         * <p>
         * The reader group associated with your Active Direcrtory. For more information about using Active Directory in
         * Amazon QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory
         * with Amazon QuickSight Enterprise Edition</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param readerGroup
         *        The reader group associated with your Active Direcrtory. For more information about using Active
         *        Directory in Amazon QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
         *        Directory with Amazon QuickSight Enterprise Edition</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readerGroup(Collection<String> readerGroup);

        /**
         * <p>
         * The reader group associated with your Active Direcrtory. For more information about using Active Directory in
         * Amazon QuickSight, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active Directory
         * with Amazon QuickSight Enterprise Edition</a> in the <i>Amazon QuickSight User Guide</i>.
         * </p>
         * 
         * @param readerGroup
         *        The reader group associated with your Active Direcrtory. For more information about using Active
         *        Directory in Amazon QuickSight, see <a
         *        href="https://docs.aws.amazon.com/quicksight/latest/user/aws-directory-service.html">Using Active
         *        Directory with Amazon QuickSight Enterprise Edition</a> in the <i>Amazon QuickSight User Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder readerGroup(String... readerGroup);

        /**
         * <p>
         * The first name of the author of the Amazon QuickSight account to use for future communications. This field is
         * required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.
         * </p>
         * 
         * @param firstName
         *        The first name of the author of the Amazon QuickSight account to use for future communications. This
         *        field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon
         *        QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder firstName(String firstName);

        /**
         * <p>
         * The last name of the author of the Amazon QuickSight account to use for future communications. This field is
         * required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.
         * </p>
         * 
         * @param lastName
         *        The last name of the author of the Amazon QuickSight account to use for future communications. This
         *        field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon
         *        QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastName(String lastName);

        /**
         * <p>
         * The email address of the author of the Amazon QuickSight account to use for future communications. This field
         * is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight account.
         * </p>
         * 
         * @param emailAddress
         *        The email address of the author of the Amazon QuickSight account to use for future communications.
         *        This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon
         *        QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder emailAddress(String emailAddress);

        /**
         * <p>
         * A 10-digit phone number for the author of the Amazon QuickSight account to use for future communications.
         * This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of the new Amazon QuickSight
         * account.
         * </p>
         * 
         * @param contactNumber
         *        A 10-digit phone number for the author of the Amazon QuickSight account to use for future
         *        communications. This field is required if <code>ENTERPPRISE_AND_Q</code> is the selected edition of
         *        the new Amazon QuickSight account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contactNumber(String contactNumber);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends QuickSightRequest.BuilderImpl implements Builder {
        private String edition;

        private String authenticationMethod;

        private String awsAccountId;

        private String accountName;

        private String notificationEmail;

        private String activeDirectoryName;

        private String realm;

        private String directoryId;

        private List<String> adminGroup = DefaultSdkAutoConstructList.getInstance();

        private List<String> authorGroup = DefaultSdkAutoConstructList.getInstance();

        private List<String> readerGroup = DefaultSdkAutoConstructList.getInstance();

        private String firstName;

        private String lastName;

        private String emailAddress;

        private String contactNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccountSubscriptionRequest model) {
            super(model);
            edition(model.edition);
            authenticationMethod(model.authenticationMethod);
            awsAccountId(model.awsAccountId);
            accountName(model.accountName);
            notificationEmail(model.notificationEmail);
            activeDirectoryName(model.activeDirectoryName);
            realm(model.realm);
            directoryId(model.directoryId);
            adminGroup(model.adminGroup);
            authorGroup(model.authorGroup);
            readerGroup(model.readerGroup);
            firstName(model.firstName);
            lastName(model.lastName);
            emailAddress(model.emailAddress);
            contactNumber(model.contactNumber);
        }

        public final String getEdition() {
            return edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getAuthenticationMethod() {
            return authenticationMethod;
        }

        public final void setAuthenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
        }

        @Override
        public final Builder authenticationMethod(String authenticationMethod) {
            this.authenticationMethod = authenticationMethod;
            return this;
        }

        @Override
        public final Builder authenticationMethod(AuthenticationMethodOption authenticationMethod) {
            this.authenticationMethod(authenticationMethod == null ? null : authenticationMethod.toString());
            return this;
        }

        public final String getAwsAccountId() {
            return awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getNotificationEmail() {
            return notificationEmail;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final String getActiveDirectoryName() {
            return activeDirectoryName;
        }

        public final void setActiveDirectoryName(String activeDirectoryName) {
            this.activeDirectoryName = activeDirectoryName;
        }

        @Override
        public final Builder activeDirectoryName(String activeDirectoryName) {
            this.activeDirectoryName = activeDirectoryName;
            return this;
        }

        public final String getRealm() {
            return realm;
        }

        public final void setRealm(String realm) {
            this.realm = realm;
        }

        @Override
        public final Builder realm(String realm) {
            this.realm = realm;
            return this;
        }

        public final String getDirectoryId() {
            return directoryId;
        }

        public final void setDirectoryId(String directoryId) {
            this.directoryId = directoryId;
        }

        @Override
        public final Builder directoryId(String directoryId) {
            this.directoryId = directoryId;
            return this;
        }

        public final Collection<String> getAdminGroup() {
            if (adminGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return adminGroup;
        }

        public final void setAdminGroup(Collection<String> adminGroup) {
            this.adminGroup = GroupsListCopier.copy(adminGroup);
        }

        @Override
        public final Builder adminGroup(Collection<String> adminGroup) {
            this.adminGroup = GroupsListCopier.copy(adminGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adminGroup(String... adminGroup) {
            adminGroup(Arrays.asList(adminGroup));
            return this;
        }

        public final Collection<String> getAuthorGroup() {
            if (authorGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return authorGroup;
        }

        public final void setAuthorGroup(Collection<String> authorGroup) {
            this.authorGroup = GroupsListCopier.copy(authorGroup);
        }

        @Override
        public final Builder authorGroup(Collection<String> authorGroup) {
            this.authorGroup = GroupsListCopier.copy(authorGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorGroup(String... authorGroup) {
            authorGroup(Arrays.asList(authorGroup));
            return this;
        }

        public final Collection<String> getReaderGroup() {
            if (readerGroup instanceof SdkAutoConstructList) {
                return null;
            }
            return readerGroup;
        }

        public final void setReaderGroup(Collection<String> readerGroup) {
            this.readerGroup = GroupsListCopier.copy(readerGroup);
        }

        @Override
        public final Builder readerGroup(Collection<String> readerGroup) {
            this.readerGroup = GroupsListCopier.copy(readerGroup);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder readerGroup(String... readerGroup) {
            readerGroup(Arrays.asList(readerGroup));
            return this;
        }

        public final String getFirstName() {
            return firstName;
        }

        public final void setFirstName(String firstName) {
            this.firstName = firstName;
        }

        @Override
        public final Builder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public final String getLastName() {
            return lastName;
        }

        public final void setLastName(String lastName) {
            this.lastName = lastName;
        }

        @Override
        public final Builder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public final String getEmailAddress() {
            return emailAddress;
        }

        public final void setEmailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
        }

        @Override
        public final Builder emailAddress(String emailAddress) {
            this.emailAddress = emailAddress;
            return this;
        }

        public final String getContactNumber() {
            return contactNumber;
        }

        public final void setContactNumber(String contactNumber) {
            this.contactNumber = contactNumber;
        }

        @Override
        public final Builder contactNumber(String contactNumber) {
            this.contactNumber = contactNumber;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAccountSubscriptionRequest build() {
            return new CreateAccountSubscriptionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
