/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dashboard.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Dashboard implements SdkPojo, Serializable, ToCopyableBuilder<Dashboard.Builder, Dashboard> {
    private static final SdkField<String> DASHBOARD_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DashboardId").getter(getter(Dashboard::dashboardId)).setter(setter(Builder::dashboardId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DashboardId").build()).build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Dashboard::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Dashboard::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<DashboardVersion> VERSION_FIELD = SdkField.<DashboardVersion> builder(MarshallingType.SDK_POJO)
            .memberName("Version").getter(getter(Dashboard::version)).setter(setter(Builder::version))
            .constructor(DashboardVersion::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Version").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Dashboard::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<Instant> LAST_PUBLISHED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastPublishedTime").getter(getter(Dashboard::lastPublishedTime))
            .setter(setter(Builder::lastPublishedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastPublishedTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(Dashboard::lastUpdatedTime)).setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DASHBOARD_ID_FIELD, ARN_FIELD,
            NAME_FIELD, VERSION_FIELD, CREATED_TIME_FIELD, LAST_PUBLISHED_TIME_FIELD, LAST_UPDATED_TIME_FIELD));

    private static final long serialVersionUID = 1L;

    private final String dashboardId;

    private final String arn;

    private final String name;

    private final DashboardVersion version;

    private final Instant createdTime;

    private final Instant lastPublishedTime;

    private final Instant lastUpdatedTime;

    private Dashboard(BuilderImpl builder) {
        this.dashboardId = builder.dashboardId;
        this.arn = builder.arn;
        this.name = builder.name;
        this.version = builder.version;
        this.createdTime = builder.createdTime;
        this.lastPublishedTime = builder.lastPublishedTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * Dashboard ID.
     * </p>
     * 
     * @return Dashboard ID.
     */
    public final String dashboardId() {
        return dashboardId;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the resource.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the resource.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * A display name for the dashboard.
     * </p>
     * 
     * @return A display name for the dashboard.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Version.
     * </p>
     * 
     * @return Version.
     */
    public final DashboardVersion version() {
        return version;
    }

    /**
     * <p>
     * The time that this dataset was created.
     * </p>
     * 
     * @return The time that this dataset was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The last time that this dataset was published.
     * </p>
     * 
     * @return The last time that this dataset was published.
     */
    public final Instant lastPublishedTime() {
        return lastPublishedTime;
    }

    /**
     * <p>
     * The last time that this dataset was updated.
     * </p>
     * 
     * @return The last time that this dataset was updated.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dashboardId());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(version());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastPublishedTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Dashboard)) {
            return false;
        }
        Dashboard other = (Dashboard) obj;
        return Objects.equals(dashboardId(), other.dashboardId()) && Objects.equals(arn(), other.arn())
                && Objects.equals(name(), other.name()) && Objects.equals(version(), other.version())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(lastPublishedTime(), other.lastPublishedTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Dashboard").add("DashboardId", dashboardId()).add("Arn", arn()).add("Name", name())
                .add("Version", version()).add("CreatedTime", createdTime()).add("LastPublishedTime", lastPublishedTime())
                .add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DashboardId":
            return Optional.ofNullable(clazz.cast(dashboardId()));
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Version":
            return Optional.ofNullable(clazz.cast(version()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "LastPublishedTime":
            return Optional.ofNullable(clazz.cast(lastPublishedTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Dashboard, T> g) {
        return obj -> g.apply((Dashboard) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Dashboard> {
        /**
         * <p>
         * Dashboard ID.
         * </p>
         * 
         * @param dashboardId
         *        Dashboard ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dashboardId(String dashboardId);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the resource.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) of the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * A display name for the dashboard.
         * </p>
         * 
         * @param name
         *        A display name for the dashboard.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Version.
         * </p>
         * 
         * @param version
         *        Version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder version(DashboardVersion version);

        /**
         * <p>
         * Version.
         * </p>
         * This is a convenience method that creates an instance of the {@link DashboardVersion.Builder} avoiding the
         * need to create one manually via {@link DashboardVersion#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DashboardVersion.Builder#build()} is called immediately and its
         * result is passed to {@link #version(DashboardVersion)}.
         * 
         * @param version
         *        a consumer that will call methods on {@link DashboardVersion.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #version(DashboardVersion)
         */
        default Builder version(Consumer<DashboardVersion.Builder> version) {
            return version(DashboardVersion.builder().applyMutation(version).build());
        }

        /**
         * <p>
         * The time that this dataset was created.
         * </p>
         * 
         * @param createdTime
         *        The time that this dataset was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The last time that this dataset was published.
         * </p>
         * 
         * @param lastPublishedTime
         *        The last time that this dataset was published.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastPublishedTime(Instant lastPublishedTime);

        /**
         * <p>
         * The last time that this dataset was updated.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The last time that this dataset was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String dashboardId;

        private String arn;

        private String name;

        private DashboardVersion version;

        private Instant createdTime;

        private Instant lastPublishedTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Dashboard model) {
            dashboardId(model.dashboardId);
            arn(model.arn);
            name(model.name);
            version(model.version);
            createdTime(model.createdTime);
            lastPublishedTime(model.lastPublishedTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getDashboardId() {
            return dashboardId;
        }

        public final void setDashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
        }

        @Override
        public final Builder dashboardId(String dashboardId) {
            this.dashboardId = dashboardId;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final DashboardVersion.Builder getVersion() {
            return version != null ? version.toBuilder() : null;
        }

        public final void setVersion(DashboardVersion.BuilderImpl version) {
            this.version = version != null ? version.build() : null;
        }

        @Override
        public final Builder version(DashboardVersion version) {
            this.version = version;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final Instant getLastPublishedTime() {
            return lastPublishedTime;
        }

        public final void setLastPublishedTime(Instant lastPublishedTime) {
            this.lastPublishedTime = lastPublishedTime;
        }

        @Override
        public final Builder lastPublishedTime(Instant lastPublishedTime) {
            this.lastPublishedTime = lastPublishedTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public Dashboard build() {
            return new Dashboard(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
