/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsAsyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.AsyncClientHandler;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.quicksight.model.AccessDeniedException;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.ConcurrentUpdatingException;
import software.amazon.awssdk.services.quicksight.model.ConflictException;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.DomainNotWhitelistedException;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserResponse;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserResponse;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.IdentityTypeNotSupportedException;
import software.amazon.awssdk.services.quicksight.model.InternalFailureException;
import software.amazon.awssdk.services.quicksight.model.InvalidNextTokenException;
import software.amazon.awssdk.services.quicksight.model.InvalidParameterValueException;
import software.amazon.awssdk.services.quicksight.model.InvalidRequestException;
import software.amazon.awssdk.services.quicksight.model.LimitExceededException;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersResponse;
import software.amazon.awssdk.services.quicksight.model.ListFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemesResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.PreconditionNotMetException;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.QuickSightUserNotFoundException;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceExistsException;
import software.amazon.awssdk.services.quicksight.model.ResourceNotFoundException;
import software.amazon.awssdk.services.quicksight.model.ResourceUnavailableException;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import software.amazon.awssdk.services.quicksight.model.TagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.TagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ThrottlingException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedPricingPlanException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedUserEditionException;
import software.amazon.awssdk.services.quicksight.model.UntagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.UntagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;
import software.amazon.awssdk.services.quicksight.paginators.ListAnalysesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListNamespacesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListThemeVersionsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.ListThemesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesPublisher;
import software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.SearchDataSetsPublisher;
import software.amazon.awssdk.services.quicksight.paginators.SearchDataSourcesPublisher;
import software.amazon.awssdk.services.quicksight.transform.CancelIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserByPrincipalIdRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderResolvedPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForAnonymousUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForRegisteredUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetDashboardEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetSessionEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFolderMembersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupMembershipsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsForUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIngestionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUserGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RegisterUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RestoreAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdatePublicSharingSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.CompletableFutureUtils;

/**
 * Internal implementation of {@link QuickSightAsyncClient}.
 *
 * @see QuickSightAsyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQuickSightAsyncClient implements QuickSightAsyncClient {
    private static final Logger log = LoggerFactory.getLogger(DefaultQuickSightAsyncClient.class);

    private final AsyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQuickSightAsyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsAsyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Cancels an ongoing ingestion of data into SPICE.
     * </p>
     *
     * @param cancelIngestionRequest
     * @return A Java Future containing the result of the CancelIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CancelIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CancelIngestionResponse> cancelIngestion(CancelIngestionRequest cancelIngestionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelIngestion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CancelIngestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CancelIngestionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CancelIngestionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CancelIngestionRequest, CancelIngestionResponse>()
                            .withOperationName("CancelIngestion")
                            .withMarshaller(new CancelIngestionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(cancelIngestionRequest));
            CompletableFuture<CancelIngestionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a
     * custom default theme by using the <code>CreateAccountCustomization</code> or
     * <code>UpdateAccountCustomization</code> API operation. To further customize Amazon QuickSight by removing Amazon
     * QuickSight sample assets and videos for all new users, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide.</i>
     * </p>
     * <p>
     * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a
     * QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply
     * to an Amazon Web Services account. To find out which customizations apply, use the
     * <code>DescribeAccountCustomization</code> API operation.
     * </p>
     * <p>
     * Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default,
     * make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme
     * isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the
     * current permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> </code>
     * API operation. To share the theme, grant permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> </code>
     * API operation.
     * </p>
     *
     * @param createAccountCustomizationRequest
     * @return A Java Future containing the result of the CreateAccountCustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccountCustomizationResponse> createAccountCustomization(
            CreateAccountCustomizationRequest createAccountCustomizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountCustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAccountCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAccountCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccountCustomizationRequest, CreateAccountCustomizationResponse>()
                            .withOperationName("CreateAccountCustomization")
                            .withMarshaller(new CreateAccountCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAccountCustomizationRequest));
            CompletableFuture<CreateAccountCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
     * </p>
     * <p>
     * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK. This
     * operation isn't supported in the US East (Ohio) Region, South America (Sao Paulo) Region, or Asia Pacific
     * (Singapore) Region.
     * </p>
     * <p>
     * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you
     * don't have an Amazon Web Services account, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html">Sign up for Amazon Web
     * Services</a> in the <i>Amazon QuickSight User Guide</i>. The person who signs up for Amazon QuickSight needs to
     * have the correct Identity and Access Management (IAM) permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html">IAM Policy Examples for Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * If your IAM policy includes both the <code>Subscribe</code> and <code>CreateAccountSubscription</code> actions,
     * make sure that both actions are set to <code>Allow</code>. If either action is set to <code>Deny</code>, the
     * <code>Deny</code> action prevails and your API call fails.
     * </p>
     * <p>
     * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To
     * pass your existing IAM role to Amazon QuickSight, see <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role"
     * >Passing IAM roles to Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default
     * resource access from the Amazon QuickSight console. For more information about setting default resource access to
     * Amazon Web Services services, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html">Setting default resource
     * access to Amazon Web Services services</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param createAccountSubscriptionRequest
     * @return A Java Future containing the result of the CreateAccountSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAccountSubscriptionResponse> createAccountSubscription(
            CreateAccountSubscriptionRequest createAccountSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAccountSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAccountSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAccountSubscriptionRequest, CreateAccountSubscriptionResponse>()
                            .withOperationName("CreateAccountSubscription")
                            .withMarshaller(new CreateAccountSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAccountSubscriptionRequest));
            CompletableFuture<CreateAccountSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an analysis in Amazon QuickSight.
     * </p>
     *
     * @param createAnalysisRequest
     * @return A Java Future containing the result of the CreateAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateAnalysisResponse> createAnalysis(CreateAnalysisRequest createAnalysisRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateAnalysisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateAnalysisRequest, CreateAnalysisResponse>()
                            .withOperationName("CreateAnalysis")
                            .withMarshaller(new CreateAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createAnalysisRequest));
            CompletableFuture<CreateAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a dashboard from a template. To first create a template, see the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code>
     * API operation.
     * </p>
     * <p>
     * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses.
     * You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports
     * from them. If you have the correct permissions, you can create a dashboard from a template that exists in a
     * different Amazon Web Services account.
     * </p>
     *
     * @param createDashboardRequest
     * @return A Java Future containing the result of the CreateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDashboardResponse> createDashboard(CreateDashboardRequest createDashboardRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDashboardRequest, CreateDashboardResponse>()
                            .withOperationName("CreateDashboard")
                            .withMarshaller(new CreateDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDashboardRequest));
            CompletableFuture<CreateDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param createDataSetRequest
     * @return A Java Future containing the result of the CreateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataSetResponse> createDataSet(CreateDataSetRequest createDataSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateDataSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDataSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataSetRequest, CreateDataSetResponse>()
                            .withOperationName("CreateDataSet")
                            .withMarshaller(new CreateDataSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDataSetRequest));
            CompletableFuture<CreateDataSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return A Java Future containing the result of the CreateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateDataSourceResponse> createDataSource(CreateDataSourceRequest createDataSourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                            .withOperationName("CreateDataSource")
                            .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createDataSourceRequest));
            CompletableFuture<CreateDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an empty shared folder.
     * </p>
     *
     * @param createFolderRequest
     * @return A Java Future containing the result of the CreateFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFolderResponse> createFolder(CreateFolderRequest createFolderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFolderRequest, CreateFolderResponse>()
                            .withOperationName("CreateFolder").withMarshaller(new CreateFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFolderRequest));
            CompletableFuture<CreateFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
     * </p>
     *
     * @param createFolderMembershipRequest
     * @return A Java Future containing the result of the CreateFolderMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateFolderMembershipResponse> createFolderMembership(
            CreateFolderMembershipRequest createFolderMembershipRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolderMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateFolderMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateFolderMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateFolderMembershipRequest, CreateFolderMembershipResponse>()
                            .withOperationName("CreateFolderMembership")
                            .withMarshaller(new CreateFolderMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createFolderMembershipRequest));
            CompletableFuture<CreateFolderMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>CreateGroup</code> operation to create a group in Amazon QuickSight. You can create up to 10,000
     * groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact AWS Support.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:&lt;your-region&gt;:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return A Java Future containing the result of the CreateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupResponse> createGroup(CreateGroupRequest createGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                            .withOperationName("CreateGroup").withMarshaller(new CreateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGroupRequest));
            CompletableFuture<CreateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return A Java Future containing the result of the CreateGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateGroupMembershipResponse> createGroupMembership(
            CreateGroupMembershipRequest createGroupMembershipRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroupMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateGroupMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateGroupMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateGroupMembershipRequest, CreateGroupMembershipResponse>()
                            .withOperationName("CreateGroupMembership")
                            .withMarshaller(new CreateGroupMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createGroupMembershipRequest));
            CompletableFuture<CreateGroupMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy
     * assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per
     * Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are
     * unique.
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the CreateIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in a state that indicates an operation is happening
     *         that must complete before a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIamPolicyAssignmentResponse> createIAMPolicyAssignment(
            CreateIamPolicyAssignmentRequest createIamPolicyAssignmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIAMPolicyAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIamPolicyAssignmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIamPolicyAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIamPolicyAssignmentRequest, CreateIamPolicyAssignmentResponse>()
                            .withOperationName("CreateIAMPolicyAssignment")
                            .withMarshaller(new CreateIamPolicyAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createIamPolicyAssignmentRequest));
            CompletableFuture<CreateIamPolicyAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise
     * edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8
     * times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an
     * example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the Amazon Web Services
     * Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
     * </p>
     *
     * @param createIngestionRequest
     * @return A Java Future containing the result of the CreateIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateIngestionResponse> createIngestion(CreateIngestionRequest createIngestionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIngestion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateIngestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateIngestionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateIngestionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateIngestionRequest, CreateIngestionResponse>()
                            .withOperationName("CreateIngestion")
                            .withMarshaller(new CreateIngestionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createIngestionRequest));
            CompletableFuture<CreateIngestionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     * </p>
     * <p>
     * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace.
     * Users that access the namespace can share assets only with other users or groups in the same namespace. They
     * can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account
     * is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By
     * default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a
     * ticket with Amazon Web Services Support.
     * </p>
     *
     * @param createNamespaceRequest
     * @return A Java Future containing the result of the CreateNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateNamespaceResponse> createNamespace(CreateNamespaceRequest createNamespaceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateNamespaceRequest, CreateNamespaceResponse>()
                            .withOperationName("CreateNamespace")
                            .withMarshaller(new CreateNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createNamespaceRequest));
            CompletableFuture<CreateNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a template from an existing Amazon QuickSight analysis or template. You can use the resulting template to
     * create a dashboard.
     * </p>
     * <p>
     * A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis
     * and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to
     * replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset
     * placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     * </p>
     *
     * @param createTemplateRequest
     * @return A Java Future containing the result of the CreateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTemplateResponse> createTemplate(CreateTemplateRequest createTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTemplateRequest, CreateTemplateResponse>()
                            .withOperationName("CreateTemplate")
                            .withMarshaller(new CreateTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTemplateRequest));
            CompletableFuture<CreateTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     *
     * @param createTemplateAliasRequest
     * @return A Java Future containing the result of the CreateTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateTemplateAliasResponse> createTemplateAlias(
            CreateTemplateAliasRequest createTemplateAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateTemplateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateTemplateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateTemplateAliasRequest, CreateTemplateAliasResponse>()
                            .withOperationName("CreateTemplateAlias")
                            .withMarshaller(new CreateTemplateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createTemplateAliasRequest));
            CompletableFuture<CreateTemplateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a theme.
     * </p>
     * <p>
     * A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param createThemeRequest
     * @return A Java Future containing the result of the CreateTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<CreateThemeResponse> createTheme(CreateThemeRequest createThemeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTheme");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    CreateThemeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateThemeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThemeRequest, CreateThemeResponse>()
                            .withOperationName("CreateTheme").withMarshaller(new CreateThemeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createThemeRequest));
            CompletableFuture<CreateThemeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates a theme alias for a theme.
     * </p>
     *
     * @param createThemeAliasRequest
     * @return A Java Future containing the result of the CreateThemeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.CreateThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<CreateThemeAliasResponse> createThemeAlias(CreateThemeAliasRequest createThemeAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThemeAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<CreateThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, CreateThemeAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<CreateThemeAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<CreateThemeAliasRequest, CreateThemeAliasResponse>()
                            .withOperationName("CreateThemeAlias")
                            .withMarshaller(new CreateThemeAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(createThemeAliasRequest));
            CompletableFuture<CreateThemeAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web
     * Services account and Amazon QuickSight namespace.
     * </p>
     *
     * @param deleteAccountCustomizationRequest
     * @return A Java Future containing the result of the DeleteAccountCustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountCustomizationResponse> deleteAccountCustomization(
            DeleteAccountCustomizationRequest deleteAccountCustomizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountCustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccountCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAccountCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountCustomizationRequest, DeleteAccountCustomizationResponse>()
                            .withOperationName("DeleteAccountCustomization")
                            .withMarshaller(new DeleteAccountCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAccountCustomizationRequest));
            CompletableFuture<DeleteAccountCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>DeleteAccountSubscription</code> operation to delete an Amazon QuickSight account. This operation
     * will result in an error message if you have configured your account termination protection settings to
     * <code>True</code>. To change this setting and delete your account, call the <code>UpdateAccountSettings</code>
     * API and set the value of the <code>TerminationProtectionEnabled</code> parameter to <code>False</code>, then make
     * another call to the <code>DeleteAccountSubscription</code> API.
     * </p>
     *
     * @param deleteAccountSubscriptionRequest
     * @return A Java Future containing the result of the DeleteAccountSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAccountSubscriptionResponse> deleteAccountSubscription(
            DeleteAccountSubscriptionRequest deleteAccountSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAccountSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAccountSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountSubscriptionRequest, DeleteAccountSubscriptionResponse>()
                            .withOperationName("DeleteAccountSubscription")
                            .withMarshaller(new DeleteAccountSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAccountSubscriptionRequest));
            CompletableFuture<DeleteAccountSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can
     * restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon
     * QuickSight attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery
     * window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the
     * <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API
     * until it's deleted, so you can describe it but you can't make a template from it.
     * </p>
     * <p>
     * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the
     * console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     * </p>
     *
     * @param deleteAnalysisRequest
     * @return A Java Future containing the result of the DeleteAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteAnalysisResponse> deleteAnalysis(DeleteAnalysisRequest deleteAnalysisRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteAnalysisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteAnalysisRequest, DeleteAnalysisResponse>()
                            .withOperationName("DeleteAnalysis")
                            .withMarshaller(new DeleteAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteAnalysisRequest));
            CompletableFuture<DeleteAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return A Java Future containing the result of the DeleteDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDashboardResponse> deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDashboardRequest, DeleteDashboardResponse>()
                            .withOperationName("DeleteDashboard")
                            .withMarshaller(new DeleteDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDashboardRequest));
            CompletableFuture<DeleteDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     *
     * @param deleteDataSetRequest
     * @return A Java Future containing the result of the DeleteDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataSetResponse> deleteDataSet(DeleteDataSetRequest deleteDataSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteDataSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDataSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSetRequest, DeleteDataSetResponse>()
                            .withOperationName("DeleteDataSet")
                            .withMarshaller(new DeleteDataSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDataSetRequest));
            CompletableFuture<DeleteDataSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data
     * source.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return A Java Future containing the result of the DeleteDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteDataSourceResponse> deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                            .withOperationName("DeleteDataSource")
                            .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteDataSourceRequest));
            CompletableFuture<DeleteDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an empty folder.
     * </p>
     *
     * @param deleteFolderRequest
     * @return A Java Future containing the result of the DeleteFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFolderResponse> deleteFolder(DeleteFolderRequest deleteFolderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFolderRequest, DeleteFolderResponse>()
                            .withOperationName("DeleteFolder").withMarshaller(new DeleteFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFolderRequest));
            CompletableFuture<DeleteFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
     * </p>
     *
     * @param deleteFolderMembershipRequest
     * @return A Java Future containing the result of the DeleteFolderMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteFolderMembershipResponse> deleteFolderMembership(
            DeleteFolderMembershipRequest deleteFolderMembershipRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolderMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteFolderMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteFolderMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteFolderMembershipRequest, DeleteFolderMembershipResponse>()
                            .withOperationName("DeleteFolderMembership")
                            .withMarshaller(new DeleteFolderMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteFolderMembershipRequest));
            CompletableFuture<DeleteFolderMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     *
     * @param deleteGroupRequest
     * @return A Java Future containing the result of the DeleteGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupResponse> deleteGroup(DeleteGroupRequest deleteGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                            .withOperationName("DeleteGroup").withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGroupRequest));
            CompletableFuture<DeleteGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return A Java Future containing the result of the DeleteGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteGroupMembershipResponse> deleteGroupMembership(
            DeleteGroupMembershipRequest deleteGroupMembershipRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroupMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteGroupMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteGroupMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteGroupMembershipRequest, DeleteGroupMembershipResponse>()
                            .withOperationName("DeleteGroupMembership")
                            .withMarshaller(new DeleteGroupMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteGroupMembershipRequest));
            CompletableFuture<DeleteGroupMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes an existing IAM policy assignment.
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the DeleteIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in a state that indicates an operation is happening
     *         that must complete before a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteIamPolicyAssignmentResponse> deleteIAMPolicyAssignment(
            DeleteIamPolicyAssignmentRequest deleteIamPolicyAssignmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIAMPolicyAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteIamPolicyAssignmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteIamPolicyAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteIamPolicyAssignmentRequest, DeleteIamPolicyAssignmentResponse>()
                            .withOperationName("DeleteIAMPolicyAssignment")
                            .withMarshaller(new DeleteIamPolicyAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteIamPolicyAssignmentRequest));
            CompletableFuture<DeleteIamPolicyAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous
     * process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these
     * assets, you use the API operations for the relevant asset.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return A Java Future containing the result of the DeleteNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteNamespaceResponse> deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                            .withOperationName("DeleteNamespace")
                            .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteNamespaceRequest));
            CompletableFuture<DeleteNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     *
     * @param deleteTemplateRequest
     * @return A Java Future containing the result of the DeleteTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTemplateResponse> deleteTemplate(DeleteTemplateRequest deleteTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTemplateRequest, DeleteTemplateResponse>()
                            .withOperationName("DeleteTemplate")
                            .withMarshaller(new DeleteTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTemplateRequest));
            CompletableFuture<DeleteTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the
     * version of the template that the alias points to.
     * </p>
     *
     * @param deleteTemplateAliasRequest
     * @return A Java Future containing the result of the DeleteTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteTemplateAliasResponse> deleteTemplateAlias(
            DeleteTemplateAliasRequest deleteTemplateAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteTemplateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteTemplateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteTemplateAliasRequest, DeleteTemplateAliasResponse>()
                            .withOperationName("DeleteTemplateAlias")
                            .withMarshaller(new DeleteTemplateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteTemplateAliasRequest));
            CompletableFuture<DeleteTemplateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a theme.
     * </p>
     *
     * @param deleteThemeRequest
     * @return A Java Future containing the result of the DeleteTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteThemeResponse> deleteTheme(DeleteThemeRequest deleteThemeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTheme");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteThemeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteThemeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThemeRequest, DeleteThemeResponse>()
                            .withOperationName("DeleteTheme").withMarshaller(new DeleteThemeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteThemeRequest));
            CompletableFuture<DeleteThemeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you
     * delete the version of the theme that the alias points to.
     * </p>
     *
     * @param deleteThemeAliasRequest
     * @return A Java Future containing the result of the DeleteThemeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteThemeAliasResponse> deleteThemeAlias(DeleteThemeAliasRequest deleteThemeAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThemeAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteThemeAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteThemeAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteThemeAliasRequest, DeleteThemeAliasResponse>()
                            .withOperationName("DeleteThemeAlias")
                            .withMarshaller(new DeleteThemeAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteThemeAliasRequest));
            CompletableFuture<DeleteThemeAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     *
     * @param deleteUserRequest
     * @return A Java Future containing the result of the DeleteUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserResponse> deleteUser(DeleteUserRequest deleteUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DeleteUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserRequest));
            CompletableFuture<DeleteUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     * @return A Java Future containing the result of the DeleteUserByPrincipalId operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DeleteUserByPrincipalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DeleteUserByPrincipalIdResponse> deleteUserByPrincipalId(
            DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserByPrincipalIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserByPrincipalId");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DeleteUserByPrincipalIdResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DeleteUserByPrincipalIdResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DeleteUserByPrincipalIdResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DeleteUserByPrincipalIdRequest, DeleteUserByPrincipalIdResponse>()
                            .withOperationName("DeleteUserByPrincipalId")
                            .withMarshaller(new DeleteUserByPrincipalIdRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(deleteUserByPrincipalIdRequest));
            CompletableFuture<DeleteUserByPrincipalIdResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon
     * QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which
     * customizations to apply by running this API operation with the <code>Resolved</code> flag included.
     * </p>
     * <p>
     * To determine what customizations display when you run this command, it can help to visualize the relationship of
     * the entities involved.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy. It
     * has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you
     * subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's
     * where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon Web Services Region</code> - In each Amazon Web Services Region where you sign in to Amazon
     * QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user
     * directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have
     * access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace.
     * </p>
     * <p>
     * To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using
     * the CLI, you can use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line
     * options</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>aws configure</code> to change your default Amazon Web Services Region. Use Enter to key the same
     * settings for your keys. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the CLI</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code> - A QuickSight namespace is a partition that contains users and assets (data sources,
     * datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also
     * be part of the same namespace. People who share a namespace are completely isolated from users and assets in
     * other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Applied customizations</code> - Within an Amazon Web Services Region, a set of Amazon QuickSight
     * customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a
     * namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a
     * single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the
     * <code>CreateAccountCustomization</code> command in each Amazon Web Services Region where you want to apply the
     * same customizations.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountCustomizationRequest
     * @return A Java Future containing the result of the DescribeAccountCustomization operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountCustomizationResponse> describeAccountCustomization(
            DescribeAccountCustomizationRequest describeAccountCustomizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountCustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountCustomizationRequest, DescribeAccountCustomizationResponse>()
                            .withOperationName("DescribeAccountCustomization")
                            .withMarshaller(new DescribeAccountCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAccountCustomizationRequest));
            CompletableFuture<DescribeAccountCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon
     * Web Services account.
     * </p>
     *
     * @param describeAccountSettingsRequest
     * @return A Java Future containing the result of the DescribeAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountSettingsResponse> describeAccountSettings(
            DescribeAccountSettingsRequest describeAccountSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSettingsRequest, DescribeAccountSettingsResponse>()
                            .withOperationName("DescribeAccountSettings")
                            .withMarshaller(new DescribeAccountSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAccountSettingsRequest));
            CompletableFuture<DescribeAccountSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the DescribeAccountSubscription operation to receive a description of an Amazon QuickSight account's
     * subscription. A successful API call returns an <code>AccountInfo</code> object that includes an account's name,
     * subscription status, authentication type, edition, and notification email address.
     * </p>
     *
     * @param describeAccountSubscriptionRequest
     * @return A Java Future containing the result of the DescribeAccountSubscription operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAccountSubscriptionResponse> describeAccountSubscription(
            DescribeAccountSubscriptionRequest describeAccountSubscriptionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSubscription");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAccountSubscriptionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAccountSubscriptionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSubscriptionRequest, DescribeAccountSubscriptionResponse>()
                            .withOperationName("DescribeAccountSubscription")
                            .withMarshaller(new DescribeAccountSubscriptionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAccountSubscriptionRequest));
            CompletableFuture<DescribeAccountSubscriptionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a summary of the metadata for an analysis.
     * </p>
     *
     * @param describeAnalysisRequest
     * @return A Java Future containing the result of the DescribeAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAnalysisResponse> describeAnalysis(DescribeAnalysisRequest describeAnalysisRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAnalysisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisRequest, DescribeAnalysisResponse>()
                            .withOperationName("DescribeAnalysis")
                            .withMarshaller(new DescribeAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAnalysisRequest));
            CompletableFuture<DescribeAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides the read and write permissions for an analysis.
     * </p>
     *
     * @param describeAnalysisPermissionsRequest
     * @return A Java Future containing the result of the DescribeAnalysisPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeAnalysisPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeAnalysisPermissionsResponse> describeAnalysisPermissions(
            DescribeAnalysisPermissionsRequest describeAnalysisPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysisPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeAnalysisPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeAnalysisPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeAnalysisPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisPermissionsRequest, DescribeAnalysisPermissionsResponse>()
                            .withOperationName("DescribeAnalysisPermissions")
                            .withMarshaller(new DescribeAnalysisPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeAnalysisPermissionsRequest));
            CompletableFuture<DescribeAnalysisPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return A Java Future containing the result of the DescribeDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardResponse> describeDashboard(DescribeDashboardRequest describeDashboardRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardRequest, DescribeDashboardResponse>()
                            .withOperationName("DescribeDashboard")
                            .withMarshaller(new DescribeDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDashboardRequest));
            CompletableFuture<DescribeDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes read and write permissions for a dashboard.
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     * @return A Java Future containing the result of the DescribeDashboardPermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDashboardPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDashboardPermissionsResponse> describeDashboardPermissions(
            DescribeDashboardPermissionsRequest describeDashboardPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDashboardPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDashboardPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDashboardPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardPermissionsRequest, DescribeDashboardPermissionsResponse>()
                            .withOperationName("DescribeDashboardPermissions")
                            .withMarshaller(new DescribeDashboardPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDashboardPermissionsRequest));
            CompletableFuture<DescribeDashboardPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param describeDataSetRequest
     * @return A Java Future containing the result of the DescribeDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSetResponse> describeDataSet(DescribeDataSetRequest describeDataSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSetResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDataSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetRequest, DescribeDataSetResponse>()
                            .withOperationName("DescribeDataSet")
                            .withMarshaller(new DescribeDataSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDataSetRequest));
            CompletableFuture<DescribeDataSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     * @return A Java Future containing the result of the DescribeDataSetPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSetPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSetPermissionsResponse> describeDataSetPermissions(
            DescribeDataSetPermissionsRequest describeDataSetPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSetPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSetPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSetPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDataSetPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetPermissionsRequest, DescribeDataSetPermissionsResponse>()
                            .withOperationName("DescribeDataSetPermissions")
                            .withMarshaller(new DescribeDataSetPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDataSetPermissionsRequest));
            CompletableFuture<DescribeDataSetPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return A Java Future containing the result of the DescribeDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSourceResponse> describeDataSource(DescribeDataSourceRequest describeDataSourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSourceRequest, DescribeDataSourceResponse>()
                            .withOperationName("DescribeDataSource")
                            .withMarshaller(new DescribeDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDataSourceRequest));
            CompletableFuture<DescribeDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     * @return A Java Future containing the result of the DescribeDataSourcePermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeDataSourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeDataSourcePermissionsResponse> describeDataSourcePermissions(
            DescribeDataSourcePermissionsRequest describeDataSourcePermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataSourcePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSourcePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeDataSourcePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeDataSourcePermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeDataSourcePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSourcePermissionsRequest, DescribeDataSourcePermissionsResponse>()
                            .withOperationName("DescribeDataSourcePermissions")
                            .withMarshaller(new DescribeDataSourcePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeDataSourcePermissionsRequest));
            CompletableFuture<DescribeDataSourcePermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a folder.
     * </p>
     *
     * @param describeFolderRequest
     * @return A Java Future containing the result of the DescribeFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFolderResponse> describeFolder(DescribeFolderRequest describeFolderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFolderResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFolderRequest, DescribeFolderResponse>()
                            .withOperationName("DescribeFolder")
                            .withMarshaller(new DescribeFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFolderRequest));
            CompletableFuture<DescribeFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes permissions for a folder.
     * </p>
     *
     * @param describeFolderPermissionsRequest
     * @return A Java Future containing the result of the DescribeFolderPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeFolderPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFolderPermissionsResponse> describeFolderPermissions(
            DescribeFolderPermissionsRequest describeFolderPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFolderPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFolderPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFolderPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeFolderPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFolderPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFolderPermissionsRequest, DescribeFolderPermissionsResponse>()
                            .withOperationName("DescribeFolderPermissions")
                            .withMarshaller(new DescribeFolderPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFolderPermissionsRequest));
            CompletableFuture<DescribeFolderPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the
     * inherited permissions from the ancestor folders.
     * </p>
     *
     * @param describeFolderResolvedPermissionsRequest
     * @return A Java Future containing the result of the DescribeFolderResolvedPermissions operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeFolderResolvedPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeFolderResolvedPermissionsResponse> describeFolderResolvedPermissions(
            DescribeFolderResolvedPermissionsRequest describeFolderResolvedPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFolderResolvedPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFolderResolvedPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeFolderResolvedPermissionsResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, DescribeFolderResolvedPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeFolderResolvedPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeFolderResolvedPermissionsRequest, DescribeFolderResolvedPermissionsResponse>()
                            .withOperationName("DescribeFolderResolvedPermissions")
                            .withMarshaller(new DescribeFolderResolvedPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeFolderResolvedPermissionsRequest));
            CompletableFuture<DescribeFolderResolvedPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeGroupRequest
     * @return A Java Future containing the result of the DescribeGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGroupResponse> describeGroup(DescribeGroupRequest describeGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGroupRequest, DescribeGroupResponse>()
                            .withOperationName("DescribeGroup")
                            .withMarshaller(new DescribeGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeGroupRequest));
            CompletableFuture<DescribeGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>DescribeGroupMembership</code> operation to determine if a user is a member of the specified group.
     * If the user exists and is a member of the specified group, an associated <code>GroupMember</code> object is
     * returned.
     * </p>
     *
     * @param describeGroupMembershipRequest
     * @return A Java Future containing the result of the DescribeGroupMembership operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeGroupMembershipResponse> describeGroupMembership(
            DescribeGroupMembershipRequest describeGroupMembershipRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGroupMembership");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeGroupMembershipResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeGroupMembershipResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeGroupMembershipRequest, DescribeGroupMembershipResponse>()
                            .withOperationName("DescribeGroupMembership")
                            .withMarshaller(new DescribeGroupMembershipRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeGroupMembershipRequest));
            CompletableFuture<DescribeGroupMembershipResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes an existing IAM policy assignment, as specified by the assignment name.
     * </p>
     *
     * @param describeIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the DescribeIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIamPolicyAssignmentResponse> describeIAMPolicyAssignment(
            DescribeIamPolicyAssignmentRequest describeIamPolicyAssignmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIAMPolicyAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeIamPolicyAssignmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIamPolicyAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIamPolicyAssignmentRequest, DescribeIamPolicyAssignmentResponse>()
                            .withOperationName("DescribeIAMPolicyAssignment")
                            .withMarshaller(new DescribeIamPolicyAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeIamPolicyAssignmentRequest));
            CompletableFuture<DescribeIamPolicyAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a SPICE ingestion.
     * </p>
     *
     * @param describeIngestionRequest
     * @return A Java Future containing the result of the DescribeIngestion operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIngestionResponse> describeIngestion(DescribeIngestionRequest describeIngestionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIngestion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIngestionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeIngestionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIngestionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIngestionRequest, DescribeIngestionResponse>()
                            .withOperationName("DescribeIngestion")
                            .withMarshaller(new DescribeIngestionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeIngestionRequest));
            CompletableFuture<DescribeIngestionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Provides a summary and status of IP rules.
     * </p>
     *
     * @param describeIpRestrictionRequest
     * @return A Java Future containing the result of the DescribeIpRestriction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeIpRestriction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeIpRestrictionResponse> describeIpRestriction(
            DescribeIpRestrictionRequest describeIpRestrictionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIpRestrictionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIpRestriction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeIpRestrictionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeIpRestrictionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeIpRestrictionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeIpRestrictionRequest, DescribeIpRestrictionResponse>()
                            .withOperationName("DescribeIpRestriction")
                            .withMarshaller(new DescribeIpRestrictionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeIpRestrictionRequest));
            CompletableFuture<DescribeIpRestrictionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the current namespace.
     * </p>
     *
     * @param describeNamespaceRequest
     * @return A Java Future containing the result of the DescribeNamespace operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeNamespaceResponse> describeNamespace(DescribeNamespaceRequest describeNamespaceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNamespace");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeNamespaceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeNamespaceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeNamespaceRequest, DescribeNamespaceResponse>()
                            .withOperationName("DescribeNamespace")
                            .withMarshaller(new DescribeNamespaceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeNamespaceRequest));
            CompletableFuture<DescribeNamespaceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a template's metadata.
     * </p>
     *
     * @param describeTemplateRequest
     * @return A Java Future containing the result of the DescribeTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTemplateResponse> describeTemplate(DescribeTemplateRequest describeTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTemplateRequest, DescribeTemplateResponse>()
                            .withOperationName("DescribeTemplate")
                            .withMarshaller(new DescribeTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTemplateRequest));
            CompletableFuture<DescribeTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the template alias for a template.
     * </p>
     *
     * @param describeTemplateAliasRequest
     * @return A Java Future containing the result of the DescribeTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTemplateAliasResponse> describeTemplateAlias(
            DescribeTemplateAliasRequest describeTemplateAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTemplateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTemplateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTemplateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTemplateAliasRequest, DescribeTemplateAliasResponse>()
                            .withOperationName("DescribeTemplateAlias")
                            .withMarshaller(new DescribeTemplateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTemplateAliasRequest));
            CompletableFuture<DescribeTemplateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes read and write permissions on a template.
     * </p>
     *
     * @param describeTemplatePermissionsRequest
     * @return A Java Future containing the result of the DescribeTemplatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTemplatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeTemplatePermissionsResponse> describeTemplatePermissions(
            DescribeTemplatePermissionsRequest describeTemplatePermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTemplatePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTemplatePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeTemplatePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeTemplatePermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeTemplatePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeTemplatePermissionsRequest, DescribeTemplatePermissionsResponse>()
                            .withOperationName("DescribeTemplatePermissions")
                            .withMarshaller(new DescribeTemplatePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeTemplatePermissionsRequest));
            CompletableFuture<DescribeTemplatePermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes a theme.
     * </p>
     *
     * @param describeThemeRequest
     * @return A Java Future containing the result of the DescribeTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeThemeResponse> describeTheme(DescribeThemeRequest describeThemeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTheme");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeThemeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThemeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThemeRequest, DescribeThemeResponse>()
                            .withOperationName("DescribeTheme")
                            .withMarshaller(new DescribeThemeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeThemeRequest));
            CompletableFuture<DescribeThemeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the alias for a theme.
     * </p>
     *
     * @param describeThemeAliasRequest
     * @return A Java Future containing the result of the DescribeThemeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeThemeAliasResponse> describeThemeAlias(DescribeThemeAliasRequest describeThemeAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThemeAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeThemeAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThemeAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThemeAliasRequest, DescribeThemeAliasResponse>()
                            .withOperationName("DescribeThemeAlias")
                            .withMarshaller(new DescribeThemeAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeThemeAliasRequest));
            CompletableFuture<DescribeThemeAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Describes the read and write permissions for a theme.
     * </p>
     *
     * @param describeThemePermissionsRequest
     * @return A Java Future containing the result of the DescribeThemePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeThemePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeThemePermissionsResponse> describeThemePermissions(
            DescribeThemePermissionsRequest describeThemePermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThemePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThemePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeThemePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, DescribeThemePermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeThemePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeThemePermissionsRequest, DescribeThemePermissionsResponse>()
                            .withOperationName("DescribeThemePermissions")
                            .withMarshaller(new DescribeThemePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeThemePermissionsRequest));
            CompletableFuture<DescribeThemePermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     *
     * @param describeUserRequest
     * @return A Java Future containing the result of the DescribeUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<DescribeUserResponse> describeUser(DescribeUserRequest describeUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<DescribeUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    DescribeUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<DescribeUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<DescribeUserRequest, DescribeUserResponse>()
                            .withOperationName("DescribeUser").withMarshaller(new DescribeUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(describeUserRequest));
            CompletableFuture<DescribeUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website,
     * without having to register any reader users. Before you use this action, make sure that you have configured the
     * dashboards and permissions.
     * </p>
     * <p>
     * The following rules apply to the generated URL:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this
     * period, it cannot be re-used again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The URL validity period should not be confused with the actual session lifetime that can be customized using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code>
     * parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default
     * session duration is 10 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the
     * <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
     * customize embedding, visit the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer
     * Portal</a>.
     * </p>
     *
     * @param generateEmbedUrlForAnonymousUserRequest
     * @return A Java Future containing the result of the GenerateEmbedUrlForAnonymousUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session isn't valid. The session lifetime must be 15-600 minutes.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>UnsupportedPricingPlanException This error indicates that you are calling an embedding operation in
     *         Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can
     *         use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon
     *         QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GenerateEmbedUrlForAnonymousUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GenerateEmbedUrlForAnonymousUserResponse> generateEmbedUrlForAnonymousUser(
            GenerateEmbedUrlForAnonymousUserRequest generateEmbedUrlForAnonymousUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateEmbedUrlForAnonymousUserRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateEmbedUrlForAnonymousUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GenerateEmbedUrlForAnonymousUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GenerateEmbedUrlForAnonymousUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GenerateEmbedUrlForAnonymousUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GenerateEmbedUrlForAnonymousUserRequest, GenerateEmbedUrlForAnonymousUserResponse>()
                            .withOperationName("GenerateEmbedUrlForAnonymousUser")
                            .withMarshaller(new GenerateEmbedUrlForAnonymousUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(generateEmbedUrlForAnonymousUserRequest));
            CompletableFuture<GenerateEmbedUrlForAnonymousUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can
     * be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure
     * that you have configured the relevant Amazon QuickSight resource and permissions.
     * </p>
     * <p>
     * The following rules apply to the generated URL:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this
     * period, it cannot be re-used again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The URL validity period should not be confused with the actual session lifetime that can be customized using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code>
     * parameter.
     * </p>
     * <p>
     * The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration
     * is 10 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the
     * <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
     * customize embedding, visit the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer
     * Portal</a>.
     * </p>
     *
     * @param generateEmbedUrlForRegisteredUserRequest
     * @return A Java Future containing the result of the GenerateEmbedUrlForRegisteredUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>QuickSightUserNotFoundException The user with the provided name isn't found. This error can happen in
     *         any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session isn't valid. The session lifetime must be 15-600 minutes.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>UnsupportedPricingPlanException This error indicates that you are calling an embedding operation in
     *         Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can
     *         use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon
     *         QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GenerateEmbedUrlForRegisteredUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GenerateEmbedUrlForRegisteredUserResponse> generateEmbedUrlForRegisteredUser(
            GenerateEmbedUrlForRegisteredUserRequest generateEmbedUrlForRegisteredUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateEmbedUrlForRegisteredUserRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateEmbedUrlForRegisteredUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GenerateEmbedUrlForRegisteredUserResponse> responseHandler = protocolFactory
                    .createResponseHandler(operationMetadata, GenerateEmbedUrlForRegisteredUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GenerateEmbedUrlForRegisteredUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GenerateEmbedUrlForRegisteredUserRequest, GenerateEmbedUrlForRegisteredUserResponse>()
                            .withOperationName("GenerateEmbedUrlForRegisteredUser")
                            .withMarshaller(new GenerateEmbedUrlForRegisteredUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(generateEmbedUrlForRegisteredUserRequest));
            CompletableFuture<GenerateEmbedUrlForRegisteredUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon
     * QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you
     * have configured the dashboards and permissions.
     * </p>
     * <p>
     * Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user's browser. The
     * following rules apply to the generated URL:
     * </p>
     * <ul>
     * <li>
     * <p>
     * They must be used together.
     * </p>
     * </li>
     * <li>
     * <p>
     * They can be used one time only.
     * </p>
     * </li>
     * <li>
     * <p>
     * They are valid for 5 minutes after you run this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional
     * <code>SessionLifetimeInMinutes</code> parameter to customize session duration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html">Embedding Analytics
     * Using GetDashboardEmbedUrl</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
     * customize embedding, visit the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer
     * Portal</a>.
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     * @return A Java Future containing the result of the GetDashboardEmbedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>DomainNotWhitelistedException The domain specified isn't on the allow list. All domains for embedded
     *         dashboards must be added to the approved list by an Amazon QuickSight admin.</li>
     *         <li>QuickSightUserNotFoundException The user with the provided name isn't found. This error can happen in
     *         any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</li>
     *         <li>IdentityTypeNotSupportedException The identity type specified isn't supported. Supported identity
     *         types include <code>IAM</code> and <code>QUICKSIGHT</code>.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session isn't valid. The session lifetime must be 15-600 minutes.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>UnsupportedPricingPlanException This error indicates that you are calling an embedding operation in
     *         Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can
     *         use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon
     *         QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GetDashboardEmbedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<GetDashboardEmbedUrlResponse> getDashboardEmbedUrl(
            GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDashboardEmbedUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDashboardEmbedUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetDashboardEmbedUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetDashboardEmbedUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetDashboardEmbedUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetDashboardEmbedUrlRequest, GetDashboardEmbedUrlResponse>()
                            .withOperationName("GetDashboardEmbedUrl")
                            .withMarshaller(new GetDashboardEmbedUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getDashboardEmbedUrlRequest));
            CompletableFuture<GetDashboardEmbedUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in
     * your web server code. Use <code>GetSessionEmbedUrl</code> where you want to provide an authoring portal that
     * allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon
     * QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to
     * some of these features, add a custom permissions profile to the user with the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
     * API operation. Use
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code>
     * API operation to add a new user with a custom permission profile attached. For more information, see the
     * following sections in the <i>Amazon QuickSight User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedding Analytics</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     * >Customizing Access to the Amazon QuickSight Console</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getSessionEmbedUrlRequest
     * @return A Java Future containing the result of the GetSessionEmbedUrl operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>QuickSightUserNotFoundException The user with the provided name isn't found. This error can happen in
     *         any operation that requires finding a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so on.</li>
     *         <li>SessionLifetimeInMinutesInvalidException The number of minutes specified for the lifetime of a
     *         session isn't valid. The session lifetime must be 15-600 minutes.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.GetSessionEmbedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<GetSessionEmbedUrlResponse> getSessionEmbedUrl(GetSessionEmbedUrlRequest getSessionEmbedUrlRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionEmbedUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionEmbedUrl");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<GetSessionEmbedUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, GetSessionEmbedUrlResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<GetSessionEmbedUrlResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<GetSessionEmbedUrlRequest, GetSessionEmbedUrlResponse>()
                            .withOperationName("GetSessionEmbedUrl")
                            .withMarshaller(new GetSessionEmbedUrlRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(getSessionEmbedUrlRequest));
            CompletableFuture<GetSessionEmbedUrlResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
     * </p>
     *
     * @param listAnalysesRequest
     * @return A Java Future containing the result of the ListAnalyses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListAnalysesResponse> listAnalyses(ListAnalysesRequest listAnalysesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnalysesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnalyses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListAnalysesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListAnalysesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListAnalysesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListAnalysesRequest, ListAnalysesResponse>()
                            .withOperationName("ListAnalyses").withMarshaller(new ListAnalysesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listAnalysesRequest));
            CompletableFuture<ListAnalysesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesPublisher publisher = client.listAnalysesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesPublisher publisher = client.listAnalysesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)} operation.</b>
     * </p>
     *
     * @param listAnalysesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    public ListAnalysesPublisher listAnalysesPaginator(ListAnalysesRequest listAnalysesRequest) {
        return new ListAnalysesPublisher(this, applyPaginatorUserAgent(listAnalysesRequest));
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return A Java Future containing the result of the ListDashboardVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboardVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDashboardVersionsResponse> listDashboardVersions(
            ListDashboardVersionsRequest listDashboardVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDashboardVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDashboardVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDashboardVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDashboardVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDashboardVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDashboardVersionsRequest, ListDashboardVersionsResponse>()
                            .withOperationName("ListDashboardVersions")
                            .withMarshaller(new ListDashboardVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDashboardVersionsRequest));
            CompletableFuture<ListDashboardVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher publisher = client.listDashboardVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsPublisher publisher = client.listDashboardVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboardVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListDashboardVersionsPublisher listDashboardVersionsPaginator(ListDashboardVersionsRequest listDashboardVersionsRequest) {
        return new ListDashboardVersionsPublisher(this, applyPaginatorUserAgent(listDashboardVersionsRequest));
    }

    /**
     * <p>
     * Lists dashboards in an Amazon Web Services account.
     * </p>
     *
     * @param listDashboardsRequest
     * @return A Java Future containing the result of the ListDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDashboardsResponse> listDashboards(ListDashboardsRequest listDashboardsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDashboardsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDashboards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDashboardsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDashboardsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDashboardsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDashboardsRequest, ListDashboardsResponse>()
                            .withOperationName("ListDashboards")
                            .withMarshaller(new ListDashboardsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDashboardsRequest));
            CompletableFuture<ListDashboardsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists dashboards in an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsPublisher publisher = client.listDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation.</b>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDashboardsPublisher listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest) {
        return new ListDashboardsPublisher(this, applyPaginatorUserAgent(listDashboardsRequest));
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     *
     * @param listDataSetsRequest
     * @return A Java Future containing the result of the ListDataSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataSetsResponse> listDataSets(ListDataSetsRequest listDataSetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListDataSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataSetsRequest, ListDataSetsResponse>()
                            .withOperationName("ListDataSets").withMarshaller(new ListDataSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDataSetsRequest));
            CompletableFuture<ListDataSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsPublisher publisher = client.listDataSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param listDataSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    public ListDataSetsPublisher listDataSetsPaginator(ListDataSetsRequest listDataSetsRequest) {
        return new ListDataSetsPublisher(this, applyPaginatorUserAgent(listDataSetsRequest));
    }

    /**
     * <p>
     * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A Java Future containing the result of the ListDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListDataSourcesResponse> listDataSources(ListDataSourcesRequest listDataSourcesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListDataSourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListDataSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListDataSourcesRequest, ListDataSourcesResponse>()
                            .withOperationName("ListDataSources")
                            .withMarshaller(new ListDataSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listDataSourcesRequest));
            CompletableFuture<ListDataSourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesPublisher publisher = client.listDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    public ListDataSourcesPublisher listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest) {
        return new ListDataSourcesPublisher(this, applyPaginatorUserAgent(listDataSourcesRequest));
    }

    /**
     * <p>
     * List all assets (<code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>) in a folder.
     * </p>
     *
     * @param listFolderMembersRequest
     * @return A Java Future containing the result of the ListFolderMembers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListFolderMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListFolderMembersResponse> listFolderMembers(ListFolderMembersRequest listFolderMembersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFolderMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFolderMembers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFolderMembersResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListFolderMembersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFolderMembersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFolderMembersRequest, ListFolderMembersResponse>()
                            .withOperationName("ListFolderMembers")
                            .withMarshaller(new ListFolderMembersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFolderMembersRequest));
            CompletableFuture<ListFolderMembersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all folders in an account.
     * </p>
     *
     * @param listFoldersRequest
     * @return A Java Future containing the result of the ListFolders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListFoldersResponse> listFolders(ListFoldersRequest listFoldersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFoldersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFolders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListFoldersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListFoldersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListFoldersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListFoldersRequest, ListFoldersResponse>()
                            .withOperationName("ListFolders").withMarshaller(new ListFoldersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listFoldersRequest));
            CompletableFuture<ListFoldersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return A Java Future containing the result of the ListGroupMemberships operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroupMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupMembershipsResponse> listGroupMemberships(
            ListGroupMembershipsRequest listGroupMembershipsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupMembershipsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupMemberships");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupMembershipsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListGroupMembershipsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupMembershipsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupMembershipsRequest, ListGroupMembershipsResponse>()
                            .withOperationName("ListGroupMemberships")
                            .withMarshaller(new ListGroupMembershipsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGroupMembershipsRequest));
            CompletableFuture<ListGroupMembershipsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     *
     * @param listGroupsRequest
     * @return A Java Future containing the result of the ListGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListGroupsResponse> listGroups(ListGroupsRequest listGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listGroupsRequest));
            CompletableFuture<ListGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists IAM policy assignments in the current Amazon QuickSight account.
     * </p>
     *
     * @param listIamPolicyAssignmentsRequest
     * @return A Java Future containing the result of the ListIAMPolicyAssignments operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIAMPolicyAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIamPolicyAssignmentsResponse> listIAMPolicyAssignments(
            ListIamPolicyAssignmentsRequest listIamPolicyAssignmentsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIamPolicyAssignmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIAMPolicyAssignments");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIamPolicyAssignmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIamPolicyAssignmentsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIamPolicyAssignmentsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIamPolicyAssignmentsRequest, ListIamPolicyAssignmentsResponse>()
                            .withOperationName("ListIAMPolicyAssignments")
                            .withMarshaller(new ListIamPolicyAssignmentsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIamPolicyAssignmentsRequest));
            CompletableFuture<ListIamPolicyAssignmentsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to
     * the specified user and group or groups that the user belongs to.
     * </p>
     *
     * @param listIamPolicyAssignmentsForUserRequest
     * @return A Java Future containing the result of the ListIAMPolicyAssignmentsForUser operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in a state that indicates an operation is happening
     *         that must complete before a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIAMPolicyAssignmentsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListIamPolicyAssignmentsForUserResponse> listIAMPolicyAssignmentsForUser(
            ListIamPolicyAssignmentsForUserRequest listIamPolicyAssignmentsForUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listIamPolicyAssignmentsForUserRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIAMPolicyAssignmentsForUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIamPolicyAssignmentsForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIamPolicyAssignmentsForUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIamPolicyAssignmentsForUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIamPolicyAssignmentsForUserRequest, ListIamPolicyAssignmentsForUserResponse>()
                            .withOperationName("ListIAMPolicyAssignmentsForUser")
                            .withMarshaller(new ListIamPolicyAssignmentsForUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIamPolicyAssignmentsForUserRequest));
            CompletableFuture<ListIamPolicyAssignmentsForUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     *
     * @param listIngestionsRequest
     * @return A Java Future containing the result of the ListIngestions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListIngestionsResponse> listIngestions(ListIngestionsRequest listIngestionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIngestionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIngestions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListIngestionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListIngestionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListIngestionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListIngestionsRequest, ListIngestionsResponse>()
                            .withOperationName("ListIngestions")
                            .withMarshaller(new ListIngestionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listIngestionsRequest));
            CompletableFuture<ListIngestionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsPublisher publisher = client.listIngestionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation.</b>
     * </p>
     *
     * @param listIngestionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    public ListIngestionsPublisher listIngestionsPaginator(ListIngestionsRequest listIngestionsRequest) {
        return new ListIngestionsPublisher(this, applyPaginatorUserAgent(listIngestionsRequest));
    }

    /**
     * <p>
     * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted
     * namespaces.
     * </p>
     *
     * @param listNamespacesRequest
     * @return A Java Future containing the result of the ListNamespaces operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListNamespacesResponse> listNamespaces(ListNamespacesRequest listNamespacesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNamespacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamespaces");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListNamespacesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListNamespacesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListNamespacesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListNamespacesRequest, ListNamespacesResponse>()
                            .withOperationName("ListNamespaces")
                            .withMarshaller(new ListNamespacesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listNamespacesRequest));
            CompletableFuture<ListNamespacesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted
     * namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesPublisher publisher = client.listNamespacesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    public ListNamespacesPublisher listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest) {
        return new ListNamespacesPublisher(this, applyPaginatorUserAgent(listNamespacesRequest));
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTagsForResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTagsForResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                            .withOperationName("ListTagsForResource")
                            .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTagsForResourceRequest));
            CompletableFuture<ListTagsForResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return A Java Future containing the result of the ListTemplateAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTemplateAliasesResponse> listTemplateAliases(
            ListTemplateAliasesRequest listTemplateAliasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTemplateAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTemplateAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTemplateAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTemplateAliasesRequest, ListTemplateAliasesResponse>()
                            .withOperationName("ListTemplateAliases")
                            .withMarshaller(new ListTemplateAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTemplateAliasesRequest));
            CompletableFuture<ListTemplateAliasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher publisher = client.listTemplateAliasesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesPublisher publisher = client.listTemplateAliasesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTemplateAliasesPublisher listTemplateAliasesPaginator(ListTemplateAliasesRequest listTemplateAliasesRequest) {
        return new ListTemplateAliasesPublisher(this, applyPaginatorUserAgent(listTemplateAliasesRequest));
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A Java Future containing the result of the ListTemplateVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<ListTemplateVersionsResponse> listTemplateVersions(
            ListTemplateVersionsRequest listTemplateVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTemplateVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListTemplateVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTemplateVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTemplateVersionsRequest, ListTemplateVersionsResponse>()
                            .withOperationName("ListTemplateVersions")
                            .withMarshaller(new ListTemplateVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTemplateVersionsRequest));
            CompletableFuture<ListTemplateVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher publisher = client.listTemplateVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsPublisher publisher = client.listTemplateVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    public ListTemplateVersionsPublisher listTemplateVersionsPaginator(ListTemplateVersionsRequest listTemplateVersionsRequest) {
        return new ListTemplateVersionsPublisher(this, applyPaginatorUserAgent(listTemplateVersionsRequest));
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     *
     * @param listTemplatesRequest
     * @return A Java Future containing the result of the ListTemplates operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListTemplatesResponse> listTemplates(ListTemplatesRequest listTemplatesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplates");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListTemplatesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListTemplatesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListTemplatesRequest, ListTemplatesResponse>()
                            .withOperationName("ListTemplates")
                            .withMarshaller(new ListTemplatesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listTemplatesRequest));
            CompletableFuture<ListTemplatesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesPublisher publisher = client.listTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    public ListTemplatesPublisher listTemplatesPaginator(ListTemplatesRequest listTemplatesRequest) {
        return new ListTemplatesPublisher(this, applyPaginatorUserAgent(listTemplatesRequest));
    }

    /**
     * <p>
     * Lists all the aliases of a theme.
     * </p>
     *
     * @param listThemeAliasesRequest
     * @return A Java Future containing the result of the ListThemeAliases operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListThemeAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListThemeAliasesResponse> listThemeAliases(ListThemeAliasesRequest listThemeAliasesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThemeAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThemeAliases");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThemeAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThemeAliasesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThemeAliasesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThemeAliasesRequest, ListThemeAliasesResponse>()
                            .withOperationName("ListThemeAliases")
                            .withMarshaller(new ListThemeAliasesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listThemeAliasesRequest));
            CompletableFuture<ListThemeAliasesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the versions of the themes in the current Amazon Web Services account.
     * </p>
     *
     * @param listThemeVersionsRequest
     * @return A Java Future containing the result of the ListThemeVersions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListThemeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<ListThemeVersionsResponse> listThemeVersions(ListThemeVersionsRequest listThemeVersionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThemeVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThemeVersions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThemeVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListThemeVersionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThemeVersionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThemeVersionsRequest, ListThemeVersionsResponse>()
                            .withOperationName("ListThemeVersions")
                            .withMarshaller(new ListThemeVersionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listThemeVersionsRequest));
            CompletableFuture<ListThemeVersionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the versions of the themes in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemeVersions(software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemeVersionsPublisher publisher = client.listThemeVersionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemeVersionsPublisher publisher = client.listThemeVersionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemeVersions(software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listThemeVersionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListThemeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    public ListThemeVersionsPublisher listThemeVersionsPaginator(ListThemeVersionsRequest listThemeVersionsRequest) {
        return new ListThemeVersionsPublisher(this, applyPaginatorUserAgent(listThemeVersionsRequest));
    }

    /**
     * <p>
     * Lists all the themes in the current Amazon Web Services account.
     * </p>
     *
     * @param listThemesRequest
     * @return A Java Future containing the result of the ListThemes operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListThemesResponse> listThemes(ListThemesRequest listThemesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThemesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThemes");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListThemesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListThemesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListThemesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListThemesRequest, ListThemesResponse>().withOperationName("ListThemes")
                            .withMarshaller(new ListThemesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listThemesRequest));
            CompletableFuture<ListThemesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Lists all the themes in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listThemes(software.amazon.awssdk.services.quicksight.model.ListThemesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemesPublisher publisher = client.listThemesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemesPublisher publisher = client.listThemesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.ListThemesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.ListThemesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.quicksight.model.ListThemesRequest)} operation.</b>
     * </p>
     *
     * @param listThemesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes" target="_top">AWS API
     *      Documentation</a>
     */
    public ListThemesPublisher listThemesPaginator(ListThemesRequest listThemesRequest) {
        return new ListThemesPublisher(this, applyPaginatorUserAgent(listThemesRequest));
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     * </p>
     *
     * @param listUserGroupsRequest
     * @return A Java Future containing the result of the ListUserGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUserGroupsResponse> listUserGroups(ListUserGroupsRequest listUserGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUserGroupsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, ListUserGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUserGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUserGroupsRequest, ListUserGroupsResponse>()
                            .withOperationName("ListUserGroups")
                            .withMarshaller(new ListUserGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(listUserGroupsRequest));
            CompletableFuture<ListUserGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     *
     * @param listUsersRequest
     * @return A Java Future containing the result of the ListUsers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<ListUsersResponse> listUsers(ListUsersRequest listUsersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    ListUsersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<ListUsersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>().withOperationName("ListUsers")
                            .withMarshaller(new ListUsersRequestMarshaller(protocolFactory)).withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withMetricCollector(apiCallMetricCollector)
                            .withInput(listUsersRequest));
            CompletableFuture<ListUsersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user, whose identity is associated with the Identity and Access Management (IAM)
     * identity or role specified in the request.
     * </p>
     *
     * @param registerUserRequest
     * @return A Java Future containing the result of the RegisterUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.RegisterUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<RegisterUserResponse> registerUser(RegisterUserRequest registerUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RegisterUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    RegisterUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RegisterUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RegisterUserRequest, RegisterUserResponse>()
                            .withOperationName("RegisterUser").withMarshaller(new RegisterUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(registerUserRequest));
            CompletableFuture<RegisterUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Restores an analysis.
     * </p>
     *
     * @param restoreAnalysisRequest
     * @return A Java Future containing the result of the RestoreAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.RestoreAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<RestoreAnalysisResponse> restoreAnalysis(RestoreAnalysisRequest restoreAnalysisRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<RestoreAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, RestoreAnalysisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<RestoreAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<RestoreAnalysisRequest, RestoreAnalysisResponse>()
                            .withOperationName("RestoreAnalysis")
                            .withMarshaller(new RestoreAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(restoreAnalysisRequest));
            CompletableFuture<RestoreAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param searchAnalysesRequest
     * @return A Java Future containing the result of the SearchAnalyses operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchAnalysesResponse> searchAnalyses(SearchAnalysesRequest searchAnalysesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchAnalysesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchAnalyses");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchAnalysesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchAnalysesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchAnalysesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchAnalysesRequest, SearchAnalysesResponse>()
                            .withOperationName("SearchAnalyses")
                            .withMarshaller(new SearchAnalysesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchAnalysesRequest));
            CompletableFuture<SearchAnalysesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesPublisher publisher = client.searchAnalysesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesPublisher publisher = client.searchAnalysesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation.</b>
     * </p>
     *
     * @param searchAnalysesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    public SearchAnalysesPublisher searchAnalysesPaginator(SearchAnalysesRequest searchAnalysesRequest) {
        return new SearchAnalysesPublisher(this, applyPaginatorUserAgent(searchAnalysesRequest));
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param searchDashboardsRequest
     * @return A Java Future containing the result of the SearchDashboards operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchDashboardsResponse> searchDashboards(SearchDashboardsRequest searchDashboardsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchDashboardsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDashboards");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchDashboardsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchDashboardsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchDashboardsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchDashboardsRequest, SearchDashboardsResponse>()
                            .withOperationName("SearchDashboards")
                            .withMarshaller(new SearchDashboardsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchDashboardsRequest));
            CompletableFuture<SearchDashboardsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsPublisher publisher = client.searchDashboardsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsPublisher publisher = client.searchDashboardsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDashboardsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchDashboardsPublisher searchDashboardsPaginator(SearchDashboardsRequest searchDashboardsRequest) {
        return new SearchDashboardsPublisher(this, applyPaginatorUserAgent(searchDashboardsRequest));
    }

    /**
     * <p>
     * Use the <code>SearchDataSets</code> operation to search for datasets that belong to an account.
     * </p>
     *
     * @param searchDataSetsRequest
     * @return A Java Future containing the result of the SearchDataSets operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchDataSetsResponse> searchDataSets(SearchDataSetsRequest searchDataSetsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchDataSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDataSets");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchDataSetsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchDataSetsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchDataSetsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchDataSetsRequest, SearchDataSetsResponse>()
                            .withOperationName("SearchDataSets")
                            .withMarshaller(new SearchDataSetsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchDataSetsRequest));
            CompletableFuture<SearchDataSetsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>SearchDataSets</code> operation to search for datasets that belong to an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDataSets(software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSetsPublisher publisher = client.searchDataSetsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSetsPublisher publisher = client.searchDataSetsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDataSets(software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param searchDataSetsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    public SearchDataSetsPublisher searchDataSetsPaginator(SearchDataSetsRequest searchDataSetsRequest) {
        return new SearchDataSetsPublisher(this, applyPaginatorUserAgent(searchDataSetsRequest));
    }

    /**
     * <p>
     * Use the <code>SearchDataSources</code> operation to search for data sources that belong to an account.
     * </p>
     *
     * @param searchDataSourcesRequest
     * @return A Java Future containing the result of the SearchDataSources operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<SearchDataSourcesResponse> searchDataSources(SearchDataSourcesRequest searchDataSourcesRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDataSources");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, SearchDataSourcesResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchDataSourcesResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchDataSourcesRequest, SearchDataSourcesResponse>()
                            .withOperationName("SearchDataSources")
                            .withMarshaller(new SearchDataSourcesRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchDataSourcesRequest));
            CompletableFuture<SearchDataSourcesResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>SearchDataSources</code> operation to search for data sources that belong to an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDataSources(software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSourcesPublisher publisher = client.searchDataSourcesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSourcesPublisher publisher = client.searchDataSourcesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDataSources(software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDataSourcesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    public SearchDataSourcesPublisher searchDataSourcesPaginator(SearchDataSourcesRequest searchDataSourcesRequest) {
        return new SearchDataSourcesPublisher(this, applyPaginatorUserAgent(searchDataSourcesRequest));
    }

    /**
     * <p>
     * Searches the subfolders in a folder.
     * </p>
     *
     * @param searchFoldersRequest
     * @return A Java Future containing the result of the SearchFolders operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InvalidRequestException You don't have this feature activated for your account. To fix this issue,
     *         contact Amazon Web Services support.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchFoldersResponse> searchFolders(SearchFoldersRequest searchFoldersRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchFoldersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchFolders");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchFoldersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchFoldersResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchFoldersResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchFoldersRequest, SearchFoldersResponse>()
                            .withOperationName("SearchFolders")
                            .withMarshaller(new SearchFoldersRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchFoldersRequest));
            CompletableFuture<SearchFoldersResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>SearchGroups</code> operation to search groups in a specified Amazon QuickSight namespace using the
     * supplied filters.
     * </p>
     *
     * @param searchGroupsRequest
     * @return A Java Future containing the result of the SearchGroups operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidNextTokenException The <code>NextToken</code> value isn't valid.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.SearchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<SearchGroupsResponse> searchGroups(SearchGroupsRequest searchGroupsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchGroups");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<SearchGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    SearchGroupsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<SearchGroupsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<SearchGroupsRequest, SearchGroupsResponse>()
                            .withOperationName("SearchGroups").withMarshaller(new SearchGroupsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(searchGroupsRequest));
            CompletableFuture<SearchGroupsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the
     * resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is
     * already associated with the resource, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data
     * source, dashboard, and template.
     * </p>
     * <p>
     * Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except
     * for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't use tags to track costs for Amazon QuickSight. This isn't possible because you can't tag the resources
     * that Amazon QuickSight costs are based on, for example Amazon QuickSight storage capacity (SPICE), number of
     * users, type of users, and usage metrics.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon QuickSight doesn't currently support the tag editor for Resource Groups.
     * </p>
     * </li>
     * </ul>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    TagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<TagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                            .withOperationName("TagResource").withMarshaller(new TagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(tagResourceRequest));
            CompletableFuture<TagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UntagResourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UntagResourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                            .withOperationName("UntagResource")
                            .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(untagResourceRequest));
            CompletableFuture<UntagResourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only
     * customization that you can use is a theme.
     * </p>
     * <p>
     * You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon
     * QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an
     * Amazon Web Services account. To find out which customizations apply, use the
     * <code>DescribeAccountCustomization</code> API operation.
     * </p>
     *
     * @param updateAccountCustomizationRequest
     * @return A Java Future containing the result of the UpdateAccountCustomization operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccountCustomizationResponse> updateAccountCustomization(
            UpdateAccountCustomizationRequest updateAccountCustomizationRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountCustomization");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAccountCustomizationResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAccountCustomizationResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountCustomizationRequest, UpdateAccountCustomizationResponse>()
                            .withOperationName("UpdateAccountCustomization")
                            .withMarshaller(new UpdateAccountCustomizationRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAccountCustomizationRequest));
            CompletableFuture<UpdateAccountCustomizationResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the Amazon QuickSight settings in your Amazon Web Services account.
     * </p>
     *
     * @param updateAccountSettingsRequest
     * @return A Java Future containing the result of the UpdateAccountSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAccountSettingsResponse> updateAccountSettings(
            UpdateAccountSettingsRequest updateAccountSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAccountSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAccountSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountSettingsRequest, UpdateAccountSettingsResponse>()
                            .withOperationName("UpdateAccountSettings")
                            .withMarshaller(new UpdateAccountSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAccountSettingsRequest));
            CompletableFuture<UpdateAccountSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an analysis in Amazon QuickSight
     * </p>
     *
     * @param updateAnalysisRequest
     * @return A Java Future containing the result of the UpdateAnalysis operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAnalysisResponse> updateAnalysis(UpdateAnalysisRequest updateAnalysisRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnalysis");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAnalysisResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAnalysisResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAnalysisRequest, UpdateAnalysisResponse>()
                            .withOperationName("UpdateAnalysis")
                            .withMarshaller(new UpdateAnalysisRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAnalysisRequest));
            CompletableFuture<UpdateAnalysisResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the read and write permissions for an analysis.
     * </p>
     *
     * @param updateAnalysisPermissionsRequest
     * @return A Java Future containing the result of the UpdateAnalysisPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateAnalysisPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateAnalysisPermissionsResponse> updateAnalysisPermissions(
            UpdateAnalysisPermissionsRequest updateAnalysisPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnalysisPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnalysisPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateAnalysisPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateAnalysisPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateAnalysisPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateAnalysisPermissionsRequest, UpdateAnalysisPermissionsResponse>()
                            .withOperationName("UpdateAnalysisPermissions")
                            .withMarshaller(new UpdateAnalysisPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateAnalysisPermissionsRequest));
            CompletableFuture<UpdateAnalysisPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a dashboard in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can
     * update the published version of a dashboard by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> </code>
     * API operation.
     * </p>
     * </note>
     *
     * @param updateDashboardRequest
     * @return A Java Future containing the result of the UpdateDashboard operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDashboardResponse> updateDashboard(UpdateDashboardRequest updateDashboardRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboard");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDashboardResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDashboardResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDashboardRequest, UpdateDashboardResponse>()
                            .withOperationName("UpdateDashboard")
                            .withMarshaller(new UpdateDashboardRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDashboardRequest));
            CompletableFuture<UpdateDashboardResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates read and write permissions on a dashboard.
     * </p>
     *
     * @param updateDashboardPermissionsRequest
     * @return A Java Future containing the result of the UpdateDashboardPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboardPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDashboardPermissionsResponse> updateDashboardPermissions(
            UpdateDashboardPermissionsRequest updateDashboardPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDashboardPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboardPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDashboardPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDashboardPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDashboardPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDashboardPermissionsRequest, UpdateDashboardPermissionsResponse>()
                            .withOperationName("UpdateDashboardPermissions")
                            .withMarshaller(new UpdateDashboardPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDashboardPermissionsRequest));
            CompletableFuture<UpdateDashboardPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the published version of a dashboard.
     * </p>
     *
     * @param updateDashboardPublishedVersionRequest
     * @return A Java Future containing the result of the UpdateDashboardPublishedVersion operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDashboardPublishedVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDashboardPublishedVersionResponse> updateDashboardPublishedVersion(
            UpdateDashboardPublishedVersionRequest updateDashboardPublishedVersionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDashboardPublishedVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboardPublishedVersion");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDashboardPublishedVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDashboardPublishedVersionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDashboardPublishedVersionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDashboardPublishedVersionRequest, UpdateDashboardPublishedVersionResponse>()
                            .withOperationName("UpdateDashboardPublishedVersion")
                            .withMarshaller(new UpdateDashboardPublishedVersionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDashboardPublishedVersionRequest));
            CompletableFuture<UpdateDashboardPublishedVersionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a dataset. This operation doesn't support datasets that include uploaded files as a source. Partial
     * updates are not supported by this operation.
     * </p>
     *
     * @param updateDataSetRequest
     * @return A Java Future containing the result of the UpdateDataSet operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDataSetResponse> updateDataSet(UpdateDataSetRequest updateDataSetRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSet");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateDataSetResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDataSetResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSetRequest, UpdateDataSetResponse>()
                            .withOperationName("UpdateDataSet")
                            .withMarshaller(new UpdateDataSetRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDataSetRequest));
            CompletableFuture<UpdateDataSetResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param updateDataSetPermissionsRequest
     * @return A Java Future containing the result of the UpdateDataSetPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSetPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDataSetPermissionsResponse> updateDataSetPermissions(
            UpdateDataSetPermissionsRequest updateDataSetPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSetPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSetPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDataSetPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDataSetPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDataSetPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSetPermissionsRequest, UpdateDataSetPermissionsResponse>()
                            .withOperationName("UpdateDataSetPermissions")
                            .withMarshaller(new UpdateDataSetPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDataSetPermissionsRequest));
            CompletableFuture<UpdateDataSetPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a data source.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return A Java Future containing the result of the UpdateDataSource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDataSourceResponse> updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSource");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDataSourceResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDataSourceResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                            .withOperationName("UpdateDataSource")
                            .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDataSourceRequest));
            CompletableFuture<UpdateDataSourceResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the permissions to a data source.
     * </p>
     *
     * @param updateDataSourcePermissionsRequest
     * @return A Java Future containing the result of the UpdateDataSourcePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateDataSourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateDataSourcePermissionsResponse> updateDataSourcePermissions(
            UpdateDataSourcePermissionsRequest updateDataSourcePermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourcePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSourcePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateDataSourcePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateDataSourcePermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateDataSourcePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSourcePermissionsRequest, UpdateDataSourcePermissionsResponse>()
                            .withOperationName("UpdateDataSourcePermissions")
                            .withMarshaller(new UpdateDataSourcePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateDataSourcePermissionsRequest));
            CompletableFuture<UpdateDataSourcePermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the name of a folder.
     * </p>
     *
     * @param updateFolderRequest
     * @return A Java Future containing the result of the UpdateFolder operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFolderResponse> updateFolder(UpdateFolderRequest updateFolderRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFolder");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateFolderResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFolderResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFolderRequest, UpdateFolderResponse>()
                            .withOperationName("UpdateFolder").withMarshaller(new UpdateFolderRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateFolderRequest));
            CompletableFuture<UpdateFolderResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates permissions of a folder.
     * </p>
     *
     * @param updateFolderPermissionsRequest
     * @return A Java Future containing the result of the UpdateFolderPermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateFolderPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateFolderPermissionsResponse> updateFolderPermissions(
            UpdateFolderPermissionsRequest updateFolderPermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFolderPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFolderPermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateFolderPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateFolderPermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateFolderPermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateFolderPermissionsRequest, UpdateFolderPermissionsResponse>()
                            .withOperationName("UpdateFolderPermissions")
                            .withMarshaller(new UpdateFolderPermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateFolderPermissionsRequest));
            CompletableFuture<UpdateFolderPermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     *
     * @param updateGroupRequest
     * @return A Java Future containing the result of the UpdateGroup operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateGroupResponse> updateGroup(UpdateGroupRequest updateGroupRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateGroupResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateGroupResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                            .withOperationName("UpdateGroup").withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateGroupRequest));
            CompletableFuture<UpdateGroupResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that
     * are specified in the request. This overwrites all of the users included in <code>Identities</code>.
     * </p>
     *
     * @param updateIamPolicyAssignmentRequest
     * @return A Java Future containing the result of the UpdateIAMPolicyAssignment operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConcurrentUpdatingException A resource is already in a state that indicates an operation is happening
     *         that must complete before a new update can be applied.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIamPolicyAssignmentResponse> updateIAMPolicyAssignment(
            UpdateIamPolicyAssignmentRequest updateIamPolicyAssignmentRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIAMPolicyAssignment");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIamPolicyAssignmentResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIamPolicyAssignmentResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIamPolicyAssignmentRequest, UpdateIamPolicyAssignmentResponse>()
                            .withOperationName("UpdateIAMPolicyAssignment")
                            .withMarshaller(new UpdateIamPolicyAssignmentRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateIamPolicyAssignmentRequest));
            CompletableFuture<UpdateIamPolicyAssignmentResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the content and status of IP rules. To use this operation, you need to provide the entire map of rules.
     * You can use the <code>DescribeIpRestriction</code> operation to get the current rule map.
     * </p>
     *
     * @param updateIpRestrictionRequest
     * @return A Java Future containing the result of the UpdateIpRestriction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateIpRestriction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateIpRestrictionResponse> updateIpRestriction(
            UpdateIpRestrictionRequest updateIpRestrictionRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIpRestrictionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIpRestriction");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateIpRestrictionResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateIpRestrictionResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateIpRestrictionResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateIpRestrictionRequest, UpdateIpRestrictionResponse>()
                            .withOperationName("UpdateIpRestriction")
                            .withMarshaller(new UpdateIpRestrictionRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateIpRestrictionRequest));
            CompletableFuture<UpdateIpRestrictionResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Use the <code>UpdatePublicSharingSettings</code> operation to turn on or turn off the public sharing settings of
     * an Amazon QuickSight dashboard.
     * </p>
     * <p>
     * To use this operation, turn on session capacity pricing for your Amazon QuickSight account.
     * </p>
     * <p>
     * Before you can turn on public sharing on your account, make sure to give public sharing permissions to an
     * administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with
     * Amazon QuickSight, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html">Using Amazon
     * QuickSight with IAM</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param updatePublicSharingSettingsRequest
     * @return A Java Future containing the result of the UpdatePublicSharingSettings operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedPricingPlanException This error indicates that you are calling an embedding operation in
     *         Amazon QuickSight without the required pricing plan on your Amazon Web Services account. Before you can
     *         use embedding for anonymous users, a QuickSight administrator needs to add capacity pricing to Amazon
     *         QuickSight. You can do this on the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdatePublicSharingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdatePublicSharingSettingsResponse> updatePublicSharingSettings(
            UpdatePublicSharingSettingsRequest updatePublicSharingSettingsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePublicSharingSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePublicSharingSettings");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdatePublicSharingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdatePublicSharingSettingsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdatePublicSharingSettingsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdatePublicSharingSettingsRequest, UpdatePublicSharingSettingsResponse>()
                            .withOperationName("UpdatePublicSharingSettings")
                            .withMarshaller(new UpdatePublicSharingSettingsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updatePublicSharingSettingsRequest));
            CompletableFuture<UpdatePublicSharingSettingsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a template from an existing Amazon QuickSight analysis or another template.
     * </p>
     *
     * @param updateTemplateRequest
     * @return A Java Future containing the result of the UpdateTemplate operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTemplateResponse> updateTemplate(UpdateTemplateRequest updateTemplateRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplate");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTemplateResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTemplateResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTemplateRequest, UpdateTemplateResponse>()
                            .withOperationName("UpdateTemplate")
                            .withMarshaller(new UpdateTemplateRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTemplateRequest));
            CompletableFuture<UpdateTemplateResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the template alias of a template.
     * </p>
     *
     * @param updateTemplateAliasRequest
     * @return A Java Future containing the result of the UpdateTemplateAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTemplateAliasResponse> updateTemplateAlias(
            UpdateTemplateAliasRequest updateTemplateAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplateAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTemplateAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTemplateAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTemplateAliasRequest, UpdateTemplateAliasResponse>()
                            .withOperationName("UpdateTemplateAlias")
                            .withMarshaller(new UpdateTemplateAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTemplateAliasRequest));
            CompletableFuture<UpdateTemplateAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the resource permissions for a template.
     * </p>
     *
     * @param updateTemplatePermissionsRequest
     * @return A Java Future containing the result of the UpdateTemplatePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTemplatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateTemplatePermissionsResponse> updateTemplatePermissions(
            UpdateTemplatePermissionsRequest updateTemplatePermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplatePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplatePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateTemplatePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateTemplatePermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateTemplatePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateTemplatePermissionsRequest, UpdateTemplatePermissionsResponse>()
                            .withOperationName("UpdateTemplatePermissions")
                            .withMarshaller(new UpdateTemplatePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateTemplatePermissionsRequest));
            CompletableFuture<UpdateTemplatePermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates a theme.
     * </p>
     *
     * @param updateThemeRequest
     * @return A Java Future containing the result of the UpdateTheme operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>LimitExceededException A limit is exceeded.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateThemeResponse> updateTheme(UpdateThemeRequest updateThemeRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTheme");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateThemeResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThemeResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThemeRequest, UpdateThemeResponse>()
                            .withOperationName("UpdateTheme").withMarshaller(new UpdateThemeRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateThemeRequest));
            CompletableFuture<UpdateThemeResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an alias of a theme.
     * </p>
     *
     * @param updateThemeAliasRequest
     * @return A Java Future containing the result of the UpdateThemeAlias operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ConflictException Updating or deleting a resource can cause an inconsistent state.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceExistsException The resource specified already exists.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateThemeAliasResponse> updateThemeAlias(UpdateThemeAliasRequest updateThemeAliasRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThemeAlias");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateThemeAliasResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThemeAliasResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThemeAliasRequest, UpdateThemeAliasResponse>()
                            .withOperationName("UpdateThemeAlias")
                            .withMarshaller(new UpdateThemeAliasRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateThemeAliasRequest));
            CompletableFuture<UpdateThemeAliasResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on,
     * for example <code>"quicksight:DescribeTheme"</code>.
     * </p>
     * <p>
     * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions,
     * which are user, owner, or no permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Owner
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:CreateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemePermissions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemePermissions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To specify no permissions, omit the permissions list.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateThemePermissionsRequest
     * @return A Java Future containing the result of the UpdateThemePermissions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>UnsupportedUserEditionException This error indicates that you are calling an operation on an Amazon
     *         QuickSight subscription where the edition doesn't include support for that operation. Amazon Amazon
     *         QuickSight currently has Standard Edition and Enterprise Edition. Not every operation and capability is
     *         available in every edition.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateThemePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateThemePermissionsResponse> updateThemePermissions(
            UpdateThemePermissionsRequest updateThemePermissionsRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThemePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThemePermissions");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateThemePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                    operationMetadata, UpdateThemePermissionsResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateThemePermissionsResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateThemePermissionsRequest, UpdateThemePermissionsResponse>()
                            .withOperationName("UpdateThemePermissions")
                            .withMarshaller(new UpdateThemePermissionsRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateThemePermissionsRequest));
            CompletableFuture<UpdateThemePermissionsResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     *
     * @param updateUserRequest
     * @return A Java Future containing the result of the UpdateUser operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>AccessDeniedException You don't have access to this item. The provided credentials couldn't be
     *         validated. You might not be authorized to carry out the request. Make sure that your account is
     *         authorized to use the Amazon QuickSight service, that your policies have the correct permissions, and
     *         that you are using the correct access keys.</li>
     *         <li>InvalidParameterValueException One or more parameters has a value that isn't valid.</li>
     *         <li>ResourceNotFoundException One or more resources can't be found.</li>
     *         <li>ThrottlingException Access is throttled.</li>
     *         <li>PreconditionNotMetException One or more preconditions aren't met.</li>
     *         <li>InternalFailureException An internal failure occurred.</li>
     *         <li>ResourceUnavailableException This resource is currently unavailable.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>QuickSightException Base class for all service exceptions. Unknown exceptions will be thrown as an
     *         instance of this type.</li>
     *         </ul>
     * @sample QuickSightAsyncClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CompletableFuture<UpdateUserResponse> updateUser(UpdateUserRequest updateUserRequest) {
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");
            JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                    .isPayloadJson(true).build();

            HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                    UpdateUserResponse::builder);

            HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                    operationMetadata);

            CompletableFuture<UpdateUserResponse> executeFuture = clientHandler
                    .execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>().withOperationName("UpdateUser")
                            .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory))
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withMetricCollector(apiCallMetricCollector).withInput(updateUserRequest));
            CompletableFuture<UpdateUserResponse> whenCompleted = executeFuture.whenComplete((r, e) -> {
                metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            });
            executeFuture = CompletableFutureUtils.forwardExceptionTo(whenCompleted, executeFuture);
            return executeFuture;
        } catch (Throwable t) {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
            return CompletableFutureUtils.failedFuture(t);
        }
    }

    @Override
    public void close() {
        clientHandler.close();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(QuickSightException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.0")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                                .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                                .exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException")
                                .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                                .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                                .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceExistsException")
                                .exceptionBuilderSupplier(ResourceExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionNotMetException")
                                .exceptionBuilderSupplier(PreconditionNotMetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException")
                                .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                                .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).httpStatusCode(403).build());
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private <T extends QuickSightRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }
}
