/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The filter operation that filters data included in a visual or in an entire sheet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomActionFilterOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomActionFilterOperation.Builder, CustomActionFilterOperation> {
    private static final SdkField<FilterOperationSelectedFieldsConfiguration> SELECTED_FIELDS_CONFIGURATION_FIELD = SdkField
            .<FilterOperationSelectedFieldsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("SelectedFieldsConfiguration")
            .getter(getter(CustomActionFilterOperation::selectedFieldsConfiguration))
            .setter(setter(Builder::selectedFieldsConfiguration))
            .constructor(FilterOperationSelectedFieldsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFieldsConfiguration")
                    .build()).build();

    private static final SdkField<FilterOperationTargetVisualsConfiguration> TARGET_VISUALS_CONFIGURATION_FIELD = SdkField
            .<FilterOperationTargetVisualsConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("TargetVisualsConfiguration")
            .getter(getter(CustomActionFilterOperation::targetVisualsConfiguration))
            .setter(setter(Builder::targetVisualsConfiguration))
            .constructor(FilterOperationTargetVisualsConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetVisualsConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SELECTED_FIELDS_CONFIGURATION_FIELD, TARGET_VISUALS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FilterOperationSelectedFieldsConfiguration selectedFieldsConfiguration;

    private final FilterOperationTargetVisualsConfiguration targetVisualsConfiguration;

    private CustomActionFilterOperation(BuilderImpl builder) {
        this.selectedFieldsConfiguration = builder.selectedFieldsConfiguration;
        this.targetVisualsConfiguration = builder.targetVisualsConfiguration;
    }

    /**
     * <p>
     * The configuration that chooses the fields to be filtered.
     * </p>
     * 
     * @return The configuration that chooses the fields to be filtered.
     */
    public final FilterOperationSelectedFieldsConfiguration selectedFieldsConfiguration() {
        return selectedFieldsConfiguration;
    }

    /**
     * <p>
     * The configuration that chooses the target visuals to be filtered.
     * </p>
     * 
     * @return The configuration that chooses the target visuals to be filtered.
     */
    public final FilterOperationTargetVisualsConfiguration targetVisualsConfiguration() {
        return targetVisualsConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(selectedFieldsConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(targetVisualsConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomActionFilterOperation)) {
            return false;
        }
        CustomActionFilterOperation other = (CustomActionFilterOperation) obj;
        return Objects.equals(selectedFieldsConfiguration(), other.selectedFieldsConfiguration())
                && Objects.equals(targetVisualsConfiguration(), other.targetVisualsConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomActionFilterOperation").add("SelectedFieldsConfiguration", selectedFieldsConfiguration())
                .add("TargetVisualsConfiguration", targetVisualsConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedFieldsConfiguration":
            return Optional.ofNullable(clazz.cast(selectedFieldsConfiguration()));
        case "TargetVisualsConfiguration":
            return Optional.ofNullable(clazz.cast(targetVisualsConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CustomActionFilterOperation, T> g) {
        return obj -> g.apply((CustomActionFilterOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomActionFilterOperation> {
        /**
         * <p>
         * The configuration that chooses the fields to be filtered.
         * </p>
         * 
         * @param selectedFieldsConfiguration
         *        The configuration that chooses the fields to be filtered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFieldsConfiguration(FilterOperationSelectedFieldsConfiguration selectedFieldsConfiguration);

        /**
         * <p>
         * The configuration that chooses the fields to be filtered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FilterOperationSelectedFieldsConfiguration.Builder} avoiding the need to create one manually via
         * {@link FilterOperationSelectedFieldsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterOperationSelectedFieldsConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #selectedFieldsConfiguration(FilterOperationSelectedFieldsConfiguration)}.
         * 
         * @param selectedFieldsConfiguration
         *        a consumer that will call methods on {@link FilterOperationSelectedFieldsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedFieldsConfiguration(FilterOperationSelectedFieldsConfiguration)
         */
        default Builder selectedFieldsConfiguration(
                Consumer<FilterOperationSelectedFieldsConfiguration.Builder> selectedFieldsConfiguration) {
            return selectedFieldsConfiguration(FilterOperationSelectedFieldsConfiguration.builder()
                    .applyMutation(selectedFieldsConfiguration).build());
        }

        /**
         * <p>
         * The configuration that chooses the target visuals to be filtered.
         * </p>
         * 
         * @param targetVisualsConfiguration
         *        The configuration that chooses the target visuals to be filtered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetVisualsConfiguration(FilterOperationTargetVisualsConfiguration targetVisualsConfiguration);

        /**
         * <p>
         * The configuration that chooses the target visuals to be filtered.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link FilterOperationTargetVisualsConfiguration.Builder} avoiding the need to create one manually via
         * {@link FilterOperationTargetVisualsConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterOperationTargetVisualsConfiguration.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #targetVisualsConfiguration(FilterOperationTargetVisualsConfiguration)}.
         * 
         * @param targetVisualsConfiguration
         *        a consumer that will call methods on {@link FilterOperationTargetVisualsConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetVisualsConfiguration(FilterOperationTargetVisualsConfiguration)
         */
        default Builder targetVisualsConfiguration(
                Consumer<FilterOperationTargetVisualsConfiguration.Builder> targetVisualsConfiguration) {
            return targetVisualsConfiguration(FilterOperationTargetVisualsConfiguration.builder()
                    .applyMutation(targetVisualsConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilterOperationSelectedFieldsConfiguration selectedFieldsConfiguration;

        private FilterOperationTargetVisualsConfiguration targetVisualsConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomActionFilterOperation model) {
            selectedFieldsConfiguration(model.selectedFieldsConfiguration);
            targetVisualsConfiguration(model.targetVisualsConfiguration);
        }

        public final FilterOperationSelectedFieldsConfiguration.Builder getSelectedFieldsConfiguration() {
            return selectedFieldsConfiguration != null ? selectedFieldsConfiguration.toBuilder() : null;
        }

        public final void setSelectedFieldsConfiguration(
                FilterOperationSelectedFieldsConfiguration.BuilderImpl selectedFieldsConfiguration) {
            this.selectedFieldsConfiguration = selectedFieldsConfiguration != null ? selectedFieldsConfiguration.build() : null;
        }

        @Override
        public final Builder selectedFieldsConfiguration(FilterOperationSelectedFieldsConfiguration selectedFieldsConfiguration) {
            this.selectedFieldsConfiguration = selectedFieldsConfiguration;
            return this;
        }

        public final FilterOperationTargetVisualsConfiguration.Builder getTargetVisualsConfiguration() {
            return targetVisualsConfiguration != null ? targetVisualsConfiguration.toBuilder() : null;
        }

        public final void setTargetVisualsConfiguration(
                FilterOperationTargetVisualsConfiguration.BuilderImpl targetVisualsConfiguration) {
            this.targetVisualsConfiguration = targetVisualsConfiguration != null ? targetVisualsConfiguration.build() : null;
        }

        @Override
        public final Builder targetVisualsConfiguration(FilterOperationTargetVisualsConfiguration targetVisualsConfiguration) {
            this.targetVisualsConfiguration = targetVisualsConfiguration;
            return this;
        }

        @Override
        public CustomActionFilterOperation build() {
            return new CustomActionFilterOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
