/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Dashboard error.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardError implements SdkPojo, Serializable, ToCopyableBuilder<DashboardError.Builder, DashboardError> {
    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Type")
            .getter(getter(DashboardError::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Message")
            .getter(getter(DashboardError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Message").build()).build();

    private static final SdkField<List<Entity>> VIOLATED_ENTITIES_FIELD = SdkField
            .<List<Entity>> builder(MarshallingType.LIST)
            .memberName("ViolatedEntities")
            .getter(getter(DashboardError::violatedEntities))
            .setter(setter(Builder::violatedEntities))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViolatedEntities").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Entity> builder(MarshallingType.SDK_POJO)
                                            .constructor(Entity::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, MESSAGE_FIELD,
            VIOLATED_ENTITIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String type;

    private final String message;

    private final List<Entity> violatedEntities;

    private DashboardError(BuilderImpl builder) {
        this.type = builder.type;
        this.message = builder.message;
        this.violatedEntities = builder.violatedEntities;
    }

    /**
     * <p>
     * Type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type.
     * @see DashboardErrorType
     */
    public final DashboardErrorType type() {
        return DashboardErrorType.fromValue(type);
    }

    /**
     * <p>
     * Type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link DashboardErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return Type.
     * @see DashboardErrorType
     */
    public final String typeAsString() {
        return type;
    }

    /**
     * <p>
     * Message.
     * </p>
     * 
     * @return Message.
     */
    public final String message() {
        return message;
    }

    /**
     * For responses, this returns true if the service returned a value for the ViolatedEntities property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasViolatedEntities() {
        return violatedEntities != null && !(violatedEntities instanceof SdkAutoConstructList);
    }

    /**
     * <p/>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasViolatedEntities} method.
     * </p>
     * 
     * @return
     */
    public final List<Entity> violatedEntities() {
        return violatedEntities;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(hasViolatedEntities() ? violatedEntities() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardError)) {
            return false;
        }
        DashboardError other = (DashboardError) obj;
        return Objects.equals(typeAsString(), other.typeAsString()) && Objects.equals(message(), other.message())
                && hasViolatedEntities() == other.hasViolatedEntities()
                && Objects.equals(violatedEntities(), other.violatedEntities());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashboardError").add("Type", typeAsString()).add("Message", message())
                .add("ViolatedEntities", hasViolatedEntities() ? violatedEntities() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        case "Message":
            return Optional.ofNullable(clazz.cast(message()));
        case "ViolatedEntities":
            return Optional.ofNullable(clazz.cast(violatedEntities()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardError, T> g) {
        return obj -> g.apply((DashboardError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardError> {
        /**
         * <p>
         * Type.
         * </p>
         * 
         * @param type
         *        Type.
         * @see DashboardErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardErrorType
         */
        Builder type(String type);

        /**
         * <p>
         * Type.
         * </p>
         * 
         * @param type
         *        Type.
         * @see DashboardErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DashboardErrorType
         */
        Builder type(DashboardErrorType type);

        /**
         * <p>
         * Message.
         * </p>
         * 
         * @param message
         *        Message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p/>
         * 
         * @param violatedEntities
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatedEntities(Collection<Entity> violatedEntities);

        /**
         * <p/>
         * 
         * @param violatedEntities
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder violatedEntities(Entity... violatedEntities);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.Entity.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.Entity#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.Entity.Builder#build()} is called immediately and its
         * result is passed to {@link #violatedEntities(List<Entity>)}.
         * 
         * @param violatedEntities
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.Entity.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #violatedEntities(java.util.Collection<Entity>)
         */
        Builder violatedEntities(Consumer<Entity.Builder>... violatedEntities);
    }

    static final class BuilderImpl implements Builder {
        private String type;

        private String message;

        private List<Entity> violatedEntities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardError model) {
            type(model.type);
            message(model.message);
            violatedEntities(model.violatedEntities);
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(DashboardErrorType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<Entity.Builder> getViolatedEntities() {
            List<Entity.Builder> result = EntityListCopier.copyToBuilder(this.violatedEntities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViolatedEntities(Collection<Entity.BuilderImpl> violatedEntities) {
            this.violatedEntities = EntityListCopier.copyFromBuilder(violatedEntities);
        }

        @Override
        public final Builder violatedEntities(Collection<Entity> violatedEntities) {
            this.violatedEntities = EntityListCopier.copy(violatedEntities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatedEntities(Entity... violatedEntities) {
            violatedEntities(Arrays.asList(violatedEntities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder violatedEntities(Consumer<Entity.Builder>... violatedEntities) {
            violatedEntities(Stream.of(violatedEntities).map(c -> Entity.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public DashboardError build() {
            return new DashboardError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
