/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The table options for a pivot table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableOptions.Builder, PivotTableOptions> {
    private static final SdkField<String> METRIC_PLACEMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetricPlacement").getter(getter(PivotTableOptions::metricPlacementAsString))
            .setter(setter(Builder::metricPlacement))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetricPlacement").build()).build();

    private static final SdkField<String> SINGLE_METRIC_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SingleMetricVisibility").getter(getter(PivotTableOptions::singleMetricVisibilityAsString))
            .setter(setter(Builder::singleMetricVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SingleMetricVisibility").build())
            .build();

    private static final SdkField<String> COLUMN_NAMES_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnNamesVisibility").getter(getter(PivotTableOptions::columnNamesVisibilityAsString))
            .setter(setter(Builder::columnNamesVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnNamesVisibility").build())
            .build();

    private static final SdkField<String> TOGGLE_BUTTONS_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ToggleButtonsVisibility").getter(getter(PivotTableOptions::toggleButtonsVisibilityAsString))
            .setter(setter(Builder::toggleButtonsVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ToggleButtonsVisibility").build())
            .build();

    private static final SdkField<TableCellStyle> COLUMN_HEADER_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("ColumnHeaderStyle")
            .getter(getter(PivotTableOptions::columnHeaderStyle)).setter(setter(Builder::columnHeaderStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnHeaderStyle").build()).build();

    private static final SdkField<TableCellStyle> ROW_HEADER_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("RowHeaderStyle")
            .getter(getter(PivotTableOptions::rowHeaderStyle)).setter(setter(Builder::rowHeaderStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowHeaderStyle").build()).build();

    private static final SdkField<TableCellStyle> CELL_STYLE_FIELD = SdkField.<TableCellStyle> builder(MarshallingType.SDK_POJO)
            .memberName("CellStyle").getter(getter(PivotTableOptions::cellStyle)).setter(setter(Builder::cellStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CellStyle").build()).build();

    private static final SdkField<TableCellStyle> ROW_FIELD_NAMES_STYLE_FIELD = SdkField
            .<TableCellStyle> builder(MarshallingType.SDK_POJO).memberName("RowFieldNamesStyle")
            .getter(getter(PivotTableOptions::rowFieldNamesStyle)).setter(setter(Builder::rowFieldNamesStyle))
            .constructor(TableCellStyle::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowFieldNamesStyle").build())
            .build();

    private static final SdkField<RowAlternateColorOptions> ROW_ALTERNATE_COLOR_OPTIONS_FIELD = SdkField
            .<RowAlternateColorOptions> builder(MarshallingType.SDK_POJO).memberName("RowAlternateColorOptions")
            .getter(getter(PivotTableOptions::rowAlternateColorOptions)).setter(setter(Builder::rowAlternateColorOptions))
            .constructor(RowAlternateColorOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RowAlternateColorOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METRIC_PLACEMENT_FIELD,
            SINGLE_METRIC_VISIBILITY_FIELD, COLUMN_NAMES_VISIBILITY_FIELD, TOGGLE_BUTTONS_VISIBILITY_FIELD,
            COLUMN_HEADER_STYLE_FIELD, ROW_HEADER_STYLE_FIELD, CELL_STYLE_FIELD, ROW_FIELD_NAMES_STYLE_FIELD,
            ROW_ALTERNATE_COLOR_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String metricPlacement;

    private final String singleMetricVisibility;

    private final String columnNamesVisibility;

    private final String toggleButtonsVisibility;

    private final TableCellStyle columnHeaderStyle;

    private final TableCellStyle rowHeaderStyle;

    private final TableCellStyle cellStyle;

    private final TableCellStyle rowFieldNamesStyle;

    private final RowAlternateColorOptions rowAlternateColorOptions;

    private PivotTableOptions(BuilderImpl builder) {
        this.metricPlacement = builder.metricPlacement;
        this.singleMetricVisibility = builder.singleMetricVisibility;
        this.columnNamesVisibility = builder.columnNamesVisibility;
        this.toggleButtonsVisibility = builder.toggleButtonsVisibility;
        this.columnHeaderStyle = builder.columnHeaderStyle;
        this.rowHeaderStyle = builder.rowHeaderStyle;
        this.cellStyle = builder.cellStyle;
        this.rowFieldNamesStyle = builder.rowFieldNamesStyle;
        this.rowAlternateColorOptions = builder.rowAlternateColorOptions;
    }

    /**
     * <p>
     * The metric placement (row, column) options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricPlacement}
     * will return {@link PivotTableMetricPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricPlacementAsString}.
     * </p>
     * 
     * @return The metric placement (row, column) options.
     * @see PivotTableMetricPlacement
     */
    public final PivotTableMetricPlacement metricPlacement() {
        return PivotTableMetricPlacement.fromValue(metricPlacement);
    }

    /**
     * <p>
     * The metric placement (row, column) options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #metricPlacement}
     * will return {@link PivotTableMetricPlacement#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #metricPlacementAsString}.
     * </p>
     * 
     * @return The metric placement (row, column) options.
     * @see PivotTableMetricPlacement
     */
    public final String metricPlacementAsString() {
        return metricPlacement;
    }

    /**
     * <p>
     * The visibility of the single metric options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #singleMetricVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #singleMetricVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the single metric options.
     * @see Visibility
     */
    public final Visibility singleMetricVisibility() {
        return Visibility.fromValue(singleMetricVisibility);
    }

    /**
     * <p>
     * The visibility of the single metric options.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #singleMetricVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #singleMetricVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the single metric options.
     * @see Visibility
     */
    public final String singleMetricVisibilityAsString() {
        return singleMetricVisibility;
    }

    /**
     * <p>
     * The visibility of the column names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #columnNamesVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #columnNamesVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the column names.
     * @see Visibility
     */
    public final Visibility columnNamesVisibility() {
        return Visibility.fromValue(columnNamesVisibility);
    }

    /**
     * <p>
     * The visibility of the column names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #columnNamesVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #columnNamesVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of the column names.
     * @see Visibility
     */
    public final String columnNamesVisibilityAsString() {
        return columnNamesVisibility;
    }

    /**
     * <p>
     * Determines the visibility of the pivot table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #toggleButtonsVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #toggleButtonsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the pivot table.
     * @see Visibility
     */
    public final Visibility toggleButtonsVisibility() {
        return Visibility.fromValue(toggleButtonsVisibility);
    }

    /**
     * <p>
     * Determines the visibility of the pivot table.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #toggleButtonsVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #toggleButtonsVisibilityAsString}.
     * </p>
     * 
     * @return Determines the visibility of the pivot table.
     * @see Visibility
     */
    public final String toggleButtonsVisibilityAsString() {
        return toggleButtonsVisibility;
    }

    /**
     * <p>
     * The table cell style of the column header.
     * </p>
     * 
     * @return The table cell style of the column header.
     */
    public final TableCellStyle columnHeaderStyle() {
        return columnHeaderStyle;
    }

    /**
     * <p>
     * The table cell style of the row headers.
     * </p>
     * 
     * @return The table cell style of the row headers.
     */
    public final TableCellStyle rowHeaderStyle() {
        return rowHeaderStyle;
    }

    /**
     * <p>
     * The table cell style of cells.
     * </p>
     * 
     * @return The table cell style of cells.
     */
    public final TableCellStyle cellStyle() {
        return cellStyle;
    }

    /**
     * <p>
     * The table cell style of row field names.
     * </p>
     * 
     * @return The table cell style of row field names.
     */
    public final TableCellStyle rowFieldNamesStyle() {
        return rowFieldNamesStyle;
    }

    /**
     * <p>
     * The row alternate color options (widget status, row alternate colors).
     * </p>
     * 
     * @return The row alternate color options (widget status, row alternate colors).
     */
    public final RowAlternateColorOptions rowAlternateColorOptions() {
        return rowAlternateColorOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(metricPlacementAsString());
        hashCode = 31 * hashCode + Objects.hashCode(singleMetricVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(columnNamesVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(toggleButtonsVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(columnHeaderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(rowHeaderStyle());
        hashCode = 31 * hashCode + Objects.hashCode(cellStyle());
        hashCode = 31 * hashCode + Objects.hashCode(rowFieldNamesStyle());
        hashCode = 31 * hashCode + Objects.hashCode(rowAlternateColorOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableOptions)) {
            return false;
        }
        PivotTableOptions other = (PivotTableOptions) obj;
        return Objects.equals(metricPlacementAsString(), other.metricPlacementAsString())
                && Objects.equals(singleMetricVisibilityAsString(), other.singleMetricVisibilityAsString())
                && Objects.equals(columnNamesVisibilityAsString(), other.columnNamesVisibilityAsString())
                && Objects.equals(toggleButtonsVisibilityAsString(), other.toggleButtonsVisibilityAsString())
                && Objects.equals(columnHeaderStyle(), other.columnHeaderStyle())
                && Objects.equals(rowHeaderStyle(), other.rowHeaderStyle()) && Objects.equals(cellStyle(), other.cellStyle())
                && Objects.equals(rowFieldNamesStyle(), other.rowFieldNamesStyle())
                && Objects.equals(rowAlternateColorOptions(), other.rowAlternateColorOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableOptions").add("MetricPlacement", metricPlacementAsString())
                .add("SingleMetricVisibility", singleMetricVisibilityAsString())
                .add("ColumnNamesVisibility", columnNamesVisibilityAsString())
                .add("ToggleButtonsVisibility", toggleButtonsVisibilityAsString()).add("ColumnHeaderStyle", columnHeaderStyle())
                .add("RowHeaderStyle", rowHeaderStyle()).add("CellStyle", cellStyle())
                .add("RowFieldNamesStyle", rowFieldNamesStyle()).add("RowAlternateColorOptions", rowAlternateColorOptions())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "MetricPlacement":
            return Optional.ofNullable(clazz.cast(metricPlacementAsString()));
        case "SingleMetricVisibility":
            return Optional.ofNullable(clazz.cast(singleMetricVisibilityAsString()));
        case "ColumnNamesVisibility":
            return Optional.ofNullable(clazz.cast(columnNamesVisibilityAsString()));
        case "ToggleButtonsVisibility":
            return Optional.ofNullable(clazz.cast(toggleButtonsVisibilityAsString()));
        case "ColumnHeaderStyle":
            return Optional.ofNullable(clazz.cast(columnHeaderStyle()));
        case "RowHeaderStyle":
            return Optional.ofNullable(clazz.cast(rowHeaderStyle()));
        case "CellStyle":
            return Optional.ofNullable(clazz.cast(cellStyle()));
        case "RowFieldNamesStyle":
            return Optional.ofNullable(clazz.cast(rowFieldNamesStyle()));
        case "RowAlternateColorOptions":
            return Optional.ofNullable(clazz.cast(rowAlternateColorOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PivotTableOptions, T> g) {
        return obj -> g.apply((PivotTableOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableOptions> {
        /**
         * <p>
         * The metric placement (row, column) options.
         * </p>
         * 
         * @param metricPlacement
         *        The metric placement (row, column) options.
         * @see PivotTableMetricPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableMetricPlacement
         */
        Builder metricPlacement(String metricPlacement);

        /**
         * <p>
         * The metric placement (row, column) options.
         * </p>
         * 
         * @param metricPlacement
         *        The metric placement (row, column) options.
         * @see PivotTableMetricPlacement
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PivotTableMetricPlacement
         */
        Builder metricPlacement(PivotTableMetricPlacement metricPlacement);

        /**
         * <p>
         * The visibility of the single metric options.
         * </p>
         * 
         * @param singleMetricVisibility
         *        The visibility of the single metric options.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder singleMetricVisibility(String singleMetricVisibility);

        /**
         * <p>
         * The visibility of the single metric options.
         * </p>
         * 
         * @param singleMetricVisibility
         *        The visibility of the single metric options.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder singleMetricVisibility(Visibility singleMetricVisibility);

        /**
         * <p>
         * The visibility of the column names.
         * </p>
         * 
         * @param columnNamesVisibility
         *        The visibility of the column names.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder columnNamesVisibility(String columnNamesVisibility);

        /**
         * <p>
         * The visibility of the column names.
         * </p>
         * 
         * @param columnNamesVisibility
         *        The visibility of the column names.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder columnNamesVisibility(Visibility columnNamesVisibility);

        /**
         * <p>
         * Determines the visibility of the pivot table.
         * </p>
         * 
         * @param toggleButtonsVisibility
         *        Determines the visibility of the pivot table.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder toggleButtonsVisibility(String toggleButtonsVisibility);

        /**
         * <p>
         * Determines the visibility of the pivot table.
         * </p>
         * 
         * @param toggleButtonsVisibility
         *        Determines the visibility of the pivot table.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder toggleButtonsVisibility(Visibility toggleButtonsVisibility);

        /**
         * <p>
         * The table cell style of the column header.
         * </p>
         * 
         * @param columnHeaderStyle
         *        The table cell style of the column header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnHeaderStyle(TableCellStyle columnHeaderStyle);

        /**
         * <p>
         * The table cell style of the column header.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #columnHeaderStyle(TableCellStyle)}.
         * 
         * @param columnHeaderStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnHeaderStyle(TableCellStyle)
         */
        default Builder columnHeaderStyle(Consumer<TableCellStyle.Builder> columnHeaderStyle) {
            return columnHeaderStyle(TableCellStyle.builder().applyMutation(columnHeaderStyle).build());
        }

        /**
         * <p>
         * The table cell style of the row headers.
         * </p>
         * 
         * @param rowHeaderStyle
         *        The table cell style of the row headers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowHeaderStyle(TableCellStyle rowHeaderStyle);

        /**
         * <p>
         * The table cell style of the row headers.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #rowHeaderStyle(TableCellStyle)}.
         * 
         * @param rowHeaderStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowHeaderStyle(TableCellStyle)
         */
        default Builder rowHeaderStyle(Consumer<TableCellStyle.Builder> rowHeaderStyle) {
            return rowHeaderStyle(TableCellStyle.builder().applyMutation(rowHeaderStyle).build());
        }

        /**
         * <p>
         * The table cell style of cells.
         * </p>
         * 
         * @param cellStyle
         *        The table cell style of cells.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cellStyle(TableCellStyle cellStyle);

        /**
         * <p>
         * The table cell style of cells.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #cellStyle(TableCellStyle)}.
         * 
         * @param cellStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cellStyle(TableCellStyle)
         */
        default Builder cellStyle(Consumer<TableCellStyle.Builder> cellStyle) {
            return cellStyle(TableCellStyle.builder().applyMutation(cellStyle).build());
        }

        /**
         * <p>
         * The table cell style of row field names.
         * </p>
         * 
         * @param rowFieldNamesStyle
         *        The table cell style of row field names.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowFieldNamesStyle(TableCellStyle rowFieldNamesStyle);

        /**
         * <p>
         * The table cell style of row field names.
         * </p>
         * This is a convenience method that creates an instance of the {@link TableCellStyle.Builder} avoiding the need
         * to create one manually via {@link TableCellStyle#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TableCellStyle.Builder#build()} is called immediately and its
         * result is passed to {@link #rowFieldNamesStyle(TableCellStyle)}.
         * 
         * @param rowFieldNamesStyle
         *        a consumer that will call methods on {@link TableCellStyle.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowFieldNamesStyle(TableCellStyle)
         */
        default Builder rowFieldNamesStyle(Consumer<TableCellStyle.Builder> rowFieldNamesStyle) {
            return rowFieldNamesStyle(TableCellStyle.builder().applyMutation(rowFieldNamesStyle).build());
        }

        /**
         * <p>
         * The row alternate color options (widget status, row alternate colors).
         * </p>
         * 
         * @param rowAlternateColorOptions
         *        The row alternate color options (widget status, row alternate colors).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions);

        /**
         * <p>
         * The row alternate color options (widget status, row alternate colors).
         * </p>
         * This is a convenience method that creates an instance of the {@link RowAlternateColorOptions.Builder}
         * avoiding the need to create one manually via {@link RowAlternateColorOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RowAlternateColorOptions.Builder#build()} is called immediately
         * and its result is passed to {@link #rowAlternateColorOptions(RowAlternateColorOptions)}.
         * 
         * @param rowAlternateColorOptions
         *        a consumer that will call methods on {@link RowAlternateColorOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rowAlternateColorOptions(RowAlternateColorOptions)
         */
        default Builder rowAlternateColorOptions(Consumer<RowAlternateColorOptions.Builder> rowAlternateColorOptions) {
            return rowAlternateColorOptions(RowAlternateColorOptions.builder().applyMutation(rowAlternateColorOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String metricPlacement;

        private String singleMetricVisibility;

        private String columnNamesVisibility;

        private String toggleButtonsVisibility;

        private TableCellStyle columnHeaderStyle;

        private TableCellStyle rowHeaderStyle;

        private TableCellStyle cellStyle;

        private TableCellStyle rowFieldNamesStyle;

        private RowAlternateColorOptions rowAlternateColorOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableOptions model) {
            metricPlacement(model.metricPlacement);
            singleMetricVisibility(model.singleMetricVisibility);
            columnNamesVisibility(model.columnNamesVisibility);
            toggleButtonsVisibility(model.toggleButtonsVisibility);
            columnHeaderStyle(model.columnHeaderStyle);
            rowHeaderStyle(model.rowHeaderStyle);
            cellStyle(model.cellStyle);
            rowFieldNamesStyle(model.rowFieldNamesStyle);
            rowAlternateColorOptions(model.rowAlternateColorOptions);
        }

        public final String getMetricPlacement() {
            return metricPlacement;
        }

        public final void setMetricPlacement(String metricPlacement) {
            this.metricPlacement = metricPlacement;
        }

        @Override
        public final Builder metricPlacement(String metricPlacement) {
            this.metricPlacement = metricPlacement;
            return this;
        }

        @Override
        public final Builder metricPlacement(PivotTableMetricPlacement metricPlacement) {
            this.metricPlacement(metricPlacement == null ? null : metricPlacement.toString());
            return this;
        }

        public final String getSingleMetricVisibility() {
            return singleMetricVisibility;
        }

        public final void setSingleMetricVisibility(String singleMetricVisibility) {
            this.singleMetricVisibility = singleMetricVisibility;
        }

        @Override
        public final Builder singleMetricVisibility(String singleMetricVisibility) {
            this.singleMetricVisibility = singleMetricVisibility;
            return this;
        }

        @Override
        public final Builder singleMetricVisibility(Visibility singleMetricVisibility) {
            this.singleMetricVisibility(singleMetricVisibility == null ? null : singleMetricVisibility.toString());
            return this;
        }

        public final String getColumnNamesVisibility() {
            return columnNamesVisibility;
        }

        public final void setColumnNamesVisibility(String columnNamesVisibility) {
            this.columnNamesVisibility = columnNamesVisibility;
        }

        @Override
        public final Builder columnNamesVisibility(String columnNamesVisibility) {
            this.columnNamesVisibility = columnNamesVisibility;
            return this;
        }

        @Override
        public final Builder columnNamesVisibility(Visibility columnNamesVisibility) {
            this.columnNamesVisibility(columnNamesVisibility == null ? null : columnNamesVisibility.toString());
            return this;
        }

        public final String getToggleButtonsVisibility() {
            return toggleButtonsVisibility;
        }

        public final void setToggleButtonsVisibility(String toggleButtonsVisibility) {
            this.toggleButtonsVisibility = toggleButtonsVisibility;
        }

        @Override
        public final Builder toggleButtonsVisibility(String toggleButtonsVisibility) {
            this.toggleButtonsVisibility = toggleButtonsVisibility;
            return this;
        }

        @Override
        public final Builder toggleButtonsVisibility(Visibility toggleButtonsVisibility) {
            this.toggleButtonsVisibility(toggleButtonsVisibility == null ? null : toggleButtonsVisibility.toString());
            return this;
        }

        public final TableCellStyle.Builder getColumnHeaderStyle() {
            return columnHeaderStyle != null ? columnHeaderStyle.toBuilder() : null;
        }

        public final void setColumnHeaderStyle(TableCellStyle.BuilderImpl columnHeaderStyle) {
            this.columnHeaderStyle = columnHeaderStyle != null ? columnHeaderStyle.build() : null;
        }

        @Override
        public final Builder columnHeaderStyle(TableCellStyle columnHeaderStyle) {
            this.columnHeaderStyle = columnHeaderStyle;
            return this;
        }

        public final TableCellStyle.Builder getRowHeaderStyle() {
            return rowHeaderStyle != null ? rowHeaderStyle.toBuilder() : null;
        }

        public final void setRowHeaderStyle(TableCellStyle.BuilderImpl rowHeaderStyle) {
            this.rowHeaderStyle = rowHeaderStyle != null ? rowHeaderStyle.build() : null;
        }

        @Override
        public final Builder rowHeaderStyle(TableCellStyle rowHeaderStyle) {
            this.rowHeaderStyle = rowHeaderStyle;
            return this;
        }

        public final TableCellStyle.Builder getCellStyle() {
            return cellStyle != null ? cellStyle.toBuilder() : null;
        }

        public final void setCellStyle(TableCellStyle.BuilderImpl cellStyle) {
            this.cellStyle = cellStyle != null ? cellStyle.build() : null;
        }

        @Override
        public final Builder cellStyle(TableCellStyle cellStyle) {
            this.cellStyle = cellStyle;
            return this;
        }

        public final TableCellStyle.Builder getRowFieldNamesStyle() {
            return rowFieldNamesStyle != null ? rowFieldNamesStyle.toBuilder() : null;
        }

        public final void setRowFieldNamesStyle(TableCellStyle.BuilderImpl rowFieldNamesStyle) {
            this.rowFieldNamesStyle = rowFieldNamesStyle != null ? rowFieldNamesStyle.build() : null;
        }

        @Override
        public final Builder rowFieldNamesStyle(TableCellStyle rowFieldNamesStyle) {
            this.rowFieldNamesStyle = rowFieldNamesStyle;
            return this;
        }

        public final RowAlternateColorOptions.Builder getRowAlternateColorOptions() {
            return rowAlternateColorOptions != null ? rowAlternateColorOptions.toBuilder() : null;
        }

        public final void setRowAlternateColorOptions(RowAlternateColorOptions.BuilderImpl rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions != null ? rowAlternateColorOptions.build() : null;
        }

        @Override
        public final Builder rowAlternateColorOptions(RowAlternateColorOptions rowAlternateColorOptions) {
            this.rowAlternateColorOptions = rowAlternateColorOptions;
            return this;
        }

        @Override
        public PivotTableOptions build() {
            return new PivotTableOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
