/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon QuickSight settings associated with your Amazon Web Services account.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AccountSettings implements SdkPojo, Serializable, ToCopyableBuilder<AccountSettings.Builder, AccountSettings> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountName").getter(getter(AccountSettings::accountName)).setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final SdkField<String> EDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Edition")
            .getter(getter(AccountSettings::editionAsString)).setter(setter(Builder::edition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()).build();

    private static final SdkField<String> DEFAULT_NAMESPACE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DefaultNamespace").getter(getter(AccountSettings::defaultNamespace))
            .setter(setter(Builder::defaultNamespace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultNamespace").build()).build();

    private static final SdkField<String> NOTIFICATION_EMAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NotificationEmail").getter(getter(AccountSettings::notificationEmail))
            .setter(setter(Builder::notificationEmail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationEmail").build()).build();

    private static final SdkField<Boolean> PUBLIC_SHARING_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("PublicSharingEnabled").getter(getter(AccountSettings::publicSharingEnabled))
            .setter(setter(Builder::publicSharingEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PublicSharingEnabled").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD,
            EDITION_FIELD, DEFAULT_NAMESPACE_FIELD, NOTIFICATION_EMAIL_FIELD, PUBLIC_SHARING_ENABLED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountName;

    private final String edition;

    private final String defaultNamespace;

    private final String notificationEmail;

    private final Boolean publicSharingEnabled;

    private AccountSettings(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.edition = builder.edition;
        this.defaultNamespace = builder.defaultNamespace;
        this.notificationEmail = builder.notificationEmail;
        this.publicSharingEnabled = builder.publicSharingEnabled;
    }

    /**
     * <p>
     * The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You
     * create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and it
     * appears only when users sign in.
     * </p>
     * 
     * @return The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services
     *         account. You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web
     *         Services and it appears only when users sign in.
     */
    public final String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard
     *         edition.
     * @see Edition
     */
    public final Edition edition() {
        return Edition.fromValue(edition);
    }

    /**
     * <p>
     * The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #edition} will
     * return {@link Edition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #editionAsString}.
     * </p>
     * 
     * @return The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard
     *         edition.
     * @see Edition
     */
    public final String editionAsString() {
        return edition;
    }

    /**
     * <p>
     * The default Amazon QuickSight namespace for your Amazon Web Services account.
     * </p>
     * 
     * @return The default Amazon QuickSight namespace for your Amazon Web Services account.
     */
    public final String defaultNamespace() {
        return defaultNamespace;
    }

    /**
     * <p>
     * The main notification email for your Amazon QuickSight subscription.
     * </p>
     * 
     * @return The main notification email for your Amazon QuickSight subscription.
     */
    public final String notificationEmail() {
        return notificationEmail;
    }

    /**
     * <p>
     * A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account. For more
     * information about turning on public sharing, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html"
     * >UpdatePublicSharingSettings</a>.
     * </p>
     * 
     * @return A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account. For
     *         more information about turning on public sharing, see <a
     *         href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html"
     *         >UpdatePublicSharingSettings</a>.
     */
    public final Boolean publicSharingEnabled() {
        return publicSharingEnabled;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(editionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(defaultNamespace());
        hashCode = 31 * hashCode + Objects.hashCode(notificationEmail());
        hashCode = 31 * hashCode + Objects.hashCode(publicSharingEnabled());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccountSettings)) {
            return false;
        }
        AccountSettings other = (AccountSettings) obj;
        return Objects.equals(accountName(), other.accountName()) && Objects.equals(editionAsString(), other.editionAsString())
                && Objects.equals(defaultNamespace(), other.defaultNamespace())
                && Objects.equals(notificationEmail(), other.notificationEmail())
                && Objects.equals(publicSharingEnabled(), other.publicSharingEnabled());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AccountSettings").add("AccountName", accountName()).add("Edition", editionAsString())
                .add("DefaultNamespace", defaultNamespace()).add("NotificationEmail", notificationEmail())
                .add("PublicSharingEnabled", publicSharingEnabled()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "Edition":
            return Optional.ofNullable(clazz.cast(editionAsString()));
        case "DefaultNamespace":
            return Optional.ofNullable(clazz.cast(defaultNamespace()));
        case "NotificationEmail":
            return Optional.ofNullable(clazz.cast(notificationEmail()));
        case "PublicSharingEnabled":
            return Optional.ofNullable(clazz.cast(publicSharingEnabled()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AccountSettings, T> g) {
        return obj -> g.apply((AccountSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AccountSettings> {
        /**
         * <p>
         * The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account.
         * You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and
         * it appears only when users sign in.
         * </p>
         * 
         * @param accountName
         *        The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services
         *        account. You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon
         *        Web Services and it appears only when users sign in.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
         * </p>
         * 
         * @param edition
         *        The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard
         *        edition.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(String edition);

        /**
         * <p>
         * The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
         * </p>
         * 
         * @param edition
         *        The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard
         *        edition.
         * @see Edition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Edition
         */
        Builder edition(Edition edition);

        /**
         * <p>
         * The default Amazon QuickSight namespace for your Amazon Web Services account.
         * </p>
         * 
         * @param defaultNamespace
         *        The default Amazon QuickSight namespace for your Amazon Web Services account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultNamespace(String defaultNamespace);

        /**
         * <p>
         * The main notification email for your Amazon QuickSight subscription.
         * </p>
         * 
         * @param notificationEmail
         *        The main notification email for your Amazon QuickSight subscription.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder notificationEmail(String notificationEmail);

        /**
         * <p>
         * A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account. For more
         * information about turning on public sharing, see <a
         * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html"
         * >UpdatePublicSharingSettings</a>.
         * </p>
         * 
         * @param publicSharingEnabled
         *        A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account.
         *        For more information about turning on public sharing, see <a href=
         *        "https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html"
         *        >UpdatePublicSharingSettings</a>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder publicSharingEnabled(Boolean publicSharingEnabled);
    }

    static final class BuilderImpl implements Builder {
        private String accountName;

        private String edition;

        private String defaultNamespace;

        private String notificationEmail;

        private Boolean publicSharingEnabled;

        private BuilderImpl() {
        }

        private BuilderImpl(AccountSettings model) {
            accountName(model.accountName);
            edition(model.edition);
            defaultNamespace(model.defaultNamespace);
            notificationEmail(model.notificationEmail);
            publicSharingEnabled(model.publicSharingEnabled);
        }

        public final String getAccountName() {
            return accountName;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final String getEdition() {
            return edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final String getDefaultNamespace() {
            return defaultNamespace;
        }

        public final void setDefaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
        }

        @Override
        public final Builder defaultNamespace(String defaultNamespace) {
            this.defaultNamespace = defaultNamespace;
            return this;
        }

        public final String getNotificationEmail() {
            return notificationEmail;
        }

        public final void setNotificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
        }

        @Override
        public final Builder notificationEmail(String notificationEmail) {
            this.notificationEmail = notificationEmail;
            return this;
        }

        public final Boolean getPublicSharingEnabled() {
            return publicSharingEnabled;
        }

        public final void setPublicSharingEnabled(Boolean publicSharingEnabled) {
            this.publicSharingEnabled = publicSharingEnabled;
        }

        @Override
        public final Builder publicSharingEnabled(Boolean publicSharingEnabled) {
            this.publicSharingEnabled = publicSharingEnabled;
            return this;
        }

        @Override
        public AccountSettings build() {
            return new AccountSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
