/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p/>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DashboardVisualPublishOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<DashboardVisualPublishOptions.Builder, DashboardVisualPublishOptions> {
    private static final SdkField<ExportHiddenFieldsOption> EXPORT_HIDDEN_FIELDS_OPTION_FIELD = SdkField
            .<ExportHiddenFieldsOption> builder(MarshallingType.SDK_POJO).memberName("ExportHiddenFieldsOption")
            .getter(getter(DashboardVisualPublishOptions::exportHiddenFieldsOption))
            .setter(setter(Builder::exportHiddenFieldsOption)).constructor(ExportHiddenFieldsOption::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExportHiddenFieldsOption").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(EXPORT_HIDDEN_FIELDS_OPTION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ExportHiddenFieldsOption exportHiddenFieldsOption;

    private DashboardVisualPublishOptions(BuilderImpl builder) {
        this.exportHiddenFieldsOption = builder.exportHiddenFieldsOption;
    }

    /**
     * <p/>
     * 
     * @return
     */
    public final ExportHiddenFieldsOption exportHiddenFieldsOption() {
        return exportHiddenFieldsOption;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(exportHiddenFieldsOption());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DashboardVisualPublishOptions)) {
            return false;
        }
        DashboardVisualPublishOptions other = (DashboardVisualPublishOptions) obj;
        return Objects.equals(exportHiddenFieldsOption(), other.exportHiddenFieldsOption());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DashboardVisualPublishOptions").add("ExportHiddenFieldsOption", exportHiddenFieldsOption())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ExportHiddenFieldsOption":
            return Optional.ofNullable(clazz.cast(exportHiddenFieldsOption()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DashboardVisualPublishOptions, T> g) {
        return obj -> g.apply((DashboardVisualPublishOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DashboardVisualPublishOptions> {
        /**
         * <p/>
         * 
         * @param exportHiddenFieldsOption
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportHiddenFieldsOption(ExportHiddenFieldsOption exportHiddenFieldsOption);

        /**
         * <p/>
         * This is a convenience method that creates an instance of the {@link ExportHiddenFieldsOption.Builder}
         * avoiding the need to create one manually via {@link ExportHiddenFieldsOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportHiddenFieldsOption.Builder#build()} is called immediately
         * and its result is passed to {@link #exportHiddenFieldsOption(ExportHiddenFieldsOption)}.
         * 
         * @param exportHiddenFieldsOption
         *        a consumer that will call methods on {@link ExportHiddenFieldsOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportHiddenFieldsOption(ExportHiddenFieldsOption)
         */
        default Builder exportHiddenFieldsOption(Consumer<ExportHiddenFieldsOption.Builder> exportHiddenFieldsOption) {
            return exportHiddenFieldsOption(ExportHiddenFieldsOption.builder().applyMutation(exportHiddenFieldsOption).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ExportHiddenFieldsOption exportHiddenFieldsOption;

        private BuilderImpl() {
        }

        private BuilderImpl(DashboardVisualPublishOptions model) {
            exportHiddenFieldsOption(model.exportHiddenFieldsOption);
        }

        public final ExportHiddenFieldsOption.Builder getExportHiddenFieldsOption() {
            return exportHiddenFieldsOption != null ? exportHiddenFieldsOption.toBuilder() : null;
        }

        public final void setExportHiddenFieldsOption(ExportHiddenFieldsOption.BuilderImpl exportHiddenFieldsOption) {
            this.exportHiddenFieldsOption = exportHiddenFieldsOption != null ? exportHiddenFieldsOption.build() : null;
        }

        @Override
        public final Builder exportHiddenFieldsOption(ExportHiddenFieldsOption exportHiddenFieldsOption) {
            this.exportHiddenFieldsOption = exportHiddenFieldsOption;
            return this;
        }

        @Override
        public DashboardVisualPublishOptions build() {
            return new DashboardVisualPublishOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
