/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.TableFieldURLConfiguration;
import software.amazon.awssdk.services.quicksight.model.Visibility;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TableFieldOption
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TableFieldOption> {
    private static final SdkField<String> FIELD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FieldId").getter(TableFieldOption.getter(TableFieldOption::fieldId)).setter(TableFieldOption.setter(Builder::fieldId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldId").build()}).build();
    private static final SdkField<String> WIDTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Width").getter(TableFieldOption.getter(TableFieldOption::width)).setter(TableFieldOption.setter(Builder::width)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Width").build()}).build();
    private static final SdkField<String> CUSTOM_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CustomLabel").getter(TableFieldOption.getter(TableFieldOption::customLabel)).setter(TableFieldOption.setter(Builder::customLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomLabel").build()}).build();
    private static final SdkField<String> VISIBILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Visibility").getter(TableFieldOption.getter(TableFieldOption::visibilityAsString)).setter(TableFieldOption.setter(Builder::visibility)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Visibility").build()}).build();
    private static final SdkField<TableFieldURLConfiguration> URL_STYLING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("URLStyling").getter(TableFieldOption.getter(TableFieldOption::urlStyling)).setter(TableFieldOption.setter(Builder::urlStyling)).constructor(TableFieldURLConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("URLStyling").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_ID_FIELD, WIDTH_FIELD, CUSTOM_LABEL_FIELD, VISIBILITY_FIELD, URL_STYLING_FIELD));
    private static final long serialVersionUID = 1L;
    private final String fieldId;
    private final String width;
    private final String customLabel;
    private final String visibility;
    private final TableFieldURLConfiguration urlStyling;

    private TableFieldOption(BuilderImpl builder) {
        this.fieldId = builder.fieldId;
        this.width = builder.width;
        this.customLabel = builder.customLabel;
        this.visibility = builder.visibility;
        this.urlStyling = builder.urlStyling;
    }

    public final String fieldId() {
        return this.fieldId;
    }

    public final String width() {
        return this.width;
    }

    public final String customLabel() {
        return this.customLabel;
    }

    public final Visibility visibility() {
        return Visibility.fromValue(this.visibility);
    }

    public final String visibilityAsString() {
        return this.visibility;
    }

    public final TableFieldURLConfiguration urlStyling() {
        return this.urlStyling;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldId());
        hashCode = 31 * hashCode + Objects.hashCode(this.width());
        hashCode = 31 * hashCode + Objects.hashCode(this.customLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.visibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.urlStyling());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldOption)) {
            return false;
        }
        TableFieldOption other = (TableFieldOption)obj;
        return Objects.equals(this.fieldId(), other.fieldId()) && Objects.equals(this.width(), other.width()) && Objects.equals(this.customLabel(), other.customLabel()) && Objects.equals(this.visibilityAsString(), other.visibilityAsString()) && Objects.equals(this.urlStyling(), other.urlStyling());
    }

    public final String toString() {
        return ToString.builder((String)"TableFieldOption").add("FieldId", (Object)this.fieldId()).add("Width", (Object)this.width()).add("CustomLabel", (Object)this.customLabel()).add("Visibility", (Object)this.visibilityAsString()).add("URLStyling", (Object)this.urlStyling()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "FieldId": {
                return Optional.ofNullable(clazz.cast(this.fieldId()));
            }
            case "Width": {
                return Optional.ofNullable(clazz.cast(this.width()));
            }
            case "CustomLabel": {
                return Optional.ofNullable(clazz.cast(this.customLabel()));
            }
            case "Visibility": {
                return Optional.ofNullable(clazz.cast(this.visibilityAsString()));
            }
            case "URLStyling": {
                return Optional.ofNullable(clazz.cast(this.urlStyling()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableFieldOption, T> g) {
        return obj -> g.apply((TableFieldOption)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String fieldId;
        private String width;
        private String customLabel;
        private String visibility;
        private TableFieldURLConfiguration urlStyling;

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldOption model) {
            this.fieldId(model.fieldId);
            this.width(model.width);
            this.customLabel(model.customLabel);
            this.visibility(model.visibility);
            this.urlStyling(model.urlStyling);
        }

        public final String getFieldId() {
            return this.fieldId;
        }

        public final void setFieldId(String fieldId) {
            this.fieldId = fieldId;
        }

        @Override
        public final Builder fieldId(String fieldId) {
            this.fieldId = fieldId;
            return this;
        }

        public final String getWidth() {
            return this.width;
        }

        public final void setWidth(String width) {
            this.width = width;
        }

        @Override
        public final Builder width(String width) {
            this.width = width;
            return this;
        }

        public final String getCustomLabel() {
            return this.customLabel;
        }

        public final void setCustomLabel(String customLabel) {
            this.customLabel = customLabel;
        }

        @Override
        public final Builder customLabel(String customLabel) {
            this.customLabel = customLabel;
            return this;
        }

        public final String getVisibility() {
            return this.visibility;
        }

        public final void setVisibility(String visibility) {
            this.visibility = visibility;
        }

        @Override
        public final Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        @Override
        public final Builder visibility(Visibility visibility) {
            this.visibility(visibility == null ? null : visibility.toString());
            return this;
        }

        public final TableFieldURLConfiguration.Builder getUrlStyling() {
            return this.urlStyling != null ? this.urlStyling.toBuilder() : null;
        }

        public final void setUrlStyling(TableFieldURLConfiguration.BuilderImpl urlStyling) {
            this.urlStyling = urlStyling != null ? urlStyling.build() : null;
        }

        @Override
        public final Builder urlStyling(TableFieldURLConfiguration urlStyling) {
            this.urlStyling = urlStyling;
            return this;
        }

        public TableFieldOption build() {
            return new TableFieldOption(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TableFieldOption> {
        public Builder fieldId(String var1);

        public Builder width(String var1);

        public Builder customLabel(String var1);

        public Builder visibility(String var1);

        public Builder visibility(Visibility var1);

        public Builder urlStyling(TableFieldURLConfiguration var1);

        default public Builder urlStyling(Consumer<TableFieldURLConfiguration.Builder> urlStyling) {
            return this.urlStyling((TableFieldURLConfiguration)((TableFieldURLConfiguration.Builder)TableFieldURLConfiguration.builder().applyMutation(urlStyling)).build());
        }
    }
}

