/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration of selected fields in the<code>CustomActionFilterOperation</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FilterOperationSelectedFieldsConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FilterOperationSelectedFieldsConfiguration.Builder, FilterOperationSelectedFieldsConfiguration> {
    private static final SdkField<List<String>> SELECTED_FIELDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SelectedFields")
            .getter(getter(FilterOperationSelectedFieldsConfiguration::selectedFields))
            .setter(setter(Builder::selectedFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> SELECTED_FIELD_OPTIONS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectedFieldOptions")
            .getter(getter(FilterOperationSelectedFieldsConfiguration::selectedFieldOptionsAsString))
            .setter(setter(Builder::selectedFieldOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFieldOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_FIELDS_FIELD,
            SELECTED_FIELD_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> selectedFields;

    private final String selectedFieldOptions;

    private FilterOperationSelectedFieldsConfiguration(BuilderImpl builder) {
        this.selectedFields = builder.selectedFields;
        this.selectedFieldOptions = builder.selectedFieldOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedFields() {
        return selectedFields != null && !(selectedFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Chooses the fields that are filtered in <code>CustomActionFilterOperation</code>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedFields} method.
     * </p>
     * 
     * @return Chooses the fields that are filtered in <code>CustomActionFilterOperation</code>.
     */
    public final List<String> selectedFields() {
        return selectedFields;
    }

    /**
     * <p>
     * A structure that contains the options that choose which fields are filtered in the
     * <code>CustomActionFilterOperation</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectedFieldOptions} will return {@link SelectedFieldOptions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #selectedFieldOptionsAsString}.
     * </p>
     * 
     * @return A structure that contains the options that choose which fields are filtered in the
     *         <code>CustomActionFilterOperation</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
     *         </p>
     *         </li>
     * @see SelectedFieldOptions
     */
    public final SelectedFieldOptions selectedFieldOptions() {
        return SelectedFieldOptions.fromValue(selectedFieldOptions);
    }

    /**
     * <p>
     * A structure that contains the options that choose which fields are filtered in the
     * <code>CustomActionFilterOperation</code>.
     * </p>
     * <p>
     * Valid values are defined as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #selectedFieldOptions} will return {@link SelectedFieldOptions#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #selectedFieldOptionsAsString}.
     * </p>
     * 
     * @return A structure that contains the options that choose which fields are filtered in the
     *         <code>CustomActionFilterOperation</code>.</p>
     *         <p>
     *         Valid values are defined as follows:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
     *         </p>
     *         </li>
     * @see SelectedFieldOptions
     */
    public final String selectedFieldOptionsAsString() {
        return selectedFieldOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedFields() ? selectedFields() : null);
        hashCode = 31 * hashCode + Objects.hashCode(selectedFieldOptionsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FilterOperationSelectedFieldsConfiguration)) {
            return false;
        }
        FilterOperationSelectedFieldsConfiguration other = (FilterOperationSelectedFieldsConfiguration) obj;
        return hasSelectedFields() == other.hasSelectedFields() && Objects.equals(selectedFields(), other.selectedFields())
                && Objects.equals(selectedFieldOptionsAsString(), other.selectedFieldOptionsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FilterOperationSelectedFieldsConfiguration")
                .add("SelectedFields", hasSelectedFields() ? selectedFields() : null)
                .add("SelectedFieldOptions", selectedFieldOptionsAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedFields":
            return Optional.ofNullable(clazz.cast(selectedFields()));
        case "SelectedFieldOptions":
            return Optional.ofNullable(clazz.cast(selectedFieldOptionsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FilterOperationSelectedFieldsConfiguration, T> g) {
        return obj -> g.apply((FilterOperationSelectedFieldsConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FilterOperationSelectedFieldsConfiguration> {
        /**
         * <p>
         * Chooses the fields that are filtered in <code>CustomActionFilterOperation</code>.
         * </p>
         * 
         * @param selectedFields
         *        Chooses the fields that are filtered in <code>CustomActionFilterOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFields(Collection<String> selectedFields);

        /**
         * <p>
         * Chooses the fields that are filtered in <code>CustomActionFilterOperation</code>.
         * </p>
         * 
         * @param selectedFields
         *        Chooses the fields that are filtered in <code>CustomActionFilterOperation</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFields(String... selectedFields);

        /**
         * <p>
         * A structure that contains the options that choose which fields are filtered in the
         * <code>CustomActionFilterOperation</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectedFieldOptions
         *        A structure that contains the options that choose which fields are filtered in the
         *        <code>CustomActionFilterOperation</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
         *        </p>
         *        </li>
         * @see SelectedFieldOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectedFieldOptions
         */
        Builder selectedFieldOptions(String selectedFieldOptions);

        /**
         * <p>
         * A structure that contains the options that choose which fields are filtered in the
         * <code>CustomActionFilterOperation</code>.
         * </p>
         * <p>
         * Valid values are defined as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectedFieldOptions
         *        A structure that contains the options that choose which fields are filtered in the
         *        <code>CustomActionFilterOperation</code>.</p>
         *        <p>
         *        Valid values are defined as follows:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_FIELDS</code>: Applies the filter operation to all fields.
         *        </p>
         *        </li>
         * @see SelectedFieldOptions
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SelectedFieldOptions
         */
        Builder selectedFieldOptions(SelectedFieldOptions selectedFieldOptions);
    }

    static final class BuilderImpl implements Builder {
        private List<String> selectedFields = DefaultSdkAutoConstructList.getInstance();

        private String selectedFieldOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(FilterOperationSelectedFieldsConfiguration model) {
            selectedFields(model.selectedFields);
            selectedFieldOptions(model.selectedFieldOptions);
        }

        public final Collection<String> getSelectedFields() {
            if (selectedFields instanceof SdkAutoConstructList) {
                return null;
            }
            return selectedFields;
        }

        public final void setSelectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldListCopier.copy(selectedFields);
        }

        @Override
        public final Builder selectedFields(Collection<String> selectedFields) {
            this.selectedFields = SelectedFieldListCopier.copy(selectedFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFields(String... selectedFields) {
            selectedFields(Arrays.asList(selectedFields));
            return this;
        }

        public final String getSelectedFieldOptions() {
            return selectedFieldOptions;
        }

        public final void setSelectedFieldOptions(String selectedFieldOptions) {
            this.selectedFieldOptions = selectedFieldOptions;
        }

        @Override
        public final Builder selectedFieldOptions(String selectedFieldOptions) {
            this.selectedFieldOptions = selectedFieldOptions;
            return this;
        }

        @Override
        public final Builder selectedFieldOptions(SelectedFieldOptions selectedFieldOptions) {
            this.selectedFieldOptions(selectedFieldOptions == null ? null : selectedFieldOptions.toString());
            return this;
        }

        @Override
        public FilterOperationSelectedFieldsConfiguration build() {
            return new FilterOperationSelectedFieldsConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
