/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field well configuration of a scatter plot.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScatterPlotFieldWells implements SdkPojo, Serializable,
        ToCopyableBuilder<ScatterPlotFieldWells.Builder, ScatterPlotFieldWells> {
    private static final SdkField<ScatterPlotCategoricallyAggregatedFieldWells> SCATTER_PLOT_CATEGORICALLY_AGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<ScatterPlotCategoricallyAggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("ScatterPlotCategoricallyAggregatedFieldWells")
            .getter(getter(ScatterPlotFieldWells::scatterPlotCategoricallyAggregatedFieldWells))
            .setter(setter(Builder::scatterPlotCategoricallyAggregatedFieldWells))
            .constructor(ScatterPlotCategoricallyAggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("ScatterPlotCategoricallyAggregatedFieldWells").build()).build();

    private static final SdkField<ScatterPlotUnaggregatedFieldWells> SCATTER_PLOT_UNAGGREGATED_FIELD_WELLS_FIELD = SdkField
            .<ScatterPlotUnaggregatedFieldWells> builder(MarshallingType.SDK_POJO)
            .memberName("ScatterPlotUnaggregatedFieldWells")
            .getter(getter(ScatterPlotFieldWells::scatterPlotUnaggregatedFieldWells))
            .setter(setter(Builder::scatterPlotUnaggregatedFieldWells))
            .constructor(ScatterPlotUnaggregatedFieldWells::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScatterPlotUnaggregatedFieldWells")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            SCATTER_PLOT_CATEGORICALLY_AGGREGATED_FIELD_WELLS_FIELD, SCATTER_PLOT_UNAGGREGATED_FIELD_WELLS_FIELD));

    private static final long serialVersionUID = 1L;

    private final ScatterPlotCategoricallyAggregatedFieldWells scatterPlotCategoricallyAggregatedFieldWells;

    private final ScatterPlotUnaggregatedFieldWells scatterPlotUnaggregatedFieldWells;

    private ScatterPlotFieldWells(BuilderImpl builder) {
        this.scatterPlotCategoricallyAggregatedFieldWells = builder.scatterPlotCategoricallyAggregatedFieldWells;
        this.scatterPlotUnaggregatedFieldWells = builder.scatterPlotUnaggregatedFieldWells;
    }

    /**
     * <p>
     * The aggregated field wells of a scatter plot. Scatter plots that have a field in the category (group/color) field
     * will have aggregated field wells. The x and y-axes of these scatter plots are aggregated by category.
     * </p>
     * 
     * @return The aggregated field wells of a scatter plot. Scatter plots that have a field in the category
     *         (group/color) field will have aggregated field wells. The x and y-axes of these scatter plots are
     *         aggregated by category.
     */
    public final ScatterPlotCategoricallyAggregatedFieldWells scatterPlotCategoricallyAggregatedFieldWells() {
        return scatterPlotCategoricallyAggregatedFieldWells;
    }

    /**
     * <p>
     * The unaggregated field wells of a scatter plot. Scatter plots without a category field well have unaggregated
     * field wells. The x and y-axes of these scatter plots are unaggregated.
     * </p>
     * 
     * @return The unaggregated field wells of a scatter plot. Scatter plots without a category field well have
     *         unaggregated field wells. The x and y-axes of these scatter plots are unaggregated.
     */
    public final ScatterPlotUnaggregatedFieldWells scatterPlotUnaggregatedFieldWells() {
        return scatterPlotUnaggregatedFieldWells;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(scatterPlotCategoricallyAggregatedFieldWells());
        hashCode = 31 * hashCode + Objects.hashCode(scatterPlotUnaggregatedFieldWells());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScatterPlotFieldWells)) {
            return false;
        }
        ScatterPlotFieldWells other = (ScatterPlotFieldWells) obj;
        return Objects.equals(scatterPlotCategoricallyAggregatedFieldWells(),
                other.scatterPlotCategoricallyAggregatedFieldWells())
                && Objects.equals(scatterPlotUnaggregatedFieldWells(), other.scatterPlotUnaggregatedFieldWells());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScatterPlotFieldWells")
                .add("ScatterPlotCategoricallyAggregatedFieldWells", scatterPlotCategoricallyAggregatedFieldWells())
                .add("ScatterPlotUnaggregatedFieldWells", scatterPlotUnaggregatedFieldWells()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ScatterPlotCategoricallyAggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(scatterPlotCategoricallyAggregatedFieldWells()));
        case "ScatterPlotUnaggregatedFieldWells":
            return Optional.ofNullable(clazz.cast(scatterPlotUnaggregatedFieldWells()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ScatterPlotFieldWells, T> g) {
        return obj -> g.apply((ScatterPlotFieldWells) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScatterPlotFieldWells> {
        /**
         * <p>
         * The aggregated field wells of a scatter plot. Scatter plots that have a field in the category (group/color)
         * field will have aggregated field wells. The x and y-axes of these scatter plots are aggregated by category.
         * </p>
         * 
         * @param scatterPlotCategoricallyAggregatedFieldWells
         *        The aggregated field wells of a scatter plot. Scatter plots that have a field in the category
         *        (group/color) field will have aggregated field wells. The x and y-axes of these scatter plots are
         *        aggregated by category.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scatterPlotCategoricallyAggregatedFieldWells(
                ScatterPlotCategoricallyAggregatedFieldWells scatterPlotCategoricallyAggregatedFieldWells);

        /**
         * <p>
         * The aggregated field wells of a scatter plot. Scatter plots that have a field in the category (group/color)
         * field will have aggregated field wells. The x and y-axes of these scatter plots are aggregated by category.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ScatterPlotCategoricallyAggregatedFieldWells.Builder} avoiding the need to create one manually via
         * {@link ScatterPlotCategoricallyAggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScatterPlotCategoricallyAggregatedFieldWells.Builder#build()} is
         * called immediately and its result is passed to
         * {@link #scatterPlotCategoricallyAggregatedFieldWells(ScatterPlotCategoricallyAggregatedFieldWells)}.
         * 
         * @param scatterPlotCategoricallyAggregatedFieldWells
         *        a consumer that will call methods on {@link ScatterPlotCategoricallyAggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scatterPlotCategoricallyAggregatedFieldWells(ScatterPlotCategoricallyAggregatedFieldWells)
         */
        default Builder scatterPlotCategoricallyAggregatedFieldWells(
                Consumer<ScatterPlotCategoricallyAggregatedFieldWells.Builder> scatterPlotCategoricallyAggregatedFieldWells) {
            return scatterPlotCategoricallyAggregatedFieldWells(ScatterPlotCategoricallyAggregatedFieldWells.builder()
                    .applyMutation(scatterPlotCategoricallyAggregatedFieldWells).build());
        }

        /**
         * <p>
         * The unaggregated field wells of a scatter plot. Scatter plots without a category field well have unaggregated
         * field wells. The x and y-axes of these scatter plots are unaggregated.
         * </p>
         * 
         * @param scatterPlotUnaggregatedFieldWells
         *        The unaggregated field wells of a scatter plot. Scatter plots without a category field well have
         *        unaggregated field wells. The x and y-axes of these scatter plots are unaggregated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder scatterPlotUnaggregatedFieldWells(ScatterPlotUnaggregatedFieldWells scatterPlotUnaggregatedFieldWells);

        /**
         * <p>
         * The unaggregated field wells of a scatter plot. Scatter plots without a category field well have unaggregated
         * field wells. The x and y-axes of these scatter plots are unaggregated.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ScatterPlotUnaggregatedFieldWells.Builder} avoiding the need to create one manually via
         * {@link ScatterPlotUnaggregatedFieldWells#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ScatterPlotUnaggregatedFieldWells.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #scatterPlotUnaggregatedFieldWells(ScatterPlotUnaggregatedFieldWells)}.
         * 
         * @param scatterPlotUnaggregatedFieldWells
         *        a consumer that will call methods on {@link ScatterPlotUnaggregatedFieldWells.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #scatterPlotUnaggregatedFieldWells(ScatterPlotUnaggregatedFieldWells)
         */
        default Builder scatterPlotUnaggregatedFieldWells(
                Consumer<ScatterPlotUnaggregatedFieldWells.Builder> scatterPlotUnaggregatedFieldWells) {
            return scatterPlotUnaggregatedFieldWells(ScatterPlotUnaggregatedFieldWells.builder()
                    .applyMutation(scatterPlotUnaggregatedFieldWells).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ScatterPlotCategoricallyAggregatedFieldWells scatterPlotCategoricallyAggregatedFieldWells;

        private ScatterPlotUnaggregatedFieldWells scatterPlotUnaggregatedFieldWells;

        private BuilderImpl() {
        }

        private BuilderImpl(ScatterPlotFieldWells model) {
            scatterPlotCategoricallyAggregatedFieldWells(model.scatterPlotCategoricallyAggregatedFieldWells);
            scatterPlotUnaggregatedFieldWells(model.scatterPlotUnaggregatedFieldWells);
        }

        public final ScatterPlotCategoricallyAggregatedFieldWells.Builder getScatterPlotCategoricallyAggregatedFieldWells() {
            return scatterPlotCategoricallyAggregatedFieldWells != null ? scatterPlotCategoricallyAggregatedFieldWells
                    .toBuilder() : null;
        }

        public final void setScatterPlotCategoricallyAggregatedFieldWells(
                ScatterPlotCategoricallyAggregatedFieldWells.BuilderImpl scatterPlotCategoricallyAggregatedFieldWells) {
            this.scatterPlotCategoricallyAggregatedFieldWells = scatterPlotCategoricallyAggregatedFieldWells != null ? scatterPlotCategoricallyAggregatedFieldWells
                    .build() : null;
        }

        @Override
        public final Builder scatterPlotCategoricallyAggregatedFieldWells(
                ScatterPlotCategoricallyAggregatedFieldWells scatterPlotCategoricallyAggregatedFieldWells) {
            this.scatterPlotCategoricallyAggregatedFieldWells = scatterPlotCategoricallyAggregatedFieldWells;
            return this;
        }

        public final ScatterPlotUnaggregatedFieldWells.Builder getScatterPlotUnaggregatedFieldWells() {
            return scatterPlotUnaggregatedFieldWells != null ? scatterPlotUnaggregatedFieldWells.toBuilder() : null;
        }

        public final void setScatterPlotUnaggregatedFieldWells(
                ScatterPlotUnaggregatedFieldWells.BuilderImpl scatterPlotUnaggregatedFieldWells) {
            this.scatterPlotUnaggregatedFieldWells = scatterPlotUnaggregatedFieldWells != null ? scatterPlotUnaggregatedFieldWells
                    .build() : null;
        }

        @Override
        public final Builder scatterPlotUnaggregatedFieldWells(ScatterPlotUnaggregatedFieldWells scatterPlotUnaggregatedFieldWells) {
            this.scatterPlotUnaggregatedFieldWells = scatterPlotUnaggregatedFieldWells;
            return this;
        }

        @Override
        public ScatterPlotFieldWells build() {
            return new ScatterPlotFieldWells(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
