/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A parameter declaration for the <code>String</code> data type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StringParameterDeclaration implements SdkPojo, Serializable,
        ToCopyableBuilder<StringParameterDeclaration.Builder, StringParameterDeclaration> {
    private static final SdkField<String> PARAMETER_VALUE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParameterValueType").getter(getter(StringParameterDeclaration::parameterValueTypeAsString))
            .setter(setter(Builder::parameterValueType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValueType").build())
            .build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(StringParameterDeclaration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<StringDefaultValues> DEFAULT_VALUES_FIELD = SdkField
            .<StringDefaultValues> builder(MarshallingType.SDK_POJO).memberName("DefaultValues")
            .getter(getter(StringParameterDeclaration::defaultValues)).setter(setter(Builder::defaultValues))
            .constructor(StringDefaultValues::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()).build();

    private static final SdkField<StringValueWhenUnsetConfiguration> VALUE_WHEN_UNSET_FIELD = SdkField
            .<StringValueWhenUnsetConfiguration> builder(MarshallingType.SDK_POJO).memberName("ValueWhenUnset")
            .getter(getter(StringParameterDeclaration::valueWhenUnset)).setter(setter(Builder::valueWhenUnset))
            .constructor(StringValueWhenUnsetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueWhenUnset").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_VALUE_TYPE_FIELD,
            NAME_FIELD, DEFAULT_VALUES_FIELD, VALUE_WHEN_UNSET_FIELD));

    private static final long serialVersionUID = 1L;

    private final String parameterValueType;

    private final String name;

    private final StringDefaultValues defaultValues;

    private final StringValueWhenUnsetConfiguration valueWhenUnset;

    private StringParameterDeclaration(BuilderImpl builder) {
        this.parameterValueType = builder.parameterValueType;
        this.name = builder.name;
        this.defaultValues = builder.defaultValues;
        this.valueWhenUnset = builder.valueWhenUnset;
    }

    /**
     * <p>
     * The value type determines whether the parameter is a single-value or multi-value parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parameterValueType} will return {@link ParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #parameterValueTypeAsString}.
     * </p>
     * 
     * @return The value type determines whether the parameter is a single-value or multi-value parameter.
     * @see ParameterValueType
     */
    public final ParameterValueType parameterValueType() {
        return ParameterValueType.fromValue(parameterValueType);
    }

    /**
     * <p>
     * The value type determines whether the parameter is a single-value or multi-value parameter.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #parameterValueType} will return {@link ParameterValueType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #parameterValueTypeAsString}.
     * </p>
     * 
     * @return The value type determines whether the parameter is a single-value or multi-value parameter.
     * @see ParameterValueType
     */
    public final String parameterValueTypeAsString() {
        return parameterValueType;
    }

    /**
     * <p>
     * The name of the parameter that is being declared.
     * </p>
     * 
     * @return The name of the parameter that is being declared.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default value
     * can be provided.
     * </p>
     * 
     * @return The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default
     *         value can be provided.
     */
    public final StringDefaultValues defaultValues() {
        return defaultValues;
    }

    /**
     * <p>
     * The configuration that defines the default value of a <code>String</code> parameter when a value has not been
     * set.
     * </p>
     * 
     * @return The configuration that defines the default value of a <code>String</code> parameter when a value has not
     *         been set.
     */
    public final StringValueWhenUnsetConfiguration valueWhenUnset() {
        return valueWhenUnset;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(parameterValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(defaultValues());
        hashCode = 31 * hashCode + Objects.hashCode(valueWhenUnset());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringParameterDeclaration)) {
            return false;
        }
        StringParameterDeclaration other = (StringParameterDeclaration) obj;
        return Objects.equals(parameterValueTypeAsString(), other.parameterValueTypeAsString())
                && Objects.equals(name(), other.name()) && Objects.equals(defaultValues(), other.defaultValues())
                && Objects.equals(valueWhenUnset(), other.valueWhenUnset());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StringParameterDeclaration").add("ParameterValueType", parameterValueTypeAsString())
                .add("Name", name()).add("DefaultValues", defaultValues()).add("ValueWhenUnset", valueWhenUnset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ParameterValueType":
            return Optional.ofNullable(clazz.cast(parameterValueTypeAsString()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DefaultValues":
            return Optional.ofNullable(clazz.cast(defaultValues()));
        case "ValueWhenUnset":
            return Optional.ofNullable(clazz.cast(valueWhenUnset()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringParameterDeclaration, T> g) {
        return obj -> g.apply((StringParameterDeclaration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StringParameterDeclaration> {
        /**
         * <p>
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         * </p>
         * 
         * @param parameterValueType
         *        The value type determines whether the parameter is a single-value or multi-value parameter.
         * @see ParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterValueType
         */
        Builder parameterValueType(String parameterValueType);

        /**
         * <p>
         * The value type determines whether the parameter is a single-value or multi-value parameter.
         * </p>
         * 
         * @param parameterValueType
         *        The value type determines whether the parameter is a single-value or multi-value parameter.
         * @see ParameterValueType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ParameterValueType
         */
        Builder parameterValueType(ParameterValueType parameterValueType);

        /**
         * <p>
         * The name of the parameter that is being declared.
         * </p>
         * 
         * @param name
         *        The name of the parameter that is being declared.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default
         * value can be provided.
         * </p>
         * 
         * @param defaultValues
         *        The default values of a parameter. If the parameter is a single-value parameter, a maximum of one
         *        default value can be provided.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder defaultValues(StringDefaultValues defaultValues);

        /**
         * <p>
         * The default values of a parameter. If the parameter is a single-value parameter, a maximum of one default
         * value can be provided.
         * </p>
         * This is a convenience method that creates an instance of the {@link StringDefaultValues.Builder} avoiding the
         * need to create one manually via {@link StringDefaultValues#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringDefaultValues.Builder#build()} is called immediately and
         * its result is passed to {@link #defaultValues(StringDefaultValues)}.
         * 
         * @param defaultValues
         *        a consumer that will call methods on {@link StringDefaultValues.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #defaultValues(StringDefaultValues)
         */
        default Builder defaultValues(Consumer<StringDefaultValues.Builder> defaultValues) {
            return defaultValues(StringDefaultValues.builder().applyMutation(defaultValues).build());
        }

        /**
         * <p>
         * The configuration that defines the default value of a <code>String</code> parameter when a value has not been
         * set.
         * </p>
         * 
         * @param valueWhenUnset
         *        The configuration that defines the default value of a <code>String</code> parameter when a value has
         *        not been set.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder valueWhenUnset(StringValueWhenUnsetConfiguration valueWhenUnset);

        /**
         * <p>
         * The configuration that defines the default value of a <code>String</code> parameter when a value has not been
         * set.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link StringValueWhenUnsetConfiguration.Builder} avoiding the need to create one manually via
         * {@link StringValueWhenUnsetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link StringValueWhenUnsetConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #valueWhenUnset(StringValueWhenUnsetConfiguration)}.
         * 
         * @param valueWhenUnset
         *        a consumer that will call methods on {@link StringValueWhenUnsetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #valueWhenUnset(StringValueWhenUnsetConfiguration)
         */
        default Builder valueWhenUnset(Consumer<StringValueWhenUnsetConfiguration.Builder> valueWhenUnset) {
            return valueWhenUnset(StringValueWhenUnsetConfiguration.builder().applyMutation(valueWhenUnset).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String parameterValueType;

        private String name;

        private StringDefaultValues defaultValues;

        private StringValueWhenUnsetConfiguration valueWhenUnset;

        private BuilderImpl() {
        }

        private BuilderImpl(StringParameterDeclaration model) {
            parameterValueType(model.parameterValueType);
            name(model.name);
            defaultValues(model.defaultValues);
            valueWhenUnset(model.valueWhenUnset);
        }

        public final String getParameterValueType() {
            return parameterValueType;
        }

        public final void setParameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
        }

        @Override
        public final Builder parameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
            return this;
        }

        @Override
        public final Builder parameterValueType(ParameterValueType parameterValueType) {
            this.parameterValueType(parameterValueType == null ? null : parameterValueType.toString());
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StringDefaultValues.Builder getDefaultValues() {
            return defaultValues != null ? defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(StringDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(StringDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        public final StringValueWhenUnsetConfiguration.Builder getValueWhenUnset() {
            return valueWhenUnset != null ? valueWhenUnset.toBuilder() : null;
        }

        public final void setValueWhenUnset(StringValueWhenUnsetConfiguration.BuilderImpl valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset != null ? valueWhenUnset.build() : null;
        }

        @Override
        public final Builder valueWhenUnset(StringValueWhenUnsetConfiguration valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset;
            return this;
        }

        @Override
        public StringParameterDeclaration build() {
            return new StringParameterDeclaration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
