/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The display options of a control.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TextFieldControlDisplayOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TextFieldControlDisplayOptions.Builder, TextFieldControlDisplayOptions> {
    private static final SdkField<LabelOptions> TITLE_OPTIONS_FIELD = SdkField.<LabelOptions> builder(MarshallingType.SDK_POJO)
            .memberName("TitleOptions").getter(getter(TextFieldControlDisplayOptions::titleOptions))
            .setter(setter(Builder::titleOptions)).constructor(LabelOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleOptions").build()).build();

    private static final SdkField<TextControlPlaceholderOptions> PLACEHOLDER_OPTIONS_FIELD = SdkField
            .<TextControlPlaceholderOptions> builder(MarshallingType.SDK_POJO).memberName("PlaceholderOptions")
            .getter(getter(TextFieldControlDisplayOptions::placeholderOptions)).setter(setter(Builder::placeholderOptions))
            .constructor(TextControlPlaceholderOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PlaceholderOptions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TITLE_OPTIONS_FIELD,
            PLACEHOLDER_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LabelOptions titleOptions;

    private final TextControlPlaceholderOptions placeholderOptions;

    private TextFieldControlDisplayOptions(BuilderImpl builder) {
        this.titleOptions = builder.titleOptions;
        this.placeholderOptions = builder.placeholderOptions;
    }

    /**
     * <p>
     * The options to configure the title visibility, name, and font size.
     * </p>
     * 
     * @return The options to configure the title visibility, name, and font size.
     */
    public final LabelOptions titleOptions() {
        return titleOptions;
    }

    /**
     * <p>
     * The configuration of the placeholder options in a text field control.
     * </p>
     * 
     * @return The configuration of the placeholder options in a text field control.
     */
    public final TextControlPlaceholderOptions placeholderOptions() {
        return placeholderOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(titleOptions());
        hashCode = 31 * hashCode + Objects.hashCode(placeholderOptions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TextFieldControlDisplayOptions)) {
            return false;
        }
        TextFieldControlDisplayOptions other = (TextFieldControlDisplayOptions) obj;
        return Objects.equals(titleOptions(), other.titleOptions())
                && Objects.equals(placeholderOptions(), other.placeholderOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TextFieldControlDisplayOptions").add("TitleOptions", titleOptions())
                .add("PlaceholderOptions", placeholderOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TitleOptions":
            return Optional.ofNullable(clazz.cast(titleOptions()));
        case "PlaceholderOptions":
            return Optional.ofNullable(clazz.cast(placeholderOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TextFieldControlDisplayOptions, T> g) {
        return obj -> g.apply((TextFieldControlDisplayOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TextFieldControlDisplayOptions> {
        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * 
         * @param titleOptions
         *        The options to configure the title visibility, name, and font size.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleOptions(LabelOptions titleOptions);

        /**
         * <p>
         * The options to configure the title visibility, name, and font size.
         * </p>
         * This is a convenience method that creates an instance of the {@link LabelOptions.Builder} avoiding the need
         * to create one manually via {@link LabelOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LabelOptions.Builder#build()} is called immediately and its
         * result is passed to {@link #titleOptions(LabelOptions)}.
         * 
         * @param titleOptions
         *        a consumer that will call methods on {@link LabelOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #titleOptions(LabelOptions)
         */
        default Builder titleOptions(Consumer<LabelOptions.Builder> titleOptions) {
            return titleOptions(LabelOptions.builder().applyMutation(titleOptions).build());
        }

        /**
         * <p>
         * The configuration of the placeholder options in a text field control.
         * </p>
         * 
         * @param placeholderOptions
         *        The configuration of the placeholder options in a text field control.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder placeholderOptions(TextControlPlaceholderOptions placeholderOptions);

        /**
         * <p>
         * The configuration of the placeholder options in a text field control.
         * </p>
         * This is a convenience method that creates an instance of the {@link TextControlPlaceholderOptions.Builder}
         * avoiding the need to create one manually via {@link TextControlPlaceholderOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TextControlPlaceholderOptions.Builder#build()} is called
         * immediately and its result is passed to {@link #placeholderOptions(TextControlPlaceholderOptions)}.
         * 
         * @param placeholderOptions
         *        a consumer that will call methods on {@link TextControlPlaceholderOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #placeholderOptions(TextControlPlaceholderOptions)
         */
        default Builder placeholderOptions(Consumer<TextControlPlaceholderOptions.Builder> placeholderOptions) {
            return placeholderOptions(TextControlPlaceholderOptions.builder().applyMutation(placeholderOptions).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LabelOptions titleOptions;

        private TextControlPlaceholderOptions placeholderOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(TextFieldControlDisplayOptions model) {
            titleOptions(model.titleOptions);
            placeholderOptions(model.placeholderOptions);
        }

        public final LabelOptions.Builder getTitleOptions() {
            return titleOptions != null ? titleOptions.toBuilder() : null;
        }

        public final void setTitleOptions(LabelOptions.BuilderImpl titleOptions) {
            this.titleOptions = titleOptions != null ? titleOptions.build() : null;
        }

        @Override
        public final Builder titleOptions(LabelOptions titleOptions) {
            this.titleOptions = titleOptions;
            return this;
        }

        public final TextControlPlaceholderOptions.Builder getPlaceholderOptions() {
            return placeholderOptions != null ? placeholderOptions.toBuilder() : null;
        }

        public final void setPlaceholderOptions(TextControlPlaceholderOptions.BuilderImpl placeholderOptions) {
            this.placeholderOptions = placeholderOptions != null ? placeholderOptions.build() : null;
        }

        @Override
        public final Builder placeholderOptions(TextControlPlaceholderOptions placeholderOptions) {
            this.placeholderOptions = placeholderOptions;
            return this;
        }

        @Override
        public TextFieldControlDisplayOptions build() {
            return new TextFieldControlDisplayOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
