/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A data transformation on a logical table. This is a variant type structure. For this structure to be valid, only one
 * of the attributes can be non-null.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransformOperation implements SdkPojo, Serializable,
        ToCopyableBuilder<TransformOperation.Builder, TransformOperation> {
    private static final SdkField<ProjectOperation> PROJECT_OPERATION_FIELD = SdkField
            .<ProjectOperation> builder(MarshallingType.SDK_POJO).memberName("ProjectOperation")
            .getter(getter(TransformOperation::projectOperation)).setter(setter(Builder::projectOperation))
            .constructor(ProjectOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProjectOperation").build()).build();

    private static final SdkField<FilterOperation> FILTER_OPERATION_FIELD = SdkField
            .<FilterOperation> builder(MarshallingType.SDK_POJO).memberName("FilterOperation")
            .getter(getter(TransformOperation::filterOperation)).setter(setter(Builder::filterOperation))
            .constructor(FilterOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterOperation").build()).build();

    private static final SdkField<CreateColumnsOperation> CREATE_COLUMNS_OPERATION_FIELD = SdkField
            .<CreateColumnsOperation> builder(MarshallingType.SDK_POJO).memberName("CreateColumnsOperation")
            .getter(getter(TransformOperation::createColumnsOperation)).setter(setter(Builder::createColumnsOperation))
            .constructor(CreateColumnsOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreateColumnsOperation").build())
            .build();

    private static final SdkField<RenameColumnOperation> RENAME_COLUMN_OPERATION_FIELD = SdkField
            .<RenameColumnOperation> builder(MarshallingType.SDK_POJO).memberName("RenameColumnOperation")
            .getter(getter(TransformOperation::renameColumnOperation)).setter(setter(Builder::renameColumnOperation))
            .constructor(RenameColumnOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RenameColumnOperation").build())
            .build();

    private static final SdkField<CastColumnTypeOperation> CAST_COLUMN_TYPE_OPERATION_FIELD = SdkField
            .<CastColumnTypeOperation> builder(MarshallingType.SDK_POJO).memberName("CastColumnTypeOperation")
            .getter(getter(TransformOperation::castColumnTypeOperation)).setter(setter(Builder::castColumnTypeOperation))
            .constructor(CastColumnTypeOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CastColumnTypeOperation").build())
            .build();

    private static final SdkField<TagColumnOperation> TAG_COLUMN_OPERATION_FIELD = SdkField
            .<TagColumnOperation> builder(MarshallingType.SDK_POJO).memberName("TagColumnOperation")
            .getter(getter(TransformOperation::tagColumnOperation)).setter(setter(Builder::tagColumnOperation))
            .constructor(TagColumnOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagColumnOperation").build())
            .build();

    private static final SdkField<UntagColumnOperation> UNTAG_COLUMN_OPERATION_FIELD = SdkField
            .<UntagColumnOperation> builder(MarshallingType.SDK_POJO).memberName("UntagColumnOperation")
            .getter(getter(TransformOperation::untagColumnOperation)).setter(setter(Builder::untagColumnOperation))
            .constructor(UntagColumnOperation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UntagColumnOperation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROJECT_OPERATION_FIELD,
            FILTER_OPERATION_FIELD, CREATE_COLUMNS_OPERATION_FIELD, RENAME_COLUMN_OPERATION_FIELD,
            CAST_COLUMN_TYPE_OPERATION_FIELD, TAG_COLUMN_OPERATION_FIELD, UNTAG_COLUMN_OPERATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final ProjectOperation projectOperation;

    private final FilterOperation filterOperation;

    private final CreateColumnsOperation createColumnsOperation;

    private final RenameColumnOperation renameColumnOperation;

    private final CastColumnTypeOperation castColumnTypeOperation;

    private final TagColumnOperation tagColumnOperation;

    private final UntagColumnOperation untagColumnOperation;

    private final Type type;

    private TransformOperation(BuilderImpl builder) {
        this.projectOperation = builder.projectOperation;
        this.filterOperation = builder.filterOperation;
        this.createColumnsOperation = builder.createColumnsOperation;
        this.renameColumnOperation = builder.renameColumnOperation;
        this.castColumnTypeOperation = builder.castColumnTypeOperation;
        this.tagColumnOperation = builder.tagColumnOperation;
        this.untagColumnOperation = builder.untagColumnOperation;
        this.type = builder.type;
    }

    /**
     * <p>
     * An operation that projects columns. Operations that come after a projection can only refer to projected columns.
     * </p>
     * 
     * @return An operation that projects columns. Operations that come after a projection can only refer to projected
     *         columns.
     */
    public final ProjectOperation projectOperation() {
        return projectOperation;
    }

    /**
     * <p>
     * An operation that filters rows based on some condition.
     * </p>
     * 
     * @return An operation that filters rows based on some condition.
     */
    public final FilterOperation filterOperation() {
        return filterOperation;
    }

    /**
     * <p>
     * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
     * </p>
     * 
     * @return An operation that creates calculated columns. Columns created in one such operation form a lexical
     *         closure.
     */
    public final CreateColumnsOperation createColumnsOperation() {
        return createColumnsOperation;
    }

    /**
     * <p>
     * An operation that renames a column.
     * </p>
     * 
     * @return An operation that renames a column.
     */
    public final RenameColumnOperation renameColumnOperation() {
        return renameColumnOperation;
    }

    /**
     * <p>
     * A transform operation that casts a column to a different type.
     * </p>
     * 
     * @return A transform operation that casts a column to a different type.
     */
    public final CastColumnTypeOperation castColumnTypeOperation() {
        return castColumnTypeOperation;
    }

    /**
     * <p>
     * An operation that tags a column with additional information.
     * </p>
     * 
     * @return An operation that tags a column with additional information.
     */
    public final TagColumnOperation tagColumnOperation() {
        return tagColumnOperation;
    }

    /**
     * Returns the value of the UntagColumnOperation property for this object.
     * 
     * @return The value of the UntagColumnOperation property for this object.
     */
    public final UntagColumnOperation untagColumnOperation() {
        return untagColumnOperation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(projectOperation());
        hashCode = 31 * hashCode + Objects.hashCode(filterOperation());
        hashCode = 31 * hashCode + Objects.hashCode(createColumnsOperation());
        hashCode = 31 * hashCode + Objects.hashCode(renameColumnOperation());
        hashCode = 31 * hashCode + Objects.hashCode(castColumnTypeOperation());
        hashCode = 31 * hashCode + Objects.hashCode(tagColumnOperation());
        hashCode = 31 * hashCode + Objects.hashCode(untagColumnOperation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransformOperation)) {
            return false;
        }
        TransformOperation other = (TransformOperation) obj;
        return Objects.equals(projectOperation(), other.projectOperation())
                && Objects.equals(filterOperation(), other.filterOperation())
                && Objects.equals(createColumnsOperation(), other.createColumnsOperation())
                && Objects.equals(renameColumnOperation(), other.renameColumnOperation())
                && Objects.equals(castColumnTypeOperation(), other.castColumnTypeOperation())
                && Objects.equals(tagColumnOperation(), other.tagColumnOperation())
                && Objects.equals(untagColumnOperation(), other.untagColumnOperation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransformOperation").add("ProjectOperation", projectOperation())
                .add("FilterOperation", filterOperation()).add("CreateColumnsOperation", createColumnsOperation())
                .add("RenameColumnOperation", renameColumnOperation()).add("CastColumnTypeOperation", castColumnTypeOperation())
                .add("TagColumnOperation", tagColumnOperation()).add("UntagColumnOperation", untagColumnOperation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProjectOperation":
            return Optional.ofNullable(clazz.cast(projectOperation()));
        case "FilterOperation":
            return Optional.ofNullable(clazz.cast(filterOperation()));
        case "CreateColumnsOperation":
            return Optional.ofNullable(clazz.cast(createColumnsOperation()));
        case "RenameColumnOperation":
            return Optional.ofNullable(clazz.cast(renameColumnOperation()));
        case "CastColumnTypeOperation":
            return Optional.ofNullable(clazz.cast(castColumnTypeOperation()));
        case "TagColumnOperation":
            return Optional.ofNullable(clazz.cast(tagColumnOperation()));
        case "UntagColumnOperation":
            return Optional.ofNullable(clazz.cast(untagColumnOperation()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #projectOperation()} initialized to the given value.
     *
     * <p>
     * An operation that projects columns. Operations that come after a projection can only refer to projected columns.
     * </p>
     * 
     * @param projectOperation
     *        An operation that projects columns. Operations that come after a projection can only refer to projected
     *        columns.
     */
    public static TransformOperation fromProjectOperation(ProjectOperation projectOperation) {
        return builder().projectOperation(projectOperation).build();
    }

    /**
     * Create an instance of this class with {@link #projectOperation()} initialized to the given value.
     *
     * <p>
     * An operation that projects columns. Operations that come after a projection can only refer to projected columns.
     * </p>
     * 
     * @param projectOperation
     *        An operation that projects columns. Operations that come after a projection can only refer to projected
     *        columns.
     */
    public static TransformOperation fromProjectOperation(Consumer<ProjectOperation.Builder> projectOperation) {
        ProjectOperation.Builder builder = ProjectOperation.builder();
        projectOperation.accept(builder);
        return fromProjectOperation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #filterOperation()} initialized to the given value.
     *
     * <p>
     * An operation that filters rows based on some condition.
     * </p>
     * 
     * @param filterOperation
     *        An operation that filters rows based on some condition.
     */
    public static TransformOperation fromFilterOperation(FilterOperation filterOperation) {
        return builder().filterOperation(filterOperation).build();
    }

    /**
     * Create an instance of this class with {@link #filterOperation()} initialized to the given value.
     *
     * <p>
     * An operation that filters rows based on some condition.
     * </p>
     * 
     * @param filterOperation
     *        An operation that filters rows based on some condition.
     */
    public static TransformOperation fromFilterOperation(Consumer<FilterOperation.Builder> filterOperation) {
        FilterOperation.Builder builder = FilterOperation.builder();
        filterOperation.accept(builder);
        return fromFilterOperation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #createColumnsOperation()} initialized to the given value.
     *
     * <p>
     * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
     * </p>
     * 
     * @param createColumnsOperation
     *        An operation that creates calculated columns. Columns created in one such operation form a lexical
     *        closure.
     */
    public static TransformOperation fromCreateColumnsOperation(CreateColumnsOperation createColumnsOperation) {
        return builder().createColumnsOperation(createColumnsOperation).build();
    }

    /**
     * Create an instance of this class with {@link #createColumnsOperation()} initialized to the given value.
     *
     * <p>
     * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
     * </p>
     * 
     * @param createColumnsOperation
     *        An operation that creates calculated columns. Columns created in one such operation form a lexical
     *        closure.
     */
    public static TransformOperation fromCreateColumnsOperation(Consumer<CreateColumnsOperation.Builder> createColumnsOperation) {
        CreateColumnsOperation.Builder builder = CreateColumnsOperation.builder();
        createColumnsOperation.accept(builder);
        return fromCreateColumnsOperation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #renameColumnOperation()} initialized to the given value.
     *
     * <p>
     * An operation that renames a column.
     * </p>
     * 
     * @param renameColumnOperation
     *        An operation that renames a column.
     */
    public static TransformOperation fromRenameColumnOperation(RenameColumnOperation renameColumnOperation) {
        return builder().renameColumnOperation(renameColumnOperation).build();
    }

    /**
     * Create an instance of this class with {@link #renameColumnOperation()} initialized to the given value.
     *
     * <p>
     * An operation that renames a column.
     * </p>
     * 
     * @param renameColumnOperation
     *        An operation that renames a column.
     */
    public static TransformOperation fromRenameColumnOperation(Consumer<RenameColumnOperation.Builder> renameColumnOperation) {
        RenameColumnOperation.Builder builder = RenameColumnOperation.builder();
        renameColumnOperation.accept(builder);
        return fromRenameColumnOperation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #castColumnTypeOperation()} initialized to the given value.
     *
     * <p>
     * A transform operation that casts a column to a different type.
     * </p>
     * 
     * @param castColumnTypeOperation
     *        A transform operation that casts a column to a different type.
     */
    public static TransformOperation fromCastColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation) {
        return builder().castColumnTypeOperation(castColumnTypeOperation).build();
    }

    /**
     * Create an instance of this class with {@link #castColumnTypeOperation()} initialized to the given value.
     *
     * <p>
     * A transform operation that casts a column to a different type.
     * </p>
     * 
     * @param castColumnTypeOperation
     *        A transform operation that casts a column to a different type.
     */
    public static TransformOperation fromCastColumnTypeOperation(Consumer<CastColumnTypeOperation.Builder> castColumnTypeOperation) {
        CastColumnTypeOperation.Builder builder = CastColumnTypeOperation.builder();
        castColumnTypeOperation.accept(builder);
        return fromCastColumnTypeOperation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #tagColumnOperation()} initialized to the given value.
     *
     * <p>
     * An operation that tags a column with additional information.
     * </p>
     * 
     * @param tagColumnOperation
     *        An operation that tags a column with additional information.
     */
    public static TransformOperation fromTagColumnOperation(TagColumnOperation tagColumnOperation) {
        return builder().tagColumnOperation(tagColumnOperation).build();
    }

    /**
     * Create an instance of this class with {@link #tagColumnOperation()} initialized to the given value.
     *
     * <p>
     * An operation that tags a column with additional information.
     * </p>
     * 
     * @param tagColumnOperation
     *        An operation that tags a column with additional information.
     */
    public static TransformOperation fromTagColumnOperation(Consumer<TagColumnOperation.Builder> tagColumnOperation) {
        TagColumnOperation.Builder builder = TagColumnOperation.builder();
        tagColumnOperation.accept(builder);
        return fromTagColumnOperation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #untagColumnOperation()} initialized to the given value.
     *
     * Sets the value of the UntagColumnOperation property for this object.
     *
     * @param untagColumnOperation
     *        The new value for the UntagColumnOperation property for this object.
     */
    public static TransformOperation fromUntagColumnOperation(UntagColumnOperation untagColumnOperation) {
        return builder().untagColumnOperation(untagColumnOperation).build();
    }

    /**
     * Create an instance of this class with {@link #untagColumnOperation()} initialized to the given value.
     *
     * Sets the value of the UntagColumnOperation property for this object.
     *
     * @param untagColumnOperation
     *        The new value for the UntagColumnOperation property for this object.
     */
    public static TransformOperation fromUntagColumnOperation(Consumer<UntagColumnOperation.Builder> untagColumnOperation) {
        UntagColumnOperation.Builder builder = UntagColumnOperation.builder();
        untagColumnOperation.accept(builder);
        return fromUntagColumnOperation(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransformOperation, T> g) {
        return obj -> g.apply((TransformOperation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransformOperation> {
        /**
         * <p>
         * An operation that projects columns. Operations that come after a projection can only refer to projected
         * columns.
         * </p>
         * 
         * @param projectOperation
         *        An operation that projects columns. Operations that come after a projection can only refer to
         *        projected columns.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder projectOperation(ProjectOperation projectOperation);

        /**
         * <p>
         * An operation that projects columns. Operations that come after a projection can only refer to projected
         * columns.
         * </p>
         * This is a convenience method that creates an instance of the {@link ProjectOperation.Builder} avoiding the
         * need to create one manually via {@link ProjectOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ProjectOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #projectOperation(ProjectOperation)}.
         * 
         * @param projectOperation
         *        a consumer that will call methods on {@link ProjectOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #projectOperation(ProjectOperation)
         */
        default Builder projectOperation(Consumer<ProjectOperation.Builder> projectOperation) {
            return projectOperation(ProjectOperation.builder().applyMutation(projectOperation).build());
        }

        /**
         * <p>
         * An operation that filters rows based on some condition.
         * </p>
         * 
         * @param filterOperation
         *        An operation that filters rows based on some condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterOperation(FilterOperation filterOperation);

        /**
         * <p>
         * An operation that filters rows based on some condition.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterOperation.Builder} avoiding the
         * need to create one manually via {@link FilterOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #filterOperation(FilterOperation)}.
         * 
         * @param filterOperation
         *        a consumer that will call methods on {@link FilterOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterOperation(FilterOperation)
         */
        default Builder filterOperation(Consumer<FilterOperation.Builder> filterOperation) {
            return filterOperation(FilterOperation.builder().applyMutation(filterOperation).build());
        }

        /**
         * <p>
         * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
         * </p>
         * 
         * @param createColumnsOperation
         *        An operation that creates calculated columns. Columns created in one such operation form a lexical
         *        closure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createColumnsOperation(CreateColumnsOperation createColumnsOperation);

        /**
         * <p>
         * An operation that creates calculated columns. Columns created in one such operation form a lexical closure.
         * </p>
         * This is a convenience method that creates an instance of the {@link CreateColumnsOperation.Builder} avoiding
         * the need to create one manually via {@link CreateColumnsOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CreateColumnsOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #createColumnsOperation(CreateColumnsOperation)}.
         * 
         * @param createColumnsOperation
         *        a consumer that will call methods on {@link CreateColumnsOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #createColumnsOperation(CreateColumnsOperation)
         */
        default Builder createColumnsOperation(Consumer<CreateColumnsOperation.Builder> createColumnsOperation) {
            return createColumnsOperation(CreateColumnsOperation.builder().applyMutation(createColumnsOperation).build());
        }

        /**
         * <p>
         * An operation that renames a column.
         * </p>
         * 
         * @param renameColumnOperation
         *        An operation that renames a column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder renameColumnOperation(RenameColumnOperation renameColumnOperation);

        /**
         * <p>
         * An operation that renames a column.
         * </p>
         * This is a convenience method that creates an instance of the {@link RenameColumnOperation.Builder} avoiding
         * the need to create one manually via {@link RenameColumnOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RenameColumnOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #renameColumnOperation(RenameColumnOperation)}.
         * 
         * @param renameColumnOperation
         *        a consumer that will call methods on {@link RenameColumnOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #renameColumnOperation(RenameColumnOperation)
         */
        default Builder renameColumnOperation(Consumer<RenameColumnOperation.Builder> renameColumnOperation) {
            return renameColumnOperation(RenameColumnOperation.builder().applyMutation(renameColumnOperation).build());
        }

        /**
         * <p>
         * A transform operation that casts a column to a different type.
         * </p>
         * 
         * @param castColumnTypeOperation
         *        A transform operation that casts a column to a different type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder castColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation);

        /**
         * <p>
         * A transform operation that casts a column to a different type.
         * </p>
         * This is a convenience method that creates an instance of the {@link CastColumnTypeOperation.Builder} avoiding
         * the need to create one manually via {@link CastColumnTypeOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CastColumnTypeOperation.Builder#build()} is called immediately
         * and its result is passed to {@link #castColumnTypeOperation(CastColumnTypeOperation)}.
         * 
         * @param castColumnTypeOperation
         *        a consumer that will call methods on {@link CastColumnTypeOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #castColumnTypeOperation(CastColumnTypeOperation)
         */
        default Builder castColumnTypeOperation(Consumer<CastColumnTypeOperation.Builder> castColumnTypeOperation) {
            return castColumnTypeOperation(CastColumnTypeOperation.builder().applyMutation(castColumnTypeOperation).build());
        }

        /**
         * <p>
         * An operation that tags a column with additional information.
         * </p>
         * 
         * @param tagColumnOperation
         *        An operation that tags a column with additional information.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tagColumnOperation(TagColumnOperation tagColumnOperation);

        /**
         * <p>
         * An operation that tags a column with additional information.
         * </p>
         * This is a convenience method that creates an instance of the {@link TagColumnOperation.Builder} avoiding the
         * need to create one manually via {@link TagColumnOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TagColumnOperation.Builder#build()} is called immediately and its
         * result is passed to {@link #tagColumnOperation(TagColumnOperation)}.
         * 
         * @param tagColumnOperation
         *        a consumer that will call methods on {@link TagColumnOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tagColumnOperation(TagColumnOperation)
         */
        default Builder tagColumnOperation(Consumer<TagColumnOperation.Builder> tagColumnOperation) {
            return tagColumnOperation(TagColumnOperation.builder().applyMutation(tagColumnOperation).build());
        }

        /**
         * Sets the value of the UntagColumnOperation property for this object.
         *
         * @param untagColumnOperation
         *        The new value for the UntagColumnOperation property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder untagColumnOperation(UntagColumnOperation untagColumnOperation);

        /**
         * Sets the value of the UntagColumnOperation property for this object.
         *
         * This is a convenience method that creates an instance of the {@link UntagColumnOperation.Builder} avoiding
         * the need to create one manually via {@link UntagColumnOperation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link UntagColumnOperation.Builder#build()} is called immediately and
         * its result is passed to {@link #untagColumnOperation(UntagColumnOperation)}.
         * 
         * @param untagColumnOperation
         *        a consumer that will call methods on {@link UntagColumnOperation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #untagColumnOperation(UntagColumnOperation)
         */
        default Builder untagColumnOperation(Consumer<UntagColumnOperation.Builder> untagColumnOperation) {
            return untagColumnOperation(UntagColumnOperation.builder().applyMutation(untagColumnOperation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ProjectOperation projectOperation;

        private FilterOperation filterOperation;

        private CreateColumnsOperation createColumnsOperation;

        private RenameColumnOperation renameColumnOperation;

        private CastColumnTypeOperation castColumnTypeOperation;

        private TagColumnOperation tagColumnOperation;

        private UntagColumnOperation untagColumnOperation;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TransformOperation model) {
            projectOperation(model.projectOperation);
            filterOperation(model.filterOperation);
            createColumnsOperation(model.createColumnsOperation);
            renameColumnOperation(model.renameColumnOperation);
            castColumnTypeOperation(model.castColumnTypeOperation);
            tagColumnOperation(model.tagColumnOperation);
            untagColumnOperation(model.untagColumnOperation);
        }

        public final ProjectOperation.Builder getProjectOperation() {
            return projectOperation != null ? projectOperation.toBuilder() : null;
        }

        public final void setProjectOperation(ProjectOperation.BuilderImpl projectOperation) {
            Object oldValue = this.projectOperation;
            this.projectOperation = projectOperation != null ? projectOperation.build() : null;
            handleUnionValueChange(Type.PROJECT_OPERATION, oldValue, this.projectOperation);
        }

        @Override
        public final Builder projectOperation(ProjectOperation projectOperation) {
            Object oldValue = this.projectOperation;
            this.projectOperation = projectOperation;
            handleUnionValueChange(Type.PROJECT_OPERATION, oldValue, this.projectOperation);
            return this;
        }

        public final FilterOperation.Builder getFilterOperation() {
            return filterOperation != null ? filterOperation.toBuilder() : null;
        }

        public final void setFilterOperation(FilterOperation.BuilderImpl filterOperation) {
            Object oldValue = this.filterOperation;
            this.filterOperation = filterOperation != null ? filterOperation.build() : null;
            handleUnionValueChange(Type.FILTER_OPERATION, oldValue, this.filterOperation);
        }

        @Override
        public final Builder filterOperation(FilterOperation filterOperation) {
            Object oldValue = this.filterOperation;
            this.filterOperation = filterOperation;
            handleUnionValueChange(Type.FILTER_OPERATION, oldValue, this.filterOperation);
            return this;
        }

        public final CreateColumnsOperation.Builder getCreateColumnsOperation() {
            return createColumnsOperation != null ? createColumnsOperation.toBuilder() : null;
        }

        public final void setCreateColumnsOperation(CreateColumnsOperation.BuilderImpl createColumnsOperation) {
            Object oldValue = this.createColumnsOperation;
            this.createColumnsOperation = createColumnsOperation != null ? createColumnsOperation.build() : null;
            handleUnionValueChange(Type.CREATE_COLUMNS_OPERATION, oldValue, this.createColumnsOperation);
        }

        @Override
        public final Builder createColumnsOperation(CreateColumnsOperation createColumnsOperation) {
            Object oldValue = this.createColumnsOperation;
            this.createColumnsOperation = createColumnsOperation;
            handleUnionValueChange(Type.CREATE_COLUMNS_OPERATION, oldValue, this.createColumnsOperation);
            return this;
        }

        public final RenameColumnOperation.Builder getRenameColumnOperation() {
            return renameColumnOperation != null ? renameColumnOperation.toBuilder() : null;
        }

        public final void setRenameColumnOperation(RenameColumnOperation.BuilderImpl renameColumnOperation) {
            Object oldValue = this.renameColumnOperation;
            this.renameColumnOperation = renameColumnOperation != null ? renameColumnOperation.build() : null;
            handleUnionValueChange(Type.RENAME_COLUMN_OPERATION, oldValue, this.renameColumnOperation);
        }

        @Override
        public final Builder renameColumnOperation(RenameColumnOperation renameColumnOperation) {
            Object oldValue = this.renameColumnOperation;
            this.renameColumnOperation = renameColumnOperation;
            handleUnionValueChange(Type.RENAME_COLUMN_OPERATION, oldValue, this.renameColumnOperation);
            return this;
        }

        public final CastColumnTypeOperation.Builder getCastColumnTypeOperation() {
            return castColumnTypeOperation != null ? castColumnTypeOperation.toBuilder() : null;
        }

        public final void setCastColumnTypeOperation(CastColumnTypeOperation.BuilderImpl castColumnTypeOperation) {
            Object oldValue = this.castColumnTypeOperation;
            this.castColumnTypeOperation = castColumnTypeOperation != null ? castColumnTypeOperation.build() : null;
            handleUnionValueChange(Type.CAST_COLUMN_TYPE_OPERATION, oldValue, this.castColumnTypeOperation);
        }

        @Override
        public final Builder castColumnTypeOperation(CastColumnTypeOperation castColumnTypeOperation) {
            Object oldValue = this.castColumnTypeOperation;
            this.castColumnTypeOperation = castColumnTypeOperation;
            handleUnionValueChange(Type.CAST_COLUMN_TYPE_OPERATION, oldValue, this.castColumnTypeOperation);
            return this;
        }

        public final TagColumnOperation.Builder getTagColumnOperation() {
            return tagColumnOperation != null ? tagColumnOperation.toBuilder() : null;
        }

        public final void setTagColumnOperation(TagColumnOperation.BuilderImpl tagColumnOperation) {
            Object oldValue = this.tagColumnOperation;
            this.tagColumnOperation = tagColumnOperation != null ? tagColumnOperation.build() : null;
            handleUnionValueChange(Type.TAG_COLUMN_OPERATION, oldValue, this.tagColumnOperation);
        }

        @Override
        public final Builder tagColumnOperation(TagColumnOperation tagColumnOperation) {
            Object oldValue = this.tagColumnOperation;
            this.tagColumnOperation = tagColumnOperation;
            handleUnionValueChange(Type.TAG_COLUMN_OPERATION, oldValue, this.tagColumnOperation);
            return this;
        }

        public final UntagColumnOperation.Builder getUntagColumnOperation() {
            return untagColumnOperation != null ? untagColumnOperation.toBuilder() : null;
        }

        public final void setUntagColumnOperation(UntagColumnOperation.BuilderImpl untagColumnOperation) {
            Object oldValue = this.untagColumnOperation;
            this.untagColumnOperation = untagColumnOperation != null ? untagColumnOperation.build() : null;
            handleUnionValueChange(Type.UNTAG_COLUMN_OPERATION, oldValue, this.untagColumnOperation);
        }

        @Override
        public final Builder untagColumnOperation(UntagColumnOperation untagColumnOperation) {
            Object oldValue = this.untagColumnOperation;
            this.untagColumnOperation = untagColumnOperation;
            handleUnionValueChange(Type.UNTAG_COLUMN_OPERATION, oldValue, this.untagColumnOperation);
            return this;
        }

        @Override
        public TransformOperation build() {
            return new TransformOperation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TransformOperation#type()
     */
    public enum Type {
        PROJECT_OPERATION,

        FILTER_OPERATION,

        CREATE_COLUMNS_OPERATION,

        RENAME_COLUMN_OPERATION,

        CAST_COLUMN_TYPE_OPERATION,

        TAG_COLUMN_OPERATION,

        UNTAG_COLUMN_OPERATION,

        UNKNOWN_TO_SDK_VERSION
    }
}
