/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.quicksight.model.PivotTableDataPathOption;
import software.amazon.awssdk.services.quicksight.model.PivotTableDataPathOptionListCopier;
import software.amazon.awssdk.services.quicksight.model.PivotTableFieldOption;
import software.amazon.awssdk.services.quicksight.model.PivotTableFieldOptionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PivotTableFieldOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PivotTableFieldOptions> {
    private static final SdkField<List<PivotTableFieldOption>> SELECTED_FIELD_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SelectedFieldOptions").getter(PivotTableFieldOptions.getter(PivotTableFieldOptions::selectedFieldOptions)).setter(PivotTableFieldOptions.setter(Builder::selectedFieldOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFieldOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PivotTableFieldOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PivotTableDataPathOption>> DATA_PATH_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("DataPathOptions").getter(PivotTableFieldOptions.getter(PivotTableFieldOptions::dataPathOptions)).setter(PivotTableFieldOptions.setter(Builder::dataPathOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPathOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PivotTableDataPathOption::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_FIELD_OPTIONS_FIELD, DATA_PATH_OPTIONS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<PivotTableFieldOption> selectedFieldOptions;
    private final List<PivotTableDataPathOption> dataPathOptions;

    private PivotTableFieldOptions(BuilderImpl builder) {
        this.selectedFieldOptions = builder.selectedFieldOptions;
        this.dataPathOptions = builder.dataPathOptions;
    }

    public final boolean hasSelectedFieldOptions() {
        return this.selectedFieldOptions != null && !(this.selectedFieldOptions instanceof SdkAutoConstructList);
    }

    public final List<PivotTableFieldOption> selectedFieldOptions() {
        return this.selectedFieldOptions;
    }

    public final boolean hasDataPathOptions() {
        return this.dataPathOptions != null && !(this.dataPathOptions instanceof SdkAutoConstructList);
    }

    public final List<PivotTableDataPathOption> dataPathOptions() {
        return this.dataPathOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSelectedFieldOptions() ? this.selectedFieldOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDataPathOptions() ? this.dataPathOptions() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableFieldOptions)) {
            return false;
        }
        PivotTableFieldOptions other = (PivotTableFieldOptions)obj;
        return this.hasSelectedFieldOptions() == other.hasSelectedFieldOptions() && Objects.equals(this.selectedFieldOptions(), other.selectedFieldOptions()) && this.hasDataPathOptions() == other.hasDataPathOptions() && Objects.equals(this.dataPathOptions(), other.dataPathOptions());
    }

    public final String toString() {
        return ToString.builder((String)"PivotTableFieldOptions").add("SelectedFieldOptions", this.hasSelectedFieldOptions() ? this.selectedFieldOptions() : null).add("DataPathOptions", this.hasDataPathOptions() ? this.dataPathOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SelectedFieldOptions": {
                return Optional.ofNullable(clazz.cast(this.selectedFieldOptions()));
            }
            case "DataPathOptions": {
                return Optional.ofNullable(clazz.cast(this.dataPathOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PivotTableFieldOptions, T> g) {
        return obj -> g.apply((PivotTableFieldOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<PivotTableFieldOption> selectedFieldOptions = DefaultSdkAutoConstructList.getInstance();
        private List<PivotTableDataPathOption> dataPathOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableFieldOptions model) {
            this.selectedFieldOptions(model.selectedFieldOptions);
            this.dataPathOptions(model.dataPathOptions);
        }

        public final List<PivotTableFieldOption.Builder> getSelectedFieldOptions() {
            List<PivotTableFieldOption.Builder> result = PivotTableFieldOptionListCopier.copyToBuilder(this.selectedFieldOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedFieldOptions(Collection<PivotTableFieldOption.BuilderImpl> selectedFieldOptions) {
            this.selectedFieldOptions = PivotTableFieldOptionListCopier.copyFromBuilder(selectedFieldOptions);
        }

        @Override
        public final Builder selectedFieldOptions(Collection<PivotTableFieldOption> selectedFieldOptions) {
            this.selectedFieldOptions = PivotTableFieldOptionListCopier.copy(selectedFieldOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(PivotTableFieldOption ... selectedFieldOptions) {
            this.selectedFieldOptions(Arrays.asList(selectedFieldOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(Consumer<PivotTableFieldOption.Builder> ... selectedFieldOptions) {
            this.selectedFieldOptions(Stream.of(selectedFieldOptions).map(c -> (PivotTableFieldOption)((PivotTableFieldOption.Builder)PivotTableFieldOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PivotTableDataPathOption.Builder> getDataPathOptions() {
            List<PivotTableDataPathOption.Builder> result = PivotTableDataPathOptionListCopier.copyToBuilder(this.dataPathOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataPathOptions(Collection<PivotTableDataPathOption.BuilderImpl> dataPathOptions) {
            this.dataPathOptions = PivotTableDataPathOptionListCopier.copyFromBuilder(dataPathOptions);
        }

        @Override
        public final Builder dataPathOptions(Collection<PivotTableDataPathOption> dataPathOptions) {
            this.dataPathOptions = PivotTableDataPathOptionListCopier.copy(dataPathOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathOptions(PivotTableDataPathOption ... dataPathOptions) {
            this.dataPathOptions(Arrays.asList(dataPathOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathOptions(Consumer<PivotTableDataPathOption.Builder> ... dataPathOptions) {
            this.dataPathOptions(Stream.of(dataPathOptions).map(c -> (PivotTableDataPathOption)((PivotTableDataPathOption.Builder)PivotTableDataPathOption.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PivotTableFieldOptions build() {
            return new PivotTableFieldOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PivotTableFieldOptions> {
        public Builder selectedFieldOptions(Collection<PivotTableFieldOption> var1);

        public Builder selectedFieldOptions(PivotTableFieldOption ... var1);

        public Builder selectedFieldOptions(Consumer<PivotTableFieldOption.Builder> ... var1);

        public Builder dataPathOptions(Collection<PivotTableDataPathOption> var1);

        public Builder dataPathOptions(PivotTableDataPathOption ... var1);

        public Builder dataPathOptions(Consumer<PivotTableDataPathOption.Builder> ... var1);
    }
}

