/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ParameterValueType;
import software.amazon.awssdk.services.quicksight.model.StringDefaultValues;
import software.amazon.awssdk.services.quicksight.model.StringValueWhenUnsetConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StringParameterDeclaration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StringParameterDeclaration> {
    private static final SdkField<String> PARAMETER_VALUE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterValueType").getter(StringParameterDeclaration.getter(StringParameterDeclaration::parameterValueTypeAsString)).setter(StringParameterDeclaration.setter(Builder::parameterValueType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterValueType").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(StringParameterDeclaration.getter(StringParameterDeclaration::name)).setter(StringParameterDeclaration.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<StringDefaultValues> DEFAULT_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("DefaultValues").getter(StringParameterDeclaration.getter(StringParameterDeclaration::defaultValues)).setter(StringParameterDeclaration.setter(Builder::defaultValues)).constructor(StringDefaultValues::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultValues").build()}).build();
    private static final SdkField<StringValueWhenUnsetConfiguration> VALUE_WHEN_UNSET_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ValueWhenUnset").getter(StringParameterDeclaration.getter(StringParameterDeclaration::valueWhenUnset)).setter(StringParameterDeclaration.setter(Builder::valueWhenUnset)).constructor(StringValueWhenUnsetConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValueWhenUnset").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PARAMETER_VALUE_TYPE_FIELD, NAME_FIELD, DEFAULT_VALUES_FIELD, VALUE_WHEN_UNSET_FIELD));
    private static final long serialVersionUID = 1L;
    private final String parameterValueType;
    private final String name;
    private final StringDefaultValues defaultValues;
    private final StringValueWhenUnsetConfiguration valueWhenUnset;

    private StringParameterDeclaration(BuilderImpl builder) {
        this.parameterValueType = builder.parameterValueType;
        this.name = builder.name;
        this.defaultValues = builder.defaultValues;
        this.valueWhenUnset = builder.valueWhenUnset;
    }

    public final ParameterValueType parameterValueType() {
        return ParameterValueType.fromValue(this.parameterValueType);
    }

    public final String parameterValueTypeAsString() {
        return this.parameterValueType;
    }

    public final String name() {
        return this.name;
    }

    public final StringDefaultValues defaultValues() {
        return this.defaultValues;
    }

    public final StringValueWhenUnsetConfiguration valueWhenUnset() {
        return this.valueWhenUnset;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterValueTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValues());
        hashCode = 31 * hashCode + Objects.hashCode(this.valueWhenUnset());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StringParameterDeclaration)) {
            return false;
        }
        StringParameterDeclaration other = (StringParameterDeclaration)obj;
        return Objects.equals(this.parameterValueTypeAsString(), other.parameterValueTypeAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.defaultValues(), other.defaultValues()) && Objects.equals(this.valueWhenUnset(), other.valueWhenUnset());
    }

    public final String toString() {
        return ToString.builder((String)"StringParameterDeclaration").add("ParameterValueType", (Object)this.parameterValueTypeAsString()).add("Name", (Object)this.name()).add("DefaultValues", (Object)this.defaultValues()).add("ValueWhenUnset", (Object)this.valueWhenUnset()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ParameterValueType": {
                return Optional.ofNullable(clazz.cast(this.parameterValueTypeAsString()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "DefaultValues": {
                return Optional.ofNullable(clazz.cast(this.defaultValues()));
            }
            case "ValueWhenUnset": {
                return Optional.ofNullable(clazz.cast(this.valueWhenUnset()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StringParameterDeclaration, T> g) {
        return obj -> g.apply((StringParameterDeclaration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String parameterValueType;
        private String name;
        private StringDefaultValues defaultValues;
        private StringValueWhenUnsetConfiguration valueWhenUnset;

        private BuilderImpl() {
        }

        private BuilderImpl(StringParameterDeclaration model) {
            this.parameterValueType(model.parameterValueType);
            this.name(model.name);
            this.defaultValues(model.defaultValues);
            this.valueWhenUnset(model.valueWhenUnset);
        }

        public final String getParameterValueType() {
            return this.parameterValueType;
        }

        public final void setParameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
        }

        @Override
        public final Builder parameterValueType(String parameterValueType) {
            this.parameterValueType = parameterValueType;
            return this;
        }

        @Override
        public final Builder parameterValueType(ParameterValueType parameterValueType) {
            this.parameterValueType(parameterValueType == null ? null : parameterValueType.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final StringDefaultValues.Builder getDefaultValues() {
            return this.defaultValues != null ? this.defaultValues.toBuilder() : null;
        }

        public final void setDefaultValues(StringDefaultValues.BuilderImpl defaultValues) {
            this.defaultValues = defaultValues != null ? defaultValues.build() : null;
        }

        @Override
        public final Builder defaultValues(StringDefaultValues defaultValues) {
            this.defaultValues = defaultValues;
            return this;
        }

        public final StringValueWhenUnsetConfiguration.Builder getValueWhenUnset() {
            return this.valueWhenUnset != null ? this.valueWhenUnset.toBuilder() : null;
        }

        public final void setValueWhenUnset(StringValueWhenUnsetConfiguration.BuilderImpl valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset != null ? valueWhenUnset.build() : null;
        }

        @Override
        public final Builder valueWhenUnset(StringValueWhenUnsetConfiguration valueWhenUnset) {
            this.valueWhenUnset = valueWhenUnset;
            return this;
        }

        public StringParameterDeclaration build() {
            return new StringParameterDeclaration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StringParameterDeclaration> {
        public Builder parameterValueType(String var1);

        public Builder parameterValueType(ParameterValueType var1);

        public Builder name(String var1);

        public Builder defaultValues(StringDefaultValues var1);

        default public Builder defaultValues(Consumer<StringDefaultValues.Builder> defaultValues) {
            return this.defaultValues((StringDefaultValues)((StringDefaultValues.Builder)StringDefaultValues.builder().applyMutation(defaultValues)).build());
        }

        public Builder valueWhenUnset(StringValueWhenUnsetConfiguration var1);

        default public Builder valueWhenUnset(Consumer<StringValueWhenUnsetConfiguration.Builder> valueWhenUnset) {
            return this.valueWhenUnset((StringValueWhenUnsetConfiguration)((StringValueWhenUnsetConfiguration.Builder)StringValueWhenUnsetConfiguration.builder().applyMutation(valueWhenUnset)).build());
        }
    }
}

