/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field options for a pivot table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PivotTableFieldOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<PivotTableFieldOptions.Builder, PivotTableFieldOptions> {
    private static final SdkField<List<PivotTableFieldOption>> SELECTED_FIELD_OPTIONS_FIELD = SdkField
            .<List<PivotTableFieldOption>> builder(MarshallingType.LIST)
            .memberName("SelectedFieldOptions")
            .getter(getter(PivotTableFieldOptions::selectedFieldOptions))
            .setter(setter(Builder::selectedFieldOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFieldOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PivotTableFieldOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(PivotTableFieldOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<PivotTableDataPathOption>> DATA_PATH_OPTIONS_FIELD = SdkField
            .<List<PivotTableDataPathOption>> builder(MarshallingType.LIST)
            .memberName("DataPathOptions")
            .getter(getter(PivotTableFieldOptions::dataPathOptions))
            .setter(setter(Builder::dataPathOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataPathOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<PivotTableDataPathOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(PivotTableDataPathOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_FIELD_OPTIONS_FIELD,
            DATA_PATH_OPTIONS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<PivotTableFieldOption> selectedFieldOptions;

    private final List<PivotTableDataPathOption> dataPathOptions;

    private PivotTableFieldOptions(BuilderImpl builder) {
        this.selectedFieldOptions = builder.selectedFieldOptions;
        this.dataPathOptions = builder.dataPathOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedFieldOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedFieldOptions() {
        return selectedFieldOptions != null && !(selectedFieldOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selected field options for the pivot table field options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedFieldOptions} method.
     * </p>
     * 
     * @return The selected field options for the pivot table field options.
     */
    public final List<PivotTableFieldOption> selectedFieldOptions() {
        return selectedFieldOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the DataPathOptions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDataPathOptions() {
        return dataPathOptions != null && !(dataPathOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The data path options for the pivot table field options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDataPathOptions} method.
     * </p>
     * 
     * @return The data path options for the pivot table field options.
     */
    public final List<PivotTableDataPathOption> dataPathOptions() {
        return dataPathOptions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedFieldOptions() ? selectedFieldOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasDataPathOptions() ? dataPathOptions() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PivotTableFieldOptions)) {
            return false;
        }
        PivotTableFieldOptions other = (PivotTableFieldOptions) obj;
        return hasSelectedFieldOptions() == other.hasSelectedFieldOptions()
                && Objects.equals(selectedFieldOptions(), other.selectedFieldOptions())
                && hasDataPathOptions() == other.hasDataPathOptions()
                && Objects.equals(dataPathOptions(), other.dataPathOptions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PivotTableFieldOptions")
                .add("SelectedFieldOptions", hasSelectedFieldOptions() ? selectedFieldOptions() : null)
                .add("DataPathOptions", hasDataPathOptions() ? dataPathOptions() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedFieldOptions":
            return Optional.ofNullable(clazz.cast(selectedFieldOptions()));
        case "DataPathOptions":
            return Optional.ofNullable(clazz.cast(dataPathOptions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PivotTableFieldOptions, T> g) {
        return obj -> g.apply((PivotTableFieldOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PivotTableFieldOptions> {
        /**
         * <p>
         * The selected field options for the pivot table field options.
         * </p>
         * 
         * @param selectedFieldOptions
         *        The selected field options for the pivot table field options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFieldOptions(Collection<PivotTableFieldOption> selectedFieldOptions);

        /**
         * <p>
         * The selected field options for the pivot table field options.
         * </p>
         * 
         * @param selectedFieldOptions
         *        The selected field options for the pivot table field options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFieldOptions(PivotTableFieldOption... selectedFieldOptions);

        /**
         * <p>
         * The selected field options for the pivot table field options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldOption.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldOption.Builder#build()} is called
         * immediately and its result is passed to {@link #selectedFieldOptions(List<PivotTableFieldOption>)}.
         * 
         * @param selectedFieldOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.PivotTableFieldOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedFieldOptions(java.util.Collection<PivotTableFieldOption>)
         */
        Builder selectedFieldOptions(Consumer<PivotTableFieldOption.Builder>... selectedFieldOptions);

        /**
         * <p>
         * The data path options for the pivot table field options.
         * </p>
         * 
         * @param dataPathOptions
         *        The data path options for the pivot table field options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPathOptions(Collection<PivotTableDataPathOption> dataPathOptions);

        /**
         * <p>
         * The data path options for the pivot table field options.
         * </p>
         * 
         * @param dataPathOptions
         *        The data path options for the pivot table field options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataPathOptions(PivotTableDataPathOption... dataPathOptions);

        /**
         * <p>
         * The data path options for the pivot table field options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableDataPathOption.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableDataPathOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.PivotTableDataPathOption.Builder#build()} is called
         * immediately and its result is passed to {@link #dataPathOptions(List<PivotTableDataPathOption>)}.
         * 
         * @param dataPathOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.PivotTableDataPathOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #dataPathOptions(java.util.Collection<PivotTableDataPathOption>)
         */
        Builder dataPathOptions(Consumer<PivotTableDataPathOption.Builder>... dataPathOptions);
    }

    static final class BuilderImpl implements Builder {
        private List<PivotTableFieldOption> selectedFieldOptions = DefaultSdkAutoConstructList.getInstance();

        private List<PivotTableDataPathOption> dataPathOptions = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PivotTableFieldOptions model) {
            selectedFieldOptions(model.selectedFieldOptions);
            dataPathOptions(model.dataPathOptions);
        }

        public final List<PivotTableFieldOption.Builder> getSelectedFieldOptions() {
            List<PivotTableFieldOption.Builder> result = PivotTableFieldOptionListCopier.copyToBuilder(this.selectedFieldOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedFieldOptions(Collection<PivotTableFieldOption.BuilderImpl> selectedFieldOptions) {
            this.selectedFieldOptions = PivotTableFieldOptionListCopier.copyFromBuilder(selectedFieldOptions);
        }

        @Override
        public final Builder selectedFieldOptions(Collection<PivotTableFieldOption> selectedFieldOptions) {
            this.selectedFieldOptions = PivotTableFieldOptionListCopier.copy(selectedFieldOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(PivotTableFieldOption... selectedFieldOptions) {
            selectedFieldOptions(Arrays.asList(selectedFieldOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(Consumer<PivotTableFieldOption.Builder>... selectedFieldOptions) {
            selectedFieldOptions(Stream.of(selectedFieldOptions)
                    .map(c -> PivotTableFieldOption.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<PivotTableDataPathOption.Builder> getDataPathOptions() {
            List<PivotTableDataPathOption.Builder> result = PivotTableDataPathOptionListCopier
                    .copyToBuilder(this.dataPathOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDataPathOptions(Collection<PivotTableDataPathOption.BuilderImpl> dataPathOptions) {
            this.dataPathOptions = PivotTableDataPathOptionListCopier.copyFromBuilder(dataPathOptions);
        }

        @Override
        public final Builder dataPathOptions(Collection<PivotTableDataPathOption> dataPathOptions) {
            this.dataPathOptions = PivotTableDataPathOptionListCopier.copy(dataPathOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathOptions(PivotTableDataPathOption... dataPathOptions) {
            dataPathOptions(Arrays.asList(dataPathOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dataPathOptions(Consumer<PivotTableDataPathOption.Builder>... dataPathOptions) {
            dataPathOptions(Stream.of(dataPathOptions).map(c -> PivotTableDataPathOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public PivotTableFieldOptions build() {
            return new PivotTableFieldOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
