/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.util.VersionInfo;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.quicksight.model.AccessDeniedException;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CancelIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.ConcurrentUpdatingException;
import software.amazon.awssdk.services.quicksight.model.ConflictException;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.CreateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.CreateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.CreateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.CreateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.CreateIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.CreateNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.CreateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.CreateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.CreateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserByPrincipalIdResponse;
import software.amazon.awssdk.services.quicksight.model.DeleteUserRequest;
import software.amazon.awssdk.services.quicksight.model.DeleteUserResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAccountSubscriptionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResolvedPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeFolderResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupMembershipResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeGroupResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIngestionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeNamespaceResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateDefinitionRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateDefinitionResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeThemeResponse;
import software.amazon.awssdk.services.quicksight.model.DescribeUserRequest;
import software.amazon.awssdk.services.quicksight.model.DescribeUserResponse;
import software.amazon.awssdk.services.quicksight.model.DomainNotWhitelistedException;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForAnonymousUserResponse;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest;
import software.amazon.awssdk.services.quicksight.model.GenerateEmbedUrlForRegisteredUserResponse;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetDashboardEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlRequest;
import software.amazon.awssdk.services.quicksight.model.GetSessionEmbedUrlResponse;
import software.amazon.awssdk.services.quicksight.model.IdentityTypeNotSupportedException;
import software.amazon.awssdk.services.quicksight.model.InternalFailureException;
import software.amazon.awssdk.services.quicksight.model.InvalidNextTokenException;
import software.amazon.awssdk.services.quicksight.model.InvalidParameterValueException;
import software.amazon.awssdk.services.quicksight.model.InvalidRequestException;
import software.amazon.awssdk.services.quicksight.model.LimitExceededException;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFolderMembersResponse;
import software.amazon.awssdk.services.quicksight.model.ListFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.ListFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupMembershipsResponse;
import software.amazon.awssdk.services.quicksight.model.ListGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIamPolicyAssignmentsResponse;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest;
import software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.quicksight.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest;
import software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeAliasesResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse;
import software.amazon.awssdk.services.quicksight.model.ListThemesRequest;
import software.amazon.awssdk.services.quicksight.model.ListThemesResponse;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.ListUserGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.ListUsersRequest;
import software.amazon.awssdk.services.quicksight.model.ListUsersResponse;
import software.amazon.awssdk.services.quicksight.model.PreconditionNotMetException;
import software.amazon.awssdk.services.quicksight.model.QuickSightException;
import software.amazon.awssdk.services.quicksight.model.QuickSightRequest;
import software.amazon.awssdk.services.quicksight.model.QuickSightUserNotFoundException;
import software.amazon.awssdk.services.quicksight.model.RegisterUserRequest;
import software.amazon.awssdk.services.quicksight.model.RegisterUserResponse;
import software.amazon.awssdk.services.quicksight.model.ResourceExistsException;
import software.amazon.awssdk.services.quicksight.model.ResourceNotFoundException;
import software.amazon.awssdk.services.quicksight.model.ResourceUnavailableException;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.RestoreAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest;
import software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersRequest;
import software.amazon.awssdk.services.quicksight.model.SearchFoldersResponse;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsRequest;
import software.amazon.awssdk.services.quicksight.model.SearchGroupsResponse;
import software.amazon.awssdk.services.quicksight.model.SessionLifetimeInMinutesInvalidException;
import software.amazon.awssdk.services.quicksight.model.TagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.TagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.ThrottlingException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedPricingPlanException;
import software.amazon.awssdk.services.quicksight.model.UnsupportedUserEditionException;
import software.amazon.awssdk.services.quicksight.model.UntagResourceRequest;
import software.amazon.awssdk.services.quicksight.model.UntagResourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountCustomizationResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAccountSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateAnalysisResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardPublishedVersionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDashboardResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSetResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourcePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderPermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateFolderResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateGroupResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIamPolicyAssignmentResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateIpRestrictionResponse;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdatePublicSharingSettingsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplatePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateTemplateResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeAliasResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemePermissionsResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateThemeResponse;
import software.amazon.awssdk.services.quicksight.model.UpdateUserRequest;
import software.amazon.awssdk.services.quicksight.model.UpdateUserResponse;
import software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListThemeVersionsIterable;
import software.amazon.awssdk.services.quicksight.paginators.ListThemesIterable;
import software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable;
import software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable;
import software.amazon.awssdk.services.quicksight.paginators.SearchDataSetsIterable;
import software.amazon.awssdk.services.quicksight.paginators.SearchDataSourcesIterable;
import software.amazon.awssdk.services.quicksight.transform.CancelIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.CreateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserByPrincipalIdRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DeleteUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAccountSubscriptionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeFolderResolvedPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupMembershipRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIngestionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeNamespaceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateDefinitionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.DescribeUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForAnonymousUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GenerateEmbedUrlForRegisteredUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetDashboardEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.GetSessionEmbedUrlRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFolderMembersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupMembershipsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsForUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIamPolicyAssignmentsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListIngestionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListNamespacesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplateVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListTemplatesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeAliasesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemeVersionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListThemesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUserGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.ListUsersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RegisterUserRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.RestoreAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchAnalysesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDashboardsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSetsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchFoldersRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.SearchGroupsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountCustomizationRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAccountSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateAnalysisRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardPublishedVersionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDashboardRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSetRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourcePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderPermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateFolderRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateGroupRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIamPolicyAssignmentRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateIpRestrictionRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdatePublicSharingSettingsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplatePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateTemplateRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeAliasRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemePermissionsRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateThemeRequestMarshaller;
import software.amazon.awssdk.services.quicksight.transform.UpdateUserRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link QuickSightClient}.
 *
 * @see QuickSightClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultQuickSightClient implements QuickSightClient {
    private static final Logger log = Logger.loggerFor(DefaultQuickSightClient.class);

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultQuickSightClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Cancels an ongoing ingestion of data into SPICE.
     * </p>
     *
     * @param cancelIngestionRequest
     * @return Result of the CancelIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CancelIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CancelIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CancelIngestionResponse cancelIngestion(CancelIngestionRequest cancelIngestionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ResourceExistsException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CancelIngestionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CancelIngestionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, cancelIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CancelIngestion");

            return clientHandler.execute(new ClientExecutionParams<CancelIngestionRequest, CancelIngestionResponse>()
                    .withOperationName("CancelIngestion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(cancelIngestionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CancelIngestionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a
     * custom default theme by using the <code>CreateAccountCustomization</code> or
     * <code>UpdateAccountCustomization</code> API operation. To further customize Amazon QuickSight by removing Amazon
     * QuickSight sample assets and videos for all new users, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html">Customizing Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide.</i>
     * </p>
     * <p>
     * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a
     * QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply
     * to an Amazon Web Services account. To find out which customizations apply, use the
     * <code>DescribeAccountCustomization</code> API operation.
     * </p>
     * <p>
     * Before you use the <code>CreateAccountCustomization</code> API operation to add a theme as the namespace default,
     * make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme
     * isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the
     * current permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> </code>
     * API operation. To share the theme, grant permissions by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> </code>
     * API operation.
     * </p>
     *
     * @param createAccountCustomizationRequest
     * @return Result of the CreateAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccountCustomizationResponse createAccountCustomization(
            CreateAccountCustomizationRequest createAccountCustomizationRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccountCustomizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountCustomization");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAccountCustomizationRequest, CreateAccountCustomizationResponse>()
                            .withOperationName("CreateAccountCustomization").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createAccountCustomizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAccountCustomizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
     * </p>
     * <p>
     * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK. This
     * operation isn't supported in the US East (Ohio) Region, South America (Sao Paulo) Region, or Asia Pacific
     * (Singapore) Region.
     * </p>
     * <p>
     * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you
     * don't have an Amazon Web Services account, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html">Sign up for Amazon Web
     * Services</a> in the <i>Amazon QuickSight User Guide</i>. The person who signs up for Amazon QuickSight needs to
     * have the correct Identity and Access Management (IAM) permissions. For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html">IAM Policy Examples for Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * If your IAM policy includes both the <code>Subscribe</code> and <code>CreateAccountSubscription</code> actions,
     * make sure that both actions are set to <code>Allow</code>. If either action is set to <code>Deny</code>, the
     * <code>Deny</code> action prevails and your API call fails.
     * </p>
     * <p>
     * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To
     * pass your existing IAM role to Amazon QuickSight, see <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role"
     * >Passing IAM roles to Amazon QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default
     * resource access from the Amazon QuickSight console. For more information about setting default resource access to
     * Amazon Web Services services, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html">Setting default resource
     * access to Amazon Web Services services</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param createAccountSubscriptionRequest
     * @return Result of the CreateAccountSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateAccountSubscriptionResponse createAccountSubscription(
            CreateAccountSubscriptionRequest createAccountSubscriptionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ResourceExistsException,
            PreconditionNotMetException, ConflictException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateAccountSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAccountSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateAccountSubscriptionRequest, CreateAccountSubscriptionResponse>()
                            .withOperationName("CreateAccountSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createAccountSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateAccountSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an analysis in Amazon QuickSight. Analyses can be created either from a template or from an
     * <code>AnalysisDefinition</code>.
     * </p>
     *
     * @param createAnalysisRequest
     * @return Result of the CreateAnalysis operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateAnalysisResponse createAnalysis(CreateAnalysisRequest createAnalysisRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, ThrottlingException, ResourceExistsException, ConflictException,
            UnsupportedUserEditionException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateAnalysisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateAnalysis");

            return clientHandler.execute(new ClientExecutionParams<CreateAnalysisRequest, CreateAnalysisResponse>()
                    .withOperationName("CreateAnalysis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dashboard from either a template or directly with a <code>DashboardDefinition</code>. To first create a
     * template, see the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> </code>
     * API operation.
     * </p>
     * <p>
     * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses.
     * You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports
     * from them. If you have the correct permissions, you can create a dashboard from a template that exists in a
     * different Amazon Web Services account.
     * </p>
     *
     * @param createDashboardRequest
     * @return Result of the CreateDashboard operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDashboardResponse createDashboard(CreateDashboardRequest createDashboardRequest)
            throws ResourceNotFoundException, InvalidParameterValueException, ThrottlingException, ResourceExistsException,
            ConflictException, UnsupportedUserEditionException, LimitExceededException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDashboard");

            return clientHandler.execute(new ClientExecutionParams<CreateDashboardRequest, CreateDashboardResponse>()
                    .withOperationName("CreateDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param createDataSetRequest
     * @return Result of the CreateDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDataSetResponse createDataSet(CreateDataSetRequest createDataSetRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, LimitExceededException, ResourceExistsException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSet");

            return clientHandler.execute(new ClientExecutionParams<CreateDataSetRequest, CreateDataSetResponse>()
                    .withOperationName("CreateDataSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDataSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a data source.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, LimitExceededException,
            ResourceNotFoundException, ResourceExistsException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");

            return clientHandler.execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                    .withOperationName("CreateDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an empty shared folder.
     * </p>
     *
     * @param createFolderRequest
     * @return Result of the CreateFolder operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFolderResponse createFolder(CreateFolderRequest createFolderRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, ThrottlingException, ResourceExistsException, ConflictException,
            UnsupportedUserEditionException, AccessDeniedException, LimitExceededException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFolderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolder");

            return clientHandler.execute(new ClientExecutionParams<CreateFolderRequest, CreateFolderResponse>()
                    .withOperationName("CreateFolder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createFolderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFolderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
     * </p>
     *
     * @param createFolderMembershipRequest
     * @return Result of the CreateFolderMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateFolderMembershipResponse createFolderMembership(CreateFolderMembershipRequest createFolderMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ResourceExistsException,
            ThrottlingException, LimitExceededException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateFolderMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFolderMembership");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateFolderMembershipRequest, CreateFolderMembershipResponse>()
                            .withOperationName("CreateFolderMembership").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createFolderMembershipRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateFolderMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>CreateGroup</code> operation to create a group in Amazon QuickSight. You can create up to 10,000
     * groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact AWS Support.
     * </p>
     * <p>
     * The permissions resource is
     * <code>arn:aws:quicksight:&lt;your-region&gt;:<i>&lt;relevant-aws-account-id&gt;</i>:group/default/<i>&lt;group-name&gt;</i> </code>
     * .
     * </p>
     * <p>
     * The response is a group object.
     * </p>
     *
     * @param createGroupRequest
     *        The request object for this operation.
     * @return Result of the CreateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGroupResponse createGroup(CreateGroupRequest createGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, LimitExceededException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroup");

            return clientHandler.execute(new ClientExecutionParams<CreateGroupRequest, CreateGroupResponse>()
                    .withOperationName("CreateGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     * </p>
     *
     * @param createGroupMembershipRequest
     * @return Result of the CreateGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateGroupMembershipResponse createGroupMembership(CreateGroupMembershipRequest createGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateGroupMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGroupMembership");

            return clientHandler.execute(new ClientExecutionParams<CreateGroupMembershipRequest, CreateGroupMembershipResponse>()
                    .withOperationName("CreateGroupMembership").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createGroupMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGroupMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy
     * assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per
     * Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are
     * unique.
     * </p>
     *
     * @param createIamPolicyAssignmentRequest
     * @return Result of the CreateIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateIamPolicyAssignmentResponse createIAMPolicyAssignment(
            CreateIamPolicyAssignmentRequest createIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateIamPolicyAssignmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIAMPolicyAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateIamPolicyAssignmentRequest, CreateIamPolicyAssignmentResponse>()
                            .withOperationName("CreateIAMPolicyAssignment").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(createIamPolicyAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateIamPolicyAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise
     * edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8
     * times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
     * </p>
     * <p>
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an
     * example, see <a href="http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/">How do I
     * create an IAM policy to control access to Amazon EC2 resources using tags?</a> in the Amazon Web Services
     * Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
     * </p>
     *
     * @param createIngestionRequest
     * @return Result of the CreateIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateIngestionResponse createIngestion(CreateIngestionRequest createIngestionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateIngestionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateIngestionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateIngestion");

            return clientHandler.execute(new ClientExecutionParams<CreateIngestionRequest, CreateIngestionResponse>()
                    .withOperationName("CreateIngestion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createIngestionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateIngestionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     * </p>
     * <p>
     * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace.
     * Users that access the namespace can share assets only with other users or groups in the same namespace. They
     * can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account
     * is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By
     * default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a
     * ticket with Amazon Web Services Support.
     * </p>
     *
     * @param createNamespaceRequest
     * @return Result of the CreateNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateNamespaceResponse createNamespace(CreateNamespaceRequest createNamespaceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, PreconditionNotMetException, ConflictException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateNamespace");

            return clientHandler.execute(new ClientExecutionParams<CreateNamespaceRequest, CreateNamespaceResponse>()
                    .withOperationName("CreateNamespace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a template either from a <code>TemplateDefinition</code> or from an existing Amazon QuickSight analysis
     * or template. You can use the resulting template to create additional dashboards, templates, or analyses.
     * </p>
     * <p>
     * A <i>template</i> is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis
     * and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to
     * replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset
     * placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     * </p>
     *
     * @param createTemplateRequest
     * @return Result of the CreateTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTemplateResponse createTemplate(CreateTemplateRequest createTemplateRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, LimitExceededException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplate");

            return clientHandler.execute(new ClientExecutionParams<CreateTemplateRequest, CreateTemplateResponse>()
                    .withOperationName("CreateTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a template alias for a template.
     * </p>
     *
     * @param createTemplateAliasRequest
     * @return Result of the CreateTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public CreateTemplateAliasResponse createTemplateAlias(CreateTemplateAliasRequest createTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, ConflictException, ResourceExistsException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, CreateTemplateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTemplateAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateTemplateAliasRequest, CreateTemplateAliasResponse>()
                    .withOperationName("CreateTemplateAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createTemplateAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTemplateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a theme.
     * </p>
     * <p>
     * A <i>theme</i> is set of configuration options for color and layout. Themes apply to analyses and dashboards. For
     * more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html">Using Themes in Amazon
     * QuickSight</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param createThemeRequest
     * @return Result of the CreateTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateThemeResponse createTheme(CreateThemeRequest createThemeRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateTheme");

            return clientHandler.execute(new ClientExecutionParams<CreateThemeRequest, CreateThemeResponse>()
                    .withOperationName("CreateTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createThemeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a theme alias for a theme.
     * </p>
     *
     * @param createThemeAliasRequest
     * @return Result of the CreateThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.CreateThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/CreateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public CreateThemeAliasResponse createThemeAlias(CreateThemeAliasRequest createThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, LimitExceededException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateThemeAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateThemeAlias");

            return clientHandler.execute(new ClientExecutionParams<CreateThemeAliasRequest, CreateThemeAliasResponse>()
                    .withOperationName("CreateThemeAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createThemeAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateThemeAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web
     * Services account and Amazon QuickSight namespace.
     * </p>
     *
     * @param deleteAccountCustomizationRequest
     * @return Result of the DeleteAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountCustomizationResponse deleteAccountCustomization(
            DeleteAccountCustomizationRequest deleteAccountCustomizationRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountCustomizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountCustomization");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountCustomizationRequest, DeleteAccountCustomizationResponse>()
                            .withOperationName("DeleteAccountCustomization").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccountCustomizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountCustomizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>DeleteAccountSubscription</code> operation to delete an Amazon QuickSight account. This operation
     * will result in an error message if you have configured your account termination protection settings to
     * <code>True</code>. To change this setting and delete your account, call the <code>UpdateAccountSettings</code>
     * API and set the value of the <code>TerminationProtectionEnabled</code> parameter to <code>False</code>, then make
     * another call to the <code>DeleteAccountSubscription</code> API.
     * </p>
     *
     * @param deleteAccountSubscriptionRequest
     * @return Result of the DeleteAccountSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteAccountSubscriptionResponse deleteAccountSubscription(
            DeleteAccountSubscriptionRequest deleteAccountSubscriptionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteAccountSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAccountSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteAccountSubscriptionRequest, DeleteAccountSubscriptionResponse>()
                            .withOperationName("DeleteAccountSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteAccountSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteAccountSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can
     * restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon
     * QuickSight attaches a <code>DeletionTime</code> stamp to the response that specifies the end of the recovery
     * window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
     * </p>
     * <p>
     * At any time before recovery window ends, you can use the <code>RestoreAnalysis</code> API operation to remove the
     * <code>DeletionTime</code> stamp and cancel the deletion of the analysis. The analysis remains visible in the API
     * until it's deleted, so you can describe it but you can't make a template from it.
     * </p>
     * <p>
     * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the
     * console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     * </p>
     *
     * @param deleteAnalysisRequest
     * @return Result of the DeleteAnalysis operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteAnalysisResponse deleteAnalysis(DeleteAnalysisRequest deleteAnalysisRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteAnalysisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteAnalysis");

            return clientHandler.execute(new ClientExecutionParams<DeleteAnalysisRequest, DeleteAnalysisResponse>()
                    .withOperationName("DeleteAnalysis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a dashboard.
     * </p>
     *
     * @param deleteDashboardRequest
     * @return Result of the DeleteDashboard operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDashboardResponse deleteDashboard(DeleteDashboardRequest deleteDashboardRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDashboard");

            return clientHandler.execute(new ClientExecutionParams<DeleteDashboardRequest, DeleteDashboardResponse>()
                    .withOperationName("DeleteDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a dataset.
     * </p>
     *
     * @param deleteDataSetRequest
     * @return Result of the DeleteDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDataSetResponse deleteDataSet(DeleteDataSetRequest deleteDataSetRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSet");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataSetRequest, DeleteDataSetResponse>()
                    .withOperationName("DeleteDataSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDataSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data
     * source.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                    .withOperationName("DeleteDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an empty folder.
     * </p>
     *
     * @param deleteFolderRequest
     * @return Result of the DeleteFolder operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFolderResponse deleteFolder(DeleteFolderRequest deleteFolderRequest) throws InvalidParameterValueException,
            PreconditionNotMetException, AccessDeniedException, ResourceNotFoundException, ConflictException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFolderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolder");

            return clientHandler.execute(new ClientExecutionParams<DeleteFolderRequest, DeleteFolderResponse>()
                    .withOperationName("DeleteFolder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteFolderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFolderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
     * </p>
     *
     * @param deleteFolderMembershipRequest
     * @return Result of the DeleteFolderMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteFolderMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteFolderMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteFolderMembershipResponse deleteFolderMembership(DeleteFolderMembershipRequest deleteFolderMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFolderMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteFolderMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFolderMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFolderMembership");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteFolderMembershipRequest, DeleteFolderMembershipResponse>()
                            .withOperationName("DeleteFolderMembership").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteFolderMembershipRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteFolderMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a user group from Amazon QuickSight.
     * </p>
     *
     * @param deleteGroupRequest
     * @return Result of the DeleteGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGroupResponse deleteGroup(DeleteGroupRequest deleteGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroup");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupRequest, DeleteGroupResponse>()
                    .withOperationName("DeleteGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a user from a group so that the user is no longer a member of the group.
     * </p>
     *
     * @param deleteGroupMembershipRequest
     * @return Result of the DeleteGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteGroupMembershipResponse deleteGroupMembership(DeleteGroupMembershipRequest deleteGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteGroupMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGroupMembership");

            return clientHandler.execute(new ClientExecutionParams<DeleteGroupMembershipRequest, DeleteGroupMembershipResponse>()
                    .withOperationName("DeleteGroupMembership").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGroupMembershipRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGroupMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an existing IAM policy assignment.
     * </p>
     *
     * @param deleteIamPolicyAssignmentRequest
     * @return Result of the DeleteIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteIamPolicyAssignmentResponse deleteIAMPolicyAssignment(
            DeleteIamPolicyAssignmentRequest deleteIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteIamPolicyAssignmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteIAMPolicyAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteIamPolicyAssignmentRequest, DeleteIamPolicyAssignmentResponse>()
                            .withOperationName("DeleteIAMPolicyAssignment").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteIamPolicyAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteIamPolicyAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous
     * process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these
     * assets, you use the API operations for the relevant asset.
     * </p>
     *
     * @param deleteNamespaceRequest
     * @return Result of the DeleteNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteNamespaceResponse deleteNamespace(DeleteNamespaceRequest deleteNamespaceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteNamespace");

            return clientHandler.execute(new ClientExecutionParams<DeleteNamespaceRequest, DeleteNamespaceResponse>()
                    .withOperationName("DeleteNamespace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a template.
     * </p>
     *
     * @param deleteTemplateRequest
     * @return Result of the DeleteTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTemplateResponse deleteTemplate(DeleteTemplateRequest deleteTemplateRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ConflictException,
            LimitExceededException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplate");

            return clientHandler.execute(new ClientExecutionParams<DeleteTemplateRequest, DeleteTemplateResponse>()
                    .withOperationName("DeleteTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the
     * version of the template that the alias points to.
     * </p>
     *
     * @param deleteTemplateAliasRequest
     * @return Result of the DeleteTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteTemplateAliasResponse deleteTemplateAlias(DeleteTemplateAliasRequest deleteTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteTemplateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTemplateAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteTemplateAliasRequest, DeleteTemplateAliasResponse>()
                    .withOperationName("DeleteTemplateAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteTemplateAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTemplateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a theme.
     * </p>
     *
     * @param deleteThemeRequest
     * @return Result of the DeleteTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteThemeResponse deleteTheme(DeleteThemeRequest deleteThemeRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteTheme");

            return clientHandler.execute(new ClientExecutionParams<DeleteThemeRequest, DeleteThemeResponse>()
                    .withOperationName("DeleteTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteThemeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you
     * delete the version of the theme that the alias points to.
     * </p>
     *
     * @param deleteThemeAliasRequest
     * @return Result of the DeleteThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DeleteThemeAliasResponse deleteThemeAlias(DeleteThemeAliasRequest deleteThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteThemeAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteThemeAlias");

            return clientHandler.execute(new ClientExecutionParams<DeleteThemeAliasRequest, DeleteThemeAliasResponse>()
                    .withOperationName("DeleteThemeAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteThemeAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteThemeAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes the Amazon QuickSight user that is associated with the identity of the Identity and Access Management
     * (IAM) user or role that's making the call. The IAM user isn't deleted as a result of this call.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUser");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserRequest, DeleteUserResponse>().withOperationName("DeleteUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a user identified by its principal ID.
     * </p>
     *
     * @param deleteUserByPrincipalIdRequest
     * @return Result of the DeleteUserByPrincipalId operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DeleteUserByPrincipalId
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DeleteUserByPrincipalId"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DeleteUserByPrincipalIdResponse deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest deleteUserByPrincipalIdRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteUserByPrincipalIdResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DeleteUserByPrincipalIdResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteUserByPrincipalIdRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteUserByPrincipalId");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteUserByPrincipalIdRequest, DeleteUserByPrincipalIdResponse>()
                            .withOperationName("DeleteUserByPrincipalId").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(deleteUserByPrincipalIdRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteUserByPrincipalIdRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon
     * QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which
     * customizations to apply by running this API operation with the <code>Resolved</code> flag included.
     * </p>
     * <p>
     * To determine what customizations display when you run this command, it can help to visualize the relationship of
     * the entities involved.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Amazon Web Services account</code> - The Amazon Web Services account exists at the top of the hierarchy. It
     * has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you
     * subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's
     * where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services
     * Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Amazon Web Services Region</code> - In each Amazon Web Services Region where you sign in to Amazon
     * QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user
     * directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have
     * access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace.
     * </p>
     * <p>
     * To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using
     * the CLI, you can use one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html">command line
     * options</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Use <a href="https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html">named profiles</a>.
     * </p>
     * </li>
     * <li>
     * <p>
     * Run <code>aws configure</code> to change your default Amazon Web Services Region. Use Enter to key the same
     * settings for your keys. For more information, see <a
     * href="https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html">Configuring the CLI</a>.
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * <code>Namespace</code> - A QuickSight namespace is a partition that contains users and assets (data sources,
     * datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also
     * be part of the same namespace. People who share a namespace are completely isolated from users and assets in
     * other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>Applied customizations</code> - Within an Amazon Web Services Region, a set of Amazon QuickSight
     * customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a
     * namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a
     * single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the
     * <code>CreateAccountCustomization</code> command in each Amazon Web Services Region where you want to apply the
     * same customizations.
     * </p>
     * </li>
     * </ul>
     *
     * @param describeAccountCustomizationRequest
     * @return Result of the DescribeAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountCustomizationResponse describeAccountCustomization(
            DescribeAccountCustomizationRequest describeAccountCustomizationRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountCustomizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountCustomization");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountCustomizationRequest, DescribeAccountCustomizationResponse>()
                            .withOperationName("DescribeAccountCustomization").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountCustomizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountCustomizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon
     * Web Services account.
     * </p>
     *
     * @param describeAccountSettingsRequest
     * @return Result of the DescribeAccountSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountSettingsResponse describeAccountSettings(DescribeAccountSettingsRequest describeAccountSettingsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSettingsRequest, DescribeAccountSettingsResponse>()
                            .withOperationName("DescribeAccountSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the DescribeAccountSubscription operation to receive a description of an Amazon QuickSight account's
     * subscription. A successful API call returns an <code>AccountInfo</code> object that includes an account's name,
     * subscription status, authentication type, edition, and notification email address.
     * </p>
     *
     * @param describeAccountSubscriptionRequest
     * @return Result of the DescribeAccountSubscription operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAccountSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAccountSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAccountSubscriptionResponse describeAccountSubscription(
            DescribeAccountSubscriptionRequest describeAccountSubscriptionRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAccountSubscriptionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAccountSubscriptionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAccountSubscriptionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAccountSubscription");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAccountSubscriptionRequest, DescribeAccountSubscriptionResponse>()
                            .withOperationName("DescribeAccountSubscription").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAccountSubscriptionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAccountSubscriptionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a summary of the metadata for an analysis.
     * </p>
     *
     * @param describeAnalysisRequest
     * @return Result of the DescribeAnalysis operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeAnalysisResponse describeAnalysis(DescribeAnalysisRequest describeAnalysisRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeAnalysisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysis");

            return clientHandler.execute(new ClientExecutionParams<DescribeAnalysisRequest, DescribeAnalysisResponse>()
                    .withOperationName("DescribeAnalysis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a detailed description of the definition of an analysis.
     * </p>
     * <note>
     * <p>
     * If you do not need to know details about the content of an Analysis, for instance if you are trying to check the
     * status of a recently created or updated Analysis, use the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html">
     * <code>DescribeAnalysis</code> </a> instead.
     * </p>
     * </note>
     *
     * @param describeAnalysisDefinitionRequest
     * @return Result of the DescribeAnalysisDefinition operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysisDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAnalysisDefinitionResponse describeAnalysisDefinition(
            DescribeAnalysisDefinitionRequest describeAnalysisDefinitionRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnalysisDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAnalysisDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysisDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisDefinitionRequest, DescribeAnalysisDefinitionResponse>()
                            .withOperationName("DescribeAnalysisDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAnalysisDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAnalysisDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides the read and write permissions for an analysis.
     * </p>
     *
     * @param describeAnalysisPermissionsRequest
     * @return Result of the DescribeAnalysisPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeAnalysisPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeAnalysisPermissionsResponse describeAnalysisPermissions(
            DescribeAnalysisPermissionsRequest describeAnalysisPermissionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeAnalysisPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeAnalysisPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeAnalysisPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeAnalysisPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeAnalysisPermissionsRequest, DescribeAnalysisPermissionsResponse>()
                            .withOperationName("DescribeAnalysisPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeAnalysisPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeAnalysisPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a summary for a dashboard.
     * </p>
     *
     * @param describeDashboardRequest
     * @return Result of the DescribeDashboard operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDashboardResponse describeDashboard(DescribeDashboardRequest describeDashboardRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, AccessDeniedException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboard");

            return clientHandler.execute(new ClientExecutionParams<DescribeDashboardRequest, DescribeDashboardResponse>()
                    .withOperationName("DescribeDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a detailed description of the definition of a dashboard.
     * </p>
     * <note>
     * <p>
     * If you do not need to know details about the content of a dashboard, for instance if you are trying to check the
     * status of a recently created or updated dashboard, use the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html">
     * <code>DescribeDashboard</code> </a> instead.
     * </p>
     * </note>
     *
     * @param describeDashboardDefinitionRequest
     * @return Result of the DescribeDashboardDefinition operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDashboardDefinitionResponse describeDashboardDefinition(
            DescribeDashboardDefinitionRequest describeDashboardDefinitionRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDashboardDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardDefinitionRequest, DescribeDashboardDefinitionResponse>()
                            .withOperationName("DescribeDashboardDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDashboardDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDashboardDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes read and write permissions for a dashboard.
     * </p>
     *
     * @param describeDashboardPermissionsRequest
     * @return Result of the DescribeDashboardPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDashboardPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDashboardPermissionsResponse describeDashboardPermissions(
            DescribeDashboardPermissionsRequest describeDashboardPermissionsRequest) throws InvalidParameterValueException,
            ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDashboardPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDashboardPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDashboardPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDashboardPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDashboardPermissionsRequest, DescribeDashboardPermissionsResponse>()
                            .withOperationName("DescribeDashboardPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDashboardPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDashboardPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
     * </p>
     *
     * @param describeDataSetRequest
     * @return Result of the DescribeDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSet" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDataSetResponse describeDataSet(DescribeDataSetRequest describeDataSetRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeDataSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSet");

            return clientHandler.execute(new ClientExecutionParams<DescribeDataSetRequest, DescribeDataSetResponse>()
                    .withOperationName("DescribeDataSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDataSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param describeDataSetPermissionsRequest
     * @return Result of the DescribeDataSetPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSetPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDataSetPermissionsResponse describeDataSetPermissions(
            DescribeDataSetPermissionsRequest describeDataSetPermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSetPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDataSetPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSetPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSetPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSetPermissionsRequest, DescribeDataSetPermissionsResponse>()
                            .withOperationName("DescribeDataSetPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDataSetPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDataSetPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a data source.
     * </p>
     *
     * @param describeDataSourceRequest
     * @return Result of the DescribeDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeDataSourceResponse describeDataSource(DescribeDataSourceRequest describeDataSourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSource");

            return clientHandler.execute(new ClientExecutionParams<DescribeDataSourceRequest, DescribeDataSourceResponse>()
                    .withOperationName("DescribeDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the resource permissions for a data source.
     * </p>
     *
     * @param describeDataSourcePermissionsRequest
     * @return Result of the DescribeDataSourcePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeDataSourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeDataSourcePermissionsResponse describeDataSourcePermissions(
            DescribeDataSourcePermissionsRequest describeDataSourcePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, ResourceNotFoundException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeDataSourcePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeDataSourcePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeDataSourcePermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeDataSourcePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeDataSourcePermissionsRequest, DescribeDataSourcePermissionsResponse>()
                            .withOperationName("DescribeDataSourcePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeDataSourcePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeDataSourcePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a folder.
     * </p>
     *
     * @param describeFolderRequest
     * @return Result of the DescribeFolder operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeFolderResponse describeFolder(DescribeFolderRequest describeFolderRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeFolderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFolder");

            return clientHandler.execute(new ClientExecutionParams<DescribeFolderRequest, DescribeFolderResponse>()
                    .withOperationName("DescribeFolder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeFolderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeFolderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes permissions for a folder.
     * </p>
     *
     * @param describeFolderPermissionsRequest
     * @return Result of the DescribeFolderPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeFolderPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFolderPermissionsResponse describeFolderPermissions(
            DescribeFolderPermissionsRequest describeFolderPermissionsRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFolderPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFolderPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeFolderPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFolderPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFolderPermissionsRequest, DescribeFolderPermissionsResponse>()
                            .withOperationName("DescribeFolderPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeFolderPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFolderPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the
     * inherited permissions from the ancestor folders.
     * </p>
     *
     * @param describeFolderResolvedPermissionsRequest
     * @return Result of the DescribeFolderResolvedPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeFolderResolvedPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeFolderResolvedPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeFolderResolvedPermissionsResponse describeFolderResolvedPermissions(
            DescribeFolderResolvedPermissionsRequest describeFolderResolvedPermissionsRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeFolderResolvedPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeFolderResolvedPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                describeFolderResolvedPermissionsRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeFolderResolvedPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeFolderResolvedPermissionsRequest, DescribeFolderResolvedPermissionsResponse>()
                            .withOperationName("DescribeFolderResolvedPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeFolderResolvedPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeFolderResolvedPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     * </p>
     *
     * @param describeGroupRequest
     * @return Result of the DescribeGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeGroupResponse describeGroup(DescribeGroupRequest describeGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGroup");

            return clientHandler.execute(new ClientExecutionParams<DescribeGroupRequest, DescribeGroupResponse>()
                    .withOperationName("DescribeGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>DescribeGroupMembership</code> operation to determine if a user is a member of the specified group.
     * If the user exists and is a member of the specified group, an associated <code>GroupMember</code> object is
     * returned.
     * </p>
     *
     * @param describeGroupMembershipRequest
     * @return Result of the DescribeGroupMembership operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeGroupMembership
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeGroupMembership"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeGroupMembershipResponse describeGroupMembership(DescribeGroupMembershipRequest describeGroupMembershipRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeGroupMembershipResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeGroupMembershipResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeGroupMembershipRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeGroupMembership");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeGroupMembershipRequest, DescribeGroupMembershipResponse>()
                            .withOperationName("DescribeGroupMembership").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeGroupMembershipRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeGroupMembershipRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes an existing IAM policy assignment, as specified by the assignment name.
     * </p>
     *
     * @param describeIamPolicyAssignmentRequest
     * @return Result of the DescribeIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeIamPolicyAssignmentResponse describeIAMPolicyAssignment(
            DescribeIamPolicyAssignmentRequest describeIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeIamPolicyAssignmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIAMPolicyAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeIamPolicyAssignmentRequest, DescribeIamPolicyAssignmentResponse>()
                            .withOperationName("DescribeIAMPolicyAssignment").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeIamPolicyAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeIamPolicyAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a SPICE ingestion.
     * </p>
     *
     * @param describeIngestionRequest
     * @return Result of the DescribeIngestion operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeIngestion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIngestion" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeIngestionResponse describeIngestion(DescribeIngestionRequest describeIngestionRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIngestionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeIngestionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIngestionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIngestion");

            return clientHandler.execute(new ClientExecutionParams<DescribeIngestionRequest, DescribeIngestionResponse>()
                    .withOperationName("DescribeIngestion").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeIngestionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIngestionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a summary and status of IP rules.
     * </p>
     *
     * @param describeIpRestrictionRequest
     * @return Result of the DescribeIpRestriction operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeIpRestriction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeIpRestriction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeIpRestrictionResponse describeIpRestriction(DescribeIpRestrictionRequest describeIpRestrictionRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, ResourceNotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeIpRestrictionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeIpRestrictionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeIpRestrictionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeIpRestriction");

            return clientHandler.execute(new ClientExecutionParams<DescribeIpRestrictionRequest, DescribeIpRestrictionResponse>()
                    .withOperationName("DescribeIpRestriction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeIpRestrictionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeIpRestrictionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the current namespace.
     * </p>
     *
     * @param describeNamespaceRequest
     * @return Result of the DescribeNamespace operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeNamespace
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeNamespace" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeNamespaceResponse describeNamespace(DescribeNamespaceRequest describeNamespaceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeNamespaceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeNamespaceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeNamespaceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeNamespace");

            return clientHandler.execute(new ClientExecutionParams<DescribeNamespaceRequest, DescribeNamespaceResponse>()
                    .withOperationName("DescribeNamespace").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeNamespaceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeNamespaceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a template's metadata.
     * </p>
     *
     * @param describeTemplateRequest
     * @return Result of the DescribeTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplate" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeTemplateResponse describeTemplate(DescribeTemplateRequest describeTemplateRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, ConflictException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTemplate");

            return clientHandler.execute(new ClientExecutionParams<DescribeTemplateRequest, DescribeTemplateResponse>()
                    .withOperationName("DescribeTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the template alias for a template.
     * </p>
     *
     * @param describeTemplateAliasRequest
     * @return Result of the DescribeTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTemplateAliasResponse describeTemplateAlias(DescribeTemplateAliasRequest describeTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTemplateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTemplateAlias");

            return clientHandler.execute(new ClientExecutionParams<DescribeTemplateAliasRequest, DescribeTemplateAliasResponse>()
                    .withOperationName("DescribeTemplateAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeTemplateAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeTemplateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Provides a detailed description of the definition of a template.
     * </p>
     * <note>
     * <p>
     * If you do not need to know details about the content of a template, for instance if you are trying to check the
     * status of a recently created or updated template, use the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html">
     * <code>DescribeTemplate</code> </a> instead.
     * </p>
     * </note>
     *
     * @param describeTemplateDefinitionRequest
     * @return Result of the DescribeTemplateDefinition operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplateDefinition
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplateDefinition"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTemplateDefinitionResponse describeTemplateDefinition(
            DescribeTemplateDefinitionRequest describeTemplateDefinitionRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceExistsException, ResourceNotFoundException, ThrottlingException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTemplateDefinitionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTemplateDefinitionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTemplateDefinitionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTemplateDefinition");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTemplateDefinitionRequest, DescribeTemplateDefinitionResponse>()
                            .withOperationName("DescribeTemplateDefinition").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeTemplateDefinitionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTemplateDefinitionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes read and write permissions on a template.
     * </p>
     *
     * @param describeTemplatePermissionsRequest
     * @return Result of the DescribeTemplatePermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTemplatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeTemplatePermissionsResponse describeTemplatePermissions(
            DescribeTemplatePermissionsRequest describeTemplatePermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeTemplatePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeTemplatePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeTemplatePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTemplatePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeTemplatePermissionsRequest, DescribeTemplatePermissionsResponse>()
                            .withOperationName("DescribeTemplatePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeTemplatePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeTemplatePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes a theme.
     * </p>
     *
     * @param describeThemeRequest
     * @return Result of the DescribeTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeThemeResponse describeTheme(DescribeThemeRequest describeThemeRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeTheme");

            return clientHandler.execute(new ClientExecutionParams<DescribeThemeRequest, DescribeThemeResponse>()
                    .withOperationName("DescribeTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeThemeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the alias for a theme.
     * </p>
     *
     * @param describeThemeAliasRequest
     * @return Result of the DescribeThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public DescribeThemeAliasResponse describeThemeAlias(DescribeThemeAliasRequest describeThemeAliasRequest)
            throws ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeThemeAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThemeAlias");

            return clientHandler.execute(new ClientExecutionParams<DescribeThemeAliasRequest, DescribeThemeAliasResponse>()
                    .withOperationName("DescribeThemeAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeThemeAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeThemeAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Describes the read and write permissions for a theme.
     * </p>
     *
     * @param describeThemePermissionsRequest
     * @return Result of the DescribeThemePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeThemePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DescribeThemePermissionsResponse describeThemePermissions(
            DescribeThemePermissionsRequest describeThemePermissionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeThemePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DescribeThemePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeThemePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeThemePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<DescribeThemePermissionsRequest, DescribeThemePermissionsResponse>()
                            .withOperationName("DescribeThemePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(describeThemePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DescribeThemePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns information about a user, given the user name.
     * </p>
     *
     * @param describeUserRequest
     * @return Result of the DescribeUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.DescribeUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/DescribeUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DescribeUserResponse describeUser(DescribeUserRequest describeUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DescribeUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DescribeUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, describeUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DescribeUser");

            return clientHandler.execute(new ClientExecutionParams<DescribeUserRequest, DescribeUserResponse>()
                    .withOperationName("DescribeUser").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(describeUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DescribeUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website,
     * without having to register any reader users. Before you use this action, make sure that you have configured the
     * dashboards and permissions.
     * </p>
     * <p>
     * The following rules apply to the generated URL:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this
     * period, it cannot be re-used again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The URL validity period should not be confused with the actual session lifetime that can be customized using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code>
     * parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default
     * session duration is 10 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the
     * <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
     * customize embedding, visit the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer
     * Portal</a>.
     * </p>
     *
     * @param generateEmbedUrlForAnonymousUserRequest
     * @return Result of the GenerateEmbedUrlForAnonymousUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws UnsupportedPricingPlanException
     *         This error indicates that you are calling an embedding operation in Amazon QuickSight without the
     *         required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous
     *         users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on
     *         the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GenerateEmbedUrlForAnonymousUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForAnonymousUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GenerateEmbedUrlForAnonymousUserResponse generateEmbedUrlForAnonymousUser(
            GenerateEmbedUrlForAnonymousUserRequest generateEmbedUrlForAnonymousUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            SessionLifetimeInMinutesInvalidException, UnsupportedUserEditionException, UnsupportedPricingPlanException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GenerateEmbedUrlForAnonymousUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GenerateEmbedUrlForAnonymousUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateEmbedUrlForAnonymousUserRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateEmbedUrlForAnonymousUser");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateEmbedUrlForAnonymousUserRequest, GenerateEmbedUrlForAnonymousUserResponse>()
                            .withOperationName("GenerateEmbedUrlForAnonymousUser").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(generateEmbedUrlForAnonymousUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateEmbedUrlForAnonymousUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can
     * be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure
     * that you have configured the relevant Amazon QuickSight resource and permissions.
     * </p>
     * <p>
     * The following rules apply to the generated URL:
     * </p>
     * <ul>
     * <li>
     * <p>
     * It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this
     * period, it cannot be re-used again.
     * </p>
     * </li>
     * <li>
     * <p>
     * The URL validity period should not be confused with the actual session lifetime that can be customized using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> </code>
     * parameter.
     * </p>
     * <p>
     * The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration
     * is 10 hours.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedded Analytics</a> in the
     * <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
     * customize embedding, visit the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer
     * Portal</a>.
     * </p>
     *
     * @param generateEmbedUrlForRegisteredUserRequest
     * @return Result of the GenerateEmbedUrlForRegisteredUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws QuickSightUserNotFoundException
     *         The user with the provided name isn't found. This error can happen in any operation that requires finding
     *         a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so
     *         on.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws UnsupportedPricingPlanException
     *         This error indicates that you are calling an embedding operation in Amazon QuickSight without the
     *         required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous
     *         users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on
     *         the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GenerateEmbedUrlForRegisteredUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GenerateEmbedUrlForRegisteredUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GenerateEmbedUrlForRegisteredUserResponse generateEmbedUrlForRegisteredUser(
            GenerateEmbedUrlForRegisteredUserRequest generateEmbedUrlForRegisteredUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, QuickSightUserNotFoundException, ResourceNotFoundException,
            SessionLifetimeInMinutesInvalidException, ThrottlingException, UnsupportedUserEditionException,
            UnsupportedPricingPlanException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GenerateEmbedUrlForRegisteredUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GenerateEmbedUrlForRegisteredUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                generateEmbedUrlForRegisteredUserRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GenerateEmbedUrlForRegisteredUser");

            return clientHandler
                    .execute(new ClientExecutionParams<GenerateEmbedUrlForRegisteredUserRequest, GenerateEmbedUrlForRegisteredUserResponse>()
                            .withOperationName("GenerateEmbedUrlForRegisteredUser").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(generateEmbedUrlForRegisteredUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GenerateEmbedUrlForRegisteredUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon
     * QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you
     * have configured the dashboards and permissions.
     * </p>
     * <p>
     * Currently, you can use <code>GetDashboardEmbedURL</code> only from the server, not from the user's browser. The
     * following rules apply to the generated URL:
     * </p>
     * <ul>
     * <li>
     * <p>
     * They must be used together.
     * </p>
     * </li>
     * <li>
     * <p>
     * They can be used one time only.
     * </p>
     * </li>
     * <li>
     * <p>
     * They are valid for 5 minutes after you run this command.
     * </p>
     * </li>
     * <li>
     * <p>
     * You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * </p>
     * </li>
     * <li>
     * <p>
     * The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional
     * <code>SessionLifetimeInMinutes</code> parameter to customize session duration.
     * </p>
     * </li>
     * </ul>
     * <p>
     * For more information, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html">Embedding Analytics
     * Using GetDashboardEmbedUrl</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     * <p>
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can
     * customize embedding, visit the <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html">Amazon QuickSight Developer
     * Portal</a>.
     * </p>
     *
     * @param getDashboardEmbedUrlRequest
     * @return Result of the GetDashboardEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws DomainNotWhitelistedException
     *         The domain specified isn't on the allow list. All domains for embedded dashboards must be added to the
     *         approved list by an Amazon QuickSight admin.
     * @throws QuickSightUserNotFoundException
     *         The user with the provided name isn't found. This error can happen in any operation that requires finding
     *         a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so
     *         on.
     * @throws IdentityTypeNotSupportedException
     *         The identity type specified isn't supported. Supported identity types include <code>IAM</code> and
     *         <code>QUICKSIGHT</code>.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws UnsupportedPricingPlanException
     *         This error indicates that you are calling an embedding operation in Amazon QuickSight without the
     *         required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous
     *         users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on
     *         the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetDashboardEmbedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetDashboardEmbedUrl"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDashboardEmbedUrlResponse getDashboardEmbedUrl(GetDashboardEmbedUrlRequest getDashboardEmbedUrlRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, DomainNotWhitelistedException, QuickSightUserNotFoundException,
            IdentityTypeNotSupportedException, SessionLifetimeInMinutesInvalidException, UnsupportedUserEditionException,
            UnsupportedPricingPlanException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDashboardEmbedUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDashboardEmbedUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDashboardEmbedUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDashboardEmbedUrl");

            return clientHandler.execute(new ClientExecutionParams<GetDashboardEmbedUrlRequest, GetDashboardEmbedUrlResponse>()
                    .withOperationName("GetDashboardEmbedUrl").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDashboardEmbedUrlRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDashboardEmbedUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in
     * your web server code. Use <code>GetSessionEmbedUrl</code> where you want to provide an authoring portal that
     * allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon
     * QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to
     * some of these features, add a custom permissions profile to the user with the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> </code>
     * API operation. Use
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> </code>
     * API operation to add a new user with a custom permission profile attached. For more information, see the
     * following sections in the <i>Amazon QuickSight User Guide</i>:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html">Embedding Analytics</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href=
     * "https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html"
     * >Customizing Access to the Amazon QuickSight Console</a>
     * </p>
     * </li>
     * </ul>
     *
     * @param getSessionEmbedUrlRequest
     * @return Result of the GetSessionEmbedUrl operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws QuickSightUserNotFoundException
     *         The user with the provided name isn't found. This error can happen in any operation that requires finding
     *         a user based on a provided user name, such as <code>DeleteUser</code>, <code>DescribeUser</code>, and so
     *         on.
     * @throws SessionLifetimeInMinutesInvalidException
     *         The number of minutes specified for the lifetime of a session isn't valid. The session lifetime must be
     *         15-600 minutes.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.GetSessionEmbedUrl
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/GetSessionEmbedUrl" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetSessionEmbedUrlResponse getSessionEmbedUrl(GetSessionEmbedUrlRequest getSessionEmbedUrlRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, QuickSightUserNotFoundException, SessionLifetimeInMinutesInvalidException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSessionEmbedUrlResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSessionEmbedUrlResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSessionEmbedUrlRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSessionEmbedUrl");

            return clientHandler.execute(new ClientExecutionParams<GetSessionEmbedUrlRequest, GetSessionEmbedUrlResponse>()
                    .withOperationName("GetSessionEmbedUrl").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getSessionEmbedUrlRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetSessionEmbedUrlRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
     * </p>
     *
     * @param listAnalysesRequest
     * @return Result of the ListAnalyses operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAnalysesResponse listAnalyses(ListAnalysesRequest listAnalysesRequest) throws ThrottlingException,
            InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListAnalysesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListAnalysesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listAnalysesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListAnalyses");

            return clientHandler.execute(new ClientExecutionParams<ListAnalysesRequest, ListAnalysesResponse>()
                    .withOperationName("ListAnalyses").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listAnalysesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListAnalysesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListAnalysesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListAnalysesIterable responses = client.listAnalysesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAnalyses(software.amazon.awssdk.services.quicksight.model.ListAnalysesRequest)} operation.</b>
     * </p>
     *
     * @param listAnalysesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListAnalysesIterable listAnalysesPaginator(ListAnalysesRequest listAnalysesRequest) throws ThrottlingException,
            InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return new ListAnalysesIterable(this, applyPaginatorUserAgent(listAnalysesRequest));
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return Result of the ListDashboardVersions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboardVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDashboardVersionsResponse listDashboardVersions(ListDashboardVersionsRequest listDashboardVersionsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDashboardVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListDashboardVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDashboardVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDashboardVersions");

            return clientHandler.execute(new ClientExecutionParams<ListDashboardVersionsRequest, ListDashboardVersionsResponse>()
                    .withOperationName("ListDashboardVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDashboardVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDashboardVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client.listDashboardVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client
     *             .listDashboardVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardVersionsIterable responses = client.listDashboardVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboardVersions(software.amazon.awssdk.services.quicksight.model.ListDashboardVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listDashboardVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboardVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboardVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListDashboardVersionsIterable listDashboardVersionsPaginator(ListDashboardVersionsRequest listDashboardVersionsRequest)
            throws InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return new ListDashboardVersionsIterable(this, applyPaginatorUserAgent(listDashboardVersionsRequest));
    }

    /**
     * <p>
     * Lists dashboards in an Amazon Web Services account.
     * </p>
     *
     * @param listDashboardsRequest
     * @return Result of the ListDashboards operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDashboardsResponse listDashboards(ListDashboardsRequest listDashboardsRequest) throws ThrottlingException,
            InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDashboardsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDashboardsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDashboardsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDashboards");

            return clientHandler.execute(new ClientExecutionParams<ListDashboardsRequest, ListDashboardsResponse>()
                    .withOperationName("ListDashboards").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDashboardsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDashboardsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists dashboards in an Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client
     *             .listDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDashboardsIterable responses = client.listDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDashboards(software.amazon.awssdk.services.quicksight.model.ListDashboardsRequest)} operation.</b>
     * </p>
     *
     * @param listDashboardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDashboards" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDashboardsIterable listDashboardsPaginator(ListDashboardsRequest listDashboardsRequest)
            throws ThrottlingException, InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return new ListDashboardsIterable(this, applyPaginatorUserAgent(listDashboardsRequest));
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     *
     * @param listDataSetsRequest
     * @return Result of the ListDataSets operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDataSetsResponse listDataSets(ListDataSetsRequest listDataSetsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, InvalidNextTokenException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDataSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSets");

            return clientHandler.execute(new ClientExecutionParams<ListDataSetsRequest, ListDataSetsResponse>()
                    .withOperationName("ListDataSets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDataSetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDataSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/*</code>.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDataSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSetsIterable responses = client.listDataSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSets(software.amazon.awssdk.services.quicksight.model.ListDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param listDataSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDataSetsIterable listDataSetsPaginator(ListDataSetsRequest listDataSetsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, InvalidNextTokenException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        return new ListDataSetsIterable(this, applyPaginatorUserAgent(listDataSetsRequest));
    }

    /**
     * <p>
     * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws AccessDeniedException,
            InvalidParameterValueException, ThrottlingException, InvalidNextTokenException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDataSourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSources");

            return clientHandler.execute(new ClientExecutionParams<ListDataSourcesRequest, ListDataSourcesResponse>()
                    .withOperationName("ListDataSources").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDataSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDataSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.quicksight.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return new ListDataSourcesIterable(this, applyPaginatorUserAgent(listDataSourcesRequest));
    }

    /**
     * <p>
     * List all assets (<code>DASHBOARD</code>, <code>ANALYSIS</code>, and <code>DATASET</code>) in a folder.
     * </p>
     *
     * @param listFolderMembersRequest
     * @return Result of the ListFolderMembers operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListFolderMembers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolderMembers" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListFolderMembersResponse listFolderMembers(ListFolderMembersRequest listFolderMembersRequest)
            throws InvalidParameterValueException, AccessDeniedException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFolderMembersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFolderMembersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFolderMembersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFolderMembers");

            return clientHandler.execute(new ClientExecutionParams<ListFolderMembersRequest, ListFolderMembersResponse>()
                    .withOperationName("ListFolderMembers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listFolderMembersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFolderMembersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all folders in an account.
     * </p>
     *
     * @param listFoldersRequest
     * @return Result of the ListFolders operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListFolders" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFoldersResponse listFolders(ListFoldersRequest listFoldersRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFoldersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFoldersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFoldersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFolders");

            return clientHandler.execute(new ClientExecutionParams<ListFoldersRequest, ListFoldersResponse>()
                    .withOperationName("ListFolders").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listFoldersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFoldersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists member users in a group.
     * </p>
     *
     * @param listGroupMembershipsRequest
     * @return Result of the ListGroupMemberships operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroupMemberships
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroupMemberships"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListGroupMembershipsResponse listGroupMemberships(ListGroupMembershipsRequest listGroupMembershipsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupMembershipsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListGroupMembershipsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupMembershipsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroupMemberships");

            return clientHandler.execute(new ClientExecutionParams<ListGroupMembershipsRequest, ListGroupMembershipsResponse>()
                    .withOperationName("ListGroupMemberships").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGroupMembershipsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGroupMembershipsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all user groups in Amazon QuickSight.
     * </p>
     *
     * @param listGroupsRequest
     * @return Result of the ListGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGroupsResponse listGroups(ListGroupsRequest listGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGroups");

            return clientHandler
                    .execute(new ClientExecutionParams<ListGroupsRequest, ListGroupsResponse>().withOperationName("ListGroups")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listGroupsRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists IAM policy assignments in the current Amazon QuickSight account.
     * </p>
     *
     * @param listIamPolicyAssignmentsRequest
     * @return Result of the ListIAMPolicyAssignments operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIAMPolicyAssignments
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignments"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIamPolicyAssignmentsResponse listIAMPolicyAssignments(
            ListIamPolicyAssignmentsRequest listIamPolicyAssignmentsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIamPolicyAssignmentsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIamPolicyAssignmentsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIamPolicyAssignmentsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIAMPolicyAssignments");

            return clientHandler
                    .execute(new ClientExecutionParams<ListIamPolicyAssignmentsRequest, ListIamPolicyAssignmentsResponse>()
                            .withOperationName("ListIAMPolicyAssignments").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listIamPolicyAssignmentsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListIamPolicyAssignmentsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the IAM policy assignments, including the Amazon Resource Names (ARNs) for the IAM policies assigned to
     * the specified user and group or groups that the user belongs to.
     * </p>
     *
     * @param listIamPolicyAssignmentsForUserRequest
     * @return Result of the ListIAMPolicyAssignmentsForUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIAMPolicyAssignmentsForUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIAMPolicyAssignmentsForUser"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListIamPolicyAssignmentsForUserResponse listIAMPolicyAssignmentsForUser(
            ListIamPolicyAssignmentsForUserRequest listIamPolicyAssignmentsForUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIamPolicyAssignmentsForUserResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListIamPolicyAssignmentsForUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                listIamPolicyAssignmentsForUserRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIAMPolicyAssignmentsForUser");

            return clientHandler
                    .execute(new ClientExecutionParams<ListIamPolicyAssignmentsForUserRequest, ListIamPolicyAssignmentsForUserResponse>()
                            .withOperationName("ListIAMPolicyAssignmentsForUser").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listIamPolicyAssignmentsForUserRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListIamPolicyAssignmentsForUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     *
     * @param listIngestionsRequest
     * @return Result of the ListIngestions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIngestionsResponse listIngestions(ListIngestionsRequest listIngestionsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, ResourceExistsException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListIngestionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListIngestionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listIngestionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListIngestions");

            return clientHandler.execute(new ClientExecutionParams<ListIngestionsRequest, ListIngestionsResponse>()
                    .withOperationName("ListIngestions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listIngestionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListIngestionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the history of SPICE ingestions for a dataset.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client
     *             .listIngestionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListIngestionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListIngestionsIterable responses = client.listIngestionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listIngestions(software.amazon.awssdk.services.quicksight.model.ListIngestionsRequest)} operation.</b>
     * </p>
     *
     * @param listIngestionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListIngestions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListIngestions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListIngestionsIterable listIngestionsPaginator(ListIngestionsRequest listIngestionsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            ResourceExistsException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return new ListIngestionsIterable(this, applyPaginatorUserAgent(listIngestionsRequest));
    }

    /**
     * <p>
     * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted
     * namespaces.
     * </p>
     *
     * @param listNamespacesRequest
     * @return Result of the ListNamespaces operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListNamespacesResponse listNamespaces(ListNamespacesRequest listNamespacesRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListNamespacesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListNamespacesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listNamespacesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListNamespaces");

            return clientHandler.execute(new ClientExecutionParams<ListNamespacesRequest, ListNamespacesResponse>()
                    .withOperationName("ListNamespaces").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listNamespacesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListNamespacesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted
     * namespaces.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client
     *             .listNamespacesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListNamespacesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListNamespacesIterable responses = client.listNamespacesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listNamespaces(software.amazon.awssdk.services.quicksight.model.ListNamespacesRequest)} operation.</b>
     * </p>
     *
     * @param listNamespacesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListNamespaces
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListNamespaces" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListNamespacesIterable listNamespacesPaginator(ListNamespacesRequest listNamespacesRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InvalidNextTokenException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        return new ListNamespacesIterable(this, applyPaginatorUserAgent(listNamespacesRequest));
    }

    /**
     * <p>
     * Lists the tags assigned to a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTagsForResource"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return Result of the ListTemplateAliases operation returned by the service.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTemplateAliasesResponse listTemplateAliases(ListTemplateAliasesRequest listTemplateAliasesRequest)
            throws InvalidNextTokenException, ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTemplateAliasesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTemplateAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateAliases");

            return clientHandler.execute(new ClientExecutionParams<ListTemplateAliasesRequest, ListTemplateAliasesResponse>()
                    .withOperationName("ListTemplateAliases").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTemplateAliasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTemplateAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the aliases of a template.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client.listTemplateAliasesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client
     *             .listTemplateAliasesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateAliasesIterable responses = client.listTemplateAliasesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateAliases(software.amazon.awssdk.services.quicksight.model.ListTemplateAliasesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateAliasesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateAliases"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTemplateAliasesIterable listTemplateAliasesPaginator(ListTemplateAliasesRequest listTemplateAliasesRequest)
            throws InvalidNextTokenException, ThrottlingException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return new ListTemplateAliasesIterable(this, applyPaginatorUserAgent(listTemplateAliasesRequest));
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return Result of the ListTemplateVersions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTemplateVersionsResponse listTemplateVersions(ListTemplateVersionsRequest listTemplateVersionsRequest)
            throws ThrottlingException, InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTemplateVersionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTemplateVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplateVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplateVersions");

            return clientHandler.execute(new ClientExecutionParams<ListTemplateVersionsRequest, ListTemplateVersionsResponse>()
                    .withOperationName("ListTemplateVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTemplateVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTemplateVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client.listTemplateVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client
     *             .listTemplateVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplateVersionsIterable responses = client.listTemplateVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateVersions(software.amazon.awssdk.services.quicksight.model.ListTemplateVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTemplateVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplateVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplateVersions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTemplateVersionsIterable listTemplateVersionsPaginator(ListTemplateVersionsRequest listTemplateVersionsRequest)
            throws ThrottlingException, InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return new ListTemplateVersionsIterable(this, applyPaginatorUserAgent(listTemplateVersionsRequest));
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     *
     * @param listTemplatesRequest
     * @return Result of the ListTemplates operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTemplatesResponse listTemplates(ListTemplatesRequest listTemplatesRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTemplatesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTemplatesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTemplatesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTemplates");

            return clientHandler.execute(new ClientExecutionParams<ListTemplatesRequest, ListTemplatesResponse>()
                    .withOperationName("ListTemplates").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTemplatesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTemplatesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the templates in the current Amazon QuickSight account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client
     *             .listTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListTemplatesIterable responses = client.listTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplates(software.amazon.awssdk.services.quicksight.model.ListTemplatesRequest)} operation.</b>
     * </p>
     *
     * @param listTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListTemplates" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTemplatesIterable listTemplatesPaginator(ListTemplatesRequest listTemplatesRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, InvalidNextTokenException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return new ListTemplatesIterable(this, applyPaginatorUserAgent(listTemplatesRequest));
    }

    /**
     * <p>
     * Lists all the aliases of a theme.
     * </p>
     *
     * @param listThemeAliasesRequest
     * @return Result of the ListThemeAliases operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemeAliases
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeAliases" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListThemeAliasesResponse listThemeAliases(ListThemeAliasesRequest listThemeAliasesRequest) throws ConflictException,
            InvalidNextTokenException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThemeAliasesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListThemeAliasesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThemeAliasesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThemeAliases");

            return clientHandler.execute(new ClientExecutionParams<ListThemeAliasesRequest, ListThemeAliasesResponse>()
                    .withOperationName("ListThemeAliases").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listThemeAliasesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListThemeAliasesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the versions of the themes in the current Amazon Web Services account.
     * </p>
     *
     * @param listThemeVersionsRequest
     * @return Result of the ListThemeVersions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListThemeVersionsResponse listThemeVersions(ListThemeVersionsRequest listThemeVersionsRequest)
            throws AccessDeniedException, InvalidNextTokenException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThemeVersionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListThemeVersionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThemeVersionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThemeVersions");

            return clientHandler.execute(new ClientExecutionParams<ListThemeVersionsRequest, ListThemeVersionsResponse>()
                    .withOperationName("ListThemeVersions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listThemeVersionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListThemeVersionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the versions of the themes in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listThemeVersions(software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemeVersionsIterable responses = client.listThemeVersionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListThemeVersionsIterable responses = client
     *             .listThemeVersionsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListThemeVersionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemeVersionsIterable responses = client.listThemeVersionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemeVersions(software.amazon.awssdk.services.quicksight.model.ListThemeVersionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listThemeVersionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemeVersions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemeVersions" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListThemeVersionsIterable listThemeVersionsPaginator(ListThemeVersionsRequest listThemeVersionsRequest)
            throws AccessDeniedException, InvalidNextTokenException, InvalidParameterValueException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return new ListThemeVersionsIterable(this, applyPaginatorUserAgent(listThemeVersionsRequest));
    }

    /**
     * <p>
     * Lists all the themes in the current Amazon Web Services account.
     * </p>
     *
     * @param listThemesRequest
     * @return Result of the ListThemes operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListThemesResponse listThemes(ListThemesRequest listThemesRequest) throws AccessDeniedException,
            InvalidParameterValueException, InvalidNextTokenException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListThemesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListThemesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listThemesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListThemes");

            return clientHandler
                    .execute(new ClientExecutionParams<ListThemesRequest, ListThemesResponse>().withOperationName("ListThemes")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(listThemesRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListThemesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists all the themes in the current Amazon Web Services account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listThemes(software.amazon.awssdk.services.quicksight.model.ListThemesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.ListThemesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.ListThemesIterable responses = client.listThemesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listThemes(software.amazon.awssdk.services.quicksight.model.ListThemesRequest)} operation.</b>
     * </p>
     *
     * @param listThemesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListThemes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListThemes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListThemesIterable listThemesPaginator(ListThemesRequest listThemesRequest) throws AccessDeniedException,
            InvalidParameterValueException, InvalidNextTokenException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        return new ListThemesIterable(this, applyPaginatorUserAgent(listThemesRequest));
    }

    /**
     * <p>
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     * </p>
     *
     * @param listUserGroupsRequest
     * @return Result of the ListUserGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUserGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUserGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUserGroupsResponse listUserGroups(ListUserGroupsRequest listUserGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUserGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUserGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUserGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUserGroups");

            return clientHandler.execute(new ClientExecutionParams<ListUserGroupsRequest, ListUserGroupsResponse>()
                    .withOperationName("ListUserGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUserGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListUserGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     * </p>
     *
     * @param listUsersRequest
     * @return Result of the ListUsers operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.ListUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/ListUsers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListUsersResponse listUsers(ListUsersRequest listUsersRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListUsersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListUsersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listUsersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListUsers");

            return clientHandler.execute(new ClientExecutionParams<ListUsersRequest, ListUsersResponse>()
                    .withOperationName("ListUsers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listUsersRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListUsersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an Amazon QuickSight user whose identity is associated with the Identity and Access Management (IAM)
     * identity or role specified in the request. When you register a new user from the Amazon QuickSight API, Amazon
     * QuickSight generates a registration URL. The user accesses this registration URL to create their account. Amazon
     * QuickSight doesn't send a registration email to users who are registered from the Amazon QuickSight API. If you
     * want new users to receive a registration email, then add those users in the Amazon QuickSight console. For more
     * information on registering a new user in the Amazon QuickSight console, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/managing-users.html#inviting-users"> Inviting users to
     * access Amazon QuickSight</a>.
     * </p>
     *
     * @param registerUserRequest
     * @return Result of the RegisterUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RegisterUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RegisterUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public RegisterUserResponse registerUser(RegisterUserRequest registerUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, LimitExceededException,
            ResourceExistsException, PreconditionNotMetException, InternalFailureException, ResourceUnavailableException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RegisterUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RegisterUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, registerUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RegisterUser");

            return clientHandler.execute(new ClientExecutionParams<RegisterUserRequest, RegisterUserResponse>()
                    .withOperationName("RegisterUser").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(registerUserRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RegisterUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Restores an analysis.
     * </p>
     *
     * @param restoreAnalysisRequest
     * @return Result of the RestoreAnalysis operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.RestoreAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/RestoreAnalysis" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public RestoreAnalysisResponse restoreAnalysis(RestoreAnalysisRequest restoreAnalysisRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<RestoreAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                RestoreAnalysisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, restoreAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "RestoreAnalysis");

            return clientHandler.execute(new ClientExecutionParams<RestoreAnalysisRequest, RestoreAnalysisResponse>()
                    .withOperationName("RestoreAnalysis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(restoreAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new RestoreAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param searchAnalysesRequest
     * @return Result of the SearchAnalyses operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchAnalysesResponse searchAnalyses(SearchAnalysesRequest searchAnalysesRequest) throws ThrottlingException,
            ResourceNotFoundException, InvalidParameterValueException, UnsupportedUserEditionException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchAnalysesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchAnalysesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchAnalysesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchAnalyses");

            return clientHandler.execute(new ClientExecutionParams<SearchAnalysesRequest, SearchAnalysesResponse>()
                    .withOperationName("SearchAnalyses").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchAnalysesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchAnalysesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for analyses that belong to the user specified in the filter.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client.searchAnalysesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client
     *             .searchAnalysesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchAnalysesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchAnalysesIterable responses = client.searchAnalysesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchAnalyses(software.amazon.awssdk.services.quicksight.model.SearchAnalysesRequest)} operation.</b>
     * </p>
     *
     * @param searchAnalysesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchAnalyses
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchAnalyses" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchAnalysesIterable searchAnalysesPaginator(SearchAnalysesRequest searchAnalysesRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return new SearchAnalysesIterable(this, applyPaginatorUserAgent(searchAnalysesRequest));
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note>
     *
     * @param searchDashboardsRequest
     * @return Result of the SearchDashboards operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDashboardsResponse searchDashboards(SearchDashboardsRequest searchDashboardsRequest) throws ThrottlingException,
            ResourceNotFoundException, InvalidParameterValueException, UnsupportedUserEditionException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchDashboardsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchDashboardsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchDashboardsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDashboards");

            return clientHandler.execute(new ClientExecutionParams<SearchDashboardsRequest, SearchDashboardsResponse>()
                    .withOperationName("SearchDashboards").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchDashboardsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchDashboardsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Searches for dashboards that belong to a user.
     * </p>
     * <note>
     * <p>
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and
     * changes.
     * </p>
     * </note><br/>
     * <p>
     * This is a variant of
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client.searchDashboardsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client
     *             .searchDashboardsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchDashboardsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDashboardsIterable responses = client.searchDashboardsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDashboards(software.amazon.awssdk.services.quicksight.model.SearchDashboardsRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDashboardsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDashboards
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDashboards" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDashboardsIterable searchDashboardsPaginator(SearchDashboardsRequest searchDashboardsRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException,
            UnsupportedUserEditionException, InvalidNextTokenException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        return new SearchDashboardsIterable(this, applyPaginatorUserAgent(searchDashboardsRequest));
    }

    /**
     * <p>
     * Use the <code>SearchDataSets</code> operation to search for datasets that belong to an account.
     * </p>
     *
     * @param searchDataSetsRequest
     * @return Result of the SearchDataSets operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchDataSetsResponse searchDataSets(SearchDataSetsRequest searchDataSetsRequest) throws ThrottlingException,
            ResourceNotFoundException, InvalidParameterValueException, AccessDeniedException, InvalidNextTokenException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchDataSetsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchDataSetsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchDataSetsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDataSets");

            return clientHandler.execute(new ClientExecutionParams<SearchDataSetsRequest, SearchDataSetsResponse>()
                    .withOperationName("SearchDataSets").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchDataSetsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchDataSetsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>SearchDataSets</code> operation to search for datasets that belong to an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDataSets(software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSetsIterable responses = client.searchDataSetsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchDataSetsIterable responses = client
     *             .searchDataSetsPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchDataSetsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSetsIterable responses = client.searchDataSetsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDataSets(software.amazon.awssdk.services.quicksight.model.SearchDataSetsRequest)} operation.</b>
     * </p>
     *
     * @param searchDataSetsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDataSets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSets" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchDataSetsIterable searchDataSetsPaginator(SearchDataSetsRequest searchDataSetsRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException, AccessDeniedException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return new SearchDataSetsIterable(this, applyPaginatorUserAgent(searchDataSetsRequest));
    }

    /**
     * <p>
     * Use the <code>SearchDataSources</code> operation to search for data sources that belong to an account.
     * </p>
     *
     * @param searchDataSourcesRequest
     * @return Result of the SearchDataSources operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDataSourcesResponse searchDataSources(SearchDataSourcesRequest searchDataSourcesRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException, AccessDeniedException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchDataSourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchDataSources");

            return clientHandler.execute(new ClientExecutionParams<SearchDataSourcesRequest, SearchDataSourcesResponse>()
                    .withOperationName("SearchDataSources").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchDataSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchDataSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>SearchDataSources</code> operation to search for data sources that belong to an account.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #searchDataSources(software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSourcesIterable responses = client.searchDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.quicksight.paginators.SearchDataSourcesIterable responses = client
     *             .searchDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.quicksight.model.SearchDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.quicksight.paginators.SearchDataSourcesIterable responses = client.searchDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #searchDataSources(software.amazon.awssdk.services.quicksight.model.SearchDataSourcesRequest)}
     * operation.</b>
     * </p>
     *
     * @param searchDataSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchDataSources" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public SearchDataSourcesIterable searchDataSourcesPaginator(SearchDataSourcesRequest searchDataSourcesRequest)
            throws ThrottlingException, ResourceNotFoundException, InvalidParameterValueException, AccessDeniedException,
            InvalidNextTokenException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        return new SearchDataSourcesIterable(this, applyPaginatorUserAgent(searchDataSourcesRequest));
    }

    /**
     * <p>
     * Searches the subfolders in a folder.
     * </p>
     *
     * @param searchFoldersRequest
     * @return Result of the SearchFolders operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InvalidRequestException
     *         You don't have this feature activated for your account. To fix this issue, contact Amazon Web Services
     *         support.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchFolders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchFolders" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchFoldersResponse searchFolders(SearchFoldersRequest searchFoldersRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            UnsupportedUserEditionException, InvalidRequestException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchFoldersResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchFoldersResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchFoldersRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchFolders");

            return clientHandler.execute(new ClientExecutionParams<SearchFoldersRequest, SearchFoldersResponse>()
                    .withOperationName("SearchFolders").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchFoldersRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchFoldersRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>SearchGroups</code> operation to search groups in a specified Amazon QuickSight namespace using the
     * supplied filters.
     * </p>
     *
     * @param searchGroupsRequest
     * @return Result of the SearchGroups operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidNextTokenException
     *         The <code>NextToken</code> value isn't valid.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.SearchGroups
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/SearchGroups" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public SearchGroupsResponse searchGroups(SearchGroupsRequest searchGroupsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InvalidNextTokenException,
            PreconditionNotMetException, InternalFailureException, ResourceUnavailableException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<SearchGroupsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                SearchGroupsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, searchGroupsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "SearchGroups");

            return clientHandler.execute(new ClientExecutionParams<SearchGroupsRequest, SearchGroupsResponse>()
                    .withOperationName("SearchGroups").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(searchGroupsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new SearchGroupsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
     * </p>
     * <p>
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by
     * granting a user permission to access or change only resources with certain tag values. You can use the
     * <code>TagResource</code> operation with a resource that already has tags. If you specify a new tag key for the
     * resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is
     * already associated with the resource, the new tag value that you specify replaces the previous value for that
     * tag.
     * </p>
     * <p>
     * You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data
     * source, dashboard, and template.
     * </p>
     * <p>
     * Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except
     * for the following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * You can't use tags to track costs for Amazon QuickSight. This isn't possible because you can't tag the resources
     * that Amazon QuickSight costs are based on, for example Amazon QuickSight storage capacity (SPICE), number of
     * users, type of users, and usage metrics.
     * </p>
     * </li>
     * <li>
     * <p>
     * Amazon QuickSight doesn't currently support the tag editor for Resource Groups.
     * </p>
     * </li>
     * </ul>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException,
            AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes a tag or tags from a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only
     * customization that you can use is a theme.
     * </p>
     * <p>
     * You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon
     * QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an
     * Amazon Web Services account. To find out which customizations apply, use the
     * <code>DescribeAccountCustomization</code> API operation.
     * </p>
     *
     * @param updateAccountCustomizationRequest
     * @return Result of the UpdateAccountCustomization operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAccountCustomization
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountCustomization"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccountCustomizationResponse updateAccountCustomization(
            UpdateAccountCustomizationRequest updateAccountCustomizationRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccountCustomizationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccountCustomizationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountCustomizationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountCustomization");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAccountCustomizationRequest, UpdateAccountCustomizationResponse>()
                            .withOperationName("UpdateAccountCustomization").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateAccountCustomizationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAccountCustomizationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the Amazon QuickSight settings in your Amazon Web Services account.
     * </p>
     *
     * @param updateAccountSettingsRequest
     * @return Result of the UpdateAccountSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAccountSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAccountSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAccountSettingsResponse updateAccountSettings(UpdateAccountSettingsRequest updateAccountSettingsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAccountSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAccountSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAccountSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAccountSettings");

            return clientHandler.execute(new ClientExecutionParams<UpdateAccountSettingsRequest, UpdateAccountSettingsResponse>()
                    .withOperationName("UpdateAccountSettings").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAccountSettingsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAccountSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an analysis in Amazon QuickSight
     * </p>
     *
     * @param updateAnalysisRequest
     * @return Result of the UpdateAnalysis operation returned by the service.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAnalysis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateAnalysisResponse updateAnalysis(UpdateAnalysisRequest updateAnalysisRequest) throws ResourceNotFoundException,
            InvalidParameterValueException, ThrottlingException, ResourceExistsException, ConflictException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnalysisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateAnalysisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnalysisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnalysis");

            return clientHandler.execute(new ClientExecutionParams<UpdateAnalysisRequest, UpdateAnalysisResponse>()
                    .withOperationName("UpdateAnalysis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateAnalysisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateAnalysisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the read and write permissions for an analysis.
     * </p>
     *
     * @param updateAnalysisPermissionsRequest
     * @return Result of the UpdateAnalysisPermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateAnalysisPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateAnalysisPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateAnalysisPermissionsResponse updateAnalysisPermissions(
            UpdateAnalysisPermissionsRequest updateAnalysisPermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateAnalysisPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateAnalysisPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateAnalysisPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateAnalysisPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateAnalysisPermissionsRequest, UpdateAnalysisPermissionsResponse>()
                            .withOperationName("UpdateAnalysisPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateAnalysisPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateAnalysisPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a dashboard in an Amazon Web Services account.
     * </p>
     * <note>
     * <p>
     * Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can
     * update the published version of a dashboard by using the
     * <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> </code>
     * API operation.
     * </p>
     * </note>
     *
     * @param updateDashboardRequest
     * @return Result of the UpdateDashboard operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboard
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboard" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDashboardResponse updateDashboard(UpdateDashboardRequest updateDashboardRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, ConflictException, LimitExceededException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDashboardResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDashboardResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDashboardRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboard");

            return clientHandler.execute(new ClientExecutionParams<UpdateDashboardRequest, UpdateDashboardResponse>()
                    .withOperationName("UpdateDashboard").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDashboardRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDashboardRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates read and write permissions on a dashboard.
     * </p>
     *
     * @param updateDashboardPermissionsRequest
     * @return Result of the UpdateDashboardPermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboardPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDashboardPermissionsResponse updateDashboardPermissions(
            UpdateDashboardPermissionsRequest updateDashboardPermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ResourceNotFoundException, UnsupportedUserEditionException, ConflictException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDashboardPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDashboardPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDashboardPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboardPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDashboardPermissionsRequest, UpdateDashboardPermissionsResponse>()
                            .withOperationName("UpdateDashboardPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDashboardPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDashboardPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the published version of a dashboard.
     * </p>
     *
     * @param updateDashboardPublishedVersionRequest
     * @return Result of the UpdateDashboardPublishedVersion operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDashboardPublishedVersion
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDashboardPublishedVersion"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDashboardPublishedVersionResponse updateDashboardPublishedVersion(
            UpdateDashboardPublishedVersionRequest updateDashboardPublishedVersionRequest) throws InvalidParameterValueException,
            ThrottlingException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDashboardPublishedVersionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDashboardPublishedVersionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                updateDashboardPublishedVersionRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDashboardPublishedVersion");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDashboardPublishedVersionRequest, UpdateDashboardPublishedVersionResponse>()
                            .withOperationName("UpdateDashboardPublishedVersion").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDashboardPublishedVersionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDashboardPublishedVersionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a dataset. This operation doesn't support datasets that include uploaded files as a source. Partial
     * updates are not supported by this operation.
     * </p>
     *
     * @param updateDataSetRequest
     * @return Result of the UpdateDataSet operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSet" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDataSetResponse updateDataSet(UpdateDataSetRequest updateDataSetRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, LimitExceededException, ThrottlingException,
            ResourceNotFoundException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataSetResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDataSetResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSetRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSet");

            return clientHandler.execute(new ClientExecutionParams<UpdateDataSetRequest, UpdateDataSetResponse>()
                    .withOperationName("UpdateDataSet").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDataSetRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDataSetRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the permissions on a dataset.
     * </p>
     * <p>
     * The permissions resource is <code>arn:aws:quicksight:region:aws-account-id:dataset/data-set-id</code>.
     * </p>
     *
     * @param updateDataSetPermissionsRequest
     * @return Result of the UpdateDataSetPermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSetPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSetPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDataSetPermissionsResponse updateDataSetPermissions(
            UpdateDataSetPermissionsRequest updateDataSetPermissionsRequest) throws AccessDeniedException, ConflictException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataSetPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDataSetPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSetPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSetPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSetPermissionsRequest, UpdateDataSetPermissionsResponse>()
                            .withOperationName("UpdateDataSetPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDataSetPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDataSetPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a data source.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest)
            throws AccessDeniedException, ConflictException, InvalidParameterValueException, ThrottlingException,
            ResourceNotFoundException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                    .withOperationName("UpdateDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the permissions to a data source.
     * </p>
     *
     * @param updateDataSourcePermissionsRequest
     * @return Result of the UpdateDataSourcePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateDataSourcePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateDataSourcePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateDataSourcePermissionsResponse updateDataSourcePermissions(
            UpdateDataSourcePermissionsRequest updateDataSourcePermissionsRequest) throws AccessDeniedException,
            ConflictException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataSourcePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateDataSourcePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourcePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSourcePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateDataSourcePermissionsRequest, UpdateDataSourcePermissionsResponse>()
                            .withOperationName("UpdateDataSourcePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateDataSourcePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateDataSourcePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the name of a folder.
     * </p>
     *
     * @param updateFolderRequest
     * @return Result of the UpdateFolder operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateFolder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolder" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFolderResponse updateFolder(UpdateFolderRequest updateFolderRequest) throws InvalidParameterValueException,
            AccessDeniedException, ResourceExistsException, ResourceNotFoundException, ConflictException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFolderResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFolderResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFolderRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFolder");

            return clientHandler.execute(new ClientExecutionParams<UpdateFolderRequest, UpdateFolderResponse>()
                    .withOperationName("UpdateFolder").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateFolderRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFolderRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates permissions of a folder.
     * </p>
     *
     * @param updateFolderPermissionsRequest
     * @return Result of the UpdateFolderPermissions operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateFolderPermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateFolderPermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateFolderPermissionsResponse updateFolderPermissions(UpdateFolderPermissionsRequest updateFolderPermissionsRequest)
            throws InvalidParameterValueException, AccessDeniedException, LimitExceededException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFolderPermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateFolderPermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFolderPermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFolderPermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateFolderPermissionsRequest, UpdateFolderPermissionsResponse>()
                            .withOperationName("UpdateFolderPermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateFolderPermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateFolderPermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Changes a group description.
     * </p>
     *
     * @param updateGroupRequest
     * @return Result of the UpdateGroup operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateGroup
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateGroup" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGroupResponse updateGroup(UpdateGroupRequest updateGroupRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGroupResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGroupResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGroupRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGroup");

            return clientHandler.execute(new ClientExecutionParams<UpdateGroupRequest, UpdateGroupResponse>()
                    .withOperationName("UpdateGroup").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateGroupRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGroupRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that
     * are specified in the request. This overwrites all of the users included in <code>Identities</code>.
     * </p>
     *
     * @param updateIamPolicyAssignmentRequest
     * @return Result of the UpdateIAMPolicyAssignment operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConcurrentUpdatingException
     *         A resource is already in a state that indicates an operation is happening that must complete before a new
     *         update can be applied.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateIAMPolicyAssignment
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIAMPolicyAssignment"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateIamPolicyAssignmentResponse updateIAMPolicyAssignment(
            UpdateIamPolicyAssignmentRequest updateIamPolicyAssignmentRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConcurrentUpdatingException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIamPolicyAssignmentResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIamPolicyAssignmentResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIamPolicyAssignmentRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIAMPolicyAssignment");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateIamPolicyAssignmentRequest, UpdateIamPolicyAssignmentResponse>()
                            .withOperationName("UpdateIAMPolicyAssignment").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateIamPolicyAssignmentRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateIamPolicyAssignmentRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the content and status of IP rules. To use this operation, you need to provide the entire map of rules.
     * You can use the <code>DescribeIpRestriction</code> operation to get the current rule map.
     * </p>
     *
     * @param updateIpRestrictionRequest
     * @return Result of the UpdateIpRestriction operation returned by the service.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateIpRestriction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateIpRestriction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateIpRestrictionResponse updateIpRestriction(UpdateIpRestrictionRequest updateIpRestrictionRequest)
            throws LimitExceededException, AccessDeniedException, InvalidParameterValueException, ThrottlingException,
            ResourceNotFoundException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateIpRestrictionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateIpRestrictionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateIpRestrictionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateIpRestriction");

            return clientHandler.execute(new ClientExecutionParams<UpdateIpRestrictionRequest, UpdateIpRestrictionResponse>()
                    .withOperationName("UpdateIpRestriction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateIpRestrictionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateIpRestrictionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Use the <code>UpdatePublicSharingSettings</code> operation to turn on or turn off the public sharing settings of
     * an Amazon QuickSight dashboard.
     * </p>
     * <p>
     * To use this operation, turn on session capacity pricing for your Amazon QuickSight account.
     * </p>
     * <p>
     * Before you can turn on public sharing on your account, make sure to give public sharing permissions to an
     * administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with
     * Amazon QuickSight, see <a
     * href="https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html">Using Amazon
     * QuickSight with IAM</a> in the <i>Amazon QuickSight User Guide</i>.
     * </p>
     *
     * @param updatePublicSharingSettingsRequest
     * @return Result of the UpdatePublicSharingSettings operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedPricingPlanException
     *         This error indicates that you are calling an embedding operation in Amazon QuickSight without the
     *         required pricing plan on your Amazon Web Services account. Before you can use embedding for anonymous
     *         users, a QuickSight administrator needs to add capacity pricing to Amazon QuickSight. You can do this on
     *         the <b>Manage Amazon QuickSight</b> page. </p>
     *         <p>
     *         After capacity pricing is added, you can use the
     *         <code> <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GetDashboardEmbedUrl.html">GetDashboardEmbedUrl</a> </code>
     *         API operation with the <code>--identity-type ANONYMOUS</code> option.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdatePublicSharingSettings
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdatePublicSharingSettings"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdatePublicSharingSettingsResponse updatePublicSharingSettings(
            UpdatePublicSharingSettingsRequest updatePublicSharingSettingsRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, UnsupportedPricingPlanException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdatePublicSharingSettingsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdatePublicSharingSettingsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updatePublicSharingSettingsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdatePublicSharingSettings");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdatePublicSharingSettingsRequest, UpdatePublicSharingSettingsResponse>()
                            .withOperationName("UpdatePublicSharingSettings").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updatePublicSharingSettingsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdatePublicSharingSettingsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a template from an existing Amazon QuickSight analysis or another template.
     * </p>
     *
     * @param updateTemplateRequest
     * @return Result of the UpdateTemplate operation returned by the service.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplate" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateTemplateResponse updateTemplate(UpdateTemplateRequest updateTemplateRequest)
            throws InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            ConflictException, LimitExceededException, UnsupportedUserEditionException, InternalFailureException,
            AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTemplateResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplate");

            return clientHandler.execute(new ClientExecutionParams<UpdateTemplateRequest, UpdateTemplateResponse>()
                    .withOperationName("UpdateTemplate").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateTemplateRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the template alias of a template.
     * </p>
     *
     * @param updateTemplateAliasRequest
     * @return Result of the UpdateTemplateAlias operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplateAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplateAlias"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTemplateAliasResponse updateTemplateAlias(UpdateTemplateAliasRequest updateTemplateAliasRequest)
            throws ThrottlingException, ResourceNotFoundException, ConflictException, UnsupportedUserEditionException,
            InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTemplateAliasResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateTemplateAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplateAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplateAlias");

            return clientHandler.execute(new ClientExecutionParams<UpdateTemplateAliasRequest, UpdateTemplateAliasResponse>()
                    .withOperationName("UpdateTemplateAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateTemplateAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTemplateAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the resource permissions for a template.
     * </p>
     *
     * @param updateTemplatePermissionsRequest
     * @return Result of the UpdateTemplatePermissions operation returned by the service.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTemplatePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTemplatePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateTemplatePermissionsResponse updateTemplatePermissions(
            UpdateTemplatePermissionsRequest updateTemplatePermissionsRequest) throws ThrottlingException,
            InvalidParameterValueException, ConflictException, ResourceNotFoundException, UnsupportedUserEditionException,
            LimitExceededException, InternalFailureException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTemplatePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateTemplatePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTemplatePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTemplatePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTemplatePermissionsRequest, UpdateTemplatePermissionsResponse>()
                            .withOperationName("UpdateTemplatePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateTemplatePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateTemplatePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a theme.
     * </p>
     *
     * @param updateThemeRequest
     * @return Result of the UpdateTheme operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateTheme
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateTheme" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateThemeResponse updateTheme(UpdateThemeRequest updateThemeRequest) throws AccessDeniedException,
            InvalidParameterValueException, LimitExceededException, ResourceExistsException, ResourceNotFoundException,
            ThrottlingException, UnsupportedUserEditionException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThemeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateThemeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThemeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateTheme");

            return clientHandler.execute(new ClientExecutionParams<UpdateThemeRequest, UpdateThemeResponse>()
                    .withOperationName("UpdateTheme").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateThemeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateThemeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an alias of a theme.
     * </p>
     *
     * @param updateThemeAliasRequest
     * @return Result of the UpdateThemeAlias operation returned by the service.
     * @throws ConflictException
     *         Updating or deleting a resource can cause an inconsistent state.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceExistsException
     *         The resource specified already exists.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateThemeAlias
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemeAlias" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public UpdateThemeAliasResponse updateThemeAlias(UpdateThemeAliasRequest updateThemeAliasRequest) throws ConflictException,
            InvalidParameterValueException, ResourceExistsException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, InternalFailureException, AwsServiceException, SdkClientException,
            QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThemeAliasResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateThemeAliasResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThemeAliasRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThemeAlias");

            return clientHandler.execute(new ClientExecutionParams<UpdateThemeAliasRequest, UpdateThemeAliasResponse>()
                    .withOperationName("UpdateThemeAlias").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateThemeAliasRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateThemeAliasRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on,
     * for example <code>"quicksight:DescribeTheme"</code>.
     * </p>
     * <p>
     * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions,
     * which are user, owner, or no permissions:
     * </p>
     * <ul>
     * <li>
     * <p>
     * User
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * Owner
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>"quicksight:DescribeTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeAliases"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:ListThemeVersions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateTheme"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:CreateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DeleteThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemeAlias"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:UpdateThemePermissions"</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>"quicksight:DescribeThemePermissions"</code>
     * </p>
     * </li>
     * </ul>
     * </li>
     * <li>
     * <p>
     * To specify no permissions, omit the permissions list.
     * </p>
     * </li>
     * </ul>
     *
     * @param updateThemePermissionsRequest
     * @return Result of the UpdateThemePermissions operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws UnsupportedUserEditionException
     *         This error indicates that you are calling an operation on an Amazon QuickSight subscription where the
     *         edition doesn't include support for that operation. Amazon Amazon QuickSight currently has Standard
     *         Edition and Enterprise Edition. Not every operation and capability is available in every edition.
     * @throws LimitExceededException
     *         A limit is exceeded.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateThemePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateThemePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateThemePermissionsResponse updateThemePermissions(UpdateThemePermissionsRequest updateThemePermissionsRequest)
            throws AccessDeniedException, InvalidParameterValueException, ResourceNotFoundException, ThrottlingException,
            UnsupportedUserEditionException, LimitExceededException, InternalFailureException, AwsServiceException,
            SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateThemePermissionsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateThemePermissionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateThemePermissionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateThemePermissions");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateThemePermissionsRequest, UpdateThemePermissionsResponse>()
                            .withOperationName("UpdateThemePermissions").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(updateThemePermissionsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateThemePermissionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an Amazon QuickSight user.
     * </p>
     *
     * @param updateUserRequest
     * @return Result of the UpdateUser operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to this item. The provided credentials couldn't be validated. You might not be
     *         authorized to carry out the request. Make sure that your account is authorized to use the Amazon
     *         QuickSight service, that your policies have the correct permissions, and that you are using the correct
     *         access keys.
     * @throws InvalidParameterValueException
     *         One or more parameters has a value that isn't valid.
     * @throws ResourceNotFoundException
     *         One or more resources can't be found.
     * @throws ThrottlingException
     *         Access is throttled.
     * @throws PreconditionNotMetException
     *         One or more preconditions aren't met.
     * @throws InternalFailureException
     *         An internal failure occurred.
     * @throws ResourceUnavailableException
     *         This resource is currently unavailable.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws QuickSightException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample QuickSightClient.UpdateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/quicksight-2018-04-01/UpdateUser" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateUserResponse updateUser(UpdateUserRequest updateUserRequest) throws AccessDeniedException,
            InvalidParameterValueException, ResourceNotFoundException, ThrottlingException, PreconditionNotMetException,
            InternalFailureException, ResourceUnavailableException, AwsServiceException, SdkClientException, QuickSightException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateUserResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateUserResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateUserRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "QuickSight");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateUser");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateUserRequest, UpdateUserResponse>().withOperationName("UpdateUser")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateUserRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateUserRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private <T extends QuickSightRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder()
                .version(VersionInfo.SDK_VERSION).name("PAGINATED").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration()
                .map(c -> c.toBuilder().applyMutation(userAgentApplier).build())
                .orElse((AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier).build()));
        return (T) request.toBuilder().overrideConfiguration(overrideConfiguration).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(QuickSightException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.0")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("QuickSightUserNotFoundException")
                                .exceptionBuilderSupplier(QuickSightUserNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("SessionLifetimeInMinutesInvalidException")
                                .exceptionBuilderSupplier(SessionLifetimeInMinutesInvalidException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidNextTokenException")
                                .exceptionBuilderSupplier(InvalidNextTokenException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceUnavailableException")
                                .exceptionBuilderSupplier(ResourceUnavailableException::builder).httpStatusCode(503).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConflictException")
                                .exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidRequestException")
                                .exceptionBuilderSupplier(InvalidRequestException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceNotFoundException")
                                .exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ResourceExistsException")
                                .exceptionBuilderSupplier(ResourceExistsException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InvalidParameterValueException")
                                .exceptionBuilderSupplier(InvalidParameterValueException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentUpdatingException")
                                .exceptionBuilderSupplier(ConcurrentUpdatingException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("DomainNotWhitelistedException")
                                .exceptionBuilderSupplier(DomainNotWhitelistedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ThrottlingException")
                                .exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("IdentityTypeNotSupportedException")
                                .exceptionBuilderSupplier(IdentityTypeNotSupportedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedPricingPlanException")
                                .exceptionBuilderSupplier(UnsupportedPricingPlanException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("PreconditionNotMetException")
                                .exceptionBuilderSupplier(PreconditionNotMetException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnsupportedUserEditionException")
                                .exceptionBuilderSupplier(UnsupportedUserEditionException::builder).httpStatusCode(403).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
