/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The field options for a table visual.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableFieldOptions implements SdkPojo, Serializable,
        ToCopyableBuilder<TableFieldOptions.Builder, TableFieldOptions> {
    private static final SdkField<List<TableFieldOption>> SELECTED_FIELD_OPTIONS_FIELD = SdkField
            .<List<TableFieldOption>> builder(MarshallingType.LIST)
            .memberName("SelectedFieldOptions")
            .getter(getter(TableFieldOptions::selectedFieldOptions))
            .setter(setter(Builder::selectedFieldOptions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectedFieldOptions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TableFieldOption> builder(MarshallingType.SDK_POJO)
                                            .constructor(TableFieldOption::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> ORDER_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Order")
            .getter(getter(TableFieldOptions::order))
            .setter(setter(Builder::order))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Order").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SELECTED_FIELD_OPTIONS_FIELD,
            ORDER_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<TableFieldOption> selectedFieldOptions;

    private final List<String> order;

    private TableFieldOptions(BuilderImpl builder) {
        this.selectedFieldOptions = builder.selectedFieldOptions;
        this.order = builder.order;
    }

    /**
     * For responses, this returns true if the service returned a value for the SelectedFieldOptions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSelectedFieldOptions() {
        return selectedFieldOptions != null && !(selectedFieldOptions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The selected field options for the table field options.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSelectedFieldOptions} method.
     * </p>
     * 
     * @return The selected field options for the table field options.
     */
    public final List<TableFieldOption> selectedFieldOptions() {
        return selectedFieldOptions;
    }

    /**
     * For responses, this returns true if the service returned a value for the Order property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasOrder() {
        return order != null && !(order instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The order of field IDs of the field options for a table visual.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrder} method.
     * </p>
     * 
     * @return The order of field IDs of the field options for a table visual.
     */
    public final List<String> order() {
        return order;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSelectedFieldOptions() ? selectedFieldOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasOrder() ? order() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableFieldOptions)) {
            return false;
        }
        TableFieldOptions other = (TableFieldOptions) obj;
        return hasSelectedFieldOptions() == other.hasSelectedFieldOptions()
                && Objects.equals(selectedFieldOptions(), other.selectedFieldOptions()) && hasOrder() == other.hasOrder()
                && Objects.equals(order(), other.order());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableFieldOptions")
                .add("SelectedFieldOptions", hasSelectedFieldOptions() ? selectedFieldOptions() : null)
                .add("Order", hasOrder() ? order() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SelectedFieldOptions":
            return Optional.ofNullable(clazz.cast(selectedFieldOptions()));
        case "Order":
            return Optional.ofNullable(clazz.cast(order()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TableFieldOptions, T> g) {
        return obj -> g.apply((TableFieldOptions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableFieldOptions> {
        /**
         * <p>
         * The selected field options for the table field options.
         * </p>
         * 
         * @param selectedFieldOptions
         *        The selected field options for the table field options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFieldOptions(Collection<TableFieldOption> selectedFieldOptions);

        /**
         * <p>
         * The selected field options for the table field options.
         * </p>
         * 
         * @param selectedFieldOptions
         *        The selected field options for the table field options.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder selectedFieldOptions(TableFieldOption... selectedFieldOptions);

        /**
         * <p>
         * The selected field options for the table field options.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TableFieldOption.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.quicksight.model.TableFieldOption#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TableFieldOption.Builder#build()} is called
         * immediately and its result is passed to {@link #selectedFieldOptions(List<TableFieldOption>)}.
         * 
         * @param selectedFieldOptions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TableFieldOption.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #selectedFieldOptions(java.util.Collection<TableFieldOption>)
         */
        Builder selectedFieldOptions(Consumer<TableFieldOption.Builder>... selectedFieldOptions);

        /**
         * <p>
         * The order of field IDs of the field options for a table visual.
         * </p>
         * 
         * @param order
         *        The order of field IDs of the field options for a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(Collection<String> order);

        /**
         * <p>
         * The order of field IDs of the field options for a table visual.
         * </p>
         * 
         * @param order
         *        The order of field IDs of the field options for a table visual.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder order(String... order);
    }

    static final class BuilderImpl implements Builder {
        private List<TableFieldOption> selectedFieldOptions = DefaultSdkAutoConstructList.getInstance();

        private List<String> order = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TableFieldOptions model) {
            selectedFieldOptions(model.selectedFieldOptions);
            order(model.order);
        }

        public final List<TableFieldOption.Builder> getSelectedFieldOptions() {
            List<TableFieldOption.Builder> result = TableFieldOptionListCopier.copyToBuilder(this.selectedFieldOptions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSelectedFieldOptions(Collection<TableFieldOption.BuilderImpl> selectedFieldOptions) {
            this.selectedFieldOptions = TableFieldOptionListCopier.copyFromBuilder(selectedFieldOptions);
        }

        @Override
        public final Builder selectedFieldOptions(Collection<TableFieldOption> selectedFieldOptions) {
            this.selectedFieldOptions = TableFieldOptionListCopier.copy(selectedFieldOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(TableFieldOption... selectedFieldOptions) {
            selectedFieldOptions(Arrays.asList(selectedFieldOptions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder selectedFieldOptions(Consumer<TableFieldOption.Builder>... selectedFieldOptions) {
            selectedFieldOptions(Stream.of(selectedFieldOptions).map(c -> TableFieldOption.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getOrder() {
            if (order instanceof SdkAutoConstructList) {
                return null;
            }
            return order;
        }

        public final void setOrder(Collection<String> order) {
            this.order = FieldOrderListCopier.copy(order);
        }

        @Override
        public final Builder order(Collection<String> order) {
            this.order = FieldOrderListCopier.copy(order);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder order(String... order) {
            order(Arrays.asList(order));
            return this;
        }

        @Override
        public TableFieldOptions build() {
            return new TableFieldOptions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
