/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information that identifies the snapshot that needs to be generated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnapshotFileSheetSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<SnapshotFileSheetSelection.Builder, SnapshotFileSheetSelection> {
    private static final SdkField<String> SHEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SheetId").getter(getter(SnapshotFileSheetSelection::sheetId)).setter(setter(Builder::sheetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SheetId").build()).build();

    private static final SdkField<String> SELECTION_SCOPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SelectionScope").getter(getter(SnapshotFileSheetSelection::selectionScopeAsString))
            .setter(setter(Builder::selectionScope))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SelectionScope").build()).build();

    private static final SdkField<List<String>> VISUAL_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("VisualIds")
            .getter(getter(SnapshotFileSheetSelection::visualIds))
            .setter(setter(Builder::visualIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VisualIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SHEET_ID_FIELD,
            SELECTION_SCOPE_FIELD, VISUAL_IDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String sheetId;

    private final String selectionScope;

    private final List<String> visualIds;

    private SnapshotFileSheetSelection(BuilderImpl builder) {
        this.sheetId = builder.sheetId;
        this.selectionScope = builder.selectionScope;
        this.visualIds = builder.visualIds;
    }

    /**
     * <p>
     * The sheet ID of the dashboard to generate the snapshot artifact from. This value is required for CSV and PDF
     * format types.
     * </p>
     * 
     * @return The sheet ID of the dashboard to generate the snapshot artifact from. This value is required for CSV and
     *         PDF format types.
     */
    public final String sheetId() {
        return sheetId;
    }

    /**
     * <p>
     * The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You can
     * choose one of the following options.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the snapshot is a
     * PDF.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is required if
     * the snapshot is a CSV.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionScope}
     * will return {@link SnapshotFileSheetSelectionScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectionScopeAsString}.
     * </p>
     * 
     * @return The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You
     *         can choose one of the following options.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the
     *         snapshot is a PDF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is
     *         required if the snapshot is a CSV.
     *         </p>
     *         </li>
     * @see SnapshotFileSheetSelectionScope
     */
    public final SnapshotFileSheetSelectionScope selectionScope() {
        return SnapshotFileSheetSelectionScope.fromValue(selectionScope);
    }

    /**
     * <p>
     * The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You can
     * choose one of the following options.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the snapshot is a
     * PDF.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is required if
     * the snapshot is a CSV.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #selectionScope}
     * will return {@link SnapshotFileSheetSelectionScope#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #selectionScopeAsString}.
     * </p>
     * 
     * @return The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You
     *         can choose one of the following options.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the
     *         snapshot is a PDF.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is
     *         required if the snapshot is a CSV.
     *         </p>
     *         </li>
     * @see SnapshotFileSheetSelectionScope
     */
    public final String selectionScopeAsString() {
        return selectionScope;
    }

    /**
     * For responses, this returns true if the service returned a value for the VisualIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasVisualIds() {
        return visualIds != null && !(visualIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of visual IDs that are located in the selected sheet. This structure supports tables and pivot tables.
     * This structure is required if you are generating a CSV. You can add a maximum of 1 visual ID to this structure.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasVisualIds} method.
     * </p>
     * 
     * @return A list of visual IDs that are located in the selected sheet. This structure supports tables and pivot
     *         tables. This structure is required if you are generating a CSV. You can add a maximum of 1 visual ID to
     *         this structure.
     */
    public final List<String> visualIds() {
        return visualIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sheetId());
        hashCode = 31 * hashCode + Objects.hashCode(selectionScopeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasVisualIds() ? visualIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnapshotFileSheetSelection)) {
            return false;
        }
        SnapshotFileSheetSelection other = (SnapshotFileSheetSelection) obj;
        return Objects.equals(sheetId(), other.sheetId())
                && Objects.equals(selectionScopeAsString(), other.selectionScopeAsString())
                && hasVisualIds() == other.hasVisualIds() && Objects.equals(visualIds(), other.visualIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnapshotFileSheetSelection").add("SheetId", sheetId())
                .add("SelectionScope", selectionScopeAsString()).add("VisualIds", hasVisualIds() ? visualIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SheetId":
            return Optional.ofNullable(clazz.cast(sheetId()));
        case "SelectionScope":
            return Optional.ofNullable(clazz.cast(selectionScopeAsString()));
        case "VisualIds":
            return Optional.ofNullable(clazz.cast(visualIds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SnapshotFileSheetSelection, T> g) {
        return obj -> g.apply((SnapshotFileSheetSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnapshotFileSheetSelection> {
        /**
         * <p>
         * The sheet ID of the dashboard to generate the snapshot artifact from. This value is required for CSV and PDF
         * format types.
         * </p>
         * 
         * @param sheetId
         *        The sheet ID of the dashboard to generate the snapshot artifact from. This value is required for CSV
         *        and PDF format types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sheetId(String sheetId);

        /**
         * <p>
         * The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You can
         * choose one of the following options.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the snapshot
         * is a PDF.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is
         * required if the snapshot is a CSV.
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectionScope
         *        The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of.
         *        You can choose one of the following options.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the
         *        snapshot is a PDF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is
         *        required if the snapshot is a CSV.
         *        </p>
         *        </li>
         * @see SnapshotFileSheetSelectionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotFileSheetSelectionScope
         */
        Builder selectionScope(String selectionScope);

        /**
         * <p>
         * The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of. You can
         * choose one of the following options.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the snapshot
         * is a PDF.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is
         * required if the snapshot is a CSV.
         * </p>
         * </li>
         * </ul>
         * 
         * @param selectionScope
         *        The selection scope of the visuals on a sheet of a dashboard that you are generating a snapthot of.
         *        You can choose one of the following options.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ALL_VISUALS</code> - Selects all visuals that are on the sheet. This value is required if the
         *        snapshot is a PDF.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SELECTED_VISUALS</code> - Select the visual that you want to add to the snapshot. This value is
         *        required if the snapshot is a CSV.
         *        </p>
         *        </li>
         * @see SnapshotFileSheetSelectionScope
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SnapshotFileSheetSelectionScope
         */
        Builder selectionScope(SnapshotFileSheetSelectionScope selectionScope);

        /**
         * <p>
         * A list of visual IDs that are located in the selected sheet. This structure supports tables and pivot tables.
         * This structure is required if you are generating a CSV. You can add a maximum of 1 visual ID to this
         * structure.
         * </p>
         * 
         * @param visualIds
         *        A list of visual IDs that are located in the selected sheet. This structure supports tables and pivot
         *        tables. This structure is required if you are generating a CSV. You can add a maximum of 1 visual ID
         *        to this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualIds(Collection<String> visualIds);

        /**
         * <p>
         * A list of visual IDs that are located in the selected sheet. This structure supports tables and pivot tables.
         * This structure is required if you are generating a CSV. You can add a maximum of 1 visual ID to this
         * structure.
         * </p>
         * 
         * @param visualIds
         *        A list of visual IDs that are located in the selected sheet. This structure supports tables and pivot
         *        tables. This structure is required if you are generating a CSV. You can add a maximum of 1 visual ID
         *        to this structure.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder visualIds(String... visualIds);
    }

    static final class BuilderImpl implements Builder {
        private String sheetId;

        private String selectionScope;

        private List<String> visualIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnapshotFileSheetSelection model) {
            sheetId(model.sheetId);
            selectionScope(model.selectionScope);
            visualIds(model.visualIds);
        }

        public final String getSheetId() {
            return sheetId;
        }

        public final void setSheetId(String sheetId) {
            this.sheetId = sheetId;
        }

        @Override
        public final Builder sheetId(String sheetId) {
            this.sheetId = sheetId;
            return this;
        }

        public final String getSelectionScope() {
            return selectionScope;
        }

        public final void setSelectionScope(String selectionScope) {
            this.selectionScope = selectionScope;
        }

        @Override
        public final Builder selectionScope(String selectionScope) {
            this.selectionScope = selectionScope;
            return this;
        }

        @Override
        public final Builder selectionScope(SnapshotFileSheetSelectionScope selectionScope) {
            this.selectionScope(selectionScope == null ? null : selectionScope.toString());
            return this;
        }

        public final Collection<String> getVisualIds() {
            if (visualIds instanceof SdkAutoConstructList) {
                return null;
            }
            return visualIds;
        }

        public final void setVisualIds(Collection<String> visualIds) {
            this.visualIds = SnapshotFileSheetSelectionVisualIdListCopier.copy(visualIds);
        }

        @Override
        public final Builder visualIds(Collection<String> visualIds) {
            this.visualIds = SnapshotFileSheetSelectionVisualIdListCopier.copy(visualIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder visualIds(String... visualIds) {
            visualIds(Arrays.asList(visualIds));
            return this;
        }

        @Override
        public SnapshotFileSheetSelection build() {
            return new SnapshotFileSheetSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
