/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for a <code>CategoryFilter</code>.
 * </p>
 * <p>
 * This is a union type structure. For this structure to be valid, only one of the attributes can be defined.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CategoryFilterConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CategoryFilterConfiguration.Builder, CategoryFilterConfiguration> {
    private static final SdkField<FilterListConfiguration> FILTER_LIST_CONFIGURATION_FIELD = SdkField
            .<FilterListConfiguration> builder(MarshallingType.SDK_POJO).memberName("FilterListConfiguration")
            .getter(getter(CategoryFilterConfiguration::filterListConfiguration))
            .setter(setter(Builder::filterListConfiguration)).constructor(FilterListConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FilterListConfiguration").build())
            .build();

    private static final SdkField<CustomFilterListConfiguration> CUSTOM_FILTER_LIST_CONFIGURATION_FIELD = SdkField
            .<CustomFilterListConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("CustomFilterListConfiguration")
            .getter(getter(CategoryFilterConfiguration::customFilterListConfiguration))
            .setter(setter(Builder::customFilterListConfiguration))
            .constructor(CustomFilterListConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFilterListConfiguration")
                    .build()).build();

    private static final SdkField<CustomFilterConfiguration> CUSTOM_FILTER_CONFIGURATION_FIELD = SdkField
            .<CustomFilterConfiguration> builder(MarshallingType.SDK_POJO).memberName("CustomFilterConfiguration")
            .getter(getter(CategoryFilterConfiguration::customFilterConfiguration))
            .setter(setter(Builder::customFilterConfiguration)).constructor(CustomFilterConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomFilterConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            FILTER_LIST_CONFIGURATION_FIELD, CUSTOM_FILTER_LIST_CONFIGURATION_FIELD, CUSTOM_FILTER_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final FilterListConfiguration filterListConfiguration;

    private final CustomFilterListConfiguration customFilterListConfiguration;

    private final CustomFilterConfiguration customFilterConfiguration;

    private CategoryFilterConfiguration(BuilderImpl builder) {
        this.filterListConfiguration = builder.filterListConfiguration;
        this.customFilterListConfiguration = builder.customFilterListConfiguration;
        this.customFilterConfiguration = builder.customFilterConfiguration;
    }

    /**
     * <p>
     * A list of filter configurations. In the Amazon QuickSight console, this filter type is called a filter list.
     * </p>
     * 
     * @return A list of filter configurations. In the Amazon QuickSight console, this filter type is called a filter
     *         list.
     */
    public final FilterListConfiguration filterListConfiguration() {
        return filterListConfiguration;
    }

    /**
     * <p>
     * A list of custom filter values. In the Amazon QuickSight console, this filter type is called a custom filter
     * list.
     * </p>
     * 
     * @return A list of custom filter values. In the Amazon QuickSight console, this filter type is called a custom
     *         filter list.
     */
    public final CustomFilterListConfiguration customFilterListConfiguration() {
        return customFilterListConfiguration;
    }

    /**
     * <p>
     * A custom filter that filters based on a single value. This filter can be partially matched.
     * </p>
     * 
     * @return A custom filter that filters based on a single value. This filter can be partially matched.
     */
    public final CustomFilterConfiguration customFilterConfiguration() {
        return customFilterConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filterListConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customFilterListConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(customFilterConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CategoryFilterConfiguration)) {
            return false;
        }
        CategoryFilterConfiguration other = (CategoryFilterConfiguration) obj;
        return Objects.equals(filterListConfiguration(), other.filterListConfiguration())
                && Objects.equals(customFilterListConfiguration(), other.customFilterListConfiguration())
                && Objects.equals(customFilterConfiguration(), other.customFilterConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CategoryFilterConfiguration").add("FilterListConfiguration", filterListConfiguration())
                .add("CustomFilterListConfiguration", customFilterListConfiguration())
                .add("CustomFilterConfiguration", customFilterConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FilterListConfiguration":
            return Optional.ofNullable(clazz.cast(filterListConfiguration()));
        case "CustomFilterListConfiguration":
            return Optional.ofNullable(clazz.cast(customFilterListConfiguration()));
        case "CustomFilterConfiguration":
            return Optional.ofNullable(clazz.cast(customFilterConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CategoryFilterConfiguration, T> g) {
        return obj -> g.apply((CategoryFilterConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CategoryFilterConfiguration> {
        /**
         * <p>
         * A list of filter configurations. In the Amazon QuickSight console, this filter type is called a filter list.
         * </p>
         * 
         * @param filterListConfiguration
         *        A list of filter configurations. In the Amazon QuickSight console, this filter type is called a filter
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterListConfiguration(FilterListConfiguration filterListConfiguration);

        /**
         * <p>
         * A list of filter configurations. In the Amazon QuickSight console, this filter type is called a filter list.
         * </p>
         * This is a convenience method that creates an instance of the {@link FilterListConfiguration.Builder} avoiding
         * the need to create one manually via {@link FilterListConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FilterListConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #filterListConfiguration(FilterListConfiguration)}.
         * 
         * @param filterListConfiguration
         *        a consumer that will call methods on {@link FilterListConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterListConfiguration(FilterListConfiguration)
         */
        default Builder filterListConfiguration(Consumer<FilterListConfiguration.Builder> filterListConfiguration) {
            return filterListConfiguration(FilterListConfiguration.builder().applyMutation(filterListConfiguration).build());
        }

        /**
         * <p>
         * A list of custom filter values. In the Amazon QuickSight console, this filter type is called a custom filter
         * list.
         * </p>
         * 
         * @param customFilterListConfiguration
         *        A list of custom filter values. In the Amazon QuickSight console, this filter type is called a custom
         *        filter list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFilterListConfiguration(CustomFilterListConfiguration customFilterListConfiguration);

        /**
         * <p>
         * A list of custom filter values. In the Amazon QuickSight console, this filter type is called a custom filter
         * list.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomFilterListConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomFilterListConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomFilterListConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #customFilterListConfiguration(CustomFilterListConfiguration)}.
         * 
         * @param customFilterListConfiguration
         *        a consumer that will call methods on {@link CustomFilterListConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customFilterListConfiguration(CustomFilterListConfiguration)
         */
        default Builder customFilterListConfiguration(
                Consumer<CustomFilterListConfiguration.Builder> customFilterListConfiguration) {
            return customFilterListConfiguration(CustomFilterListConfiguration.builder()
                    .applyMutation(customFilterListConfiguration).build());
        }

        /**
         * <p>
         * A custom filter that filters based on a single value. This filter can be partially matched.
         * </p>
         * 
         * @param customFilterConfiguration
         *        A custom filter that filters based on a single value. This filter can be partially matched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customFilterConfiguration(CustomFilterConfiguration customFilterConfiguration);

        /**
         * <p>
         * A custom filter that filters based on a single value. This filter can be partially matched.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomFilterConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomFilterConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomFilterConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #customFilterConfiguration(CustomFilterConfiguration)}.
         * 
         * @param customFilterConfiguration
         *        a consumer that will call methods on {@link CustomFilterConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customFilterConfiguration(CustomFilterConfiguration)
         */
        default Builder customFilterConfiguration(Consumer<CustomFilterConfiguration.Builder> customFilterConfiguration) {
            return customFilterConfiguration(CustomFilterConfiguration.builder().applyMutation(customFilterConfiguration).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private FilterListConfiguration filterListConfiguration;

        private CustomFilterListConfiguration customFilterListConfiguration;

        private CustomFilterConfiguration customFilterConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CategoryFilterConfiguration model) {
            filterListConfiguration(model.filterListConfiguration);
            customFilterListConfiguration(model.customFilterListConfiguration);
            customFilterConfiguration(model.customFilterConfiguration);
        }

        public final FilterListConfiguration.Builder getFilterListConfiguration() {
            return filterListConfiguration != null ? filterListConfiguration.toBuilder() : null;
        }

        public final void setFilterListConfiguration(FilterListConfiguration.BuilderImpl filterListConfiguration) {
            this.filterListConfiguration = filterListConfiguration != null ? filterListConfiguration.build() : null;
        }

        @Override
        public final Builder filterListConfiguration(FilterListConfiguration filterListConfiguration) {
            this.filterListConfiguration = filterListConfiguration;
            return this;
        }

        public final CustomFilterListConfiguration.Builder getCustomFilterListConfiguration() {
            return customFilterListConfiguration != null ? customFilterListConfiguration.toBuilder() : null;
        }

        public final void setCustomFilterListConfiguration(CustomFilterListConfiguration.BuilderImpl customFilterListConfiguration) {
            this.customFilterListConfiguration = customFilterListConfiguration != null ? customFilterListConfiguration.build()
                    : null;
        }

        @Override
        public final Builder customFilterListConfiguration(CustomFilterListConfiguration customFilterListConfiguration) {
            this.customFilterListConfiguration = customFilterListConfiguration;
            return this;
        }

        public final CustomFilterConfiguration.Builder getCustomFilterConfiguration() {
            return customFilterConfiguration != null ? customFilterConfiguration.toBuilder() : null;
        }

        public final void setCustomFilterConfiguration(CustomFilterConfiguration.BuilderImpl customFilterConfiguration) {
            this.customFilterConfiguration = customFilterConfiguration != null ? customFilterConfiguration.build() : null;
        }

        @Override
        public final Builder customFilterConfiguration(CustomFilterConfiguration customFilterConfiguration) {
            this.customFilterConfiguration = customFilterConfiguration;
            return this;
        }

        @Override
        public CategoryFilterConfiguration build() {
            return new CategoryFilterConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
