/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The arc axis configuration of a <code>GaugeChartVisual</code>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ArcAxisConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ArcAxisConfiguration.Builder, ArcAxisConfiguration> {
    private static final SdkField<ArcAxisDisplayRange> RANGE_FIELD = SdkField
            .<ArcAxisDisplayRange> builder(MarshallingType.SDK_POJO).memberName("Range")
            .getter(getter(ArcAxisConfiguration::range)).setter(setter(Builder::range)).constructor(ArcAxisDisplayRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Range").build()).build();

    private static final SdkField<Integer> RESERVE_RANGE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ReserveRange").getter(getter(ArcAxisConfiguration::reserveRange)).setter(setter(Builder::reserveRange))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReserveRange").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RANGE_FIELD,
            RESERVE_RANGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final ArcAxisDisplayRange range;

    private final Integer reserveRange;

    private ArcAxisConfiguration(BuilderImpl builder) {
        this.range = builder.range;
        this.reserveRange = builder.reserveRange;
    }

    /**
     * <p>
     * The arc axis range of a <code>GaugeChartVisual</code>.
     * </p>
     * 
     * @return The arc axis range of a <code>GaugeChartVisual</code>.
     */
    public final ArcAxisDisplayRange range() {
        return range;
    }

    /**
     * <p>
     * The reserved range of the arc axis.
     * </p>
     * 
     * @return The reserved range of the arc axis.
     */
    public final Integer reserveRange() {
        return reserveRange;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(range());
        hashCode = 31 * hashCode + Objects.hashCode(reserveRange());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArcAxisConfiguration)) {
            return false;
        }
        ArcAxisConfiguration other = (ArcAxisConfiguration) obj;
        return Objects.equals(range(), other.range()) && Objects.equals(reserveRange(), other.reserveRange());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ArcAxisConfiguration").add("Range", range()).add("ReserveRange", reserveRange()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Range":
            return Optional.ofNullable(clazz.cast(range()));
        case "ReserveRange":
            return Optional.ofNullable(clazz.cast(reserveRange()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ArcAxisConfiguration, T> g) {
        return obj -> g.apply((ArcAxisConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ArcAxisConfiguration> {
        /**
         * <p>
         * The arc axis range of a <code>GaugeChartVisual</code>.
         * </p>
         * 
         * @param range
         *        The arc axis range of a <code>GaugeChartVisual</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder range(ArcAxisDisplayRange range);

        /**
         * <p>
         * The arc axis range of a <code>GaugeChartVisual</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArcAxisDisplayRange.Builder} avoiding the
         * need to create one manually via {@link ArcAxisDisplayRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArcAxisDisplayRange.Builder#build()} is called immediately and
         * its result is passed to {@link #range(ArcAxisDisplayRange)}.
         * 
         * @param range
         *        a consumer that will call methods on {@link ArcAxisDisplayRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #range(ArcAxisDisplayRange)
         */
        default Builder range(Consumer<ArcAxisDisplayRange.Builder> range) {
            return range(ArcAxisDisplayRange.builder().applyMutation(range).build());
        }

        /**
         * <p>
         * The reserved range of the arc axis.
         * </p>
         * 
         * @param reserveRange
         *        The reserved range of the arc axis.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reserveRange(Integer reserveRange);
    }

    static final class BuilderImpl implements Builder {
        private ArcAxisDisplayRange range;

        private Integer reserveRange;

        private BuilderImpl() {
        }

        private BuilderImpl(ArcAxisConfiguration model) {
            range(model.range);
            reserveRange(model.reserveRange);
        }

        public final ArcAxisDisplayRange.Builder getRange() {
            return range != null ? range.toBuilder() : null;
        }

        public final void setRange(ArcAxisDisplayRange.BuilderImpl range) {
            this.range = range != null ? range.build() : null;
        }

        @Override
        public final Builder range(ArcAxisDisplayRange range) {
            this.range = range;
            return this;
        }

        public final Integer getReserveRange() {
            return reserveRange;
        }

        public final void setReserveRange(Integer reserveRange) {
            this.reserveRange = reserveRange;
        }

        @Override
        public final Builder reserveRange(Integer reserveRange) {
            this.reserveRange = reserveRange;
            return this;
        }

        @Override
        public ArcAxisConfiguration build() {
            return new ArcAxisConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
