/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.quicksight.model.ConditionalFormattingIconSetType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConditionalFormattingIconSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConditionalFormattingIconSet> {
    private static final SdkField<String> EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expression").getter(ConditionalFormattingIconSet.getter(ConditionalFormattingIconSet::expression)).setter(ConditionalFormattingIconSet.setter(Builder::expression)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expression").build()}).build();
    private static final SdkField<String> ICON_SET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IconSetType").getter(ConditionalFormattingIconSet.getter(ConditionalFormattingIconSet::iconSetTypeAsString)).setter(ConditionalFormattingIconSet.setter(Builder::iconSetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconSetType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPRESSION_FIELD, ICON_SET_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String expression;
    private final String iconSetType;

    private ConditionalFormattingIconSet(BuilderImpl builder) {
        this.expression = builder.expression;
        this.iconSetType = builder.iconSetType;
    }

    public final String expression() {
        return this.expression;
    }

    public final ConditionalFormattingIconSetType iconSetType() {
        return ConditionalFormattingIconSetType.fromValue(this.iconSetType);
    }

    public final String iconSetTypeAsString() {
        return this.iconSetType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expression());
        hashCode = 31 * hashCode + Objects.hashCode(this.iconSetTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionalFormattingIconSet)) {
            return false;
        }
        ConditionalFormattingIconSet other = (ConditionalFormattingIconSet)obj;
        return Objects.equals(this.expression(), other.expression()) && Objects.equals(this.iconSetTypeAsString(), other.iconSetTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ConditionalFormattingIconSet").add("Expression", (Object)(this.expression() == null ? null : "*** Sensitive Data Redacted ***")).add("IconSetType", (Object)this.iconSetTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expression": {
                return Optional.ofNullable(clazz.cast(this.expression()));
            }
            case "IconSetType": {
                return Optional.ofNullable(clazz.cast(this.iconSetTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionalFormattingIconSet, T> g) {
        return obj -> g.apply((ConditionalFormattingIconSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expression;
        private String iconSetType;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionalFormattingIconSet model) {
            this.expression(model.expression);
            this.iconSetType(model.iconSetType);
        }

        public final String getExpression() {
            return this.expression;
        }

        public final void setExpression(String expression) {
            this.expression = expression;
        }

        @Override
        public final Builder expression(String expression) {
            this.expression = expression;
            return this;
        }

        public final String getIconSetType() {
            return this.iconSetType;
        }

        public final void setIconSetType(String iconSetType) {
            this.iconSetType = iconSetType;
        }

        @Override
        public final Builder iconSetType(String iconSetType) {
            this.iconSetType = iconSetType;
            return this;
        }

        @Override
        public final Builder iconSetType(ConditionalFormattingIconSetType iconSetType) {
            this.iconSetType(iconSetType == null ? null : iconSetType.toString());
            return this;
        }

        public ConditionalFormattingIconSet build() {
            return new ConditionalFormattingIconSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConditionalFormattingIconSet> {
        public Builder expression(String var1);

        public Builder iconSetType(String var1);

        public Builder iconSetType(ConditionalFormattingIconSetType var1);
    }
}

