/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.quicksight.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The setup for the detailed tooltip.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FieldBasedTooltip implements SdkPojo, Serializable,
        ToCopyableBuilder<FieldBasedTooltip.Builder, FieldBasedTooltip> {
    private static final SdkField<String> AGGREGATION_VISIBILITY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationVisibility").getter(getter(FieldBasedTooltip::aggregationVisibilityAsString))
            .setter(setter(Builder::aggregationVisibility))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AggregationVisibility").build())
            .build();

    private static final SdkField<String> TOOLTIP_TITLE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TooltipTitleType").getter(getter(FieldBasedTooltip::tooltipTitleTypeAsString))
            .setter(setter(Builder::tooltipTitleType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipTitleType").build()).build();

    private static final SdkField<List<TooltipItem>> TOOLTIP_FIELDS_FIELD = SdkField
            .<List<TooltipItem>> builder(MarshallingType.LIST)
            .memberName("TooltipFields")
            .getter(getter(FieldBasedTooltip::tooltipFields))
            .setter(setter(Builder::tooltipFields))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TooltipFields").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TooltipItem> builder(MarshallingType.SDK_POJO)
                                            .constructor(TooltipItem::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGGREGATION_VISIBILITY_FIELD,
            TOOLTIP_TITLE_TYPE_FIELD, TOOLTIP_FIELDS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String aggregationVisibility;

    private final String tooltipTitleType;

    private final List<TooltipItem> tooltipFields;

    private FieldBasedTooltip(BuilderImpl builder) {
        this.aggregationVisibility = builder.aggregationVisibility;
        this.tooltipTitleType = builder.tooltipTitleType;
        this.tooltipFields = builder.tooltipFields;
    }

    /**
     * <p>
     * The visibility of <code>Show aggregations</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #aggregationVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of <code>Show aggregations</code>.
     * @see Visibility
     */
    public final Visibility aggregationVisibility() {
        return Visibility.fromValue(aggregationVisibility);
    }

    /**
     * <p>
     * The visibility of <code>Show aggregations</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #aggregationVisibility} will return {@link Visibility#UNKNOWN_TO_SDK_VERSION}. The raw value returned by
     * the service is available from {@link #aggregationVisibilityAsString}.
     * </p>
     * 
     * @return The visibility of <code>Show aggregations</code>.
     * @see Visibility
     */
    public final String aggregationVisibilityAsString() {
        return aggregationVisibility;
    }

    /**
     * <p>
     * The type for the &gt;tooltip title. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Doesn't use the primary value as the title.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PRIMARY_VALUE</code>: Uses primary value as the title.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tooltipTitleType}
     * will return {@link TooltipTitleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tooltipTitleTypeAsString}.
     * </p>
     * 
     * @return The type for the &gt;tooltip title. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Doesn't use the primary value as the title.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PRIMARY_VALUE</code>: Uses primary value as the title.
     *         </p>
     *         </li>
     * @see TooltipTitleType
     */
    public final TooltipTitleType tooltipTitleType() {
        return TooltipTitleType.fromValue(tooltipTitleType);
    }

    /**
     * <p>
     * The type for the &gt;tooltip title. Choose one of the following options:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>NONE</code>: Doesn't use the primary value as the title.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>PRIMARY_VALUE</code>: Uses primary value as the title.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tooltipTitleType}
     * will return {@link TooltipTitleType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tooltipTitleTypeAsString}.
     * </p>
     * 
     * @return The type for the &gt;tooltip title. Choose one of the following options:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>NONE</code>: Doesn't use the primary value as the title.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>PRIMARY_VALUE</code>: Uses primary value as the title.
     *         </p>
     *         </li>
     * @see TooltipTitleType
     */
    public final String tooltipTitleTypeAsString() {
        return tooltipTitleType;
    }

    /**
     * For responses, this returns true if the service returned a value for the TooltipFields property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTooltipFields() {
        return tooltipFields != null && !(tooltipFields instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fields configuration in the tooltip.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTooltipFields} method.
     * </p>
     * 
     * @return The fields configuration in the tooltip.
     */
    public final List<TooltipItem> tooltipFields() {
        return tooltipFields;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(aggregationVisibilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tooltipTitleTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTooltipFields() ? tooltipFields() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FieldBasedTooltip)) {
            return false;
        }
        FieldBasedTooltip other = (FieldBasedTooltip) obj;
        return Objects.equals(aggregationVisibilityAsString(), other.aggregationVisibilityAsString())
                && Objects.equals(tooltipTitleTypeAsString(), other.tooltipTitleTypeAsString())
                && hasTooltipFields() == other.hasTooltipFields() && Objects.equals(tooltipFields(), other.tooltipFields());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FieldBasedTooltip").add("AggregationVisibility", aggregationVisibilityAsString())
                .add("TooltipTitleType", tooltipTitleTypeAsString())
                .add("TooltipFields", hasTooltipFields() ? tooltipFields() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AggregationVisibility":
            return Optional.ofNullable(clazz.cast(aggregationVisibilityAsString()));
        case "TooltipTitleType":
            return Optional.ofNullable(clazz.cast(tooltipTitleTypeAsString()));
        case "TooltipFields":
            return Optional.ofNullable(clazz.cast(tooltipFields()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<FieldBasedTooltip, T> g) {
        return obj -> g.apply((FieldBasedTooltip) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FieldBasedTooltip> {
        /**
         * <p>
         * The visibility of <code>Show aggregations</code>.
         * </p>
         * 
         * @param aggregationVisibility
         *        The visibility of <code>Show aggregations</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder aggregationVisibility(String aggregationVisibility);

        /**
         * <p>
         * The visibility of <code>Show aggregations</code>.
         * </p>
         * 
         * @param aggregationVisibility
         *        The visibility of <code>Show aggregations</code>.
         * @see Visibility
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Visibility
         */
        Builder aggregationVisibility(Visibility aggregationVisibility);

        /**
         * <p>
         * The type for the &gt;tooltip title. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Doesn't use the primary value as the title.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PRIMARY_VALUE</code>: Uses primary value as the title.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tooltipTitleType
         *        The type for the &gt;tooltip title. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Doesn't use the primary value as the title.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PRIMARY_VALUE</code>: Uses primary value as the title.
         *        </p>
         *        </li>
         * @see TooltipTitleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TooltipTitleType
         */
        Builder tooltipTitleType(String tooltipTitleType);

        /**
         * <p>
         * The type for the &gt;tooltip title. Choose one of the following options:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>NONE</code>: Doesn't use the primary value as the title.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>PRIMARY_VALUE</code>: Uses primary value as the title.
         * </p>
         * </li>
         * </ul>
         * 
         * @param tooltipTitleType
         *        The type for the &gt;tooltip title. Choose one of the following options:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>NONE</code>: Doesn't use the primary value as the title.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>PRIMARY_VALUE</code>: Uses primary value as the title.
         *        </p>
         *        </li>
         * @see TooltipTitleType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TooltipTitleType
         */
        Builder tooltipTitleType(TooltipTitleType tooltipTitleType);

        /**
         * <p>
         * The fields configuration in the tooltip.
         * </p>
         * 
         * @param tooltipFields
         *        The fields configuration in the tooltip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltipFields(Collection<TooltipItem> tooltipFields);

        /**
         * <p>
         * The fields configuration in the tooltip.
         * </p>
         * 
         * @param tooltipFields
         *        The fields configuration in the tooltip.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tooltipFields(TooltipItem... tooltipFields);

        /**
         * <p>
         * The fields configuration in the tooltip.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.quicksight.model.TooltipItem.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.quicksight.model.TooltipItem#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.quicksight.model.TooltipItem.Builder#build()} is called immediately
         * and its result is passed to {@link #tooltipFields(List<TooltipItem>)}.
         * 
         * @param tooltipFields
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.quicksight.model.TooltipItem.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tooltipFields(java.util.Collection<TooltipItem>)
         */
        Builder tooltipFields(Consumer<TooltipItem.Builder>... tooltipFields);
    }

    static final class BuilderImpl implements Builder {
        private String aggregationVisibility;

        private String tooltipTitleType;

        private List<TooltipItem> tooltipFields = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FieldBasedTooltip model) {
            aggregationVisibility(model.aggregationVisibility);
            tooltipTitleType(model.tooltipTitleType);
            tooltipFields(model.tooltipFields);
        }

        public final String getAggregationVisibility() {
            return aggregationVisibility;
        }

        public final void setAggregationVisibility(String aggregationVisibility) {
            this.aggregationVisibility = aggregationVisibility;
        }

        @Override
        public final Builder aggregationVisibility(String aggregationVisibility) {
            this.aggregationVisibility = aggregationVisibility;
            return this;
        }

        @Override
        public final Builder aggregationVisibility(Visibility aggregationVisibility) {
            this.aggregationVisibility(aggregationVisibility == null ? null : aggregationVisibility.toString());
            return this;
        }

        public final String getTooltipTitleType() {
            return tooltipTitleType;
        }

        public final void setTooltipTitleType(String tooltipTitleType) {
            this.tooltipTitleType = tooltipTitleType;
        }

        @Override
        public final Builder tooltipTitleType(String tooltipTitleType) {
            this.tooltipTitleType = tooltipTitleType;
            return this;
        }

        @Override
        public final Builder tooltipTitleType(TooltipTitleType tooltipTitleType) {
            this.tooltipTitleType(tooltipTitleType == null ? null : tooltipTitleType.toString());
            return this;
        }

        public final List<TooltipItem.Builder> getTooltipFields() {
            List<TooltipItem.Builder> result = TooltipItemListCopier.copyToBuilder(this.tooltipFields);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTooltipFields(Collection<TooltipItem.BuilderImpl> tooltipFields) {
            this.tooltipFields = TooltipItemListCopier.copyFromBuilder(tooltipFields);
        }

        @Override
        public final Builder tooltipFields(Collection<TooltipItem> tooltipFields) {
            this.tooltipFields = TooltipItemListCopier.copy(tooltipFields);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tooltipFields(TooltipItem... tooltipFields) {
            tooltipFields(Arrays.asList(tooltipFields));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tooltipFields(Consumer<TooltipItem.Builder>... tooltipFields) {
            tooltipFields(Stream.of(tooltipFields).map(c -> TooltipItem.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FieldBasedTooltip build() {
            return new FieldBasedTooltip(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
